/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.utils.LocaleUtils;

public class LocaleUtilsUnitTest {
    private static final String FILE_NAME = "FileName";
    private static final String FILE_EXTENSION = ".extension";

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingResourceFilesRegexWithNullFileName() {
        String string = null;
        LocaleUtils.createResourceFilesRegex(string, FILE_EXTENSION);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingResourceFilesRegexWithNullFileExtension() {
        String string = null;
        LocaleUtils.createResourceFilesRegex(FILE_NAME, string);
    }

    @Test
    public void shouldReturnValidRegexWhenGettingResourceFilesRegexWithNonNullFileNameAndFileExtension() {
        String string = LocaleUtils.createResourceFilesRegex(FILE_NAME, FILE_EXTENSION);
        Pattern.compile(string);
    }

    @Test
    public void shouldAcceptFileNameWithSpecialRegexCharsWhenGettingResourceFilesRegex() {
        String string = "?]|*-)(^[:.";
        Pattern.compile(LocaleUtils.createResourceFilesRegex(string, FILE_EXTENSION));
    }

    @Test
    public void shouldAcceptFileExtensionWithSpecialRegexCharsWhenGettingResourceFilesRegex() {
        String string = "?]|*-)(^[:.";
        Pattern.compile(LocaleUtils.createResourceFilesRegex(FILE_NAME, string));
    }

    @Test
    public void shouldProduceSameRegexForCreateResourceFilesRegexAsCreateResourceFilesPattern() {
        String string = LocaleUtils.createResourceFilesRegex(FILE_NAME, FILE_EXTENSION);
        Pattern pattern = LocaleUtils.createResourceFilesPattern(FILE_NAME, FILE_EXTENSION);
        String string2 = pattern.toString();
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string2)));
    }

    @Test
    public void shouldMatchValidResourceFilesWithCreatedResourceFilesPattern() {
        String[] stringArray = new String[]{"FileName.extension", "FileName_en.extension", "FileName_en_GB.extension", "FileName_ar_SA.extension", "FileName_fil_PH.extension", "FileName_zh_CN.extension"};
        Pattern pattern = LocaleUtils.createResourceFilesPattern(FILE_NAME, FILE_EXTENSION);
        for (String string : stringArray) {
            Assert.assertThat((String)string, (Object)pattern.matcher(string).matches(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
        }
    }

    @Test
    public void shouldNotMatchInvalidResourceFilesWithCreatedResourceFilesPattern() {
        String[] stringArray = new String[]{"Vulnerabilities.xml", "Vulnerabilities_en.xml", "Vulnerabilities_en_GB.xml", "OtherFile_ar_SA.properties", "fileName.ext"};
        Pattern pattern = LocaleUtils.createResourceFilesPattern(FILE_NAME, FILE_EXTENSION);
        for (String string : stringArray) {
            Assert.assertThat((String)string, (Object)pattern.matcher(string).matches(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        }
    }

    @Test
    public void shouldMatchValidMessagesPropertiesFilesWithCreateMessagesPropertiesFilePattern() {
        String[] stringArray = new String[]{"Messages.properties", "Messages_en.properties", "Messages_en_GB.properties", "Messages_ar_SA.properties", "Messages_fil_PH.properties", "Messages_zh_CN.properties"};
        Pattern pattern = LocaleUtils.createMessagesPropertiesFilePattern();
        for (String string : stringArray) {
            Assert.assertThat((String)string, (Object)pattern.matcher(string).matches(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
        }
    }

    @Test
    public void shouldNotMatchInvalidMessagesPropertiesFilesWithCreateMessagesPropertiesFilePattern() {
        String[] stringArray = new String[]{"Vulnerabilities.xml", "Vulnerabilities_en.xml", "Vulnerabilities_en_GB.xml", "OtherFile_ar_SA.properties", "messages.properties"};
        Pattern pattern = LocaleUtils.createMessagesPropertiesFilePattern();
        for (String string : stringArray) {
            Assert.assertThat((String)string, (Object)pattern.matcher(string).matches(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        }
    }
}

