/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.messagecontainer.http.SelectableHistoryReferencesContainer;
import org.zaproxy.zap.view.messagecontainer.http.SingleHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuHttpMessageContainer;

public class PopupMenuHistoryReferenceContainer
extends PopupMenuHttpMessageContainer {
    private static final long serialVersionUID = 1L;

    public PopupMenuHistoryReferenceContainer(String string) {
        this(string, false);
    }

    public PopupMenuHistoryReferenceContainer(String string, boolean bl) {
        super(string, bl);
    }

    @Override
    protected boolean isEnable(HttpMessageContainer httpMessageContainer) {
        return httpMessageContainer instanceof SelectableHistoryReferencesContainer || httpMessageContainer instanceof SingleHistoryReferenceContainer;
    }

    @Override
    protected boolean isButtonEnabledForSelectedMessages(HttpMessageContainer httpMessageContainer) {
        return this.isButtonEnabledForSelectedHistoryReferences(this.getSelectedHistoryReferences(httpMessageContainer));
    }

    @Override
    protected boolean isSelectedMessagesInSessionScope(HttpMessageContainer httpMessageContainer) {
        Session session = Model.getSingleton().getSession();
        for (HistoryReference historyReference : this.getSelectedHistoryReferences(httpMessageContainer)) {
            if (session.isInScope(historyReference)) continue;
            return false;
        }
        return true;
    }

    protected List<HistoryReference> getSelectedHistoryReferences(HttpMessageContainer httpMessageContainer) {
        SingleHistoryReferenceContainer singleHistoryReferenceContainer;
        if (httpMessageContainer instanceof SelectableHistoryReferencesContainer) {
            return ((SelectableHistoryReferencesContainer)httpMessageContainer).getSelectedHistoryReferences();
        }
        if (httpMessageContainer instanceof SingleHistoryReferenceContainer && !(singleHistoryReferenceContainer = (SingleHistoryReferenceContainer)httpMessageContainer).isEmpty()) {
            ArrayList<HistoryReference> arrayList = new ArrayList<HistoryReference>(1);
            arrayList.add(singleHistoryReferenceContainer.getHistoryReference());
            return arrayList;
        }
        return Collections.emptyList();
    }

    protected boolean isButtonEnabledForSelectedHistoryReferences(List<HistoryReference> list) {
        for (HistoryReference historyReference : list) {
            if (historyReference == null || this.isButtonEnabledForHistoryReference(historyReference)) continue;
            return false;
        }
        return true;
    }

    protected boolean isButtonEnabledForHistoryReference(HistoryReference historyReference) {
        return historyReference.getHistoryType() != 0;
    }
}

