/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.ContextIncludePanel;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupMenuItemIncludeInContext
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 990419495607725846L;
    private static final Logger LOGGER = Logger.getLogger(PopupMenuItemIncludeInContext.class);
    protected Context context;

    public PopupMenuItemIncludeInContext() {
        super(Constant.messages.getString("context.new.title"), true);
        this.context = null;
        this.setPrecedeWithSeparator(true);
    }

    public PopupMenuItemIncludeInContext(Context context) {
        super(context.getName(), true);
        this.context = context;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.include.popup");
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public void performAction(SiteNode siteNode) {
        String string;
        try {
            string = new URI(siteNode.getHierarchicNodeName(), false).toString();
        }
        catch (URIException uRIException) {
            LOGGER.error((Object)("Failed to execute action include in context: " + uRIException.getMessage()), (Throwable)uRIException);
            return;
        }
        string = siteNode.isLeaf() && siteNode.getParent().getParent() != null ? Pattern.quote(string) : Pattern.quote(string) + ".*";
        this.performAction(siteNode.getNodeName(), string);
    }

    protected void performAction(String string, String string2) {
        Session session = Model.getSingleton().getSession();
        if (this.context == null) {
            this.context = session.getNewContext(string);
        }
        SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
        sessionDialog.recreateUISharedContexts(session);
        Context context = sessionDialog.getUISharedContext(this.context.getIndex());
        context.addIncludeInContextRegex(string2);
        View.getSingleton().showSessionDialog(session, ContextIncludePanel.getPanelName(this.context.getIndex()), false);
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode siteNode) {
        if (this.context == null) {
            return true;
        }
        return !this.context.isIncluded(siteNode) && !this.context.isExcluded(siteNode);
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

