/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.PixelUtils;
import com.sun.prism.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.input.DataFormat;
import javafx.scene.input.TransferMode;
import javafx.util.Pair;

public class QuantumClipboard
implements TKClipboard {
    private ClipboardAssistance systemAssistant;
    private AccessControlContext accessContext = null;
    private boolean isCaching;
    private List<Pair<DataFormat, Object>> dataCache;
    private Set<TransferMode> transferModesCache;
    private static final Permission all = new AllPermission();
    private static final Pattern findTagIMG = Pattern.compile("IMG\\s+SRC=\\\"([^\\\"]+)\\\"", 34);

    private QuantumClipboard() {
    }

    @Override
    public void initSecurityContext() {
        this.accessContext = AccessController.getContext();
    }

    public static QuantumClipboard getClipboardInstance(ClipboardAssistance clipboardAssistance) {
        QuantumClipboard quantumClipboard = new QuantumClipboard();
        quantumClipboard.systemAssistant = clipboardAssistance;
        quantumClipboard.isCaching = false;
        return quantumClipboard;
    }

    public static QuantumClipboard getDragboardInstance(ClipboardAssistance clipboardAssistance) {
        QuantumClipboard quantumClipboard = new QuantumClipboard();
        quantumClipboard.systemAssistant = clipboardAssistance;
        quantumClipboard.isCaching = true;
        return quantumClipboard;
    }

    public static int transferModesToClipboardActions(Set<TransferMode> set) {
        int n = 0;
        block5: for (TransferMode transferMode : set) {
            switch (transferMode) {
                case COPY: {
                    n |= 1;
                    continue block5;
                }
                case MOVE: {
                    n |= 2;
                    continue block5;
                }
                case LINK: {
                    n |= 0x40000000;
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unsupported TransferMode " + set);
        }
        return n;
    }

    public void setSupportedTransferMode(Set<TransferMode> set) {
        if (this.isCaching) {
            this.transferModesCache = set;
        }
        int n = QuantumClipboard.transferModesToClipboardActions(set);
        this.systemAssistant.setSupportedActions(n);
    }

    public static Set<TransferMode> clipboardActionsToTransferModes(int n) {
        EnumSet<TransferMode> enumSet = EnumSet.noneOf(TransferMode.class);
        if ((n & 1) != 0) {
            enumSet.add(TransferMode.COPY);
        }
        if ((n & 2) != 0) {
            enumSet.add(TransferMode.MOVE);
        }
        if ((n & 0x40000000) != 0) {
            enumSet.add(TransferMode.LINK);
        }
        return enumSet;
    }

    @Override
    public Set<TransferMode> getTransferModes() {
        if (this.transferModesCache != null) {
            return EnumSet.copyOf(this.transferModesCache);
        }
        Set<TransferMode> set = QuantumClipboard.clipboardActionsToTransferModes(this.systemAssistant.getSupportedSourceActions());
        return set;
    }

    public void close() {
        this.systemAssistant.close();
    }

    public void flush() {
        this.clearCache();
        this.systemAssistant.flush();
    }

    @Override
    public Object getContent(DataFormat dataFormat) {
        if (this.dataCache != null) {
            for (Pair<DataFormat, Object> pair : this.dataCache) {
                if (pair.getKey() != dataFormat) continue;
                return pair.getValue();
            }
            return null;
        }
        if (dataFormat == DataFormat.IMAGE) {
            return this.readImage();
        }
        if (dataFormat == DataFormat.URL) {
            return this.systemAssistant.getData("text/uri-list");
        }
        if (dataFormat == DataFormat.FILES) {
            Object object = this.systemAssistant.getData("application/x-java-file-list");
            if (object == null) {
                return Collections.emptyList();
            }
            String[] stringArray = (String[])object;
            ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(new File(stringArray[i]));
            }
            return arrayList;
        }
        for (String string : dataFormat.getIdentifiers()) {
            Object object = this.systemAssistant.getData(string);
            if (object instanceof ByteBuffer) {
                try {
                    ByteBuffer byteBuffer = (ByteBuffer)object;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array());
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream){

                        @Override
                        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                            return Class.forName(objectStreamClass.getName(), false, Thread.currentThread().getContextClassLoader());
                        }
                    };
                    object = objectInputStream.readObject();
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private javafx.scene.image.Image readImage() {
        Object object = this.systemAssistant.getData("application/x-java-rawimage");
        if (object == null) {
            String string;
            Object object2 = this.systemAssistant.getData("text/html");
            if (object2 != null && (string = this.parseIMG(object2)) != null) {
                try {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        Object object3;
                        URL uRL = new URL(string);
                        String string2 = uRL.getProtocol();
                        if (string2.equalsIgnoreCase("jar")) {
                            object3 = uRL.getFile();
                            uRL = new URL((String)object3);
                            string2 = uRL.getProtocol();
                        }
                        if (string2.equalsIgnoreCase("file")) {
                            object3 = new FilePermission(uRL.getFile(), "read");
                            this.accessContext.checkPermission((Permission)object3);
                        } else if (string2.equalsIgnoreCase("ftp") || string2.equalsIgnoreCase("http") || string2.equalsIgnoreCase("https")) {
                            int n = uRL.getPort();
                            String string3 = n == -1 ? uRL.getHost() : uRL.getHost() + ":" + n;
                            SocketPermission socketPermission = new SocketPermission(string3, "connect");
                            this.accessContext.checkPermission(socketPermission);
                        } else {
                            this.accessContext.checkPermission(all);
                        }
                    }
                    return new javafx.scene.image.Image(string);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
                catch (SecurityException securityException) {
                    return null;
                }
            }
            return null;
        }
        if (object instanceof javafx.scene.image.Image) {
            return (javafx.scene.image.Image)object;
        }
        Image image = PixelUtils.pixelsToImage((Pixels)object);
        ImageLoader imageLoader = Toolkit.getToolkit().loadPlatformImage(image);
        return javafx.scene.image.Image.impl_fromPlatformImage(imageLoader);
    }

    private String parseIMG(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        Matcher matcher = findTagIMG.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean placeImage(javafx.scene.image.Image image) {
        if (image == null) {
            return false;
        }
        String string = image.impl_getUrl();
        if (string == null || PixelUtils.supportedFormatType(string)) {
            Image image2 = (Image)image.impl_getPlatformImage();
            Pixels pixels = PixelUtils.imageToPixels(image2);
            if (pixels != null) {
                this.systemAssistant.setData("application/x-java-rawimage", pixels);
                return true;
            }
            return false;
        }
        this.systemAssistant.setData("text/uri-list", string);
        return true;
    }

    @Override
    public Set<DataFormat> getContentTypes() {
        HashSet<DataFormat> hashSet = new HashSet<DataFormat>();
        if (this.dataCache != null) {
            for (Pair<DataFormat, Object> pair : this.dataCache) {
                hashSet.add(pair.getKey());
            }
            return hashSet;
        }
        String[] stringArray = this.systemAssistant.getMimeTypes();
        if (stringArray == null) {
            return hashSet;
        }
        for (String string : stringArray) {
            if (string.equalsIgnoreCase("application/x-java-rawimage")) {
                hashSet.add(DataFormat.IMAGE);
                continue;
            }
            if (string.equalsIgnoreCase("text/uri-list")) {
                hashSet.add(DataFormat.URL);
                continue;
            }
            if (string.equalsIgnoreCase("application/x-java-file-list")) {
                hashSet.add(DataFormat.FILES);
                continue;
            }
            if (string.equalsIgnoreCase("text/html")) {
                hashSet.add(DataFormat.HTML);
                try {
                    if (this.parseIMG(this.systemAssistant.getData("text/html")) == null) continue;
                    hashSet.add(DataFormat.IMAGE);
                }
                catch (Exception exception) {}
                continue;
            }
            DataFormat dataFormat = DataFormat.lookupMimeType(string);
            if (dataFormat == null) {
                dataFormat = new DataFormat(string);
            }
            hashSet.add(dataFormat);
        }
        return hashSet;
    }

    @Override
    public boolean hasContent(DataFormat dataFormat) {
        if (this.dataCache != null) {
            for (Pair<DataFormat, Object> pair : this.dataCache) {
                if (pair.getKey() != dataFormat) continue;
                return true;
            }
            return false;
        }
        String[] stringArray = this.systemAssistant.getMimeTypes();
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (dataFormat == DataFormat.IMAGE && string.equalsIgnoreCase("application/x-java-rawimage")) {
                return true;
            }
            if (dataFormat == DataFormat.URL && string.equalsIgnoreCase("text/uri-list")) {
                return true;
            }
            if (dataFormat == DataFormat.IMAGE && string.equalsIgnoreCase("text/html")) {
                return this.parseIMG(this.systemAssistant.getData("text/html")) != null;
            }
            if (dataFormat == DataFormat.FILES && string.equalsIgnoreCase("application/x-java-file-list")) {
                return true;
            }
            DataFormat dataFormat2 = DataFormat.lookupMimeType(string);
            if (dataFormat2 == null || !dataFormat2.equals(dataFormat)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean putContent(Pair<DataFormat, Object> ... pairArray) {
        Object object;
        DataFormat dataFormat;
        this.systemAssistant.emptyCache();
        if (this.isCaching) {
            this.dataCache = new ArrayList<Pair<DataFormat, Object>>(pairArray.length);
        }
        boolean bl = false;
        for (Pair<DataFormat, Object> pair : pairArray) {
            dataFormat = pair.getKey();
            object = pair.getValue();
            if (dataFormat == null) {
                throw new NullPointerException("Clipboard.putContent: null data format");
            }
            if (object != null) continue;
            throw new NullPointerException("Clipboard.putContent: null data");
        }
        for (Pair<DataFormat, Object> pair : pairArray) {
            Object object3;
            dataFormat = pair.getKey();
            object = pair.getValue();
            if (this.isCaching) {
                this.dataCache.add(pair);
            }
            if (dataFormat == DataFormat.IMAGE && object instanceof javafx.scene.image.Image) {
                this.placeImage((javafx.scene.image.Image)object);
                bl = true;
                continue;
            }
            if (dataFormat == DataFormat.URL) {
                this.systemAssistant.setData("text/uri-list", object);
                bl = true;
                continue;
            }
            if (dataFormat == DataFormat.RTF) {
                this.systemAssistant.setData("text/rtf", object);
                bl = true;
                continue;
            }
            if (dataFormat == DataFormat.FILES) {
                object3 = (List)object;
                String[] stringArray = new String[object3.size()];
                int n = 0;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    stringArray[n++] = file.getAbsolutePath();
                }
                this.systemAssistant.setData("application/x-java-file-list", stringArray);
                bl = true;
                continue;
            }
            if (object instanceof Serializable) {
                if (dataFormat != DataFormat.PLAIN_TEXT && dataFormat != DataFormat.HTML || !(object instanceof String)) {
                    try {
                        object3 = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object3);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.close();
                        object = ByteBuffer.wrap(((ByteArrayOutputStream)object3).toByteArray());
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("Could not serialize the data", iOException);
                    }
                }
            } else if (!(object instanceof ByteBuffer)) {
                throw new IllegalArgumentException("Only serializable objects or ByteBuffer can be used as data with data format " + dataFormat);
            }
            for (String string : dataFormat.getIdentifiers()) {
                this.systemAssistant.setData(string, object);
                bl = true;
            }
        }
        if (!this.isCaching) {
            this.systemAssistant.flush();
        }
        return bl;
    }

    private void clearCache() {
        this.dataCache = null;
        this.transferModesCache = null;
    }
}

