/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.osx;

import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.HostUtils;
import com.sun.media.jfxmediaimpl.platform.Platform;
import com.sun.media.jfxmediaimpl.platform.osx.OSXMedia;
import com.sun.media.jfxmediaimpl.platform.osx.OSXMediaPlayer;

public final class OSXPlatform
extends Platform {
    private static final String[] CONTENT_TYPES = new String[]{"video/mp4", "audio/x-m4a", "video/x-m4v", "application/vnd.apple.mpegurl", "audio/mpegurl"};

    public static Platform getPlatformInstance() {
        return OSXPlatformInitializer.globalInstance;
    }

    private OSXPlatform() {
    }

    public void preloadPlatform() {
    }

    public boolean loadPlatform() {
        if (!HostUtils.isMacOSX()) {
            return false;
        }
        try {
            OSXPlatform.osxPlatformInit();
        }
        catch (UnsatisfiedLinkError ule) {
            if (Logger.canLog(1)) {
                Logger.logMsg(1, "Unable to load OSX platform.");
            }
            return false;
        }
        return true;
    }

    public String[] getSupportedContentTypes() {
        return (String[])CONTENT_TYPES.clone();
    }

    public Media createMedia(Locator source) {
        return new OSXMedia(source);
    }

    public Object prerollMediaPlayer(Locator source) {
        return new OSXMediaPlayer(source);
    }

    public MediaPlayer createMediaPlayer(Locator source, Object cookie) {
        if (cookie instanceof OSXMediaPlayer) {
            OSXMediaPlayer player = (OSXMediaPlayer)cookie;
            player.initializePlayer();
            return player;
        }
        return null;
    }

    private static native void osxPlatformInit();

    private static final class OSXPlatformInitializer {
        private static final OSXPlatform globalInstance = new OSXPlatform();

        private OSXPlatformInitializer() {
        }
    }
}

