/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarWarning;
import edu.umass.cs.benchlab.har.ISO8601DateFormatter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarCacheRequest {
    public static String TABLE_NAME = "cache";
    private Date expires;
    private Date lastAccess;
    private String eTag;
    private Integer hitCount;
    private String comment;
    private final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S");
    private boolean isBefore;
    private HarCustomFields customFields = new HarCustomFields();

    public HarCacheRequest(Date expires, Date lastAccess, String tag, int hitCount, String comment, boolean isBefore) {
        this.expires = expires;
        this.lastAccess = lastAccess;
        this.eTag = tag;
        this.hitCount = hitCount;
        this.comment = comment;
        this.isBefore = isBefore;
    }

    public HarCacheRequest(Date lastAccess, String tag, int hitCount, boolean isBefore) {
        this.lastAccess = lastAccess;
        this.eTag = tag;
        this.hitCount = hitCount;
        this.isBefore = isBefore;
    }

    public HarCacheRequest(JsonParser jp, boolean isBefore, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            if ("null".equals(jp.getText())) {
                return;
            }
            throw new JsonParseException("{ missing after \"" + this.getObjectTag() + "\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("eTag".equals(name)) {
                this.setETag(jp.getText());
                continue;
            }
            if ("expires".equals(name)) {
                try {
                    if (jp.getCurrentName().equals(jp.getText())) {
                        jp.nextToken();
                    }
                    this.setExpires(ISO8601DateFormatter.parseDate(jp.getText()));
                    continue;
                }
                catch (ParseException e) {
                    try {
                        this.setExpires(this.SDF.parse(jp.getText()));
                        continue;
                    }
                    catch (ParseException e1) {
                        if (warnings != null) {
                            warnings.add(new HarWarning("Invalid date format '" + jp.getText() + "'", jp.getCurrentLocation()));
                            continue;
                        }
                        throw new JsonParseException("Invalid date format '" + jp.getText() + "'", jp.getCurrentLocation());
                    }
                }
            }
            if ("lastAccess".equals(name)) {
                try {
                    if (jp.getCurrentName().equals(jp.getText())) {
                        jp.nextToken();
                    }
                    this.setLastAccess(ISO8601DateFormatter.parseDate(jp.getText()));
                    continue;
                }
                catch (ParseException e) {
                    try {
                        this.setExpires(this.SDF.parse(jp.getText()));
                        continue;
                    }
                    catch (ParseException e1) {
                        if (warnings != null) {
                            warnings.add(new HarWarning("Invalid date format '" + jp.getText() + "'", jp.getCurrentLocation()));
                            continue;
                        }
                        throw new JsonParseException("Invalid date format '" + jp.getText() + "'", jp.getCurrentLocation());
                    }
                }
            }
            if ("hitCount".equals(name)) {
                this.setHitCount(jp.getValueAsInt());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in " + this.getObjectTag() + " element", jp.getCurrentLocation());
        }
        if (this.lastAccess == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing lastAccess field in cache element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing lastAccess field in cache element", jp.getCurrentLocation());
            }
        }
        if (this.eTag == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing eTag field in cache element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing eTag field in cache element", jp.getCurrentLocation());
            }
        }
        if (this.hitCount == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing hitCount field in cache element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing hitCount field in cache element", jp.getCurrentLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarCacheRequest(HarDatabaseConfig config, long cacheId, boolean isBefore) throws SQLException {
        this.isBefore = isBefore;
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT expires,last_access,etag,hit_count,comment FROM " + tableName + " WHERE cache_id=? AND is_before=?");
            ps.setLong(1, cacheId);
            ps.setInt(2, isBefore ? 1 : 0);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No " + this.getObjectTag() + " HarCacheRequest for cache id " + cacheId + " found in database");
            }
            this.setExpires(rs.getTimestamp(1));
            this.setLastAccess(rs.getTimestamp(2));
            this.setETag(rs.getString(3));
            this.setHitCount((int)rs.getLong(4));
            this.setComment(rs.getString(5));
            this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARCACHEREQUEST, cacheId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        if (this.eTag == null) {
            g.writeNullField(this.getObjectTag());
            return;
        }
        g.writeObjectFieldStart(this.getObjectTag());
        if (this.expires != null) {
            g.writeStringField("expires", ISO8601DateFormatter.format(this.expires));
        }
        g.writeStringField("lastAccess", ISO8601DateFormatter.format(this.lastAccess));
        g.writeStringField("eTag", this.eTag);
        g.writeNumberField("hitCount", this.hitCount);
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    private String getObjectTag() {
        return this.isBefore ? "beforeRequest" : "afterRequest";
    }

    public void writeJDBC(long cacheId, HarDatabaseConfig config, PreparedStatement cachePs, long logId) throws SQLException {
        if (this.eTag == null) {
            cachePs.setNull(1, 93);
            cachePs.setNull(2, 93);
            cachePs.setNull(3, -1);
            cachePs.setNull(4, -5);
        } else {
            cachePs.setTimestamp(1, new Timestamp(this.expires.getTime()));
            cachePs.setTimestamp(2, new Timestamp(this.lastAccess.getTime()));
            cachePs.setString(3, this.eTag);
            cachePs.setLong(4, this.hitCount.intValue());
        }
        if (this.comment == null) {
            cachePs.setNull(5, -1);
        } else {
            cachePs.setString(5, this.comment);
        }
        cachePs.setInt(6, this.isBefore ? 1 : 0);
        cachePs.setLong(7, cacheId);
        cachePs.executeUpdate();
        this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARCACHEREQUEST, cacheId, logId);
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(Date lastAccess) {
        this.lastAccess = lastAccess;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String tag) {
        this.eTag = tag;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(int hitCount) {
        this.hitCount = hitCount;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        return "\"" + this.getObjectTag() + "\":{ \"expires\": \"" + ISO8601DateFormatter.format(this.expires) + "\",\"lastAccess\": \"" + ISO8601DateFormatter.format(this.lastAccess) + "\",\"eTag\": \"" + this.eTag + "\",\"hitCount\": " + this.hitCount + ",\"comment\": " + "\"" + this.comment + "\" } }\n";
    }
}

