/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.table;

import ch.softenvironment.math.MathUtils;
import ch.softenvironment.util.Tracer;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class NumberTableCellRenderer
extends DefaultTableCellRenderer {
    NumberFormat numberFormat = null;

    public NumberTableCellRenderer(NumberFormat format) {
        this.numberFormat = format;
    }

    public NumberTableCellRenderer(int fractionDigits) {
        this(NumberFormat.getNumberInstance());
        this.numberFormat.setMinimumFractionDigits(fractionDigits);
        this.numberFormat.setMaximumFractionDigits(fractionDigits);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    protected void setValue(Object value) {
        try {
            if (value == null) {
                this.setText("");
            } else if (MathUtils.compare(0.0, ((Number)value).doubleValue()) == 0) {
                this.setText(this.numberFormat.format(new Double(0.0)));
            } else {
                this.setText(value == null ? "" : this.numberFormat.format((Number)value));
            }
        }
        catch (ClassCastException e) {
            Tracer.getInstance().developerError("Number value expected for: " + value);
        }
    }
}

