/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.DeclarationWriterWrapper;
import com.ibm.xmi.framework.DefinitionWriter;
import com.ibm.xmi.framework.Feature;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.Package;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.SchemaConstructWriter;
import com.ibm.xmi.framework.SchemaWriter;
import com.ibm.xmi.framework.WriterFactory;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMISchema;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class Schema20Writer
extends SchemaWriter {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private DeclarationWriterWrapper wrapper = new DeclarationWriterWrapper(AdapterFactoryRegister.getAdapterFactory().createDeclarationWriterAdapter());
    private ArrayList namespaces = new ArrayList();

    public Schema20Writer(XMISchema xMISchema) {
        super(xMISchema);
    }

    public void write(int n, int n2) throws Exception {
        PrintXML.setEncoding(this.getSchema().getEncoding());
        this.getNamespaces(this.getSchema().getDeclarations());
        this.writeHeader(n, n2);
        String[] stringArray = new String[32];
        int n3 = 0;
        stringArray[n3++] = "xmlns:xsd";
        stringArray[n3++] = "http://www.w3.org/2001/XMLSchema";
        stringArray[n3++] = "xmlns:xmi";
        stringArray[n3++] = "http://www.omg.org/XMI";
        if (this.getSchema().getTargetNamespace() != null) {
            stringArray[n3++] = "xmlns";
            stringArray[n3++] = this.getSchema().getTargetNamespace().getURI();
            stringArray[n3++] = "targetNamespace";
            stringArray[n3++] = this.getSchema().getTargetNamespace().getURI();
        }
        Iterator iterator = ((AbstractList)this.namespaces).iterator();
        while (iterator.hasNext()) {
            Namespace namespace = (Namespace)iterator.next();
            stringArray[n3++] = "xmlns:" + namespace.getPrefix();
            stringArray[n3++] = namespace.getURI();
        }
        PrintXML.printStartElement("xsd:schema", stringArray, false, n);
        this.writeContent(n, n2);
        PrintXML.printEndElement("xsd:schema", n);
        PrintXML.printEndDocument();
    }

    private void getNamespaces(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Package) {
                this.getNamespaces(((Package)e).getXMIContents());
                continue;
            }
            if (!(e instanceof XMIClass)) continue;
            this.getNamespaces((XMIClass)e);
        }
    }

    private void getNamespaces(XMIClass xMIClass) {
        if (!this.equalsSchemaNamespace(xMIClass.getXMINamespace())) {
            return;
        }
        Iterator iterator = xMIClass.getXMIFeatures().iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            if (feature.getXMIType() == null) continue;
            this.addToNamespace(feature.getXMIType());
        }
    }

    private void addToNamespace(Data data) {
        Namespace namespace = data.getXMINamespace();
        if (namespace == null) {
            return;
        }
        if (!this.equalsSchemaNamespace(namespace) && !this.namespaces.contains(namespace)) {
            this.namespaces.add(namespace);
        }
    }

    private boolean equalsSchemaNamespace(Namespace namespace) {
        Namespace namespace2 = this.getSchema().getTargetNamespace();
        if (namespace == namespace2) {
            return true;
        }
        if (namespace != null && namespace2 != null) {
            return namespace.equals(namespace2);
        }
        return false;
    }

    private void writeContent(int n, int n2) throws Exception {
        Object object;
        PrintXML.printBlankLine();
        String[] stringArray = new String[]{"namespace", "http://www.omg.org/XMI", "schemaLocation", "xmi20.xsd"};
        PrintXML.printStartElement("xsd:import", stringArray, true, n);
        Iterator iterator = ((AbstractList)this.namespaces).iterator();
        while (iterator.hasNext()) {
            object = (Namespace)iterator.next();
            stringArray = new String[]{"namespace", ((Namespace)object).getURI(), "schemaLocation", ((Namespace)object).getPrefix() + ".xsd"};
            PrintXML.printStartElement("xsd:import", stringArray, true, n);
        }
        PrintXML.printBlankLine();
        object = WriterFactory.makeEnumsWriter(this.getSchema().getDeclarations(), "1.1");
        if (object instanceof SchemaConstructWriter) {
            ((SchemaConstructWriter)object).setSchema(this.getSchema());
        }
        ((DefinitionWriter)object).setWrapper(this.wrapper);
        ((DefinitionWriter)object).write(n, n2);
        Iterator iterator2 = this.getSchema().getDeclarations().iterator();
        while (iterator2.hasNext()) {
            object = WriterFactory.makeDeclWriter(iterator2.next(), "2.0", "schema");
            if (object instanceof SchemaConstructWriter) {
                ((SchemaConstructWriter)object).setSchema(this.getSchema());
            }
            ((DefinitionWriter)object).setWrapper(this.wrapper);
            ((DefinitionWriter)object).write(n, n2);
        }
    }

    private void writeHeader(int n, int n2) throws Exception {
        PrintXML.printXMLPI("1.0");
    }
}

