/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javajs.util.PT;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jmol.api.Interface;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.JmolAdapter;
import org.jmol.awt.FileDropper;
import org.jmol.awt.Platform;
import org.jmol.console.JmolButton;
import org.jmol.console.JmolToggleButton;
import org.jmol.dialog.Dialog;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.Jmol;
import org.openscience.jmol.app.JmolApp;
import org.openscience.jmol.app.SplashInterface;
import org.openscience.jmol.app.jmolpanel.AboutDialog;
import org.openscience.jmol.app.jmolpanel.AtomSetChooser;
import org.openscience.jmol.app.jmolpanel.CreditsDialog;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.GaussianDialog;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.jmolpanel.MeasurementTable;
import org.openscience.jmol.app.jmolpanel.PovrayDialog;
import org.openscience.jmol.app.jmolpanel.PreferencesDialog;
import org.openscience.jmol.app.jmolpanel.RecentFilesDialog;
import org.openscience.jmol.app.jmolpanel.Splash;
import org.openscience.jmol.app.jmolpanel.StatusBar;
import org.openscience.jmol.app.jmolpanel.StatusListener;
import org.openscience.jmol.app.jmolpanel.WhatsNewDialog;
import org.openscience.jmol.app.jmolpanel.console.AppConsole;
import org.openscience.jmol.app.jmolpanel.console.ConsoleTextArea;
import org.openscience.jmol.app.jsonkiosk.BannerFrame;
import org.openscience.jmol.app.jsonkiosk.JsonNioClient;
import org.openscience.jmol.app.jsonkiosk.JsonNioServer;
import org.openscience.jmol.app.jsonkiosk.KioskFrame;
import org.openscience.jmol.app.nbo.NBODialog;
import org.openscience.jmol.app.nbo.NBOService;
import org.openscience.jmol.app.surfacetool.SurfaceTool;
import org.openscience.jmol.app.webexport.WebExport;

public class JmolPanel
extends JPanel
implements SplashInterface,
JsonNioClient {
    public static HistoryFile historyFile;
    public Viewer vwr;
    JmolAdapter modelAdapter;
    JmolApp jmolApp;
    StatusBar status;
    int startupWidth;
    int startupHeight;
    JsonNioServer serverService;
    public NBOService nboService;
    protected String appletContext;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected DisplayPanel display;
    protected GaussianDialog gaussianDialog;
    protected NBODialog nboDialog;
    protected RecentFilesDialog recentFiles;
    protected AtomSetChooser atomSetChooser;
    public JFrame frame;
    protected SplashInterface splash;
    protected JFrame consoleframe;
    protected JsonNioServer service;
    protected int qualityJPG = -1;
    protected int qualityPNG = -1;
    protected String imageType;
    public GuiMap guimap = new GuiMap();
    private ExecuteScriptAction executeScriptAction;
    PreferencesDialog preferencesDialog;
    private StatusListener myStatusListener;
    private SurfaceTool surfaceTool;
    private Map<String, Action> commands;
    private Map<String, JMenuItem> menuItems;
    private JToolBar toolbar;
    private ExportAction exportAction = new ExportAction();
    private PovrayAction povrayAction = new PovrayAction();
    private ToWebAction toWebAction = new ToWebAction();
    private WriteAction writeAction = new WriteAction();
    private PrintAction printAction = new PrintAction();
    private CopyImageAction copyImageAction = new CopyImageAction();
    private CopyScriptAction copyScriptAction = new CopyScriptAction();
    private SurfaceToolAction surfaceToolAction = new SurfaceToolAction();
    private PasteClipboardAction pasteClipboardAction = new PasteClipboardAction();
    private ViewMeasurementTableAction viewMeasurementTableAction = new ViewMeasurementTableAction();
    Map<String, Object> vwrOptions;
    private static int numWindows;
    private static KioskFrame kioskFrame;
    private static BannerFrame bannerFrame;
    private static final String EDITOR_WINDOW_NAME = "ScriptEditor";
    private static final String SCRIPT_WINDOW_NAME = "ScriptWindow";
    private static final String FILE_OPEN_WINDOW_NAME = "FileOpen";
    private static final String WEB_MAKER_WINDOW_NAME = "JmolWebPageMaker";
    private static final String SURFACETOOL_WINDOW_NAME = "SurfaceToolWindow";
    private static final Dimension screenSize;
    private static final String newwinAction = "newwin";
    private static final String openAction = "open";
    private static final String openurlAction = "openurl";
    private static final String openpdbAction = "openpdb";
    private static final String openmolAction = "openmol";
    private static final String newAction = "new";
    private static final String exportActionProperty = "export";
    private static final String closeAction = "close";
    private static final String exitAction = "exit";
    private static final String aboutAction = "about";
    private static final String whatsnewAction = "whatsnew";
    private static final String creditsAction = "credits";
    private static final String uguideAction = "uguide";
    private static final String printActionProperty = "print";
    private static final String recentFilesAction = "recentFiles";
    private static final String povrayActionProperty = "povray";
    private static final String writeActionProperty = "write";
    private static final String editorAction = "editor";
    private static final String consoleAction = "console";
    private static final String toWebActionProperty = "toweb";
    private static final String atomsetchooserAction = "atomsetchooser";
    private static final String copyImageActionProperty = "copyImage";
    private static final String copyScriptActionProperty = "copyScript";
    private static final String surfaceToolActionProperty = "surfaceTool";
    private static final String pasteClipboardActionProperty = "pasteClipboard";
    private static final String gaussianAction = "gauss";
    private static final String resizeAction = "resize";
    private Action[] defaultActions = new Action[]{new NewAction(), new NewwinAction(), new OpenAction(), new OpenUrlAction(), new OpenPdbAction(), new OpenMolAction(), this.printAction, this.exportAction, new CloseAction(), new ExitAction(), this.copyImageAction, this.copyScriptAction, this.pasteClipboardAction, new AboutAction(), new WhatsNewAction(), new CreditsAction(), new UguideAction(), new ConsoleAction(), new RecentFilesAction(), this.povrayAction, this.writeAction, this.toWebAction, new ScriptWindowAction(), new ScriptEditorAction(), new AtomSetChooserAction(), this.viewMeasurementTableAction, new GaussianAction(), new ResizeAction(), this.surfaceToolAction};
    static final String[] imageChoices;
    static final String[] imageExtensions;
    WebExport webExport;
    static final String chemFileProperty = "chemFile";

    public JmolPanel(JmolApp jmolApp, Splash splash, JFrame jFrame, JmolPanel jmolPanel, int n, int n2, Map<String, Object> map, Point point) {
        super(true);
        Object object;
        int n3;
        Object object2;
        this.jmolApp = jmolApp;
        this.frame = jFrame;
        this.startupWidth = n;
        this.startupHeight = n2;
        historyFile = jmolApp.historyFile;
        ++numWindows;
        try {
            this.say("history file is " + historyFile.getFile().getAbsolutePath());
            this.say("user properties file is " + jmolApp.userPropsFile.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        jFrame.setTitle("Jmol");
        jFrame.setDefaultCloseOperation(0);
        jFrame.getContentPane().setBackground(Color.lightGray);
        jFrame.getContentPane().setLayout(new BorderLayout());
        this.splash = splash;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.status = new StatusBar();
        this.say(GT._("Initializing 3D display..."));
        this.display = new DisplayPanel(this);
        if (map == null) {
            map = new Hashtable<String, Object>();
        }
        map.put("display", this.display);
        this.myStatusListener = new StatusListener(this, this.display);
        map.put("statusListener", this.myStatusListener);
        if (JmolResourceHandler.codePath != null) {
            map.put("codePath", JmolResourceHandler.codePath);
        }
        if (this.modelAdapter != null) {
            map.put("modelAdapter", this.modelAdapter);
        }
        this.vwrOptions = map;
        this.vwr = new Viewer(map);
        this.display.setViewer(this.vwr);
        this.myStatusListener.setViewer(this.vwr);
        if (!jmolApp.haveDisplay) {
            return;
        }
        this.getDialogs();
        this.say(GT._("Initializing Script Window..."));
        this.vwr.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
        this.say(GT._("Building Command Hooks..."));
        this.commands = new Hashtable<String, Action>();
        if (this.display != null) {
            object2 = this.getActions();
            for (n3 = 0; n3 < object2.size(); ++n3) {
                object = (Action)object2.get(n3);
                this.commands.put(object.getValue("Name").toString(), (Action)object);
            }
        }
        if (jmolApp.isKiosk) {
            this.add("Center", this.display);
        } else {
            object2 = new JPanel();
            this.menuItems = new Hashtable<String, JMenuItem>();
            this.say(GT._("Building Menubar..."));
            this.executeScriptAction = new ExecuteScriptAction();
            JMenuBar jMenuBar = this.createMenubar();
            this.add("North", jMenuBar);
            ((Container)object2).setLayout(new BorderLayout());
            this.toolbar = this.createToolbar();
            ((Container)object2).add("North", this.toolbar);
            object = new JPanel();
            ((Container)object).setLayout(new BorderLayout());
            ((Container)object).add("Center", this.display);
            ((Container)object2).add("Center", (Component)object);
            this.add("Center", (Component)object2);
            this.add("South", this.status);
        }
        this.say(GT._("Starting display..."));
        this.display.start();
        if (jmolApp.isKiosk) {
            bannerFrame = new BannerFrame(jmolApp.startupWidth, 75);
        } else if (point != null) {
            jFrame.setLocation(point);
        } else if (jmolPanel == null) {
            point = historyFile.getWindowPosition("Jmol");
            if (point != null) {
                jFrame.setLocation(point);
            }
        } else {
            point = jmolPanel.frame.getLocationOnScreen();
            int n4 = JmolPanel.screenSize.width - 50;
            n3 = JmolPanel.screenSize.height - 50;
            point.x += 40;
            point.y += 40;
            if (point.x > n4 || point.y > n3) {
                point.setLocation(0, 0);
            }
            jFrame.setLocation(point);
        }
        jFrame.getContentPane().add("Center", this);
        jFrame.addWindowListener(new AppCloser());
        jFrame.pack();
        jFrame.setSize(n, n2);
        ImageIcon imageIcon = JmolResourceHandler.getIconX("icon");
        Image image = imageIcon.getImage();
        jFrame.setIconImage(image);
        object = (AppConsole)this.vwr.getProperty("DATA_API", "getAppConsole", null);
        if (object != null && ((AppConsole)object).jcd != null) {
            historyFile.repositionWindow(SCRIPT_WINDOW_NAME, ((AppConsole)object).jcd, 200, 100, !jmolApp.isKiosk);
        }
        this.say(GT._("Setting up Drag-and-Drop..."));
        new FileDropper(this.myStatusListener, this.vwr);
        this.atomSetChooser = new AtomSetChooser(this.vwr, jFrame);
        this.pcs.addPropertyChangeListener(chemFileProperty, this.atomSetChooser);
        this.say(GT._("Launching main frame..."));
    }

    private void getDialogs() {
        this.say(GT._("Initializing Preferences..."));
        this.preferencesDialog = new PreferencesDialog(this, this.frame, this.guimap, this.vwr);
        this.say(GT._("Initializing Recent Files..."));
        this.recentFiles = new RecentFilesDialog(this.frame);
        if (this.jmolApp.haveDisplay) {
            if (this.display.measurementTable != null) {
                this.display.measurementTable.dispose();
            }
            this.display.measurementTable = new MeasurementTable(this.vwr, this.frame);
        }
    }

    protected static void startJmol(JmolApp jmolApp) {
        block12: {
            JFrame jFrame;
            Dialog.setupUIManager();
            if (jmolApp.isKiosk) {
                if (jmolApp.startupWidth < 100 || jmolApp.startupHeight < 100) {
                    jmolApp.startupWidth = JmolPanel.screenSize.width;
                    jmolApp.startupHeight = JmolPanel.screenSize.height - 75;
                }
                kioskFrame = new KioskFrame(0, 75, jmolApp.startupWidth, jmolApp.startupHeight, null);
                jFrame = kioskFrame;
            } else {
                jFrame = new JFrame();
            }
            Jmol jmol = null;
            try {
                if (jmolApp.jmolPosition != null) {
                    jFrame.setLocation(jmolApp.jmolPosition);
                }
                jmol = JmolPanel.getJmol(jmolApp, jFrame);
                jmolApp.startViewer(jmol.vwr, jmol.splash, false);
            }
            catch (Throwable throwable) {
                Logger.error("uncaught exception: " + throwable);
                throwable.printStackTrace();
            }
            if (jmolApp.haveConsole) {
                JmolPanel.getJavaConsole(jmol);
            }
            if (jmolApp.isKiosk) {
                kioskFrame.setPanel(jmol);
                bannerFrame.setLabel("click below and type exitJmol[enter] to quit");
                jmol.vwr.script("set allowKeyStrokes;set zoomLarge false;");
            }
            if (jmolApp.port > 0) {
                try {
                    jmol.service = JmolPanel.getJsonNioServer();
                    jmol.service.startService(jmolApp.port, jmol, jmol.vwr, "-1", 1);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    if (bannerFrame != null) {
                        bannerFrame.setLabel("could not start NIO service on port " + jmolApp.port);
                    }
                    if (jmol.service == null) break block12;
                    jmol.service.close();
                }
            }
        }
    }

    private static void getJavaConsole(Jmol jmol) {
        Serializable serializable;
        Serializable serializable2;
        jmol.consoleframe = new JFrame(GT._("Jmol Java Console"));
        jmol.consoleframe.setIconImage(jmol.frame.getIconImage());
        try {
            serializable2 = new ConsoleTextArea(true);
            serializable2.setFont(Font.decode("monospaced"));
            jmol.consoleframe.getContentPane().add((Component)new JScrollPane((Component)serializable2), "Center");
            serializable = jmol.guimap.newJButton("JavaConsole.Clear");
            ((AbstractButton)serializable).addActionListener(new ActionListener((ConsoleTextArea)serializable2){
                final /* synthetic */ ConsoleTextArea val$consoleTextArea;
                {
                    this.val$consoleTextArea = consoleTextArea;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$consoleTextArea.setText("");
                }
            });
            jmol.consoleframe.getContentPane().add((Component)serializable, "South");
        }
        catch (IOException iOException) {
            serializable = new JTextArea();
            serializable.setFont(Font.decode("monospaced"));
            jmol.consoleframe.getContentPane().add((Component)new JScrollPane((Component)serializable), "Center");
            serializable.append(GT._("Could not create ConsoleTextArea: ") + iOException);
        }
        serializable2 = jmol.frame.getLocation();
        serializable = jmol.frame.getSize();
        ((Point)serializable2).y += ((Dimension)serializable).height;
        ((Dimension)serializable).height = 200;
        if (((Dimension)serializable).height < 200 || ((Dimension)serializable).height > 800) {
            ((Dimension)serializable).height = 200;
        }
        if (((Dimension)serializable).width < 300 || ((Dimension)serializable).width > 800) {
            ((Dimension)serializable).width = 300;
        }
        if (((Point)serializable2).y < 0 || ((Point)serializable2).y + ((Dimension)serializable).height > JmolPanel.screenSize.height) {
            ((Point)serializable2).y = JmolPanel.screenSize.height - ((Dimension)serializable).height;
        }
        if (((Point)serializable2).x < 0 || ((Point)serializable2).x + ((Dimension)serializable).width > JmolPanel.screenSize.width) {
            ((Point)serializable2).x = 0;
        }
        jmol.consoleframe.setBounds(((Point)serializable2).x, ((Point)serializable2).y, ((Dimension)serializable).width, ((Dimension)serializable).height);
    }

    public static Jmol getJmol(JmolApp jmolApp, JFrame jFrame) {
        Accessible accessible;
        Splash splash = null;
        if (jmolApp.haveDisplay && jmolApp.splashEnabled) {
            accessible = JmolResourceHandler.getIconX("splash");
            if (!jmolApp.isSilent) {
                Logger.info("splash_image=" + accessible);
            }
            splash = new Splash(jFrame, (ImageIcon)accessible);
            splash.setCursor(new Cursor(3));
            splash.showStatus(GT._("Creating main window..."));
            splash.showStatus(GT._("Initializing Swing..."));
        }
        if (jmolApp.haveDisplay) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exception) {
                System.err.println("Error loading L&F: " + exception);
            }
        }
        if (splash != null) {
            splash.showStatus(GT._("Initializing Jmol..."));
        }
        accessible = new Jmol(jmolApp, splash, jFrame, null, jmolApp.startupWidth, jmolApp.startupHeight, jmolApp.info, null);
        if (jmolApp.haveDisplay) {
            jFrame.setVisible(true);
        }
        return accessible;
    }

    @Override
    public void showStatus(String string) {
        this.splash.showStatus(string);
    }

    private void report(String string) {
        if (this.jmolApp.isSilent) {
            return;
        }
        Logger.info(string);
    }

    private void say(String string) {
        if (this.jmolApp.haveDisplay) {
            if (this.splash == null) {
                this.report(string);
            } else {
                this.splash.showStatus(string);
            }
        }
    }

    public List<Action> getActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(this.defaultActions));
        arrayList.addAll(Arrays.asList(this.display.getActions()));
        arrayList.addAll(Arrays.asList(this.preferencesDialog.getActions()));
        return arrayList;
    }

    protected boolean doClose(boolean bl) {
        if (numWindows == 1 && this.vwr.ms.ac > 0 && JOptionPane.showConfirmDialog(this.frame, GT._("Exit Jmol?"), "Exit", 0, 3) != 0) {
            return false;
        }
        this.dispose(this.frame, bl);
        return true;
    }

    void dispose(JFrame jFrame, boolean bl) {
        if (this.webExport != null) {
            WebExport.cleanUp();
        }
        if (bl) {
            this.saveWindowSizes();
        }
        if (this.service != null) {
            this.service.close();
            this.service = null;
        }
        if (this.serverService != null) {
            this.serverService.close();
            this.serverService = null;
        }
        if (numWindows <= 1) {
            this.report(GT._("Closing Jmol..."));
            System.exit(0);
        } else {
            --numWindows;
            this.vwr.dispose();
            try {
                jFrame.dispose();
            }
            catch (Exception exception) {
                Logger.error("frame disposal exception");
            }
        }
    }

    void saveWindowSizes() {
        Component component;
        AppConsole appConsole;
        if (historyFile == null) {
            return;
        }
        if (this.frame != null) {
            this.jmolApp.border.x = this.frame.getWidth() - this.display.dimSize.width;
            this.jmolApp.border.y = this.frame.getHeight() - this.display.dimSize.height;
            historyFile.addWindowInfo("Jmol", this.frame, this.jmolApp.border);
        }
        if ((appConsole = (AppConsole)this.vwr.getProperty("DATA_API", "getAppConsole", null)) != null && appConsole.jcd != null) {
            historyFile.addWindowInfo(SCRIPT_WINDOW_NAME, appConsole.jcd, null);
        }
        if ((component = (Component)this.vwr.getProperty("DATA_API", "getScriptEditor", null)) != null) {
            historyFile.addWindowInfo(EDITOR_WINDOW_NAME, component, null);
        }
        if (historyFile.getProperty("clearHistory", "false").equals("true")) {
            historyFile.clear();
        }
    }

    private JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = string.endsWith("Check") ? this.guimap.newJCheckBoxMenuItem(string, false) : this.guimap.newJMenuItem(string);
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        if (imageIcon != null) {
            jMenuItem.setHorizontalTextPosition(4);
            jMenuItem.setIcon(imageIcon);
        }
        if (string.endsWith("Script")) {
            jMenuItem.setActionCommand(JmolResourceHandler.getStringX(string));
            jMenuItem.addActionListener(this.executeScriptAction);
        } else {
            jMenuItem.setActionCommand(string);
            Action action = this.getAction(string);
            if (action != null) {
                jMenuItem.addActionListener(action);
                action.addPropertyChangeListener(new ActionChangedListener(jMenuItem));
                jMenuItem.setEnabled(action.isEnabled());
            } else {
                jMenuItem.setEnabled(false);
            }
        }
        this.menuItems.put(string, jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem getMenuItem(String string) {
        return this.menuItems.get(string);
    }

    protected Action getAction(String string) {
        return this.commands.get(string);
    }

    private JToolBar createToolbar() {
        this.toolbar = new JToolBar();
        String[] stringArray = PT.getTokens(JmolResourceHandler.getStringX("toolbar"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                this.toolbar.addSeparator();
                continue;
            }
            this.toolbar.add(this.createTool(stringArray[i]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected Component createTool(String string) {
        return this.createToolbarButton(string);
    }

    protected AbstractButton createToolbarButton(String string) {
        String string2;
        boolean bl;
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        boolean bl2 = string.startsWith("animatePrev") || string.startsWith("animateNext");
        AbstractButton abstractButton = bl2 ? new AnimButton(imageIcon, JmolResourceHandler.getStringX(string)) : new JmolButton(imageIcon);
        String string3 = JmolResourceHandler.getStringX(string + "Toggle");
        if (string3 != null && (bl = Boolean.valueOf(string3).booleanValue())) {
            abstractButton = new JmolToggleButton(imageIcon);
            if (string.equals("rotateScript")) {
                this.display.buttonRotate = abstractButton;
            }
            if (string.equals("modelkitScript")) {
                this.display.buttonModelkit = abstractButton;
            }
            this.display.toolbarButtonGroup.add(abstractButton);
            string2 = JmolResourceHandler.getStringX(string + "ToggleSelected");
            if (string2 != null) {
                boolean bl3 = Boolean.valueOf(string2);
                abstractButton.setSelected(bl3);
            }
        }
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setMargin(new Insets(1, 1, 1, 1));
        Action action = null;
        string2 = null;
        if (!bl2) {
            if (string.endsWith("Script")) {
                string2 = JmolResourceHandler.getStringX(string);
                action = this.executeScriptAction;
            } else {
                string2 = string;
                action = this.getAction(string);
            }
        }
        if (action != null) {
            abstractButton.setActionCommand(string2);
            abstractButton.addActionListener(action);
            action.addPropertyChangeListener(new ActionChangedListener(abstractButton));
            abstractButton.setEnabled(action.isEnabled());
        } else {
            abstractButton.setEnabled(bl2);
        }
        String string4 = this.guimap.getLabel(string + "Tip");
        if (string4 != null) {
            this.guimap.map.put(string + "Tip", abstractButton);
            abstractButton.setToolTipText(string4);
        }
        return abstractButton;
    }

    private JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.addNormalMenuBar(jMenuBar);
        this.addMacrosMenuBar(jMenuBar);
        this.addHelpMenuBar(jMenuBar);
        return jMenuBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMacrosMenuBar(JMenuBar jMenuBar) {
        JMenu jMenu = this.guimap.newJMenu("macros");
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmol" + System.getProperty("file.separator") + "macros");
        this.report("User macros dir: " + file);
        this.report("       exists: " + file.exists());
        this.report("  isDirectory: " + file.isDirectory());
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                if (!string.endsWith(".macro")) continue;
                if (Logger.debugging) {
                    Logger.debug("Possible macro found: " + string);
                }
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(fileArray[i]);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    String string2 = properties.getProperty("Title");
                    String string3 = properties.getProperty("Script");
                    JMenuItem jMenuItem = new JMenuItem(string2);
                    jMenuItem.setActionCommand(string3);
                    jMenuItem.addActionListener(this.executeScriptAction);
                    jMenu.add(jMenuItem);
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Could not load macro file: ");
                    System.err.println(iOException);
                    continue;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        jMenuBar.add(jMenu);
    }

    private void addNormalMenuBar(JMenuBar jMenuBar) {
        String[] stringArray = PT.getTokens(JmolResourceHandler.getStringX("menubar"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                jMenuBar.add(Box.createHorizontalGlue());
                continue;
            }
            JMenu jMenu = this.createMenu(stringArray[i]);
            if (jMenu == null) continue;
            jMenuBar.add(jMenu);
        }
    }

    private void addHelpMenuBar(JMenuBar jMenuBar) {
        JMenu jMenu = this.createMenu("help");
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
    }

    JMenu createMenu(String string) {
        String[] stringArray = PT.getTokens(JmolResourceHandler.getStringX(string));
        JMenu jMenu = this.guimap.newJMenu(string);
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        if (imageIcon != null) {
            jMenu.setHorizontalTextPosition(4);
            jMenu.setIcon(imageIcon);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("-")) {
                jMenu.addSeparator();
                continue;
            }
            if (string2.endsWith("Menu")) {
                jMenu.add(this.createMenu(string2));
                continue;
            }
            JMenuItem jMenuItem = this.createMenuItem(string2);
            jMenu.add(jMenuItem);
        }
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                String string = ((JmolAbstractButton)menuEvent.getSource()).getKey();
                if (string.equals("display") || string.equals("tools")) {
                    JmolPanel.this.setMenuState();
                }
                if (string.equals("nboMenu")) {
                    JmolPanel.this.setMenuNBO((JMenu)menuEvent.getSource());
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    void setMenuState() {
        this.guimap.setSelected("perspectiveCheck", this.vwr.tm.perspectiveDepth);
        this.guimap.setSelected("hydrogensCheck", this.vwr.getBoolean(603979922));
        this.guimap.setSelected("measurementsCheck", this.vwr.getBoolean(603979926));
        this.guimap.setSelected("axesCheck", this.vwr.getShowAxes());
        this.guimap.setSelected("boundboxCheck", this.vwr.getShowBbcage());
        this.guimap.setEnabled("openJSpecViewScript", !this.vwr.getBoolean(1073742086));
        this.guimap.setEnabled("simulate1HSpectrumScript", !this.vwr.getBoolean(1073742086));
    }

    void doNew() {
        JFrame jFrame = new JFrame();
        new Jmol(this.jmolApp, null, jFrame, (Jmol)this, this.startupWidth, this.startupHeight, this.vwrOptions, null);
        jFrame.setVisible(true);
    }

    void setMenuNBO(JMenu jMenu) {
    }

    void startNBO(String string) {
        this.getNBOService();
        if (this.nboDialog == null) {
            this.nboDialog = new NBODialog(this.frame, this.vwr, this.nboService);
        } else {
            this.nboDialog.setVisible(true);
        }
        if (string != null) {
            this.nboDialog.openPanel(string.charAt(0));
        }
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.display);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                Logger.errorEx("Error while printing", printerException);
            }
        }
    }

    String createImageStatus(String string, String string2, Object object, int n) {
        if (string != null && object != null) {
            return null;
        }
        String string3 = string;
        if (string3 != null && !string3.startsWith("OK") && this.status != null) {
            this.status.setStatus(1, GT._("IO Exception:"));
            this.status.setStatus(2, string3);
        }
        return string3;
    }

    void createWebExport() {
        this.webExport = WebExport.createAndShowGUI(this.vwr, historyFile, WEB_MAKER_WINDOW_NAME);
    }

    void createSurfaceTool() {
        if (this.surfaceTool != null) {
            this.surfaceTool.toFront();
        } else {
            this.surfaceTool = new SurfaceTool(this.vwr, historyFile, SURFACETOOL_WINDOW_NAME, true);
        }
    }

    public static File getUserDirectory() {
        String string = System.getProperty("user.dir");
        return string == null ? null : new File(System.getProperty("user.dir"));
    }

    void openFile() {
        String string = new Dialog().getOpenFileNameFromDialog(this.vwrOptions, this.vwr, null, this.jmolApp, FILE_OPEN_WINDOW_NAME, true);
        if (string == null) {
            return;
        }
        int n = 9;
        if (string.startsWith("#NOCARTOONS#;")) {
            --n;
            string = string.substring(13);
        }
        if (string.startsWith("#APPEND#;")) {
            string = string.substring(9);
            n += 4;
        }
        this.vwr.openFileAsyncSpecial(string, n);
    }

    void notifyFileOpen(String string, String string2) {
        if (string == null || !string.equals("file[]")) {
            int n;
            int n2 = n = string == null ? -1 : string.lastIndexOf("|");
            if (n > 0) {
                string = string.substring(0, n);
            }
            this.recentFiles.notifyFileOpen(string);
            this.frame.setTitle(string2);
        }
        if (this.atomSetChooser == null) {
            this.atomSetChooser = new AtomSetChooser(this.vwr, this.frame);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.atomSetChooser);
        }
        this.pcs.firePropertyChange(chemFileProperty, null, null);
    }

    int[] resizeInnerPanel(String string) {
        int n;
        int n2 = this.vwr.getScreenWidth();
        int n3 = this.vwr.getScreenHeight();
        String string2 = n2 + " " + n3;
        if (string == null) {
            string = string2;
        } else {
            int n4 = string.indexOf("preferredWidthHeight ");
            n = string.indexOf(";", n4 + 1);
            if (n4 >= 0 && n > n4) {
                string = string.substring(n4 + 21, n).trim();
            }
            if (string.equals(string2)) {
                return new int[]{n2, n3};
            }
        }
        string2 = JOptionPane.showInputDialog(GT._("width height?"), (Object)string);
        if (string2 == null) {
            return new int[]{n2, n3};
        }
        float[] fArray = new float[2];
        n = Parser.parseStringInfestedFloatArray(string2, null, fArray);
        if (n < 2) {
            return new int[]{n2, n3};
        }
        System.out.println("JmolPanel requesting display " + string2 + " " + fArray[0] + " " + fArray[1]);
        this.resizeDisplay((int)fArray[0], (int)fArray[1]);
        return new int[]{(int)fArray[0], (int)fArray[1]};
    }

    void resizeDisplay(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        this.display.setJmolSize(dimension);
        dimension = new Dimension(n, 30);
        this.status.setPreferredSize(dimension);
        this.toolbar.setPreferredSize(dimension);
        Platform.getWindow(this).pack();
        dimension = new Dimension(n, n2);
        System.out.println("resizeDisplay " + this.display.getSize((Dimension)dimension).width);
    }

    void updateLabels() {
        if (this.atomSetChooser != null) {
            this.atomSetChooser.dispose();
            this.atomSetChooser = null;
        }
        if (this.gaussianDialog != null) {
            this.gaussianDialog.dispose();
            this.gaussianDialog = null;
        }
        if (this.nboDialog != null) {
            this.nboDialog.dispose();
            this.nboDialog = null;
        }
        boolean bl = GT.setDoTranslate(true);
        this.getDialogs();
        GT.setDoTranslate(bl);
        this.guimap.updateLabels();
    }

    @Override
    public void nioRunContent(JsonNioServer jsonNioServer) {
    }

    @Override
    public void nioClosed(JsonNioServer jsonNioServer) {
        if (bannerFrame != null) {
            this.vwr.scriptWait("delay 2");
            bannerFrame.dispose();
            this.vwr.dispose();
            System.exit(0);
        }
        if (jsonNioServer.equals(this.service)) {
            this.service = null;
        } else if (jsonNioServer.equals(this.serverService)) {
            this.serverService = null;
        }
    }

    @Override
    public void setBannerLabel(String string) {
        if (bannerFrame != null) {
            bannerFrame.setLabel(string);
        }
    }

    void sendNioMessage(int n, String string) {
        try {
            if (n < 0) {
                if (this.serverService != null && "STOP".equalsIgnoreCase(string)) {
                    this.serverService.close();
                } else if (this.serverService == null) {
                    this.serverService = JmolPanel.getJsonNioServer();
                    if (this.serverService != null) {
                        this.serverService.startService(n, this, this.vwr, "-1", 1);
                    }
                }
                if (this.serverService != null && this.serverService.getPort() == -n && string != null) {
                    if (this.service == null) {
                        this.service = JmolPanel.getJsonNioServer();
                        if (this.service != null) {
                            this.service.startService(-n, this, this.vwr, null, 1);
                        }
                    }
                    if (this.service != null) {
                        this.service.send(-n, string);
                    }
                    return;
                }
                return;
            }
            if (string == null) {
                return;
            }
            if (string.equalsIgnoreCase("STOP")) {
                string = "{\"type\":\"quit\"}";
            }
            if (this.service == null && this.serverService != null && this.serverService.getPort() == n) {
                this.serverService.send(n, string);
                return;
            }
            if (this.service == null) {
                this.service = JmolPanel.getJsonNioServer();
                if (this.service != null) {
                    this.service.startService(n, this, this.vwr, null, 1);
                }
            }
            if (this.service != null) {
                this.service.send(n, string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static JsonNioServer getJsonNioServer() {
        return (JsonNioServer)Interface.getInterface("org.openscience.jmol.app.jsonkiosk.JsonNioService", null, null);
    }

    public void syncScript(String string) {
        this.vwr.syncScript(string, "~", 0);
    }

    public NBOService getNBOService() {
        return this.nboService == null ? (this.nboService = new NBOService(this.vwr)) : this.nboService;
    }

    public void updateConsoleFont() {
        AppConsole appConsole = (AppConsole)this.vwr.getProperty("DATA_API", "getAppConsole", null);
        if (appConsole != null) {
            appConsole.updateFontSize();
        }
    }

    public Object getPreference(String string) {
        return this.preferencesDialog.currentProperties.get(string);
    }

    static {
        numWindows = 0;
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        imageChoices = new String[]{"JPEG", "PNG", "GIF", "PPM", "PDF"};
        imageExtensions = new String[]{"jpg", "png", "gif", "ppm", "pdf"};
    }

    private class AnimButton
    extends JmolButton
    implements MouseListener {
        private String script;
        private long lastPressTime;

        protected AnimButton(ImageIcon imageIcon, String string) {
            super(imageIcon);
            this.script = string;
            this.addMouseListener(this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JmolPanel.this.vwr.evalStringQuiet(this.script);
            long l = System.currentTimeMillis();
            if ((float)(l - this.lastPressTime) > JmolPanel.this.jmolApp.autoAnimationDelay * 2000.0f && JmolPanel.this.jmolApp.autoAnimationDelay > 0.0f) {
                JmolPanel.this.vwr.evalStringQuiet("timeout '__animBtn' OFF;animation_running = true; delay " + JmolPanel.this.jmolApp.autoAnimationDelay + "; if(animation_running){timeout '__animBtn' -200 \"" + this.script + "\"}");
            }
            this.lastPressTime = l;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (JmolPanel.this.jmolApp.autoAnimationDelay > 0.0f) {
                JmolPanel.this.vwr.evalStringQuiet("animation_running = false; timeout '__animBtn' OFF");
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    class ResizeAction
    extends AbstractAction {
        public ResizeAction() {
            super(JmolPanel.resizeAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.resizeInnerPanel(null);
        }
    }

    class ExecuteScriptAction
    extends AbstractAction {
        public ExecuteScriptAction() {
            super("executeScriptAction");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.indexOf("#showMeasurementTable") >= 0) {
                JmolPanel.this.display.measurementTable.activate();
            }
            JmolPanel.this.vwr.evalStringQuiet(string);
        }
    }

    class SurfaceToolAction
    extends AbstractAction {
        public SurfaceToolAction() {
            super(JmolPanel.surfaceToolActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JmolPanel.this.createSurfaceTool();
                }
            });
        }
    }

    class ViewMeasurementTableAction
    extends AbstractAction {
        public ViewMeasurementTableAction() {
            super("viewMeasurementTable");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.display.measurementTable.activate();
        }
    }

    class ToWebAction
    extends AbstractAction {
        public ToWebAction() {
            super(JmolPanel.toWebActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JmolPanel.this.createWebExport();
                }
            });
        }
    }

    class WriteAction
    extends AbstractAction {
        public WriteAction() {
            super(JmolPanel.writeActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = new Dialog().getSaveFileNameFromDialog(JmolPanel.this.vwr, null, "SPT");
            if (string != null) {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("fileName", string);
                hashtable.put("type", "SPT");
                hashtable.put("text", JmolPanel.this.vwr.getStateInfo());
                String string2 = JmolPanel.this.vwr.outputToFile(hashtable);
                Logger.info(string2);
            }
        }
    }

    class PovrayAction
    extends AbstractAction {
        public PovrayAction() {
            super(JmolPanel.povrayActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new PovrayDialog(JmolPanel.this.frame, JmolPanel.this.vwr);
        }
    }

    class AtomSetChooserAction
    extends AbstractAction {
        public AtomSetChooserAction() {
            super(JmolPanel.atomsetchooserAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.atomSetChooser.setVisible(true);
        }
    }

    class ScriptEditorAction
    extends AbstractAction {
        public ScriptEditorAction() {
            super(JmolPanel.editorAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)JmolPanel.this.vwr.getProperty("DATA_API", "getScriptEditor", null);
            if (component != null) {
                component.setVisible(true);
            }
        }
    }

    class ScriptWindowAction
    extends AbstractAction {
        public ScriptWindowAction() {
            super(JmolPanel.consoleAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AppConsole appConsole = (AppConsole)JmolPanel.this.vwr.getProperty("DATA_API", "getAppConsole", null);
            if (appConsole != null) {
                appConsole.setVisible(true);
            }
        }
    }

    class RecentFilesAction
    extends AbstractAction {
        public RecentFilesAction() {
            super(JmolPanel.recentFilesAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.recentFiles.setVisible(true);
            String string = JmolPanel.this.recentFiles.getFile();
            if (string == null || string.length() == 0) {
                return;
            }
            if (string.endsWith(" (*)")) {
                JmolPanel.this.vwr.openFileAsyncSpecial(string.substring(0, string.length() - 4), 9);
            } else {
                JmolPanel.this.vwr.openFileAsyncSpecial(string, 8);
            }
        }
    }

    class ExportAction
    extends AbstractAction {
        ExportAction() {
            super(JmolPanel.exportActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Dialog dialog = new Dialog();
            String string = dialog.getImageFileNameFromDialog(JmolPanel.this.vwr, null, JmolPanel.this.imageType, imageChoices, imageExtensions, JmolPanel.this.qualityJPG, JmolPanel.this.qualityPNG);
            if (string == null) {
                return;
            }
            JmolPanel.this.qualityJPG = dialog.getQuality("JPG");
            JmolPanel.this.qualityPNG = dialog.getQuality("PNG");
            JmolPanel.this.imageType = dialog.getType();
            String string2 = JmolPanel.this.imageType;
            if (string2 == null) {
                string2 = string;
                int n = string2.lastIndexOf(".");
                if (n < 0) {
                    return;
                }
                string2 = string2.substring(n + 1).toUpperCase();
            }
            if (string.indexOf(".") < 0) {
                string = string + "." + (string2.equalsIgnoreCase("JPEG") ? "jpg" : string2.toLowerCase());
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("fileName", string);
            hashtable.put("type", string2);
            hashtable.put("quality", dialog.getQuality(string2));
            String string3 = JmolPanel.this.vwr.outputToFile(hashtable);
            Logger.info(string3);
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(JmolPanel.exitAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.saveWindowSizes();
            System.exit(0);
        }
    }

    class NewAction
    extends AbstractAction {
        protected String script;

        NewAction() {
            super(JmolPanel.newAction);
        }

        NewAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.script == null) {
                JmolPanel.this.revalidate();
            } else {
                JmolPanel.this.vwr.script(this.script);
            }
        }
    }

    class OpenMolAction
    extends NewAction {
        OpenMolAction() {
            super(JmolPanel.openmolAction);
            this.script = "var x__id__ = _smilesString; if (!x__id__) { x__id__ = 'tylenol'};x__id__ = prompt('" + GT._("Enter the name or identifier (SMILES, InChI, CAS) of a compound. Preface with \":\" to load from PubChem; otherwise Jmol will use the NCI/NIH Resolver.") + "',x__id__);if (!x__id__) { quit }; load @{(x__id__[1]==':' ? x__id__ : '$' + x__id__)}";
        }
    }

    class OpenPdbAction
    extends NewAction {
        OpenPdbAction() {
            super(JmolPanel.openpdbAction);
            this.script = "var x__id__ = _modelTitle; if (x__id__.length != 4) { x__id__ = '1crn'};x__id__ = prompt('" + GT._("Enter a four-digit PDB model ID or \"=\" and a three-digit ligand ID") + "',x__id__);if (!x__id__) { quit }; load @{'=' + x__id__}";
        }
    }

    class OpenUrlAction
    extends NewAction {
        String title;
        String prompt;

        OpenUrlAction() {
            super(JmolPanel.openurlAction);
            this.title = GT._("Open URL");
            this.prompt = GT._("Enter URL of molecular model");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(JmolPanel.this.frame, this.prompt, this.title, -1);
            if (string != null) {
                if (string.indexOf("://") < 0) {
                    if (string.length() == 4 && string.indexOf(".") < 0) {
                        string = "=" + string;
                    }
                    if (!string.startsWith("=")) {
                        string = "http://" + string;
                    }
                }
                JmolPanel.this.vwr.openFileAsync(string);
            }
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(JmolPanel.openAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.openFile();
        }
    }

    class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super(JmolPanel.printActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.print();
        }
    }

    class CopyScriptAction
    extends AbstractAction {
        public CopyScriptAction() {
            super(JmolPanel.copyScriptActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.vwr.clipImageOrPasteText((String)JmolPanel.this.vwr.getProperty("string", "stateInfo", null));
        }
    }

    class CopyImageAction
    extends AbstractAction {
        public CopyImageAction() {
            super(JmolPanel.copyImageActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.vwr.clipImageOrPasteText(null);
        }
    }

    class PasteClipboardAction
    extends AbstractAction {
        public PasteClipboardAction() {
            super(JmolPanel.pasteClipboardActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.vwr.loadInlineAppend(JmolPanel.this.vwr.getClipboardText(), false);
        }
    }

    class UguideAction
    extends AbstractAction {
        public UguideAction() {
            super(JmolPanel.uguideAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.vwr.showUrl(JmolResourceHandler.getStringX("UGuide.wikiURL"));
        }
    }

    class NewwinAction
    extends AbstractAction {
        NewwinAction() {
            super(JmolPanel.newwinAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.doNew();
        }
    }

    class GaussianAction
    extends AbstractAction {
        public GaussianAction() {
            super(JmolPanel.gaussianAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JmolPanel.this.gaussianDialog == null) {
                JmolPanel.this.gaussianDialog = new GaussianDialog(JmolPanel.this.frame, JmolPanel.this.vwr);
            }
            JmolPanel.this.gaussianDialog.setVisible(true);
        }
    }

    class CreditsAction
    extends AbstractAction {
        public CreditsAction() {
            super(JmolPanel.creditsAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new CreditsDialog(JmolPanel.this.frame).setVisible(true);
        }
    }

    class WhatsNewAction
    extends AbstractAction {
        public WhatsNewAction() {
            super(JmolPanel.whatsnewAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WhatsNewDialog whatsNewDialog = new WhatsNewDialog(JmolPanel.this.frame);
            whatsNewDialog.setVisible(true);
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(JmolPanel.aboutAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog aboutDialog = new AboutDialog(JmolPanel.this.frame, JmolPanel.this.vwr);
            aboutDialog.setVisible(true);
        }
    }

    class ConsoleAction
    extends AbstractAction {
        public ConsoleAction() {
            super("jconsole");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JmolPanel.this.consoleframe != null) {
                JmolPanel.this.consoleframe.setVisible(true);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super(JmolPanel.closeAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!JmolPanel.this.doClose(true)) {
                JmolPanel.this.vwr.script("zap");
            }
        }
    }

    private static class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton abstractButton) {
            this.button = abstractButton;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (this.button.getText() != null) {
                    this.button.setText(string2);
                }
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setEnabled(bl);
            }
        }
    }

    protected final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            JmolPanel.this.doClose(false);
        }
    }
}

