/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.Rdr;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class JanaReader
extends AtomSetCollectionReader {
    private Lst<float[]> lattvecs;
    private int thisSub;
    private String modAxes;
    private int modDim;
    private boolean haveM40Data;
    static final String records = "tit  cell ndim qi   lat  sym  spg  end  wma";
    static final int TITLE = 0;
    static final int CELL = 5;
    static final int NDIM = 10;
    static final int QI = 15;
    static final int LATT = 20;
    static final int SYM = 25;
    static final int SPG = 30;
    static final int END = 35;
    static final int WMATRIX = 40;
    private int qicount;
    private String molName;
    private Lst<Atom> molAtoms;
    private Lst<Integer> molTtypes;
    private Lst<P3> modelMolecule;
    private boolean molHasTLS;
    private M3 matR;
    private P3 rho;
    private boolean firstPosition;
    private V3 vR;
    private V3 v0Cart;
    private boolean isLegendre;
    public static final String U_LIST = "U11U22U33U12U13U23UISO";
    private static String[] XYZ = new String[]{"x", "y", "z"};
    private float[] floats = new float[6];

    public void initializeReader() throws Exception {
        this.modAxes = this.getFilter("MODAXES=");
        this.setFractionalCoordinates(true);
        this.asc.newAtomSet();
        this.asc.setCurrentModelInfo("autoBondUsingOccupation", (Object)Boolean.TRUE);
    }

    protected boolean checkLine() throws Exception {
        if (this.line.length() < 3) {
            return true;
        }
        Logger.info((String)this.line);
        this.parseTokenStr(this.line);
        switch (records.indexOf(this.line.substring(0, 3))) {
            case 0: {
                this.asc.setAtomSetName(this.line.substring(5).trim());
                break;
            }
            case 5: {
                this.cell();
                this.setSymmetryOperator("x,y,z");
                break;
            }
            case 10: {
                this.ndim();
                break;
            }
            case 20: {
                if (this.lattvecs == null) {
                    this.lattvecs = new Lst();
                }
                if (this.ms.addLatticeVector(this.lattvecs, this.line.substring(8))) break;
                this.appendLoadNote(this.line + " not supported");
                break;
            }
            case 30: {
                this.setSpaceGroupName(this.getTokens()[1]);
                break;
            }
            case 25: {
                this.symmetry();
                break;
            }
            case 15: {
                this.qi();
                break;
            }
            case 35: {
                while (this.rd() != null) {
                    if (!this.line.startsWith("command") && this.parseIntStr(this.line) < 0) continue;
                    this.readM40Data(true);
                    break;
                }
                this.continuing = false;
                break;
            }
            case 40: {
                Matrix matrix;
                int n = 3 + this.modDim;
                if (this.thisSub++ == 0) {
                    matrix = Matrix.identity((int)n, (int)n);
                    this.ms.addSubsystem("" + this.thisSub++, matrix);
                }
                matrix = new Matrix((double[][])null, n, n);
                double[][] dArray = matrix.getArray();
                float[] fArray = new float[n * n];
                this.fillFloatArray(null, 0, fArray);
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    int n3 = 0;
                    while (n3 < n) {
                        dArray[i][n3] = fArray[n2];
                        ++n3;
                        ++n2;
                    }
                }
                this.ms.addSubsystem("" + this.thisSub, matrix);
            }
        }
        return true;
    }

    public void doPreSymmetry() throws Exception {
        if (this.ms != null) {
            this.ms.setModulation(false, null);
        }
        if (this.vibsFractional) {
            this.asc.getXSymmetry().scaleFractionalVibs();
        }
    }

    public void finalizeSubclassReader() throws Exception {
        if (!this.haveM40Data) {
            this.readM40Data(false);
        }
        if (this.lattvecs != null && this.lattvecs.size() > 0) {
            this.asc.getSymmetry().addLatticeVectors(this.lattvecs);
        }
        this.applySymmetryAndSetTrajectory();
        this.finalizeReaderASCR();
    }

    protected void finalizeSubclassSymmetry(boolean bl) throws Exception {
        this.adjustM40Occupancies();
        if (this.ms != null && bl) {
            this.ms.setModulation(true, this.asc.getXSymmetry().getBaseSymmetry());
            this.ms.finalizeModulation();
        }
    }

    private void cell() throws Exception {
        for (int i = 0; i < 6; ++i) {
            this.setUnitCellItem(i, this.parseFloat());
        }
    }

    private void ndim() throws Exception {
        this.ms = (MSInterface)Interface.getOption((String)"adapter.readers.cif.MSRdr", (Viewer)this.vwr, (String)"file");
        this.modDim = this.ms.initialize((AtomSetCollectionReader)this, this.parseIntStr(this.getTokens()[1]) - 3);
    }

    private void qi() throws Exception {
        double[] dArray = new double[this.modDim];
        dArray[this.qicount] = 1.0;
        double[] dArray2 = new double[]{this.parseFloat(), this.parseFloat(), this.parseFloat()};
        this.parseTokenStr(this.rd());
        int n = 0;
        while (n < 3) {
            int n2 = n++;
            dArray2[n2] = dArray2[n2] + (double)this.parseFloat();
        }
        this.ms.addModulation(null, "W_" + ++this.qicount, dArray2, -1);
        this.ms.addModulation(null, "F_" + this.qicount + "_coefs_", dArray, -1);
    }

    private void symmetry() throws Exception {
        this.setSymmetryOperator(PT.rep((String)this.line.substring(9).trim(), (String)" ", (String)","));
    }

    private void readM40Data(boolean bl) throws Exception {
        int n;
        if (bl) {
            this.parseM40Floats();
        } else {
            String string = this.filePath;
            n = string.lastIndexOf(".");
            if (n < 0) {
                return;
            }
            string = string.substring(0, n + 2) + "40";
            String string2 = string.substring(0, n);
            this.reader.close();
            this.reader = Rdr.getBR((String)((String)this.vwr.getLigandModel(string2, string, "_file", "----")));
            if (this.out != null) {
                this.out.append("******************************* M40 DATA *******************************\n");
            }
            this.readM40Floats();
        }
        this.haveM40Data = true;
        if (this.line.startsWith("command")) {
            this.readM40WaveVectors();
        }
        int n2 = 0;
        n = 0;
        boolean bl2 = false;
        BS bS = this.thisSub == 0 ? null : new BS();
        int n3 = this.thisSub == 0 ? 1 : this.thisSub;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n3) {
            n2 = this.getInt(n6, n6 + 5);
            n = this.getInt(n6 + 5, n6 + 10);
            boolean bl3 = bl2 = this.getInt(n6 + 15, n6 + 20) == 1;
            if (n != 0 && n4 > 0) {
                throw new Exception("Jmol cannot read rigid body M40 files for composites");
            }
            if (bS != null) {
                bS.set(n5 += n2);
            }
            ++n4;
            n6 += 10;
        }
        n3 = bS == null ? 0 : 1;
        n4 = -1;
        String string = null;
        this.rho = null;
        if (n > 0) {
            Logger.info((String)("JanaReader found " + n2 + " free atoms and " + n + " groups"));
            this.molName = null;
            this.molAtoms = new Lst();
            this.molTtypes = new Lst();
        }
        while (this.skipToNextAtom() != null) {
            String string3;
            String string4;
            ++n4;
            Atom atom = new Atom();
            Logger.info((String)this.line);
            atom.atomName = string4 = this.line.substring(0, 9).trim();
            boolean bl4 = string4.equals(string);
            atom.foccupancy = this.floats[2];
            boolean bl5 = Float.isNaN(atom.foccupancy);
            if (bl5) {
                String string5 = this.getStr(12, 18);
                if (string5.length() > 0 && !string5.equals("1")) {
                    throw new Exception("Jmol cannot process M40 files with molecule positions based on point-group symmetry.");
                }
                string = null;
                if (Float.isNaN(this.floats[4])) {
                    string = this.getStr(28, 37);
                } else {
                    this.rho = P3.new3((float)this.floats[3], (float)this.floats[4], (float)this.floats[5]);
                }
                this.molName = string4;
                this.molAtoms.clear();
                this.molTtypes.clear();
                this.molHasTLS = false;
                this.firstPosition = true;
                this.modelMolecule = new Lst();
                continue;
            }
            boolean bl6 = false;
            String string6 = string3 = string4.startsWith("pos#") ? string4 : null;
            if (string3 == null) {
                if (!this.filterAtom(atom, 0)) {
                    if (!bl4) continue;
                    bl6 = true;
                }
                this.setAtomCoordXYZ(atom, this.floats[3], this.floats[4], this.floats[5]);
                if (bl4) {
                    this.rho = P3.newP((T3)atom);
                    if (bl6) continue;
                }
                this.asc.addAtom(atom);
                if (n3 > 0) {
                    if (bS.get(n4)) {
                        ++n3;
                    }
                    atom.altLoc = ("" + n3).charAt(0);
                }
                this.readAtomRecord(atom, null, null, false);
                if (this.molAtoms == null) continue;
                this.molAtoms.addLast((Object)atom);
                continue;
            }
            if (this.molAtoms.size() == 0) continue;
            this.processPosition(string3, atom, bl2);
        }
    }

    private int getInt(int n, int n2) {
        int n3 = this.line.length();
        return n3 > n ? this.parseIntStr(this.getStr(n, n2)) : 0;
    }

    private String getStr(int n, int n2) {
        int n3 = this.line.length();
        return n3 > n ? this.line.substring(n, Math.min(n3, n2)).trim() : "";
    }

    private boolean getFlag(int n) {
        return this.getInt(n, n + 1) > 0;
    }

    private String skipToNextAtom() throws Exception {
        while (this.readM40Floats() != null && (this.line.length() == 0 || this.line.charAt(0) == ' ' || this.line.charAt(0) == '-')) {
        }
        return this.line;
    }

    private void readM40WaveVectors() throws Exception {
        while (!this.readM40Floats().contains("end")) {
            if (!this.line.startsWith("wave")) continue;
            String[] stringArray = this.getTokens();
            double[] dArray = new double[this.modDim];
            for (int i = 0; i < this.modDim; ++i) {
                dArray[i] = this.parseFloatStr(stringArray[i + 2]);
            }
            this.ms.addModulation(null, "F_" + this.parseIntStr(stringArray[1]) + "_coefs_", dArray, -1);
        }
        this.readM40Floats();
    }

    private void processPosition(String string, Atom atom, boolean bl) throws Exception {
        P3 p3;
        atom.atomName = this.molName + "_" + string;
        boolean bl2 = this.getInt(9, 11) == -1;
        int n = this.getInt(13, 14);
        P3 p32 = n == 0 ? null : new P3();
        P3 p33 = p3 = n == 0 ? null : new P3();
        if (n != 0) {
            throw new Exception("Jmol can only read rigid body groups with basic crystallographic settings.");
        }
        float[][] fArray = this.readAtomRecord(atom, p32, p3, true);
        String string2 = atom.atomName;
        int n2 = this.molAtoms.size();
        Logger.info((String)(string2 + " Molecular group " + this.molName + " has " + n2 + " atoms"));
        String string3 = "_" + string.substring(4);
        V3 v3 = V3.new3((float)atom.anisoBorU[3], (float)atom.anisoBorU[4], (float)atom.anisoBorU[5]);
        Quat quat = Quat.newAA((A4)A4.newVA((V3)V3.new3((float)0.0f, (float)0.0f, (float)1.0f), (float)((float)((double)(atom.anisoBorU[0] / 180.0f) * Math.PI))));
        Quat quat2 = Quat.newAA((A4)A4.newVA((V3)(bl ? V3.new3((float)0.0f, (float)1.0f, (float)0.0f) : V3.new3((float)1.0f, (float)0.0f, (float)0.0f)), (float)((float)((double)(atom.anisoBorU[1] / 180.0f) * Math.PI))));
        Quat quat3 = Quat.newAA((A4)A4.newVA((V3)(bl ? V3.new3((float)1.0f, (float)0.0f, (float)0.0f) : V3.new3((float)0.0f, (float)0.0f, (float)1.0f)), (float)((float)((double)(atom.anisoBorU[2] / 180.0f) * Math.PI))));
        this.matR = quat.mulQ(quat2).mulQ(quat3).getMatrix();
        if (bl2) {
            this.matR.scale(-1.0f);
        }
        String string4 = "";
        for (int i = 0; i < n2; ++i) {
            Atom atom2 = (Atom)this.molAtoms.get(i);
            String string5 = atom2.atomName;
            string4 = string4 + ", " + string5;
            if (this.firstPosition) {
                string5 = string5 + string3;
                this.modelMolecule.addLast((Object)P3.newP((T3)atom2));
            } else {
                atom2 = this.asc.newCloneAtom(atom2);
                string5 = string5.substring(0, string5.lastIndexOf("_")) + string3;
            }
            atom2.atomName = string5;
            V3 v32 = V3.newVsub((T3)((T3)this.modelMolecule.get(i)), (T3)this.rho);
            this.v0Cart = V3.newV((T3)v32);
            this.getSymmetry().toCartesian((T3)this.v0Cart, true);
            this.vR = V3.newV((T3)v32);
            this.cartesianProduct((T3)this.vR, null);
            atom2.setT((T3)this.rho);
            atom2.add((T3)v3);
            atom2.add((T3)this.vR);
            this.copyModulations(";" + atom.atomName, ";" + string5);
            if (fArray == null) continue;
            this.setRigidBodyRotations(";" + string5, fArray);
        }
        this.firstPosition = false;
        string4 = "@" + this.molName + string3 + string4.substring(1);
        this.addJmolScript(string4);
        this.appendLoadNote(string4);
    }

    private void cartesianProduct(T3 t3, T3 t32) {
        this.symmetry.toCartesian(t3, true);
        if (t32 == null) {
            this.matR.rotate2(t3, t3);
        } else {
            t3.cross(t3, t32);
        }
        this.symmetry.toFractional(t3, true);
    }

    private float[][] readAtomRecord(Atom atom, P3 p3, P3 p32, boolean bl) throws Exception {
        float[][] fArray;
        int n;
        int n2;
        float f;
        int n3;
        String string = ";" + atom.atomName;
        int n4 = n3 = bl ? -1 : this.getInt(13, 14);
        if (!bl && this.molTtypes != null) {
            this.molTtypes.addLast((Object)n3);
        }
        boolean bl2 = this.getFlag(60);
        boolean bl3 = this.getFlag(61);
        boolean bl4 = this.getFlag(62);
        int n5 = this.getInt(65, 68);
        int n6 = this.getInt(68, 71);
        int n7 = this.getInt(71, 74);
        if (p3 != null) {
            this.readM40Floats();
            p3.set(this.floats[0], this.floats[1], this.floats[2]);
            p32.set(this.floats[3], this.floats[4], this.floats[5]);
        }
        if (n3 > 2) {
            this.readM40Floats();
        }
        this.readM40Floats();
        switch (n3) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.readLines(n3 - 1);
                this.appendLoadNote("Skipping temperature factors with order > 2");
            }
            case -1: 
            case 2: {
                for (int i = 0; i < 6; ++i) {
                    this.asc.setU(atom, i, this.floats[i]);
                }
                break;
            }
            case 1: {
                if (this.floats[0] == 0.0f) break;
                this.asc.setU(atom, 7, this.floats[0]);
                break;
            }
            case 0: {
                this.molHasTLS = true;
                this.appendLoadNote("Jmol cannot process molecular TLS parameters");
            }
        }
        if (this.modDim == 0) {
            return null;
        }
        if (bl && this.molHasTLS) {
            this.readLines(4);
        }
        float f2 = f = n5 > 0 && !bl2 ? this.parseFloatStr(this.rd()) : 1.0f;
        if (f != 1.0f) {
            this.ms.addModulation(null, "J_O#0" + string, new double[]{atom.foccupancy, f, 0.0}, -1);
        }
        atom.foccupancy *= f;
        int n8 = 0;
        this.isLegendre = false;
        for (n2 = 0; n2 < n5; ++n2) {
            float f3;
            float f4;
            if (bl2) {
                float[][] fArray2 = this.readM40FloatLines(2, 1);
                f4 = fArray2[0][0];
                f3 = fArray2[1][0];
            } else {
                n8 = n2 + 1;
                this.readM40Floats();
                f3 = this.floats[0];
                f4 = this.floats[1];
            }
            double[] dArray = new double[]{f3, f4, 0.0};
            if (f3 == 0.0f && f4 == 0.0f) continue;
            this.ms.addModulation(null, "O_" + n8 + "#0" + string, dArray, -1);
        }
        for (n2 = 0; n2 < n6; ++n2) {
            if (bl3) {
                this.readM40Floats();
                float f5 = this.floats[3];
                float f6 = this.floats[4];
                for (n = 0; n < 3; ++n) {
                    if (this.floats[n] == 0.0f) continue;
                    this.ms.addModulation(null, "D_S#" + XYZ[n] + string, new double[]{f5, f6, this.floats[n]}, -1);
                }
                continue;
            }
            this.addSinCos(n2, "D_", string, bl);
        }
        float[][] fArray3 = fArray = bl && n6 > 0 ? this.readM40FloatLines(n6, 6) : (float[][])null;
        if (!bl) {
            if (this.isLegendre) {
                n7 *= 2;
            }
            for (int i = 0; i < n7; ++i) {
                float[][] fArray4;
                if (n3 == 1) {
                    this.addSinCos(i, "U_", string, false);
                    continue;
                }
                if (bl4) {
                    Logger.error((String)("JanaReader -- not interpreting SpecialUij flag: " + this.line));
                    continue;
                }
                if (this.isLegendre) {
                    fArray4 = this.readM40FloatLines(1, 6);
                    n = i + 1;
                    double d = 0.0;
                    int n9 = 0;
                    int n10 = 0;
                    while (n9 < 6) {
                        d = fArray4[0][n9];
                        if (d != 0.0) {
                            this.ms.addModulation(null, "U_L" + n + "#" + U_LIST.substring(n10, n10 + 3) + string, new double[]{d, n, 0.0}, -1);
                        }
                        ++n9;
                        n10 += 3;
                    }
                    continue;
                }
                fArray4 = this.readM40FloatLines(2, 6);
                n = 0;
                int n11 = 0;
                while (n < 6) {
                    double d = fArray4[1][n];
                    double d2 = fArray4[0][n];
                    this.ms.addModulation(null, "U_" + (i + 1) + "#" + U_LIST.substring(n11, n11 + 3) + string, new double[]{d, d2, 0.0}, -1);
                    ++n;
                    n11 += 3;
                }
            }
        }
        return fArray;
    }

    private void addSinCos(int n, String string, String string2, boolean bl) throws Exception {
        this.readM40Floats();
        if (this.isLegendre) {
            for (int i = 0; i < 2; ++i) {
                int n2 = n * 2 + i + 1;
                for (int j = 0; j < 3; ++j) {
                    float f = this.floats[3 * i + j];
                    if (f == 0.0f) continue;
                    String string3 = XYZ[j % 3];
                    if (this.modAxes != null && this.modAxes.indexOf(string3.toUpperCase()) < 0) continue;
                    String string4 = string + "L#" + string3 + n2 + string2;
                    this.ms.addModulation(null, string4, new double[]{f, n2, 0.0}, -1);
                }
            }
            return;
        }
        this.ensureFourier(n);
        for (int i = 0; i < 3; ++i) {
            float f = this.floats[i];
            float f2 = this.floats[i + 3];
            if (f == 0.0f && f2 == 0.0f) {
                if (!bl) continue;
                f = 1.0E-10f;
            }
            String string5 = XYZ[i % 3];
            if (this.modAxes != null && this.modAxes.indexOf(string5.toUpperCase()) < 0) continue;
            String string6 = string + (n + 1) + "#" + string5 + string2;
            this.ms.addModulation(null, string6, new double[]{f, f2, 0.0}, -1);
        }
    }

    private void ensureFourier(int n) {
        double[] dArray;
        if (n > 0 && this.ms.getMod("F_" + ++n + "_coefs_") == null && (dArray = this.ms.getMod("F_1_coefs_")) != null) {
            double[] dArray2 = new double[this.modDim];
            int n2 = this.modDim;
            while (--n2 >= 0) {
                dArray2[n2] = dArray[n2] * (double)n;
            }
            this.ms.addModulation(null, "F_" + n + "_coefs_", dArray2, -1);
        }
    }

    private String readM40Floats() throws Exception {
        this.line = this.rd();
        if (this.line == null || this.line.indexOf("-------") >= 0) {
            this.line = null;
            return null;
        }
        if (this.debugging) {
            Logger.debug((String)this.line);
        }
        this.parseM40Floats();
        return this.line;
    }

    private void parseM40Floats() {
        int n = this.line.length() - 9;
        int n2 = 0;
        int n3 = 0;
        while (n2 < 6) {
            this.floats[n2] = n3 <= n ? this.parseFloatStr(this.line.substring(n3, n3 + 9)) : Float.NaN;
            ++n2;
            n3 += 9;
        }
    }

    private float[][] readM40FloatLines(int n, int n2) throws Exception {
        float[][] fArray = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            this.readM40Floats();
            if (this.line.indexOf("Legendre") == 19) {
                this.isLegendre = true;
            }
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = this.floats[j];
            }
        }
        return fArray;
    }

    private void adjustM40Occupancies() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Atom[] atomArray = this.asc.atoms;
        SymmetryInterface symmetryInterface = this.asc.getSymmetry();
        int n = this.asc.ac;
        while (--n >= 0) {
            Atom atom = atomArray[n];
            Integer n2 = (Integer)hashtable.get(atom.atomName);
            if (n2 == null) {
                n2 = symmetryInterface.getSiteMultiplicity((P3)atom);
                hashtable.put(atom.atomName, n2);
            }
            atom.foccupancy *= (float)n2.intValue();
        }
    }

    private void copyModulations(String string, String string2) {
        Hashtable<String, double[]> hashtable = new Hashtable<String, double[]>();
        block5: for (Map.Entry entry : this.ms.getModulationMap().entrySet()) {
            String string3 = (String)entry.getKey();
            if (!string3.contains(string)) continue;
            string3 = PT.rep((String)string3, (String)string, (String)string2);
            double[] dArray = (double[])entry.getValue();
            switch (string3.charAt(0)) {
                case 'O': {
                    dArray = new double[]{dArray[0], dArray[1], 0.0};
                    this.setRigidBodyPhase(string3, dArray);
                    break;
                }
                case 'D': {
                    break;
                }
                case 'U': {
                    continue block5;
                }
            }
            hashtable.put(string3, dArray);
        }
        for (Map.Entry entry : hashtable.entrySet()) {
            this.ms.addModulation(null, (String)entry.getKey(), (double[])entry.getValue(), -1);
        }
    }

    private double[] setRigidBodyPhase(String string, double[] dArray) {
        boolean bl = false;
        switch (this.ms.getModType(string)) {
            case 'f': 
            case 'o': 
            case 'u': {
                break;
            }
            case 'c': 
            case 's': {
                bl = true;
            }
        }
        double d = 0.0;
        double d2 = -1.0;
        double[] dArray2 = this.ms.getQCoefs(string);
        int n = this.modDim;
        while (--n >= 0) {
            if (dArray2[n] == 0.0) continue;
            d2 = dArray2[n];
            double[] dArray3 = this.ms.getMod("W_" + (n + 1));
            d = d2 * (dArray3[0] * (double)this.vR.x + dArray3[1] * (double)this.vR.y + dArray3[2] * (double)this.vR.z);
            break;
        }
        if (bl) {
            dArray[0] = dArray[0] + d;
        } else {
            double d3 = dArray[0];
            double d4 = dArray[1];
            double d5 = Math.sin(Math.PI * 2 * d);
            double d6 = Math.cos(Math.PI * 2 * d);
            dArray[0] = d3 * d6 + d4 * d5;
            dArray[1] = -d3 * d5 + d4 * d6;
        }
        return dArray;
    }

    private void setRigidBodyRotations(String string, float[][] fArray) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            this.ensureFourier(i);
            String string2 = "D_" + (i + 1);
            float[] fArray2 = fArray[i];
            V3 v3 = V3.new3((float)fArray2[0], (float)fArray2[1], (float)fArray2[2]);
            V3 v32 = V3.new3((float)fArray2[3], (float)fArray2[4], (float)fArray2[5]);
            this.cartesianProduct((T3)v32, (T3)this.v0Cart);
            this.cartesianProduct((T3)v3, (T3)this.v0Cart);
            String string3 = string2 + "#x" + string;
            String string4 = string2 + "#y" + string;
            String string5 = string2 + "#z" + string;
            double[] dArray = this.combineModulation(string3, v3.x, v32.x);
            double[] dArray2 = this.combineModulation(string4, v3.y, v32.y);
            double[] dArray3 = this.combineModulation(string5, v3.z, v32.z);
            v3.set((float)dArray[0], (float)dArray2[0], (float)dArray3[0]);
            v32.set((float)dArray[1], (float)dArray2[1], (float)dArray3[1]);
            this.cartesianProduct((T3)v3, null);
            this.cartesianProduct((T3)v32, null);
            this.setMolecularModulation(string3, v3.x, v32.x);
            this.setMolecularModulation(string4, v3.y, v32.y);
            this.setMolecularModulation(string5, v3.z, v32.z);
        }
    }

    private double[] combineModulation(String string, float f, float f2) {
        double[] dArray = this.ms.getMod(string);
        return new double[]{dArray[0] + (double)f, dArray[1] + (double)f2, 0.0};
    }

    private void setMolecularModulation(String string, float f, float f2) {
        this.ms.addModulation(null, string, this.setRigidBodyPhase(string, new double[]{f, f2, 0.0}), -1);
    }
}

