/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Polyhedra;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.C;

public class PolyhedraRenderer
extends ShapeRenderer {
    private int drawEdges;
    private boolean isAll;
    private boolean frontOnly;
    private P3[] screens3f;
    private P3i scrVib;
    private boolean vibs;
    private BS bsSelected;
    private boolean showNumbers;

    @Override
    protected boolean render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedron[] polyhedronArray = polyhedra.polyhedrons;
        this.drawEdges = polyhedra.drawEdges;
        this.bsSelected = this.vwr.getSelectionHalosEnabled() ? this.vwr.bsA() : null;
        this.g3d.addRenderer(1073742182);
        this.vibs = this.ms.vibrations != null && this.tm.vibrationOn;
        this.showNumbers = this.vwr.getTestFlag(3);
        boolean bl = false;
        int n = polyhedra.polyhedronCount;
        while (--n >= 0) {
            if (!polyhedronArray[n].isValid || !this.render1(polyhedronArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    private boolean render1(Polyhedron polyhedron) {
        int[] nArray;
        if (polyhedron.visibilityFlags == 0) {
            return false;
        }
        short[] sArray = ((Polyhedra)this.shape).colixes;
        int n = polyhedron.centralAtom.i;
        short s = sArray == null || n >= sArray.length ? (short)0 : sArray[n];
        s = C.getColixInherited(s, polyhedron.centralAtom.colixAtom);
        boolean bl = false;
        if (C.renderPass2(s)) {
            bl = true;
        } else if (!this.g3d.setC(s)) {
            return false;
        }
        P3[] p3Array = polyhedron.vertices;
        if (this.screens3f == null || this.screens3f.length < p3Array.length) {
            this.screens3f = new P3[p3Array.length];
            int n2 = p3Array.length;
            while (--n2 >= 0) {
                this.screens3f[n2] = new P3();
            }
        }
        P3[] p3Array2 = this.screens3f;
        int[][] nArray2 = polyhedron.triangles;
        int n3 = p3Array.length;
        while (--n3 >= 0) {
            Atom atom;
            Atom atom2 = atom = p3Array[n3] instanceof Atom ? (Atom)p3Array[n3] : null;
            if (atom == null) {
                this.tm.transformPtScrT3(p3Array[n3], p3Array2[n3]);
            } else if (atom.isVisible(this.myVisibilityFlag)) {
                p3Array2[n3].set(atom.sX, atom.sY, atom.sZ);
            } else if (this.vibs && atom.hasVibration()) {
                this.scrVib = this.tm.transformPtVib(atom, this.ms.vibrations[atom.i]);
                p3Array2[n3].set(this.scrVib.x, this.scrVib.y, this.scrVib.z);
            } else {
                this.tm.transformPt3f(atom, p3Array2[n3]);
            }
            if (!this.showNumbers) continue;
            this.g3d.setC((short)4);
            this.g3d.drawStringNoSlab("" + n3, null, (int)p3Array2[n3].x, (int)p3Array2[n3].y, (int)p3Array2[n3].z - 30, (short)0);
            this.g3d.setC(s);
        }
        this.isAll = this.drawEdges == 1 || this.bsSelected != null;
        this.frontOnly = this.drawEdges == 2;
        short[] sArray2 = polyhedron.getNormixes();
        if (!bl || this.g3d.setC(s)) {
            int n4 = nArray2.length;
            while (--n4 >= 0) {
                nArray = nArray2[n4];
                try {
                    this.g3d.fillTriangleTwoSided(sArray2[n4], p3Array2[nArray[0]], p3Array2[nArray[1]], p3Array2[nArray[2]]);
                }
                catch (Exception exception) {
                    System.out.println("heorhe");
                }
                if (nArray[3] < 0) continue;
                this.g3d.fillTriangleTwoSided(sArray2[n4], p3Array2[nArray[2]], p3Array2[nArray[3]], p3Array2[nArray[0]]);
            }
        }
        if (this.bsSelected != null && this.bsSelected.get(n)) {
            s = 23;
        } else if (polyhedron.colixEdge != 0) {
            s = polyhedron.colixEdge;
        }
        if (this.g3d.setC(C.getColixTranslucent3(s, false, 0.0f))) {
            int n5 = nArray2.length;
            while (--n5 >= 0) {
                nArray = nArray2[n5];
                if (nArray[3] < 0) {
                    this.drawFace(sArray2[n5], p3Array2[nArray[0]], p3Array2[nArray[1]], p3Array2[nArray[2]], -nArray[3]);
                    continue;
                }
                this.drawFace(sArray2[n5], p3Array2[nArray[0]], p3Array2[nArray[1]], p3Array2[nArray[2]], 3);
                this.drawFace(sArray2[n5], p3Array2[nArray[0]], p3Array2[nArray[2]], p3Array2[nArray[3]], 6);
            }
        }
        return bl;
    }

    private void drawFace(short s, P3 p3, P3 p32, P3 p33, int n) {
        if (this.isAll || this.frontOnly && this.vwr.gdata.isDirectedTowardsCamera(s)) {
            int n2;
            int n3 = n2 = this.g3d.isAntialiased() ? 6 : 3;
            if ((n & 1) == 1) {
                this.g3d.fillCylinderBits((byte)3, n2, p3, p32);
            }
            if ((n & 2) == 2) {
                this.g3d.fillCylinderBits((byte)3, n2, p32, p33);
            }
            if ((n & 4) == 4) {
                this.g3d.fillCylinderBits((byte)3, n2, p3, p33);
            }
        }
    }
}

