/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.V3;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.G3DRenderer;
import org.jmol.util.GData;

public class HermiteRenderer
implements G3DRenderer {
    private static V3 vAB = new V3();
    private static V3 vAC = new V3();
    private JmolRendererInterface g3d;
    private GData gdata;
    private final P3i[] pLeft = new P3i[16];
    private final P3i[] pRight = new P3i[16];
    private final float[] sLeft = new float[16];
    private final float[] sRight = new float[16];
    private final P3[] pTopLeft = new P3[16];
    private final P3[] pTopRight = new P3[16];
    private final P3[] pBotLeft = new P3[16];
    private final P3[] pBotRight = new P3[16];
    private final P3 a1;
    private final P3 a2;
    private final P3 b1;
    private final P3 b2;
    private final P3 c1;
    private final P3 c2;
    private final P3 d1;
    private final P3 d2;
    private final V3 T1;
    private final V3 T2;
    private final V3 depth1;
    private final boolean[] needToFill;

    public HermiteRenderer() {
        int n = 16;
        while (--n >= 0) {
            this.pLeft[n] = new P3i();
            this.pRight[n] = new P3i();
            this.pTopLeft[n] = new P3();
            this.pTopRight[n] = new P3();
            this.pBotLeft[n] = new P3();
            this.pBotRight[n] = new P3();
        }
        this.a1 = new P3();
        this.a2 = new P3();
        this.b1 = new P3();
        this.b2 = new P3();
        this.c1 = new P3();
        this.c2 = new P3();
        this.d1 = new P3();
        this.d2 = new P3();
        this.T1 = new V3();
        this.T2 = new V3();
        this.depth1 = new V3();
        this.needToFill = new boolean[16];
    }

    @Override
    public G3DRenderer set(JmolRendererInterface jmolRendererInterface, GData gData) {
        this.g3d = jmolRendererInterface;
        this.gdata = gData;
        return this;
    }

    public void renderHermiteRope(boolean bl, int n, int n2, int n3, int n4, P3 p3, P3 p32, P3 p33, P3 p34) {
        int n5 = (int)p32.z;
        int n6 = (int)p33.z;
        if (p3.z == 1.0f || n5 == 1 || n6 == 1 || p34.z == 1.0f) {
            return;
        }
        if (this.gdata.isClippedZ(n5) || this.gdata.isClippedZ(n6)) {
            return;
        }
        int n7 = (int)p32.x;
        int n8 = (int)p32.y;
        int n9 = (int)p33.x;
        int n10 = (int)p33.y;
        int n11 = (n9 - (int)p3.x) * n / 8;
        int n12 = (n10 - (int)p3.y) * n / 8;
        int n13 = (n6 - (int)p3.z) * n / 8;
        int n14 = ((int)p34.x - n7) * n / 8;
        int n15 = ((int)p34.y - n8) * n / 8;
        int n16 = ((int)p34.z - n5) * n / 8;
        this.sLeft[0] = 0.0f;
        this.pLeft[0].set(n7, n8, n5);
        this.sRight[0] = 1.0f;
        this.pRight[0].set(n9, n10, n6);
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        if (bl) {
            n18 = 2 * (n3 - n2);
            n19 = 2 * (n4 - n3);
        }
        do {
            int n20;
            P3i p3i = this.pLeft[n17];
            P3i p3i2 = this.pRight[n17];
            int n21 = p3i2.x - p3i.x;
            if (n21 >= -1 && n21 <= 1 && (n20 = p3i2.y - p3i.y) >= -1 && n20 <= 1) {
                float f = this.sLeft[n17];
                if (bl) {
                    int n22 = f < 0.5f ? n2 + (int)((float)n18 * f) : n3 + (int)((float)n19 * (f - 0.5f));
                    this.g3d.fillSphereI(n22, p3i);
                } else {
                    this.g3d.plotPixelClippedP3i(p3i);
                }
                --n17;
                continue;
            }
            double d = (this.sLeft[n17] + this.sRight[n17]) / 2.0f;
            double d2 = d * d;
            double d3 = d2 * d;
            double d4 = 2.0 * d3 - 3.0 * d2 + 1.0;
            double d5 = -2.0 * d3 + 3.0 * d2;
            double d6 = d3 - 2.0 * d2 + d;
            double d7 = d3 - d2;
            if (n17 >= 15) break;
            P3i p3i3 = this.pRight[n17 + 1];
            p3i3.x = (int)(d4 * (double)n7 + d5 * (double)n9 + d6 * (double)n11 + d7 * (double)n14);
            p3i3.y = (int)(d4 * (double)n8 + d5 * (double)n10 + d6 * (double)n12 + d7 * (double)n15);
            p3i3.z = (int)(d4 * (double)n5 + d5 * (double)n6 + d6 * (double)n13 + d7 * (double)n16);
            this.pRight[n17 + 1] = this.pRight[n17];
            this.sRight[n17 + 1] = this.sRight[n17];
            this.pRight[n17] = p3i3;
            this.sRight[n17] = (float)d;
            this.pLeft[++n17].setT(p3i3);
            this.sLeft[n17] = (float)d;
        } while (n17 >= 0);
    }

    public void renderHermiteRibbon(boolean bl, boolean bl2, int n, P3 p3, P3 p32, P3 p33, P3 p34, P3 p35, P3 p36, P3 p37, P3 p38, int n2, int n3) {
        boolean bl3;
        if (p3.z == 1.0f || p32.z == 1.0f || p33.z == 1.0f || p34.z == 1.0f || p35.z == 1.0f || p36.z == 1.0f || p37.z == 1.0f || p38.z == 1.0f) {
            return;
        }
        if (!bl) {
            n = Math.abs(n);
            this.renderParallelPair(bl, n, p3, p32, p33, p34, p35, p36, p37, p38);
            return;
        }
        boolean bl4 = bl3 = n < 0;
        if (bl3) {
            n = -n;
        }
        float f = 1.0f / (float)n2;
        int n4 = (int)p32.x;
        int n5 = (int)p32.y;
        int n6 = (int)p32.z;
        int n7 = (int)p33.x;
        int n8 = (int)p33.y;
        int n9 = (int)p33.z;
        int n10 = (n7 - (int)p3.x) * n / 8;
        int n11 = (n8 - (int)p3.y) * n / 8;
        int n12 = (n9 - (int)p3.z) * n / 8;
        int n13 = ((int)p34.x - n4) * n / 8;
        int n14 = ((int)p34.y - n5) * n / 8;
        int n15 = ((int)p34.z - n6) * n / 8;
        this.pTopLeft[0].set(n4, n5, n6);
        this.pTopRight[0].set(n7, n8, n9);
        int n16 = (int)p36.x;
        int n17 = (int)p36.y;
        int n18 = (int)p36.z;
        int n19 = (int)p37.x;
        int n20 = (int)p37.y;
        int n21 = (int)p37.z;
        int n22 = (n19 - (int)p35.x) * n / 8;
        int n23 = (n20 - (int)p35.y) * n / 8;
        int n24 = (n21 - (int)p35.z) * n / 8;
        int n25 = ((int)p38.x - n16) * n / 8;
        int n26 = ((int)p38.y - n17) * n / 8;
        int n27 = ((int)p38.z - n18) * n / 8;
        this.pBotLeft[0].set(n16, n17, n18);
        this.pBotRight[0].set(n19, n20, n21);
        this.sLeft[0] = 0.0f;
        this.sRight[0] = 1.0f;
        this.needToFill[0] = true;
        int n28 = 0;
        boolean bl5 = false;
        do {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            P3 p39 = this.pTopLeft[n28];
            P3 p310 = this.pTopRight[n28];
            double d7 = p310.x - p39.x;
            double d8 = d7 * d7;
            if (d8 < 10.0 && (d6 = (d5 = (double)(p310.y - p39.y)) * d5) < 10.0) {
                P3 p311 = this.pBotLeft[n28];
                P3 p312 = this.pBotRight[n28];
                d4 = p312.x - p311.x;
                d3 = d4 * d4;
                if (d3 < 8.0 && (d2 = (d = (double)(p312.y - p311.y)) * d) < 8.0) {
                    if (bl2) {
                        this.g3d.fillSphereBits(3, p39);
                        this.g3d.fillSphereBits(3, p311);
                    }
                    if (this.needToFill[n28]) {
                        if (n2 > 0) {
                            this.T1.sub2(p39, p311);
                            this.T1.scale(f);
                            this.T2.sub2(p39, p310);
                            this.depth1.cross(this.T1, this.T2);
                            this.depth1.scale(this.T1.length() / this.depth1.length());
                            this.a1.add2(p39, this.depth1);
                            this.a2.sub2(p39, this.depth1);
                            this.b1.add2(p310, this.depth1);
                            this.b2.sub2(p310, this.depth1);
                            this.c1.add2(p311, this.depth1);
                            this.c2.sub2(p311, this.depth1);
                            this.d1.add2(p312, this.depth1);
                            this.d2.sub2(p312, this.depth1);
                            this.g3d.fillQuadrilateral(this.a1, this.b1, this.d1, this.c1);
                            this.g3d.fillQuadrilateral(this.a2, this.b2, this.d2, this.c2);
                            this.g3d.fillQuadrilateral(this.a1, this.b1, this.b2, this.a2);
                            this.g3d.fillQuadrilateral(this.c1, this.d1, this.d2, this.c2);
                            bl5 = true;
                        } else if (n3 == 0) {
                            if (bl3) {
                                this.g3d.fillQuadrilateral(p311, p312, p310, p39);
                            } else {
                                this.g3d.fillQuadrilateral(p39, p310, p312, p311);
                            }
                        } else if (bl3) {
                            if (n3 != HermiteRenderer.isFront(p39, p310, p312)) {
                                this.g3d.fillTriangle3f(p39, p310, p312, false);
                            }
                            if (n3 != HermiteRenderer.isFront(p39, p312, p311)) {
                                this.g3d.fillTriangle3f(p39, p312, p311, false);
                            }
                        } else {
                            if (n3 == HermiteRenderer.isFront(p39, p310, p312)) {
                                this.g3d.fillTriangle3f(p39, p310, p312, false);
                            }
                            if (n3 == HermiteRenderer.isFront(p39, p312, p311)) {
                                this.g3d.fillTriangle3f(p39, p312, p311, false);
                            }
                        }
                        this.needToFill[n28] = false;
                    }
                    if (d8 + d6 < 2.0 && d3 + d2 < 2.0) {
                        --n28;
                        continue;
                    }
                }
            }
            d5 = (this.sLeft[n28] + this.sRight[n28]) / 2.0f;
            d6 = d5 * d5;
            double d9 = d6 * d5;
            d4 = 2.0 * d9 - 3.0 * d6 + 1.0;
            d3 = -2.0 * d9 + 3.0 * d6;
            d = d9 - 2.0 * d6 + d5;
            d2 = d9 - d6;
            if (n28 >= 15) break;
            int n29 = n28 + 1;
            P3 p313 = this.pTopRight[n29];
            p313.x = (float)(d4 * (double)n4 + d3 * (double)n7 + d * (double)n10 + d2 * (double)n13);
            p313.y = (float)(d4 * (double)n5 + d3 * (double)n8 + d * (double)n11 + d2 * (double)n14);
            p313.z = (float)(d4 * (double)n6 + d3 * (double)n9 + d * (double)n12 + d2 * (double)n15);
            P3 p314 = this.pBotRight[n29];
            p314.x = (float)(d4 * (double)n16 + d3 * (double)n19 + d * (double)n22 + d2 * (double)n25);
            p314.y = (float)(d4 * (double)n17 + d3 * (double)n20 + d * (double)n23 + d2 * (double)n26);
            p314.z = (float)(d4 * (double)n18 + d3 * (double)n21 + d * (double)n24 + d2 * (double)n27);
            this.pTopRight[n29] = this.pTopRight[n28];
            this.pTopRight[n28] = p313;
            this.pBotRight[n29] = this.pBotRight[n28];
            this.pBotRight[n28] = p314;
            this.sRight[n29] = this.sRight[n28];
            this.sRight[n28] = (float)d5;
            this.needToFill[n29] = this.needToFill[n28];
            this.pTopLeft[n29].setT(p313);
            this.pBotLeft[n29].setT(p314);
            this.sLeft[n29] = (float)d5;
            ++n28;
        } while (n28 >= 0);
        if (bl5) {
            this.a1.z += 1.0f;
            this.c1.z += 1.0f;
            this.c2.z += 1.0f;
            this.a2.z += 1.0f;
            this.g3d.fillQuadrilateral(this.a1, this.c1, this.c2, this.a2);
        }
    }

    private static int isFront(P3 p3, P3 p32, P3 p33) {
        vAB.sub2(p32, p3);
        vAC.sub2(p33, p3);
        vAB.cross(vAB, vAC);
        return HermiteRenderer.vAB.z < 0.0f ? -1 : 1;
    }

    private void renderParallelPair(boolean bl, int n, P3 p3, P3 p32, P3 p33, P3 p34, P3 p35, P3 p36, P3 p37, P3 p38) {
        int n2;
        P3[] p3Array = new P3[]{p33, p32, p37, p36};
        Lst<P3> lst = new Lst<P3>();
        int n3 = 0;
        int n4 = 2;
        float f = 5.0f;
        float f2 = 1.0f / f;
        float f3 = 0.0f;
        int n5 = (int)p32.x;
        int n6 = (int)p32.y;
        int n7 = (int)p32.z;
        int n8 = (int)p33.x;
        int n9 = (int)p33.y;
        int n10 = (int)p33.z;
        int n11 = (n8 - (int)p3.x) * n / 8;
        int n12 = (n9 - (int)p3.y) * n / 8;
        int n13 = (n10 - (int)p3.z) * n / 8;
        int n14 = ((int)p34.x - n5) * n / 8;
        int n15 = ((int)p34.y - n6) * n / 8;
        int n16 = ((int)p34.z - n7) * n / 8;
        this.sLeft[0] = 0.0f;
        this.pLeft[0].set(n5, n6, n7);
        this.sRight[0] = 1.0f;
        this.pRight[0].set(n8, n9, n10);
        int n17 = 0;
        for (n2 = 2; n2 > 0; --n2) {
            if (n2 == 1) {
                n5 = (int)p36.x;
                n6 = (int)p36.y;
                n7 = (int)p36.z;
                n8 = (int)p37.x;
                n9 = (int)p37.y;
                n10 = (int)p37.z;
                n11 = (n8 - (int)p35.x) * n / 8;
                n12 = (n9 - (int)p35.y) * n / 8;
                n13 = (n10 - (int)p35.z) * n / 8;
                n14 = ((int)p38.x - n5) * n / 8;
                n15 = ((int)p38.y - n6) * n / 8;
                n16 = ((int)p38.z - n7) * n / 8;
                this.sLeft[0] = 0.0f;
                this.pLeft[0].set(n5, n6, n7);
                this.sRight[0] = 1.0f;
                this.pRight[0].set(n8, n9, n10);
                n17 = 0;
            }
            lst.addLast(p3Array[n3++]);
            f3 = f2;
            do {
                P3i p3i = this.pLeft[n17];
                P3i p3i2 = this.pRight[n17];
                int n18 = p3i2.x - p3i.x;
                int n19 = p3i2.y - p3i.y;
                int n20 = n18 * n18 + n19 * n19;
                if (n20 <= 2) {
                    float f4 = this.sLeft[n17];
                    this.g3d.fillSphereI(3, p3i);
                    if (f4 < 1.0f - f3) {
                        P3 p39 = new P3();
                        p39.set(p3i.x, p3i.y, p3i.z);
                        lst.addLast(p39);
                        f3 += f2;
                        if (n2 == 2) {
                            ++n4;
                        }
                    }
                    --n17;
                    continue;
                }
                double d = (this.sLeft[n17] + this.sRight[n17]) / 2.0f;
                double d2 = d * d;
                double d3 = d2 * d;
                double d4 = 2.0 * d3 - 3.0 * d2 + 1.0;
                double d5 = -2.0 * d3 + 3.0 * d2;
                double d6 = d3 - 2.0 * d2 + d;
                double d7 = d3 - d2;
                if (n17 >= 15) break;
                P3i p3i3 = this.pRight[n17 + 1];
                p3i3.x = (int)(d4 * (double)n5 + d5 * (double)n8 + d6 * (double)n11 + d7 * (double)n14);
                p3i3.y = (int)(d4 * (double)n6 + d5 * (double)n9 + d6 * (double)n12 + d7 * (double)n15);
                p3i3.z = (int)(d4 * (double)n7 + d5 * (double)n10 + d6 * (double)n13 + d7 * (double)n16);
                this.pRight[n17 + 1] = this.pRight[n17];
                this.sRight[n17 + 1] = this.sRight[n17];
                this.pRight[n17] = p3i3;
                this.sRight[n17] = (float)d;
                this.pLeft[++n17].setT(p3i3);
                this.sLeft[n17] = (float)d;
            } while (n17 >= 0);
            lst.addLast(p3Array[n3++]);
        }
        n2 = lst.size();
        for (int i = 0; i < n4 && i + n4 < n2; ++i) {
            this.g3d.drawLineAB((P3)lst.get(i), (P3)lst.get(i + n4));
        }
    }
}

