/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dssx;

import java.util.Map;
import org.jmol.modelset.Atom;
import org.jmol.util.Escape;

class Bridge {
    Atom a;
    Atom b;
    int[][] ladder;
    boolean isAntiparallel;

    Bridge(Atom atom, Atom atom2, Map<int[][], Boolean> map) {
        this.a = atom;
        this.b = atom2;
        this.ladder = new int[2][2];
        int n = Math.min(atom.i, atom2.i);
        this.ladder[0][1] = n;
        this.ladder[0][0] = n;
        int n2 = Math.max(atom.i, atom2.i);
        this.ladder[1][1] = n2;
        this.ladder[1][0] = n2;
        this.addLadder(map);
    }

    boolean addBridge(Bridge bridge, Map<int[][], Boolean> map) {
        if (bridge.isAntiparallel != this.isAntiparallel || !this.canAdd(bridge) || !bridge.canAdd(this)) {
            return false;
        }
        this.extendLadder(bridge.ladder[0][0], bridge.ladder[1][0]);
        this.extendLadder(bridge.ladder[0][1], bridge.ladder[1][1]);
        bridge.ladder = this.ladder;
        if (bridge.ladder != this.ladder) {
            map.remove(bridge.ladder);
            this.addLadder(map);
        }
        return true;
    }

    private void addLadder(Map<int[][], Boolean> map) {
        map.put(this.ladder, this.isAntiparallel ? Boolean.TRUE : Boolean.FALSE);
    }

    private boolean canAdd(Bridge bridge) {
        int n = bridge.a.i;
        int n2 = bridge.b.i;
        return this.isAntiparallel ? n >= this.ladder[0][1] && n2 <= this.ladder[1][0] || n <= this.ladder[0][0] && n2 >= this.ladder[1][1] : n <= this.ladder[0][0] && n2 <= this.ladder[1][0] || n >= this.ladder[0][1] && n2 >= this.ladder[1][1];
    }

    private void extendLadder(int n, int n2) {
        if (this.ladder[0][0] > n) {
            this.ladder[0][0] = n;
        }
        if (this.ladder[0][1] < n) {
            this.ladder[0][1] = n;
        }
        if (this.ladder[1][0] > n2) {
            this.ladder[1][0] = n2;
        }
        if (this.ladder[1][1] < n2) {
            this.ladder[1][1] = n2;
        }
    }

    public String toString() {
        return (this.isAntiparallel ? "a " : "p ") + this.a + " - " + this.b + "\t" + Escape.e(this.ladder);
    }
}

