/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.Base64;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolParallelProcessor;
import org.jmol.api.JmolScriptFunction;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.c.STR;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.io.JmolBinary;
import org.jmol.java.BS;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Group;
import org.jmol.modelset.TickInfo;
import org.jmol.script.ContextToken;
import org.jmol.script.FileLoadThread;
import org.jmol.script.SV;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptDelayThread;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptExpr;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptInterruption;
import org.jmol.script.ScriptManager;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.T;
import org.jmol.thread.JmolThread;
import org.jmol.util.BSUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Txt;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public class ScriptEval
extends ScriptExpr {
    private static final String saveList = "bonds? context? coordinates? orientation? rotation? selection? state? structure?";
    private static int iProcess;
    public ShapeManager sm;
    public boolean isJS;
    private JmolThread scriptDelayThread;
    private JmolThread fileLoadThread;
    public boolean allowJSThreads = true;
    public boolean historyDisabled;
    private boolean debugScript;
    private boolean isCmdLine_C_Option;
    private boolean isCmdLine_c_or_C_Option;
    private boolean listCommands;
    public boolean tQuiet;
    private boolean executionStopped;
    private boolean executionPaused;
    private boolean executionStepping;
    private boolean executing;
    private long timeBeginExecution;
    private long timeEndExecution;
    private boolean mustResumeEval;
    private Thread currentThread = Thread.currentThread();
    public ScriptCompiler compiler;
    public SB outputBuffer;
    private String contextPath = "";
    public String scriptFileName;
    public String functionName;
    public boolean isStateScript;
    public int scriptLevel;
    public static int commandHistoryLevelMax;
    private static int contextDepthMax;
    private static int scriptReportingLevel;
    public T[][] aatoken;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private String script;
    private String scriptExtensions;
    protected int pc;
    public String thisCommand;
    public String fullCommand;
    private int lineEnd;
    private int pcEnd;
    private boolean forceNoAddHydrogens;
    private JmolParallelProcessor parallelProcessor;
    private int pcResume = -1;

    @Override
    public boolean getAllowJSThreads() {
        return this.allowJSThreads;
    }

    public boolean doReport() {
        return !this.tQuiet && this.scriptLevel <= scriptReportingLevel;
    }

    @Override
    public boolean isStateScript() {
        return this.isStateScript;
    }

    @Override
    public int setStatic(int n, int n2) {
        switch (n) {
            case 553648167: {
                if (n2 >= 10) {
                    contextDepthMax = n2;
                }
                return contextDepthMax;
            }
            case 553648148: {
                if (n2 >= 0) {
                    commandHistoryLevelMax = n2;
                }
                return commandHistoryLevelMax;
            }
            case 553648168: {
                if (n2 >= 0) {
                    scriptReportingLevel = n2;
                }
                return scriptReportingLevel;
            }
        }
        return 0;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public ScriptEval setViewer(Viewer viewer) {
        this.vwr = viewer;
        this.compiler = this.compiler == null ? (ScriptCompiler)viewer.compiler : this.compiler;
        this.isJS = viewer.isSingleThreaded;
        return this;
    }

    @Override
    public void setCompiler() {
        this.compiler = new ScriptCompiler(this.vwr);
        this.vwr.compiler = this.compiler;
    }

    @Override
    public boolean compileScriptString(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = "[script]";
        return this.compileScript(null, string, this.debugScript);
    }

    @Override
    public boolean compileScriptFile(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = string;
        return this.compileScriptFileInternal(string, null, null, null);
    }

    @Override
    public void evaluateCompiledScript(boolean bl, boolean bl2, boolean bl3, boolean bl4, SB sB, boolean bl5) {
        boolean bl6 = this.isCmdLine_C_Option;
        this.isCmdLine_C_Option = bl2;
        this.chk = this.isCmdLine_c_or_C_Option = bl;
        this.historyDisabled = bl3;
        this.outputBuffer = sB;
        this.currentThread = Thread.currentThread();
        this.allowJSThreads = bl5;
        this.listCommands = bl4;
        this.timeBeginExecution = System.currentTimeMillis();
        this.executionPaused = false;
        this.executionStopped = false;
        this.executionStepping = false;
        this.executing = true;
        this.vwr.pushHoldRepaintWhy("runEval");
        this.setScriptExtensions();
        this.executeCommands(false, true);
        this.isCmdLine_C_Option = bl6;
        if (this.isStateScript) {
            ScriptManager.setStateScriptVersion(this.vwr, null);
        }
    }

    public boolean useThreads() {
        return !this.chk && !this.vwr.headless && !this.vwr.autoExit && this.vwr.haveDisplay && this.outputBuffer == null && this.allowJSThreads;
    }

    private void executeCommands(boolean bl, boolean bl2) {
        boolean bl3 = false;
        try {
            if (!this.dispatchCommands(false, false, bl)) {
                return;
            }
        }
        catch (Error error) {
            this.vwr.handleError(error, false);
            this.setErrorMessage("" + error + " " + this.vwr.getShapeErrorState());
            this.errorMessageUntranslated = "" + error;
            this.report(this.errorMessage);
            bl3 = true;
        }
        catch (ScriptException scriptException) {
            if (!(!(scriptException instanceof ScriptInterruption) || bl && scriptException.isError)) {
                return;
            }
            if (bl) {
                this.vwr.setStringProperty("_errormessage", "" + scriptException);
                return;
            }
            this.setErrorMessage(scriptException.toString());
            this.errorMessageUntranslated = scriptException.getErrorMessageUntranslated();
            this.report(this.errorMessage);
            this.vwr.notifyError(this.errorMessage != null && this.errorMessage.indexOf("java.lang.OutOfMemoryError") >= 0 ? "Error" : "ScriptException", this.errorMessage, this.errorMessageUntranslated);
            bl3 = true;
        }
        if (bl3 || !this.isJS || !this.allowJSThreads) {
            this.vwr.setTainted(true);
            this.vwr.popHoldRepaint("executeCommands " + (this.scriptLevel > 0 ? "\u0001## REPAINT_IGNORE ##" : ""));
        }
        this.timeEndExecution = System.currentTimeMillis();
        if (this.errorMessage == null && this.executionStopped) {
            this.setErrorMessage("execution interrupted");
        } else if (!this.tQuiet && bl2) {
            this.vwr.scriptStatus("Script completed");
        }
        this.historyDisabled = false;
        this.isCmdLine_c_or_C_Option = false;
        this.chk = false;
        this.executing = false;
        String string = this.getErrorMessageUntranslated();
        this.vwr.setErrorMessage(this.errorMessage, string);
        if (!this.tQuiet && bl2) {
            this.vwr.setScriptStatus("Jmol script terminated", this.errorMessage, 1 + (int)(this.timeEndExecution - this.timeBeginExecution), string);
        }
    }

    @Override
    public void resumeEval(ScriptContext scriptContext) {
        this.setErrorMessage(null);
        if (this.executionStopped || scriptContext == null || !scriptContext.mustResumeEval) {
            this.resumeViewer("resumeEval");
            return;
        }
        if (!this.executionPaused) {
            ++scriptContext.pc;
        }
        this.thisContext = scriptContext;
        if (scriptContext.scriptLevel > 0) {
            this.scriptLevel = scriptContext.scriptLevel - 1;
        }
        this.restoreScriptContext(scriptContext, true, false, false);
        this.pcResume = scriptContext.pc;
        this.executeCommands(scriptContext.isTryCatch, this.scriptLevel <= 0);
        this.pcResume = -1;
    }

    private void resumeViewer(String string) {
        this.vwr.setTainted(true);
        this.vwr.popHoldRepaint(string + (this.chk ? "\u0001## REPAINT_IGNORE ##" : ""));
        this.vwr.queueOnHold = false;
    }

    @Override
    public void runScript(String string) throws ScriptException {
        if (!this.vwr.isPreviewOnly) {
            this.runScriptBuffer(string, this.outputBuffer);
        }
    }

    @Override
    public void runScriptBuffer(String string, SB sB) throws ScriptException {
        this.pushContext(null, "runScriptBuffer");
        this.contextPath = this.contextPath + " >> script() ";
        this.outputBuffer = sB;
        this.allowJSThreads = false;
        if (this.compileScript(null, string + "\u0001## EDITOR_IGNORE ##" + "\u0001## REPAINT_IGNORE ##", false)) {
            this.dispatchCommands(false, false, false);
        }
        this.popContext(false, false);
    }

    @Override
    public ScriptContext checkScriptSilent(String string) {
        ScriptContext scriptContext = this.compiler.compile(null, string, false, true, false, true);
        if (scriptContext.errorType != null) {
            return scriptContext;
        }
        this.restoreScriptContext(scriptContext, false, false, false);
        this.chk = true;
        this.isCmdLine_C_Option = false;
        this.isCmdLine_c_or_C_Option = false;
        this.pc = 0;
        try {
            this.dispatchCommands(false, false, false);
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
            scriptContext = this.getScriptContext("checkScriptSilent");
        }
        this.chk = false;
        return scriptContext;
    }

    static SB getContextTrace(Viewer viewer, ScriptContext scriptContext, SB sB, boolean bl) {
        if (sB == null) {
            sB = new SB();
        }
        int n = Math.min(scriptContext.pc, scriptContext.lineNumbers[scriptContext.lineNumbers.length - 1]);
        sB.append(ScriptEval.getErrorLineMessage(scriptContext.functionName, scriptContext.scriptFileName, scriptContext.lineNumbers[n], n, ScriptEval.statementAsString(viewer, scriptContext.statement, bl ? scriptContext.iToken : 9999, false)));
        if (scriptContext.parentContext != null) {
            ScriptEval.getContextTrace(viewer, scriptContext.parentContext, sB, false);
        }
        return sB;
    }

    @Override
    public void setDebugging() {
        this.debugScript = this.vwr.getBoolean(603979825);
        this.debugHigh = this.debugScript && Logger.debugging;
    }

    @Override
    public void haltExecution() {
        this.resumePausedExecution();
        this.executionStopped = true;
    }

    @Override
    public void pauseExecution(boolean bl) {
        if (this.chk || this.vwr.headless) {
            return;
        }
        if (bl && !this.isJS) {
            this.delayScript(-100);
        }
        this.vwr.popHoldRepaint("pauseExecution " + bl);
        this.executionStepping = false;
        this.executionPaused = true;
    }

    @Override
    public void stepPausedExecution() {
        this.executionStepping = true;
        this.executionPaused = false;
    }

    @Override
    public void resumePausedExecution() {
        this.executionPaused = false;
        this.executionStepping = false;
    }

    @Override
    public boolean isExecuting() {
        return this.executing && !this.executionStopped;
    }

    @Override
    public boolean isPaused() {
        return this.executionPaused;
    }

    @Override
    public boolean isStepping() {
        return this.executionStepping;
    }

    @Override
    public boolean isStopped() {
        return this.executionStopped || !this.isJS && this.currentThread != Thread.currentThread();
    }

    @Override
    public String getNextStatement() {
        return this.pc < this.aatoken.length ? ScriptEval.getErrorLineMessage(this.functionName, this.scriptFileName, this.getLinenumber(null), this.pc, ScriptEval.statementAsString(this.vwr, this.aatoken[this.pc], -9999, this.debugHigh)) : "";
    }

    private String getCommand(int n, boolean bl, boolean bl2) {
        if (n >= this.lineIndices.length) {
            return "";
        }
        if (bl) {
            String string;
            int n2 = -1;
            int n3 = this.script.length();
            for (int i = 0; i < this.lineNumbers.length; ++i) {
                if (this.lineNumbers[i] == this.lineNumbers[n]) {
                    if (n2 < 0) {
                        n2 = this.lineIndices[i][0];
                    }
                    n3 = this.lineIndices[i][1];
                    continue;
                }
                if (this.lineNumbers[i] == 0 || this.lineNumbers[i] > this.lineNumbers[n]) break;
            }
            if ((string = this.script).indexOf(1) >= 0) {
                string = string.substring(0, string.indexOf(1));
            }
            if (n3 == string.length() - 1 && string.endsWith("}")) {
                ++n3;
            }
            return n2 == string.length() || n3 < n2 ? "" : string.substring(Math.max(n2, 0), Math.min(string.length(), n3));
        }
        int n4 = this.lineIndices[n][0];
        int n5 = this.lineIndices[n][1];
        String string = "";
        if (n4 < 0 || n5 <= n4 || n5 > this.script.length()) {
            return "";
        }
        try {
            string = this.script.substring(n4, n5);
            if (string.indexOf("\\\n") >= 0) {
                string = PT.rep(string, "\\\n", "  ");
            }
            if (string.indexOf("\\\r") >= 0) {
                string = PT.rep(string, "\\\r", "  ");
            }
            if (string.length() > 0 && !string.endsWith(";")) {
                string = string + ";";
            }
        }
        catch (Exception exception) {
            Logger.error("darn problem in Eval getCommand: ichBegin=" + n4 + " ichEnd=" + n5 + " len = " + this.script.length() + "\n" + exception);
        }
        return string;
    }

    private void logDebugScript(T[] tArray, int n) {
        this.iToken = -9999;
        if (this.debugHigh) {
            if (tArray.length > 0) {
                Logger.debug(tArray[0].toString());
            }
            for (int i = 1; i < tArray.length; ++i) {
                if (tArray[i] == null) continue;
                Logger.debug(tArray[i].toString());
            }
            SB sB = new SB();
            String string = n > 0 ? "                          ".substring(0, n * 2) : "";
            sB.append(string).append(ScriptEval.statementAsString(this.vwr, tArray, this.iToken, this.debugHigh));
            this.vwr.scriptStatus(sB.toString());
        } else {
            String string = this.getCommand(this.pc, false, false);
            if (string != "") {
                this.vwr.scriptStatus(string);
            }
        }
    }

    @Override
    public Object evaluateExpression(Object object, boolean bl, boolean bl2) {
        ScriptEval scriptEval = new ScriptEval().setViewer(this.vwr);
        try {
            scriptEval.thisContext = this.thisContext;
            scriptEval.contextVariables = this.contextVariables;
            scriptEval.pushContext(null, "evalExp");
            scriptEval.allowJSThreads = false;
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        boolean bl3 = this.executing;
        Object object2 = scriptEval.evaluate(object, bl, bl2);
        this.executing = bl3;
        return object2;
    }

    private Object evaluate(Object object, boolean bl, boolean bl2) {
        try {
            if (object instanceof String) {
                if (this.compileScript(null, "e_x_p_r_e_s_s_i_o_n = " + object, false)) {
                    if (bl2) {
                        return this.aatoken[0];
                    }
                    this.setStatement(this.aatoken[0], 1);
                    return bl ? this.parameterExpressionList(2, -1, false).get(0) : this.parameterExpressionString(2, 0);
                }
            } else if (object instanceof T[]) {
                BS bS = this.atomExpression((T[])object, 0, 0, true, false, null, false);
                return bl ? SV.newV(10, bS) : bS;
            }
        }
        catch (Exception exception) {
            Logger.error("Error evaluating: " + object + "\n" + exception);
        }
        return bl ? SV.getVariable("ERROR") : "ERROR";
    }

    @Override
    public boolean checkSelect(Map<String, SV> map, T[] tArray) {
        boolean bl = false;
        try {
            this.pushContext(null, "checkSelect");
            bl = this.parameterExpressionSelect(map, tArray);
        }
        catch (Exception exception) {
            Logger.error("checkSelect " + exception);
        }
        this.popContext(false, false);
        return bl;
    }

    @Override
    public BS getAtomBitSet(Object object) {
        if (object instanceof BS) {
            return (BS)object;
        }
        BS bS = new BS();
        try {
            this.pushContext(null, "getAtomBitSet");
            String string = "select (" + object + ")";
            string = PT.replaceAllCharacters(string, "\n\r", "),(");
            string = PT.rep(string, "()", "(none)");
            if (this.compileScript(null, string, false)) {
                this.st = this.aatoken[0];
                this.setStatement(this.st, 0);
                bS = this.atomExpression(this.st, 1, 0, false, false, null, true);
            }
            this.popContext(false, false);
        }
        catch (Exception exception) {
            Logger.error("getAtomBitSet " + object + "\n" + exception);
        }
        return bS;
    }

    public boolean compileScript(String string, String string2, boolean bl) {
        this.scriptFileName = string;
        string2 = this.fixScriptPath(string2, string);
        this.restoreScriptContext(this.compiler.compile(string, string2, false, false, bl && Logger.debugging, false), false, false, false);
        this.isStateScript = this.compiler.isStateScript;
        this.forceNoAddHydrogens = this.isStateScript && this.script.indexOf("pdbAddHydrogens") < 0;
        String string3 = this.script;
        this.pc = this.setScriptExtensions();
        if (!this.chk && this.vwr.scriptEditorVisible && string2.indexOf("\u0001## EDITOR_IGNORE ##") < 0) {
            this.vwr.scriptStatus("");
        }
        this.script = string3;
        return !this.error;
    }

    private String fixScriptPath(String string, String string2) {
        if (string2 != null && string.indexOf("$SCRIPT_PATH$") >= 0) {
            String string3 = string2;
            int n = Math.max(string2.lastIndexOf("|"), string2.lastIndexOf("/"));
            string3 = string3.substring(0, n + 1);
            string = PT.rep(string, "$SCRIPT_PATH$/", string3);
            string = PT.rep(string, "$SCRIPT_PATH$", string3);
        }
        return string;
    }

    private int setScriptExtensions() {
        String string = this.scriptExtensions;
        if (string == null) {
            return 0;
        }
        int n = string.indexOf("##SCRIPT_STEP");
        if (n >= 0) {
            this.executionStepping = true;
        }
        if ((n = string.indexOf("##SCRIPT_START=")) < 0) {
            return 0;
        }
        if ((n = PT.parseInt(string.substring(n + 15))) == Integer.MIN_VALUE) {
            return 0;
        }
        this.pc = 0;
        while (this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] <= n && this.lineIndices[this.pc][1] < n) {
            ++this.pc;
        }
        if (this.pc > 0 && this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] > n) {
            --this.pc;
        }
        return this.pc;
    }

    private boolean compileScriptFileInternal(String string, String string2, String string3, String string4) {
        String string5;
        if (string.toLowerCase().indexOf("javascript:") == 0) {
            return this.compileScript(string, this.vwr.jsEval(string.substring(11)), this.debugScript);
        }
        String[] stringArray = new String[2];
        stringArray[0] = string;
        if (!this.vwr.fm.getFileDataAsString(stringArray, -1, false, true, false)) {
            this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
            return false;
        }
        if (("\n" + stringArray[1]).indexOf("\nJmolManifest.txt\n") >= 0) {
            if (string.endsWith(".all.pngj") || string.endsWith(".all.png")) {
                string5 = "|state.spt";
                string = string + "|";
            } else {
                stringArray[0] = string = string + "|JmolManifest.txt";
                if (!this.vwr.fm.getFileDataAsString(stringArray, -1, false, true, false)) {
                    this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
                    return false;
                }
                string5 = JmolBinary.getManifestScriptPath(stringArray[1]);
            }
            if (string5 != null && string5.length() > 0) {
                stringArray[0] = string = string.substring(0, string.lastIndexOf("|")) + string5;
                if (!this.vwr.fm.getFileDataAsString(stringArray, -1, false, true, false)) {
                    this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
                    return false;
                }
            }
        }
        this.scriptFileName = string;
        stringArray[1] = JmolBinary.getEmbeddedScript(stringArray[1]);
        string5 = this.fixScriptPath(stringArray[1], stringArray[0]);
        if (string4 == null) {
            string4 = this.vwr.fm.getFilePath(string, false, false);
            string4 = string4.substring(0, Math.max(string4.lastIndexOf("|"), string4.lastIndexOf("/")));
        }
        string5 = FileManager.setScriptFileReferences(string5, string2, string3, string4);
        return this.compileScript(string, string5, this.debugScript);
    }

    @Override
    public float evalFunctionFloat(Object object, Object object2, float[] fArray) {
        try {
            Lst lst = (Lst)object2;
            for (int i = 0; i < fArray.length; ++i) {
                ((SV)lst.get((int)i)).value = Float.valueOf(fArray[i]);
            }
            ScriptFunction scriptFunction = (ScriptFunction)object;
            return SV.fValue(this.runFunctionAndRet(scriptFunction, scriptFunction.name, lst, null, true, false, false));
        }
        catch (Exception exception) {
            return Float.NaN;
        }
    }

    @Override
    public SV getUserFunctionResult(String string, Lst<SV> lst, SV sV) throws ScriptException {
        return this.runFunctionAndRet(null, string, lst, sV, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SV runFunctionAndRet(JmolScriptFunction jmolScriptFunction, String string, Lst<SV> lst, SV sV, boolean bl, boolean bl2, boolean bl3) throws ScriptException {
        JmolScriptFunction jmolScriptFunction2;
        boolean bl4;
        if (jmolScriptFunction == null) {
            jmolScriptFunction = this.vwr.getFunction(string = string.toLowerCase());
            if (jmolScriptFunction == null) {
                return null;
            }
            if (bl2) {
                this.contextPath = this.contextPath + " >> function " + string;
            }
        } else if (bl2) {
            this.contextPath = this.contextPath + " >> " + string;
        }
        this.pushContext(null, "runFunctionAndRet ");
        if (this.allowJSThreads) {
            this.allowJSThreads = bl3;
        }
        this.thisContext.isTryCatch = bl4 = jmolScriptFunction.getTok() == 364558;
        this.thisContext.isFunction = !bl4;
        this.functionName = string;
        if (bl4) {
            this.resetError();
            this.thisContext.displayLoadErrorsSave = this.vwr.displayLoadErrors;
            this.thisContext.tryPt = ++this.vwr.tryPt;
            this.vwr.displayLoadErrors = false;
            this.restoreFunction(jmolScriptFunction, lst, sV);
            this.contextVariables.put("_breakval", SV.newI(Integer.MAX_VALUE));
            this.contextVariables.put("_errorval", SV.newS(""));
            Map map = this.contextVariables;
            this.executeCommands(true, false);
            while (this.thisContext.tryPt > this.vwr.tryPt) {
                this.popContext(false, false);
            }
            this.processTry(map);
            return null;
        }
        if (jmolScriptFunction instanceof JmolParallelProcessor) {
            jmolScriptFunction2 = jmolScriptFunction;
            synchronized (jmolScriptFunction2) {
                this.parallelProcessor = (JmolParallelProcessor)((Object)jmolScriptFunction);
                this.restoreFunction(jmolScriptFunction, lst, sV);
                this.dispatchCommands(false, true, false);
                ((JmolParallelProcessor)((Object)jmolScriptFunction)).runAllProcesses(this.vwr);
            }
        } else {
            this.restoreFunction(jmolScriptFunction, lst, sV);
            this.dispatchCommands(false, true, false);
        }
        jmolScriptFunction2 = bl ? this.getContextVariableAsVariable("_retval", false) : null;
        this.popContext(false, false);
        return jmolScriptFunction2;
    }

    private void processTry(Map<String, SV> map) throws ScriptException {
        int n;
        this.vwr.displayLoadErrors = this.thisContext.displayLoadErrorsSave;
        this.popContext(false, false);
        String string = (String)this.vwr.getP("_errormessage");
        if (string.length() > 0) {
            map.put("_errorval", SV.newS(string));
            this.resetError();
        }
        map.put("_tryret", map.get("_retval"));
        SV sV = map.get("_tryret");
        if (sV.value != null || sV.intValue != Integer.MAX_VALUE) {
            this.cmdReturn(sV);
            return;
        }
        String string2 = (String)map.get((Object)"_errorval").value;
        if (string2.length() == 0 && (n = map.get((Object)"_breakval").intValue) != Integer.MAX_VALUE) {
            this.breakAt(this.pc - n);
            return;
        }
        if (this.pc + 1 < this.aatoken.length && this.aatoken[this.pc + 1][0].tok == 102412) {
            ContextToken contextToken = (ContextToken)this.aatoken[this.pc + 1][0];
            if (contextToken.contextVariables != null && contextToken.name0 != null) {
                contextToken.contextVariables.put(contextToken.name0, SV.newS(string2));
            }
            contextToken.intValue = (string2.length() > 0 ? 1 : -1) * Math.abs(contextToken.intValue);
        }
    }

    private void breakAt(int n) {
        if (n < 0) {
            this.getContextVariableAsVariable((String)"_breakval", (boolean)false).intValue = -n;
            this.pcEnd = this.pc;
            return;
        }
        int n2 = Math.abs(this.aatoken[n][0].intValue);
        int n3 = this.aatoken[n][0].tok;
        if (n3 == 102411 || n3 == 102413) {
            this.theToken = this.aatoken[n2--][0];
            int n4 = Math.abs(this.theToken.intValue);
            if (this.theToken.tok != 102409) {
                this.theToken.intValue = -n4;
            }
        } else {
            this.pc = -1;
            while (this.pc != n && this.thisContext != null) {
                while (this.thisContext != null && !ScriptCompiler.isBreakableContext(this.thisContext.token.tok)) {
                    this.popContext(true, false);
                }
                this.pc = this.thisContext.pc;
                this.popContext(true, false);
            }
        }
        this.pc = n2;
    }

    private void restoreFunction(JmolScriptFunction jmolScriptFunction, Lst<SV> lst, SV sV) throws ScriptException {
        ScriptFunction scriptFunction = (ScriptFunction)jmolScriptFunction;
        this.aatoken = scriptFunction.aatoken;
        this.lineNumbers = scriptFunction.lineNumbers;
        this.lineIndices = scriptFunction.lineIndices;
        this.script = scriptFunction.script;
        this.pc = 0;
        if (scriptFunction.names != null) {
            this.contextVariables = new Hashtable();
            scriptFunction.setVariables(this.contextVariables, lst);
        }
        if (sV != null) {
            this.contextVariables.put("_x", sV);
        }
    }

    @Override
    public void clearDefinedVariableAtomSets() {
        this.vwr.definedAtomSets.remove("# variable");
    }

    private void defineSets() {
        String string;
        int n;
        if (!this.vwr.definedAtomSets.containsKey("# static")) {
            for (n = 0; n < JC.predefinedStatic.length; ++n) {
                this.defineAtomSet(JC.predefinedStatic[n]);
            }
            this.defineAtomSet("# static");
        }
        if (this.vwr.definedAtomSets.containsKey("# variable")) {
            return;
        }
        for (n = 0; n < JC.predefinedVariable.length; ++n) {
            this.defineAtomSet(JC.predefinedVariable[n]);
        }
        n = Elements.elementNumberMax;
        while (--n >= 0) {
            string = " elemno=" + n;
            this.defineAtomSet("@" + Elements.elementNameFromNumber(n) + string);
            this.defineAtomSet("@_" + Elements.elementSymbolFromNumber(n) + string);
        }
        n = 4;
        while (--n >= 0) {
            string = "@" + Elements.altElementNameFromIndex(n) + " _e=" + Elements.altElementNumberFromIndex(n);
            this.defineAtomSet(string);
        }
        n = Elements.altElementMax;
        while (--n >= 4) {
            int n2;
            int n3 = Elements.altElementNumberFromIndex(n);
            String string2 = " _e=" + n3;
            String string3 = "@_" + Elements.altElementSymbolFromIndex(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@_" + Elements.altIsotopeSymbolFromIndex(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@_" + Elements.altIsotopeSymbolFromIndex2(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@" + Elements.altElementNameFromIndex(n);
            if (string3.length() > 1) {
                this.defineAtomSet(string3 + string2);
            }
            if ((n3 = Elements.getNaturalIsotope(n2 = Elements.getElementNumber(n3))) <= 0) continue;
            string2 = Elements.elementSymbolFromNumber(n2);
            this.defineAtomSet("@_" + string2 + n3 + " _e=" + n2);
            this.defineAtomSet("@_" + n3 + string2 + " _e=" + n2);
        }
        this.defineAtomSet("# variable");
    }

    private void defineAtomSet(String string) {
        if (string.indexOf("#") == 0) {
            this.vwr.definedAtomSets.put(string, Boolean.TRUE);
            return;
        }
        ScriptContext scriptContext = this.compiler.compile("#predefine", string, true, false, false, false);
        if (scriptContext.errorType != null) {
            this.vwr.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + string + "\ncompile error:" + scriptContext.errorMessageUntranslated);
            return;
        }
        if (scriptContext.getTokenCount() != 1) {
            this.vwr.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + string);
            return;
        }
        T[] tArray = scriptContext.getToken(0);
        if (tArray.length <= 2) {
            this.vwr.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + string);
            return;
        }
        int n = tArray[1].tok;
        if (!T.tokAttr(n, 0x40000000) && !T.tokAttr(n, 0x200000)) {
            this.vwr.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + string);
            return;
        }
        String string2 = ((String)tArray[1].value).toLowerCase();
        if (string2.startsWith("dynamic_")) {
            string2 = "!" + string2.substring(8);
        }
        this.vwr.definedAtomSets.put(string2, tArray);
    }

    @Override
    public BS lookupIdentifierValue(String string) throws ScriptException {
        BS bS = this.lookupValue(string, false);
        if (bS != null) {
            return BSUtil.copy(bS);
        }
        bS = this.getAtomBits(0x40000000, string);
        return bS == null ? new BS() : bS;
    }

    private BS lookupValue(String string, boolean bl) throws ScriptException {
        if (this.chk) {
            return new BS();
        }
        this.defineSets();
        string = string.toLowerCase();
        Object object = this.vwr.definedAtomSets.get(string);
        boolean bl2 = false;
        if (object == null) {
            object = this.vwr.definedAtomSets.get("!" + string);
            boolean bl3 = bl2 = object != null;
        }
        if (object instanceof BS) {
            return (BS)object;
        }
        if (object instanceof T[]) {
            this.pushContext(null, "lookupValue");
            BS bS = this.atomExpression((T[])object, -2, 0, true, false, null, true);
            this.popContext(false, false);
            if (!bl2) {
                this.vwr.definedAtomSets.put(string, bS);
            }
            return bS;
        }
        if (string.equals("water")) {
            BS bS = this.vwr.ms.getAtoms(1612709912, null);
            if (!bl2) {
                this.vwr.definedAtomSets.put(string, bS);
            }
            return bS;
        }
        if (bl) {
            return null;
        }
        int n = string.length();
        if (n < 5) {
            return null;
        }
        if (string.charAt(n - 1) != 's') {
            return null;
        }
        string = string.endsWith("ies") ? string.substring(0, n - 3) + 'y' : string.substring(0, n - 1);
        return this.lookupValue(string, true);
    }

    @Override
    public void deleteAtomsInVariables(BS bS) {
        for (Map.Entry<String, Object> entry : this.vwr.definedAtomSets.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof BS)) continue;
            BSUtil.deleteBits((BS)object, bS);
            if (entry.getKey().startsWith("!")) continue;
            this.vwr.g.setUserVariable("@" + entry.getKey(), SV.newV(10, object));
        }
    }

    @Override
    public ScriptContext getThisContext() {
        return this.thisContext;
    }

    private void clearState(boolean bl) {
        this.thisContext = null;
        this.scriptLevel = 0;
        this.setErrorMessage(null);
        this.contextPath = "";
        this.tQuiet = bl;
    }

    @Override
    public void pushContextDown(String string) {
        --this.scriptLevel;
        this.pushContext2(null, string);
    }

    private void pushContext(ContextToken contextToken, String string) throws ScriptException {
        if (this.scriptLevel == contextDepthMax) {
            this.error(44);
        }
        this.pushContext2(contextToken, string);
    }

    private void pushContext2(ContextToken contextToken, String string) {
        this.thisContext = this.getScriptContext(string);
        this.thisContext.token = contextToken;
        if (contextToken == null) {
            this.scriptLevel = ++this.thisContext.scriptLevel;
        } else {
            this.thisContext.scriptLevel = -1;
            this.contextVariables = new Hashtable();
            if (contextToken.contextVariables != null) {
                for (String string2 : contextToken.contextVariables.keySet()) {
                    ScriptCompiler.addContextVariable(this.contextVariables, string2);
                }
            }
        }
        if (this.debugHigh || this.isCmdLine_c_or_C_Option) {
            Logger.info("-->>----------------------".substring(0, Math.min(15, this.scriptLevel + 5)) + this.scriptLevel + " " + this.scriptFileName + " " + contextToken + " " + this.thisContext.id + " " + string + " path=" + this.thisContext.contextPath);
        }
    }

    @Override
    public ScriptContext getScriptContext(String string) {
        ScriptContext scriptContext = new ScriptContext();
        if (this.debugHigh) {
            Logger.info("creating context " + scriptContext.id + " for " + string + " path=" + this.contextPath);
        }
        scriptContext.scriptLevel = this.scriptLevel;
        scriptContext.parentContext = this.thisContext;
        scriptContext.contextPath = this.contextPath;
        scriptContext.scriptFileName = this.scriptFileName;
        scriptContext.parallelProcessor = this.parallelProcessor;
        scriptContext.functionName = this.functionName;
        scriptContext.script = this.script;
        scriptContext.lineNumbers = this.lineNumbers;
        scriptContext.lineIndices = this.lineIndices;
        scriptContext.saveTokens(this.aatoken);
        scriptContext.statement = this.st;
        scriptContext.statementLength = this.slen;
        scriptContext.pc = scriptContext.pc0 = this.pc;
        scriptContext.lineEnd = this.lineEnd;
        scriptContext.pcEnd = this.pcEnd;
        scriptContext.iToken = this.iToken;
        scriptContext.theToken = this.theToken;
        scriptContext.theTok = this.theTok;
        scriptContext.outputBuffer = this.outputBuffer;
        scriptContext.vars = this.contextVariables;
        scriptContext.isStateScript = this.isStateScript;
        scriptContext.errorMessage = this.errorMessage;
        scriptContext.errorType = this.errorType;
        scriptContext.iCommandError = this.iCommandError;
        scriptContext.chk = this.chk;
        scriptContext.executionStepping = this.executionStepping;
        scriptContext.executionPaused = this.executionPaused;
        scriptContext.scriptExtensions = this.scriptExtensions;
        scriptContext.mustResumeEval = this.mustResumeEval;
        scriptContext.allowJSThreads = this.allowJSThreads;
        return scriptContext;
    }

    void popContext(boolean bl, boolean bl2) {
        if (this.thisContext == null) {
            return;
        }
        if (this.thisContext.scriptLevel > 0) {
            this.scriptLevel = this.thisContext.scriptLevel - 1;
        }
        ScriptContext scriptContext = bl ? this.getScriptContext("popFlow") : null;
        this.restoreScriptContext(this.thisContext, true, bl, bl2);
        if (scriptContext != null) {
            this.restoreScriptContext(scriptContext, true, false, true);
        }
        if (this.debugHigh || this.isCmdLine_c_or_C_Option) {
            Logger.info("--<<------------".substring(0, Math.min(15, this.scriptLevel + 5)) + (this.scriptLevel + 1) + " " + this.scriptFileName + " isFlow " + bl + " thisContext=" + (this.thisContext == null ? "" : "" + this.thisContext.id) + " pc=" + this.pc + "-->" + this.pc + " path=" + (this.thisContext == null ? "" : this.thisContext.contextPath));
        }
    }

    public void restoreScriptContext(ScriptContext scriptContext, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.executing = !this.chk;
        if (scriptContext == null) {
            return;
        }
        if (!bl2) {
            this.st = scriptContext.statement;
            this.slen = scriptContext.statementLength;
            this.pc = scriptContext.pc;
            this.lineEnd = scriptContext.lineEnd;
            this.pcEnd = scriptContext.pcEnd;
            if (bl3) {
                return;
            }
        }
        this.mustResumeEval = scriptContext.mustResumeEval;
        this.script = scriptContext.script;
        this.lineNumbers = scriptContext.lineNumbers;
        this.lineIndices = scriptContext.lineIndices;
        this.aatoken = scriptContext.restoreTokens();
        this.contextVariables = scriptContext.vars;
        this.scriptExtensions = scriptContext.scriptExtensions;
        if (bl) {
            int n;
            this.contextPath = scriptContext.contextPath;
            int n2 = n = this.contextPath == null ? -1 : this.contextPath.indexOf(" >> ");
            if (n >= 0) {
                this.contextPath = this.contextPath.substring(0, n);
            }
            this.scriptFileName = scriptContext.scriptFileName;
            this.parallelProcessor = scriptContext.parallelProcessor;
            this.functionName = scriptContext.functionName;
            this.iToken = scriptContext.iToken;
            this.theToken = scriptContext.theToken;
            this.theTok = scriptContext.theTok;
            this.outputBuffer = scriptContext.outputBuffer;
            this.isStateScript = scriptContext.isStateScript;
            this.thisContext = scriptContext.parentContext;
            this.allowJSThreads = scriptContext.allowJSThreads;
            if (this.debugHigh || this.isCmdLine_c_or_C_Option) {
                Logger.info("--r------------".substring(0, Math.min(15, this.scriptLevel + 5)) + this.scriptLevel + " " + this.scriptFileName + " isPop " + bl + " isFlow " + bl2 + " context.id=" + scriptContext.id + " pc=" + this.pc + "-->" + scriptContext.pc + " " + this.contextPath);
            }
        } else {
            this.error = scriptContext.errorType != null;
            this.errorMessage = scriptContext.errorMessage;
            this.errorMessageUntranslated = scriptContext.errorMessageUntranslated;
            this.iCommandError = scriptContext.iCommandError;
            this.errorType = scriptContext.errorType;
        }
    }

    public void setException(ScriptException scriptException, String string, String string2) {
        scriptException.untranslated = string2 == null ? string : string2;
        boolean bl = "!".equals(string2);
        this.errorType = string;
        this.iCommandError = this.pc;
        if (scriptException.message == null) {
            scriptException.message = "";
            return;
        }
        String string3 = ScriptEval.getContextTrace(this.vwr, this.getScriptContext("setException"), null, true).toString();
        while (this.thisContext != null && !this.thisContext.isTryCatch) {
            this.popContext(false, false);
        }
        if (scriptException.message.indexOf(string3) < 0) {
            scriptException.message = scriptException.message + string3;
            scriptException.untranslated = scriptException.untranslated + string3;
        }
        this.resumeViewer(bl ? "throw context" : "scriptException");
        if (bl || this.thisContext != null || this.chk || string.indexOf("NOTE: file recognized as a script file: ") >= 0) {
            return;
        }
        Logger.error("eval ERROR: " + string3 + this.toString());
        if (this.vwr.autoExit) {
            this.vwr.exitJmol();
        }
    }

    public static String statementAsString(Viewer viewer, T[] tArray, int n, boolean bl) {
        if (tArray.length == 0) {
            return "";
        }
        SB sB = new SB();
        int n2 = tArray[0].tok;
        switch (n2) {
            case 0: {
                return (String)tArray[0].value;
            }
            case 102409: {
                if (tArray.length != 2 || tArray[1].tok != 134320137 && tArray[1].tok != 102436) break;
                return ((ScriptFunction)tArray[1].value).toString();
            }
        }
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = tArray.length > 1 && n2 == 36867 && tArray[0].value.equals("") && (tArray[0].intValue == 61 || tArray[0].intValue == 35) && tArray[1].tok != 1073742325;
        int n3 = tArray.length;
        block33: for (int i = 0; i < n3; ++i) {
            T t = tArray[i];
            if (t == null) {
                n3 = i;
                break;
            }
            if (n == i - 1) {
                sB.append(" <<");
            }
            if (i != 0) {
                sB.appendC(' ');
            }
            if (i == 2 && bl5 && ((bl5 = t.tok != 268435860) || tArray[0].intValue == 35)) {
                sB.append(bl5 ? "= " : "== ");
                if (!bl5) continue;
            }
            if (n == i && t.tok != 1073742326) {
                sB.append("<<<<");
            }
            switch (t.tok) {
                case 1073742325: {
                    if (!bl2) continue block33;
                    sB.append("{");
                    continue block33;
                }
                case 1073742326: {
                    if (bl4 && i == tArray.length - 1) {
                        bl2 = false;
                    }
                    if (!bl2) continue block33;
                    sB.append("}");
                    continue block33;
                }
                case 0x10000040: 
                case 0x10000041: {
                    break;
                }
                case 1073742332: 
                case 0x40000202: {
                    bl3 = t.tok == 1073742332;
                    break;
                }
                case 12290: {
                    if (i <= 0 || !((String)t.value).equals("define")) break;
                    sB.append("@");
                    if (i + 1 >= tArray.length || tArray[i + 1].tok != 1073742325) continue block33;
                    if (!bl2) {
                        bl4 = true;
                    }
                    bl2 = true;
                    continue block33;
                }
                case 1073742335: {
                    sB.append("true");
                    continue block33;
                }
                case 1073742334: {
                    sB.append("false");
                    continue block33;
                }
                case 1275082245: {
                    break;
                }
                case 2: {
                    sB.appendI(t.intValue);
                    continue block33;
                }
                case 8: 
                case 9: 
                case 10: {
                    sB.append(SV.sValue(t));
                    continue block33;
                }
                case 6: {
                    if (Boolean.TRUE == ((Map)t.value).get("$_BINARY_$")) {
                        sB.append("<BINARY DATA>");
                        continue block33;
                    }
                }
                case 7: {
                    sB.append(((SV)t).escape());
                    continue block33;
                }
                case 5: {
                    sB.appendC('^');
                    continue block33;
                }
                case 1073742363: {
                    if (t.intValue != Integer.MAX_VALUE) {
                        sB.appendI(t.intValue);
                    } else {
                        sB.append(Group.getSeqcodeStringFor(ScriptEval.getSeqCode(t)));
                    }
                    t = tArray[++i];
                    sB.appendC(' ');
                    sB.append(bl3 ? "-" : "- ");
                }
                case 1073742362: {
                    if (t.intValue != Integer.MAX_VALUE) {
                        sB.appendI(t.intValue);
                        continue block33;
                    }
                    sB.append(Group.getSeqcodeStringFor(ScriptEval.getSeqCode(t)));
                    continue block33;
                }
                case 1073742357: {
                    sB.append("*:");
                    sB.append(viewer.getChainIDStr(t.intValue));
                    continue block33;
                }
                case 1073742355: {
                    sB.append("*%");
                    if (t.value == null) continue block33;
                    sB.append(t.value.toString());
                    continue block33;
                }
                case 1073742358: {
                    sB.append("*/");
                }
                case 3: 
                case 1073742359: {
                    if (t.intValue < Integer.MAX_VALUE) {
                        sB.append(Escape.escapeModelFileNumber(t.intValue));
                        continue block33;
                    }
                    sB.append("" + t.value);
                    continue block33;
                }
                case 1073742361: {
                    sB.appendC('[');
                    int n4 = t.intValue * 6 + 1;
                    sB.append(Group.standardGroupList.substring(n4, n4 + 3).trim());
                    sB.appendC(']');
                    continue block33;
                }
                case 1073742360: {
                    sB.appendC('[');
                    sB.appendO(t.value);
                    sB.appendC(']');
                    continue block33;
                }
                case 1073742356: {
                    sB.append("*.");
                    break;
                }
                case 1094713349: {
                    if (!(t.value instanceof P3)) break;
                    P3 p3 = (P3)t.value;
                    sB.append("cell=").append(Escape.eP(p3));
                    continue block33;
                }
                case 4: {
                    sB.append("\"").appendO(t.value).append("\"");
                    continue block33;
                }
                case 0x10000190: 
                case 0x10000191: 
                case 268435858: 
                case 268435859: 
                case 268435860: 
                case 268435861: {
                    if (t.intValue == 1715472409) {
                        sB.append((String)tArray[++i].value).append(" ");
                        break;
                    }
                    if (t.intValue == Integer.MAX_VALUE) break;
                    sB.append(T.nameOf(t.intValue)).append(" ");
                    break;
                }
                case 364558: {
                    continue block33;
                }
                case 102409: {
                    sB.append("end");
                    continue block33;
                }
                default: {
                    if (T.tokAttr(t.tok, 0x40000000) || !bl) break;
                    sB.appendC('\n').append(t.toString()).appendC('\n');
                    continue block33;
                }
            }
            if (t.value == null) continue;
            sB.append(t.value.toString());
        }
        return sB.toString();
    }

    @Override
    public String setObjectPropSafe(String string, int n) {
        try {
            return this.setObjectProp(string, n, -1);
        }
        catch (ScriptException scriptException) {
            return null;
        }
    }

    @Override
    public void restrictSelected(boolean bl, boolean bl2) {
        if (!this.chk) {
            this.sm.restrictSelected(bl, bl2);
        }
    }

    @Override
    public void showString(String string) {
        this.showStringPrint(string, false);
    }

    public void showStringPrint(String string, boolean bl) {
        if (this.chk || string == null) {
            return;
        }
        if (this.outputBuffer != null && Logger.isActiveLevel(3)) {
            this.outputBuffer.append(string).appendC('\n');
        } else {
            this.vwr.showString(string, bl);
        }
    }

    public void report(String string) {
        if (this.chk) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).appendC('\n');
            return;
        }
        this.vwr.scriptStatus(string);
    }

    private void addProcess(Lst<T[]> lst, int n, int n2) {
        if (this.parallelProcessor == null) {
            return;
        }
        T[][] tArray = new T[n2][];
        for (int i = 0; i < lst.size(); ++i) {
            tArray[i + 1 - n] = (T[])lst.get(i);
        }
        ScriptContext scriptContext = this.getScriptContext("addProcess");
        scriptContext.saveTokens(tArray);
        scriptContext.pc = 1 - n;
        scriptContext.pcEnd = n2;
        this.parallelProcessor.addProcess("p" + ++iProcess, scriptContext);
    }

    private boolean checkContinue() throws ScriptException {
        if (this.executionStopped) {
            return false;
        }
        if (this.executionStepping && this.isCommandDisplayable(this.pc)) {
            this.vwr.setScriptStatus("Next: " + this.getNextStatement(), "stepping -- type RESUME to continue", 0, null);
            this.executionPaused = true;
        } else if (!this.executionPaused) {
            return true;
        }
        if (Logger.debugging) {
            Logger.debug("script execution paused at command " + (this.pc + 1) + " level " + this.scriptLevel + ": " + this.thisCommand);
        }
        this.refresh(false);
        while (this.executionPaused) {
            this.vwr.popHoldRepaint("pause \u0001## REPAINT_IGNORE ##");
            String string = this.vwr.getInsertedCommand();
            if (string.length() > 0) {
                this.resumePausedExecution();
                this.setErrorMessage(null);
                ScriptContext scriptContext = this.getScriptContext("script insertion");
                --this.pc;
                try {
                    this.runScript(string);
                }
                catch (Exception exception) {
                    this.setErrorMessage("" + exception);
                }
                catch (Error error) {
                    this.setErrorMessage("" + error);
                }
                if (this.error) {
                    this.report(this.errorMessage);
                    this.setErrorMessage(null);
                }
                this.restoreScriptContext(scriptContext, true, false, false);
                this.pauseExecution(false);
            }
            this.doDelay(-100);
            this.vwr.pushHoldRepaintWhy("pause");
        }
        this.notifyResumeStatus();
        return !this.error && !this.executionStopped;
    }

    public void delayScript(int n) {
        if (this.vwr.autoExit) {
            return;
        }
        this.stopScriptThreads();
        this.scriptDelayThread = new ScriptDelayThread(this, this.vwr, n);
        this.scriptDelayThread.run();
    }

    private void doDelay(int n) throws ScriptException {
        if (!this.useThreads()) {
            return;
        }
        if (this.isJS) {
            throw new ScriptInterruption(this, "delay", n);
        }
        this.delayScript(n);
    }

    @Override
    public boolean evalParallel(ScriptContext scriptContext, ShapeManager shapeManager) {
        return this.getCmdExt().evalParallel(scriptContext, shapeManager);
    }

    private boolean isCommandDisplayable(int n) {
        if (n >= this.aatoken.length || n >= this.pcEnd || this.aatoken[n] == null) {
            return false;
        }
        return this.lineIndices[n][1] > this.lineIndices[n][0];
    }

    @Override
    public void loadFileResourceAsync(String string) throws ScriptException {
        this.loadFileAsync(null, string, -Math.abs(string.hashCode()), false);
    }

    public String loadFileAsync(String string, String string2, int n, boolean bl) throws ScriptException {
        String string3;
        if (this.vwr.fm.cacheGet(string2, false) != null) {
            return string2;
        }
        if (string != null) {
            string = "cache://local" + string;
        }
        String string4 = this.pc + "_" + n + "_" + string2;
        if (this.thisContext == null || this.thisContext.htFileCache == null) {
            this.pushContext(null, "loadFileAsync");
            this.thisContext.htFileCache = new Hashtable<String, String>();
        }
        if ((string3 = this.thisContext.htFileCache.get(string4)) != null && string3.length() > 0) {
            this.fileLoadThread = null;
            this.popContext(false, false);
            this.vwr.queueOnHold = false;
            if ("#CANCELED#".equals(string3) || "#CANCELED#".equals(this.vwr.fm.cacheGet(string3, false))) {
                this.evalError("#CANCELED#", null);
            }
            return string3;
        }
        string3 = string + System.currentTimeMillis();
        this.thisContext.htFileCache.put(string4, string3);
        if (bl) {
            this.vwr.cacheFileByName(string + "*", false);
        }
        this.fileLoadThread = new FileLoadThread(this, this.vwr, string2, string4, string3);
        if (this.vwr.testAsync) {
            this.fileLoadThread.start();
        } else {
            this.fileLoadThread.run();
        }
        if (n < 0) {
            this.fileLoadThread = null;
        }
        throw new ScriptInterruption(this, "load", 1);
    }

    private void logLoadInfo(String string) {
        if (string.length() > 0) {
            Logger.info(string);
        }
        SB sB = new SB();
        int n = this.vwr.ms.mc;
        if (n > 1) {
            sB.append((this.vwr.am.isMovie ? this.vwr.am.getFrameCount() + " frames" : n + " models") + "\n");
        }
        for (int i = 0; i < n; ++i) {
            Map map = (Map)this.vwr.ms.getInfo(i, "moData");
            if (map == null || !map.containsKey("mos")) continue;
            sB.appendI(((Lst)map.get("mos")).size()).append(" molecular orbitals in model ").append(this.vwr.getModelNumberDotted(i)).append("\n");
        }
        if (sB.length() > 0) {
            this.vwr.showString(sB.toString(), false);
        }
    }

    @Override
    public void notifyResumeStatus() {
        if (!(this.chk || this.executionStopped || this.executionStepping)) {
            this.vwr.scriptStatus("script execution " + (this.error || this.executionStopped ? "interrupted" : "resumed"));
        }
        if (Logger.debugging) {
            Logger.debug("script execution resumed");
        }
    }

    @Override
    public void refresh(boolean bl) throws ScriptException {
        if (this.chk) {
            return;
        }
        this.vwr.setTainted(true);
        this.vwr.requestRepaintAndWait("refresh cmd");
        if (this.isJS && bl) {
            this.doDelay(10);
        }
    }

    @Override
    public void stopScriptThreads() {
        if (this.scriptDelayThread != null) {
            this.scriptDelayThread.interrupt();
            this.scriptDelayThread = null;
        }
        if (this.fileLoadThread != null) {
            this.fileLoadThread.interrupt();
            this.fileLoadThread.resumeEval();
            if (this.thisContext != null) {
                this.popContext(false, false);
            }
            this.fileLoadThread = null;
        }
    }

    public String getErrorLineMessage2() {
        return ScriptEval.getErrorLineMessage(this.functionName, this.scriptFileName, this.getLinenumber(null), this.pc, ScriptEval.statementAsString(this.vwr, this.st, -9999, this.debugHigh));
    }

    public int getLinenumber(ScriptContext scriptContext) {
        return scriptContext == null ? this.lineNumbers[this.pc] : scriptContext.lineNumbers[scriptContext.pc];
    }

    public boolean dispatchCommands(boolean bl, boolean bl2, boolean bl3) throws ScriptException {
        if (this.sm == null) {
            this.sm = this.vwr.shm;
        }
        this.debugHigh = false;
        this.debugScript = false;
        if (!this.chk) {
            this.setDebugging();
        }
        if (this.pcEnd == 0) {
            this.pcEnd = Integer.MAX_VALUE;
        }
        if (this.lineEnd == 0) {
            this.lineEnd = Integer.MAX_VALUE;
        }
        if (this.aatoken == null) {
            return true;
        }
        if (!this.tQuiet) {
            this.tQuiet = this.vwr.getInt(0x2000000A) < 0;
        }
        boolean bl4 = this.isJS && !bl2 && this.useThreads() && this.vwr.getInt(0x2000000A) >= 0;
        this.commandLoop(bl4);
        if (this.chk) {
            return true;
        }
        String string = this.vwr.getInsertedCommand();
        if (!"".equals(string)) {
            this.runScriptBuffer(string, null);
        } else if (bl && this.debugScript && this.vwr.getBoolean(603979880)) {
            this.vwr.getChimeMessenger().update(null);
        }
        if (!this.mustResumeEval && !bl4 || bl2) {
            return true;
        }
        if (!bl3 && this.mustResumeEval || this.thisContext == null) {
            boolean bl5 = this.thisContext == null;
            this.resumeEval(this.thisContext);
            this.mustResumeEval = false;
            return bl5;
        }
        return true;
    }

    private void commandLoop(boolean bl) throws ScriptException {
        String string = "";
        boolean bl2 = false;
        Lst<T[]> lst = null;
        long l = System.currentTimeMillis();
        if (this.debugScript && this.debugHigh && !this.chk) {
            for (int i = this.pc; i < this.aatoken.length && i < this.pcEnd; ++i) {
                Logger.info("Command " + i);
                if (!this.debugScript) continue;
                this.logDebugScript(this.aatoken[i], 0);
            }
            Logger.info("-----");
        }
        while (this.pc < this.aatoken.length && this.pc < this.pcEnd) {
            block26: {
                int n;
                block29: {
                    block28: {
                        block27: {
                            block25: {
                                String string2;
                                if (bl) {
                                    if (!this.executionPaused && System.currentTimeMillis() - l > 1000L) {
                                        --this.pc;
                                        this.doDelay(-1);
                                    }
                                    l = System.currentTimeMillis();
                                }
                                if (!this.chk && !this.checkContinue() || this.pc >= this.lineNumbers.length || this.lineNumbers[this.pc] > this.lineEnd) break;
                                if (this.debugHigh) {
                                    long l2 = 0L;
                                    l2 = System.currentTimeMillis();
                                    this.vwr.scriptStatus("Eval.dispatchCommands():" + l2);
                                    this.vwr.scriptStatus(this.script);
                                }
                                if (this.debugScript && !this.chk) {
                                    Logger.info("Command " + this.pc + (this.thisContext == null ? "" : " path=" + this.thisContext.contextPath));
                                }
                                T t = this.theToken = this.aatoken[this.pc].length == 0 ? null : this.aatoken[this.pc][0];
                                if (!(this.historyDisabled || this.chk || this.scriptLevel > commandHistoryLevelMax || this.tQuiet)) {
                                    String string3 = this.getCommand(this.pc, true, true);
                                    if (!(this.theToken == null || string3.length() <= 0 || string3.equals(string) || this.theToken.tok != 134320137 && this.theToken.tok != 102436 && T.tokAttr(this.theToken.tok, 102400))) {
                                        string = string3;
                                        this.vwr.addCommand(string);
                                    }
                                }
                                if (!this.chk && bl && !"".equals(string2 = this.vwr.getInsertedCommand())) {
                                    this.runScript(string2);
                                }
                                if (this.setStatement(this.aatoken[this.pc], 1)) break block25;
                                Logger.info(this.getCommand(this.pc, true, false) + " -- STATEMENT CONTAINING @{} SKIPPED");
                                break block26;
                            }
                            this.thisCommand = this.getCommand(this.pc, false, true);
                            if (this.debugHigh || this.debugScript) {
                                Logger.info(this.thisCommand);
                            }
                            String string4 = this.getCommand(this.pc + 1, false, true);
                            this.fullCommand = this.thisCommand + (string4.startsWith("#") ? string4 : "");
                            this.getToken(0);
                            this.iToken = 0;
                            if ((this.listCommands || !this.chk && this.scriptLevel > 0) && !this.isJS) {
                                n = this.vwr.getInt(0x2000000A);
                                if (this.listCommands || n > 0) {
                                    if (n > 0) {
                                        this.delayScript(-n);
                                    }
                                    this.vwr.scriptEcho("$[" + this.scriptLevel + "." + this.lineNumbers[this.pc] + "." + (this.pc + 1) + "] " + this.thisCommand);
                                }
                            }
                            if (lst == null || this.theTok == 102409 && this.slen >= 2 && this.st[1].tok == 102439) break block27;
                            lst.addLast(this.st);
                            break block26;
                        }
                        if (!this.chk) break block28;
                        if (this.isCmdLine_c_or_C_Option) {
                            Logger.info(this.thisCommand);
                        }
                        if (this.slen != 1 || this.st[0].tok == 134320137 || this.st[0].tok == 102436) break block29;
                        break block26;
                    }
                    if (this.debugScript) {
                        this.logDebugScript(this.st, 0);
                    }
                    if (this.scriptLevel == 0 && this.vwr.g.logCommands) {
                        this.vwr.log(this.thisCommand);
                    }
                    if (this.debugHigh && this.theToken != null) {
                        Logger.debug(this.theToken.toString());
                    }
                }
                if (this.theToken != null) {
                    n = this.theToken.tok;
                    switch (n) {
                        case 36867: {
                            this.cmdSet();
                            break;
                        }
                        case 134320648: {
                            bl2 = this.cmdFor(n, bl2);
                            break;
                        }
                        case 102439: {
                            this.pushContext((ContextToken)this.theToken, "PROCESS");
                            if (this.parallelProcessor == null) break;
                            lst = new Lst<T[]>();
                            break;
                        }
                        default: {
                            if (T.tokAttr(n, 102400)) {
                                bl2 = this.cmdFlow(n, bl2, lst);
                                if (this.theTok != 102439) break;
                                lst = null;
                                break;
                            }
                            this.processCommand(n);
                            this.setCursorWait(false);
                            if (!this.executionStepping) break;
                            this.executionPaused = this.isCommandDisplayable(this.pc + 1);
                        }
                    }
                }
            }
            ++this.pc;
        }
    }

    private void processCommand(int n) throws ScriptException {
        if (T.tokAttr(this.theToken.tok, 135168)) {
            this.processShapeCommand(n);
            return;
        }
        switch (n) {
            case 0: {
                if (this.chk || !this.vwr.getBoolean(603979880)) break;
                this.vwr.getChimeMessenger().showHash(this.outputBuffer, (String)this.theToken.value);
                break;
            }
            case 1275335685: {
                this.pushContext((ContextToken)this.theToken, "PUSH");
                break;
            }
            case 1275334673: {
                this.popContext(true, false);
                break;
            }
            case 0x10000022: {
                break;
            }
            case 4097: {
                this.cmdAnimation();
                break;
            }
            case 1610616835: {
                this.cmdBackground(1);
                break;
            }
            case 4100: {
                this.cmdBind();
                break;
            }
            case 4101: {
                this.cmdBondorder();
                break;
            }
            case 20488: {
                this.cmdCD();
                break;
            }
            case 12289: {
                this.cmdCenter(1);
                break;
            }
            case 1765808132: {
                this.cmdColor();
                break;
            }
            case 12290: {
                this.cmdDefine();
                break;
            }
            case 528397: {
                this.cmdDelay();
                break;
            }
            case 12291: {
                this.cmdDelete();
                break;
            }
            case 554176526: {
                this.cmdSlab(true);
                break;
            }
            case 1610625028: {
                this.cmdDisplay(true);
                break;
            }
            case 266255: 
            case 266281: {
                if (this.chk) break;
                if (this.pc > 0 && this.theToken.tok == 266255) {
                    this.vwr.clearScriptQueue();
                }
                this.executionStopped = this.pc > 0 || !this.vwr.g.useScriptQueue;
                break;
            }
            case 266256: {
                if (this.chk) {
                    return;
                }
                if (this.outputBuffer != null) {
                    Logger.warn(this.outputBuffer.toString());
                }
                this.vwr.exitJmol();
                break;
            }
            case 1228935687: {
                this.cmdFile();
                break;
            }
            case 12293: {
                this.cmdFixed();
                break;
            }
            case 4114: {
                this.cmdFont(-1, 0.0f);
                break;
            }
            case 4115: 
            case 1094717454: {
                this.cmdModel(1);
                break;
            }
            case 0x40000000: {
                this.cmdFunc();
                break;
            }
            case 1275072522: {
                this.cmdGetProperty();
                break;
            }
            case 20500: {
                if (this.vwr.headless) break;
                this.cmdGoto(true);
                break;
            }
            case 20482: {
                this.cmdHelp();
                break;
            }
            case 12294: {
                this.cmdDisplay(false);
                break;
            }
            case 1613238294: {
                this.cmdHbond();
                break;
            }
            case 1610616855: {
                this.cmdHistory(1);
                break;
            }
            case 544771: {
                this.cmdHover();
                break;
            }
            case 266265: {
                if (this.chk) break;
                this.vwr.initialize(!this.isStateScript);
                break;
            }
            case 4122: {
                this.cmdInvertSelected();
                break;
            }
            case 134238732: {
                this.cmdScript(134238732, null, null);
                break;
            }
            case 134222851: {
                this.cmdLoad();
                break;
            }
            case 36869: {
                this.cmdLog();
                break;
            }
            case 528411: {
                this.cmdLoop();
                break;
            }
            case 20485: {
                this.cmdMessage();
                break;
            }
            case 4128: {
                this.cmdMove();
                break;
            }
            case 4129: {
                this.cmdMoveto();
                break;
            }
            case 20487: {
                this.cmdPause();
                break;
            }
            case 36865: {
                this.cmdPrint();
                break;
            }
            case 134256131: {
                this.cmdPrompt();
                break;
            }
            case 4139: 
            case 4165: {
                this.cmdUndoRedoMove();
                break;
            }
            case 266284: {
                this.refresh(true);
                break;
            }
            case 4141: {
                this.cmdReset();
                break;
            }
            case 12295: {
                this.cmdRestrict();
                break;
            }
            case 4143: {
                if (this.slen == 0) {
                    if (this.chk) break;
                    this.resumePausedExecution();
                    break;
                }
            }
            case 4142: {
                this.cmdRestore();
                break;
            }
            case 36866: {
                this.cmdReturn(null);
                break;
            }
            case 528432: {
                this.cmdRotate(false, false);
                break;
            }
            case 4145: {
                this.cmdRotate(false, true);
                break;
            }
            case 4146: {
                this.cmdSave();
                break;
            }
            case 134222853: {
                this.cmdScript(134222853, null, null);
                break;
            }
            case 1275082245: {
                this.cmdSelect(1);
                break;
            }
            case 1611141171: {
                this.cmdSelectionHalos(1);
                break;
            }
            case 554176565: {
                this.cmdSlab(false);
                break;
            }
            case 1611141175: {
                this.cmdRotate(true, false);
                break;
            }
            case 1611141176: {
                this.cmdSsbond();
                break;
            }
            case 266298: {
                if (!this.cmdPause()) break;
                this.stepPausedExecution();
                break;
            }
            case 1639976963: {
                this.cmdStructure();
                break;
            }
            case 2109448: {
                this.cmdSubset();
                break;
            }
            case 4156: {
                this.cmdSync();
                break;
            }
            case 36870: {
                this.cmdThrow();
                break;
            }
            case 536875070: {
                this.cmdTimeout(1);
                break;
            }
            case 4160: {
                this.cmdTranslate(false);
                break;
            }
            case 4162: {
                this.cmdTranslate(true);
                break;
            }
            case 4164: {
                this.cmdUnbind();
                break;
            }
            case 36868: {
                break;
            }
            case 4166: {
                this.cmdVibration();
                break;
            }
            case 12297: {
                this.cmdZap(true);
                break;
            }
            case 4168: {
                this.cmdZoom(false);
                break;
            }
            case 4170: {
                this.cmdZoom(true);
                break;
            }
            default: {
                this.checkExtension(this.theToken.tok);
            }
        }
    }

    private void checkExtension(int n) throws ScriptException {
        switch (n) {
            case 4098: 
            case 4102: 
            case 4103: 
            case 4105: 
            case 4106: 
            case 4120: 
            case 4124: 
            case 4125: 
            case 4126: 
            case 4130: 
            case 4131: 
            case 4133: 
            case 4138: 
            case 528395: 
            case 528443: 
            case 134221829: 
            case 0x8001008: 
            case 134221842: 
            case 134221846: 
            case 134221847: 
            case 134222350: 
            case 1094717448: 
            case 1275072537: 
            case 1613238294: {
                this.getCmdExt().dispatch(n, false, this.st);
                break;
            }
            default: {
                this.error(47);
            }
        }
    }

    private void processShapeCommand(int n) throws ScriptException {
        int n2 = 0;
        switch (n) {
            case 1611272194: {
                n2 = 34;
                break;
            }
            case 1114249217: {
                n2 = 9;
                break;
            }
            case 1678381065: {
                n2 = 32;
                break;
            }
            case 1112152066: {
                n2 = 11;
                break;
            }
            case 135174: {
                n2 = 23;
                break;
            }
            case 134353929: {
                n2 = 25;
                break;
            }
            case 135175: {
                n2 = 17;
                break;
            }
            case 1112150019: {
                n2 = 16;
                break;
            }
            case 135176: {
                n2 = 22;
                break;
            }
            case 537022465: {
                n2 = 31;
                break;
            }
            case 1112150020: {
                n2 = 20;
                break;
            }
            case 1611272202: {
                n2 = 36;
                break;
            }
            case 1112150021: {
                n2 = 19;
                break;
            }
            case 1112152070: {
                n2 = 8;
                break;
            }
            case 135180: {
                n2 = 24;
                break;
            }
            case 1825200140: {
                n2 = 5;
                break;
            }
            case 135182: {
                n2 = 26;
                break;
            }
            case 0x20021010: 
            case 1745489933: {
                n2 = 6;
                break;
            }
            case 1112152071: {
                n2 = 13;
                break;
            }
            case 1073877010: {
                n2 = 27;
                break;
            }
            case 1073877011: {
                n2 = 28;
                break;
            }
            case 135190: {
                n2 = 30;
                break;
            }
            case 135188: {
                n2 = 29;
                break;
            }
            case 1275203591: {
                n2 = 21;
                break;
            }
            case 1112152073: {
                n2 = 14;
                break;
            }
            case 1112152074: {
                n2 = 15;
                break;
            }
            case 1112152075: {
                n2 = 0;
                break;
            }
            case 1112152076: {
                n2 = 7;
                break;
            }
            case 1649022989: {
                n2 = 12;
                break;
            }
            case 659482: {
                n2 = 4;
                break;
            }
            case 1112152078: {
                n2 = 10;
                break;
            }
            case 1613369372: {
                n2 = 33;
                break;
            }
            case 135198: {
                n2 = 18;
                break;
            }
            case 659488: {
                n2 = 1;
                break;
            }
            default: {
                this.error(47);
            }
        }
        if (this.sm.getShape(n2) == null && this.slen == 2) {
            switch (this.st[1].tok) {
                case 12291: 
                case 1073742333: 
                case 1073742334: {
                    return;
                }
            }
        }
        switch (n) {
            case 1112152066: 
            case 1112152071: 
            case 1112152073: 
            case 1112152074: 
            case 1112152078: 
            case 1114249217: 
            case 1649022989: {
                this.setSizeBio(n2);
                return;
            }
            case 1112150019: 
            case 1112150021: {
                this.cmdDots(n2);
                return;
            }
            case 1112152070: 
            case 1112152075: 
            case 1112152076: {
                this.setSize(n2, n == 1112152070 ? -1000.0f : 1.0f);
                return;
            }
            case 1825200140: {
                this.cmdLabel(1);
                return;
            }
            case 135198: {
                this.cmdVector();
                return;
            }
            case 659488: {
                this.cmdWireframe();
                return;
            }
        }
        switch (n) {
            case 1611272194: {
                this.cmdAxes(1);
                return;
            }
            case 1678381065: {
                this.cmdBoundbox(1);
                return;
            }
            case 537022465: {
                this.cmdEcho(1);
                return;
            }
            case 1611272202: {
                this.cmdFrank(1);
                return;
            }
            case 1613369372: {
                this.cmdUnitcell(1);
                return;
            }
            case 659482: 
            case 0x20021010: 
            case 1112150020: 
            case 1275203591: 
            case 1745489933: {
                this.getCmdExt().dispatch(n2, false, this.st);
                return;
            }
            case 135174: 
            case 135175: 
            case 135176: 
            case 135180: 
            case 135182: 
            case 135188: 
            case 135190: 
            case 134353929: 
            case 1073877010: 
            case 1073877011: {
                this.getIsoExt().dispatch(n2, false, this.st);
                return;
            }
        }
    }

    private void cmdAnimation() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)1).tok) {
            case 1073742335: {
                bl = true;
            }
            case 1073742334: {
                if (this.chk) break;
                this.vwr.setAnimationOn(bl);
                break;
            }
            case 1073742030: {
                int n = (int)this.floatParameter(2);
                if (this.chk) break;
                this.vwr.am.setMorphCount(Math.abs(n));
                break;
            }
            case 1610625028: {
                this.iToken = 2;
                BS bS = this.tokAt(2) == 1073742327 ? null : this.atomExpressionAt(2);
                this.checkLength(this.iToken + 1);
                if (!this.chk) {
                    this.vwr.setAnimDisplay(bS);
                }
                return;
            }
            case 4115: {
                if (this.isArrayParameter(2)) {
                    this.setFrameSet(2);
                    break;
                }
                this.cmdModel(2);
                break;
            }
            case 1073742024: {
                float f = 1.0f;
                float f2 = 1.0f;
                if (this.slen > 5) {
                    this.bad();
                }
                int n = T.getTokFromName(this.paramAsStr(2));
                switch (n) {
                    case 1073742070: {
                        f2 = 0.0f;
                        f = 0.0f;
                        break;
                    }
                    case 528411: 
                    case 1073742082: {
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                if (this.slen >= 4) {
                    f = f2 = this.floatParameter(3);
                    if (this.slen == 5) {
                        f2 = this.floatParameter(4);
                    }
                }
                if (this.chk) break;
                this.vwr.am.setAnimationReplayMode(n, f, f2);
                break;
            }
            case 1073741918: {
                int n = 2;
                int n2 = 0;
                switch (this.tokAt(n)) {
                    case 0x100000A0: {
                        n2 = -this.intParameter(++n);
                        break;
                    }
                    case 0x100000A1: {
                        n2 = this.intParameter(++n);
                        break;
                    }
                    case 2: {
                        n2 = this.intParameter(n);
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                this.checkLength(++n);
                if (n2 != 1 && n2 != -1) {
                    this.errorStr2(35, "-1", "1");
                }
                if (this.chk) break;
                this.vwr.am.setAnimationDirection(n2);
                break;
            }
            case 1073741950: {
                this.setIntProperty("animationFps", this.intParameter(this.checkLast(2)));
                break;
            }
            default: {
                this.frameControl(1);
            }
        }
    }

    private void setFrameSet(int n) throws ScriptException {
        int[] nArray = this.expandFloatArray(this.floatParameterSet(n, 0, Integer.MAX_VALUE), 1);
        this.checkLength(this.iToken + 1);
        if (this.chk) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (nArray.length > 0) {
            hashtable.put("frames", nArray);
        }
        hashtable.put("currentFrame", 0);
        this.vwr.am.setMovie(hashtable);
    }

    private void cmdAxes(int n) throws ScriptException {
        TickInfo tickInfo = this.tickParamAsStr(n, true, true, false);
        n = this.iToken + 1;
        int n2 = this.tokAt(n);
        String string = this.optParameterAsString(n).toLowerCase();
        if (this.slen == n + 1 && PT.isOneOf(string, ";window;unitcell;molecular;")) {
            this.setBooleanProperty("axes" + string, true);
            return;
        }
        switch (n2) {
            case 12289: {
                P3 p3 = this.centerParameter(n + 1, null);
                this.setShapeProperty(34, "origin", p3);
                this.checkLast(this.iToken);
                return;
            }
            case 0x44000008: {
                String string2 = this.stringParameter(n + 1);
                if (!PT.isOneOf(string2, ";a;b;c;ab;ac;bc;abc;")) {
                    this.invArg();
                }
                this.setShapeProperty(34, "type", string2);
                this.checkLast(this.iToken);
                return;
            }
            case 1073742138: {
                this.setFloatProperty("axesScale", this.floatParameter(this.checkLast(++n)));
                return;
            }
            case 1825200140: {
                n2 = this.tokAt(n + 1);
                switch (n2) {
                    case 1073742334: 
                    case 1073742335: {
                        this.checkLength(n + 2);
                        this.setShapeProperty(34, "labels" + (n2 == 1073742335 ? "On" : "Off"), null);
                        return;
                    }
                }
                String string3 = null;
                switch (this.slen - n) {
                    case 7: {
                        this.setShapeProperty(34, "labels", new String[]{this.paramAsStr(++n), this.paramAsStr(++n), this.paramAsStr(++n), this.paramAsStr(++n), this.paramAsStr(++n), this.paramAsStr(++n)});
                        break;
                    }
                    case 5: {
                        string3 = this.paramAsStr(n + 4);
                    }
                    case 4: {
                        this.setShapeProperty(34, "labels", new String[]{this.paramAsStr(++n), this.paramAsStr(++n), this.paramAsStr(++n), string3});
                        break;
                    }
                    default: {
                        this.bad();
                    }
                }
                return;
            }
        }
        if (string.equals("position")) {
            P3 p3;
            if (this.tokAt(++n) == 1073742334) {
                p3 = new P3();
            } else {
                p3 = this.xypParameter(n);
                if (p3 == null) {
                    this.invArg();
                }
                n = this.iToken;
            }
            this.setShapeProperty(34, "position", p3);
            return;
        }
        int n3 = this.getSetAxesTypeMad(n);
        if (this.chk || n3 == Integer.MAX_VALUE) {
            return;
        }
        this.setObjectMad(34, "axes", n3);
        if (tickInfo != null) {
            this.setShapeProperty(34, "tickInfo", tickInfo);
        }
    }

    private void cmdBackground(int n) throws ScriptException {
        this.getToken(n);
        if (this.theTok == 4120) {
            Object object = null;
            switch (this.tokAt(++n)) {
                case 6: 
                case 15: {
                    object = this.getToken((int)n).value;
                    break;
                }
                default: {
                    String string = this.paramAsStr(this.checkLast(n));
                    if (this.chk) {
                        return;
                    }
                    if (string.equalsIgnoreCase("none") || string.length() == 0) {
                        this.vwr.setBackgroundImage(null, null);
                        return;
                    }
                    object = string.startsWith(";base64,") ? new BArray(Base64.decodeBase64(string)) : string;
                }
            }
            if (this.vwr.fm.loadImage(object, null, !this.useThreads())) {
                throw new ScriptInterruption(this, "backgroundImage", 1);
            }
            return;
        }
        if (this.theTok == 1073742333 || this.isColorParam(n)) {
            int n2 = this.getArgbParamLast(n, true);
            if (this.chk) {
                return;
            }
            this.setObjectArgb("background", n2);
            this.vwr.setBackgroundImage(null, null);
            return;
        }
        int n3 = this.getShapeType(this.theTok);
        this.colorShape(n3, n + 1, true);
    }

    private void cmdBind() throws ScriptException {
        String string = this.stringParameter(1);
        String string2 = this.paramAsStr(2);
        this.checkLength(3);
        if (!this.chk) {
            this.vwr.bindAction(string, string2);
        }
    }

    private void cmdBondorder() throws ScriptException {
        this.checkLength(-3);
        int n = 0;
        switch (this.getToken((int)1).tok) {
            case 2: 
            case 3: {
                n = Edge.getBondOrderFromFloat(this.floatParameter(1));
                if (n != 131071) break;
                this.invArg();
                break;
            }
            default: {
                n = ScriptEval.getBondOrderFromString(this.paramAsStr(1));
                if (n == 131071) {
                    this.invArg();
                }
                if (n != 33 || this.tokAt(2) != 3) break;
                n = ScriptEval.getPartialBondOrderFromFloatEncodedInt(this.st[2].intValue);
            }
        }
        this.setShapeProperty(1, "bondOrder", n);
    }

    private void cmdBoundbox(int n) throws ScriptException {
        boolean bl;
        TickInfo tickInfo = this.tickParamAsStr(n, false, true, false);
        n = this.iToken + 1;
        float f = 1.0f;
        if (this.tokAt(n) == 1073742138) {
            f = this.floatParameter(++n);
            if (!this.chk && f == 0.0f) {
                this.invArg();
            }
            if (++n == this.slen) {
                if (!this.chk) {
                    this.vwr.ms.setBoundBox(null, null, true, f);
                }
                return;
            }
        }
        boolean bl2 = bl = this.tokAt(n) == 0x4000004E;
        if (bl) {
            ++n;
        }
        if (this.isCenterParameter(n)) {
            Object[] objectArray = new Object[1];
            int n2 = n;
            P3 p3 = this.centerParameter(n, objectArray);
            n = this.iToken + 1;
            if (bl || this.isCenterParameter(n)) {
                P3 p32 = bl ? this.centerParameter(n, objectArray) : this.getPoint3f(n, true);
                n = this.iToken + 1;
                if (!this.chk) {
                    this.vwr.ms.setBoundBox(p3, p32, bl, f);
                }
            } else if (objectArray[0] != null && objectArray[0] instanceof BS) {
                if (!this.chk) {
                    this.vwr.calcBoundBoxDimensions((BS)objectArray[0], f);
                }
            } else if (objectArray[0] == null && this.tokAt(n2) == 1073742330) {
                P3[] p3Array;
                if (this.chk) {
                    return;
                }
                if ((p3Array = this.getObjectBoundingBox(this.objectNameParameter(++n2))) == null) {
                    this.invArg();
                }
                this.vwr.ms.setBoundBox(p3Array[0], p3Array[1], true, f);
                n = this.iToken + 1;
            } else {
                this.invArg();
            }
            if (n == this.slen) {
                return;
            }
        }
        int n3 = this.getSetAxesTypeMad(n);
        if (this.chk || n3 == Integer.MAX_VALUE) {
            return;
        }
        if (tickInfo != null) {
            this.setShapeProperty(32, "tickInfo", tickInfo);
        }
        this.setObjectMad(32, "boundbox", n3);
    }

    private void cmdCD() throws ScriptException {
        if (this.chk) {
            return;
        }
        String string = this.slen == 1 ? null : this.paramAsStr(1);
        this.showString(this.vwr.cd(string));
    }

    private void cmdCenter(int n) throws ScriptException {
        if (this.slen == 1) {
            this.vwr.setNewRotationCenter(null);
            return;
        }
        P3 p3 = this.centerParameter(n, null);
        if (p3 == null) {
            this.invArg();
        }
        if (!this.chk) {
            this.vwr.setNewRotationCenter(p3);
        }
    }

    private void cmdColor() throws ScriptException {
        int n = 1;
        if (this.isColorParam(1)) {
            this.theTok = 0x44000001;
        } else {
            int n2 = 0;
            n = 2;
            int n3 = this.getToken((int)1).tok;
            switch (n3) {
                case 1073742330: {
                    this.setObjectProperty();
                    return;
                }
                case 0x200002: 
                case 603979967: 
                case 1073741946: 
                case 1073741991: 
                case 1073742074: 
                case 1073742110: 
                case 1073742116: 
                case 0x40000140: 
                case 1073742186: 
                case 1073742333: 
                case 1086324739: 
                case 0x40C00004: 
                case 1086324742: 
                case 1086324746: 
                case 0x41400010: 
                case 0x41400011: 
                case 1094713362: 
                case 1111490574: 
                case 1111490575: 
                case 1111492619: 
                case 1111492620: 
                case 1112152075: 
                case 1113589786: 
                case 1631586315: 
                case 1639976963: 
                case 1648363544: 
                case 1715472409: {
                    this.theTok = 0x44000001;
                    n = 1;
                    break;
                }
                case 4: {
                    boolean bl;
                    n = 1;
                    String string = this.stringParameter(n++);
                    if (this.isArrayParameter(n)) {
                        string = string + "=" + SV.sValue(SV.getVariableAS(this.stringParameterSet(n))).replace('\n', ' ');
                        n = this.iToken + 1;
                    }
                    boolean bl2 = bl = this.tokAt(n) == 603979967;
                    if (!this.chk) {
                        this.vwr.setPropertyColorScheme(string, bl, true);
                    }
                    if (bl) {
                        ++n;
                    }
                    if (this.tokAt(n) == 1073742114 || this.tokAt(n) == 0x40000002) {
                        float f = this.floatParameter(++n);
                        float f2 = this.floatParameter(++n);
                        if (!this.chk) {
                            this.vwr.cm.setPropertyColorRange(f, f2);
                        }
                    }
                    return;
                }
                case 0x40000002: 
                case 1073742114: {
                    float f = this.floatParameter(2);
                    float f3 = this.floatParameter(this.checkLast(3));
                    if (!this.chk) {
                        this.vwr.cm.setPropertyColorRange(f, f3);
                    }
                    return;
                }
                case 1610616835: {
                    n2 = this.getArgbParamLast(2, true);
                    if (!this.chk) {
                        this.setObjectArgb("background", n2);
                    }
                    return;
                }
                case 10: 
                case 1073742325: {
                    n = -1;
                    this.theTok = 0x44000001;
                    break;
                }
                case 1073742134: {
                    n2 = this.getArgbParamLast(2, false);
                    if (!this.chk) {
                        this.vwr.cm.setRubberbandArgb(n2);
                    }
                    return;
                }
                case 0x20000008: 
                case 1611141171: {
                    n = 2;
                    if (this.tokAt(2) == 1073742074) {
                        ++n;
                    }
                    n2 = this.getArgbParamLast(n, true);
                    if (this.chk) {
                        return;
                    }
                    this.sm.loadShape(8);
                    this.setShapeProperty(8, n3 == 1611141171 ? "argbSelection" : "argbHighlight", n2);
                    return;
                }
                case 0x40000000: 
                case 1611272194: 
                case 1612709900: 
                case 1613369372: 
                case 1678381065: {
                    String string = this.paramAsStr(1);
                    if (this.checkToken(2)) {
                        n2 = this.getToken((int)2).tok;
                        switch (n2) {
                            case 1073742333: {
                                n2 = 1073741991;
                                break;
                            }
                            case 1073741991: 
                            case 1073742110: 
                            case 1073742116: {
                                break;
                            }
                            default: {
                                n2 = this.getArgbParam(2);
                            }
                        }
                    }
                    if (n2 == 0) {
                        this.error(9);
                    }
                    this.checkLast(this.iToken);
                    if (string.equalsIgnoreCase("axes") || StateManager.getObjectIdFromName(string) >= 0) {
                        this.setObjectArgb(string, n2);
                        return;
                    }
                    if (this.setElementColor(string, n2)) {
                        return;
                    }
                    this.invArg();
                    break;
                }
                case 135180: 
                case 134353929: {
                    this.setShapeProperty(JC.shapeTokenIndex(n3), "thisID", "+PREVIOUS_MESH+");
                }
            }
        }
        this.colorShape(this.getShapeType(this.theTok), n, false);
    }

    private void cmdDefine() throws ScriptException {
        boolean bl;
        String string;
        if (this.slen < 3 || !(this.getToken((int)1).value instanceof String)) {
            this.invArg();
        }
        if (PT.parseInt(string = ((String)this.getToken((int)1).value).toLowerCase()) != Integer.MIN_VALUE) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        boolean bl2 = string.startsWith("site_");
        boolean bl3 = bl = string.indexOf("dynamic_") == 0;
        if (bl || bl2) {
            T[] tArray = new T[this.slen];
            int n = this.slen;
            while (--n >= 0) {
                tArray[n] = this.st[n];
            }
            this.vwr.definedAtomSets.put("!" + (bl2 ? string : string.substring(8)), tArray);
        } else {
            BS bS = this.atomExpressionAt(2);
            this.vwr.definedAtomSets.put(string, bS);
            if (!this.chk) {
                this.vwr.g.setUserVariable("@" + string, SV.newV(10, bS));
            }
        }
    }

    private void cmdDelay() throws ScriptException {
        int n = 0;
        switch (this.getToken((int)1).tok) {
            case 1073742335: {
                n = 1;
                break;
            }
            case 2: {
                n = this.intParameter(1) * 1000;
                break;
            }
            case 3: {
                n = (int)(this.floatParameter(1) * 1000.0f);
                break;
            }
            default: {
                this.error(34);
            }
        }
        this.refresh(false);
        this.doDelay(Math.abs(n));
    }

    private void cmdDelete() throws ScriptException {
        BS bS;
        if (this.tokAt(1) == 1073742330) {
            if (this.slen == 4 && this.optParameterAsString(2).equals("saved") && this.slen == 4) {
                this.vwr.stm.deleteSaved(this.optParameterAsString(3));
                if (this.doReport()) {
                    this.report(GT.o(GT._("show saved: {0}"), this.vwr.stm.listSavedStates()));
                }
                return;
            }
            this.setObjectProperty();
            return;
        }
        BS bS2 = bS = this.slen == 1 ? null : this.atomExpression(this.st, 1, 0, true, false, null, false);
        if (this.chk) {
            return;
        }
        if (bS == null) {
            bS = this.vwr.getAllAtoms();
        }
        int n = this.vwr.deleteAtoms(bS, false);
        if (this.doReport()) {
            this.report(GT.i(GT._("{0} atoms deleted"), n));
        }
    }

    private void cmdDisplay(boolean bl) throws ScriptException {
        boolean bl2;
        BS bS = null;
        int n = 0;
        int n2 = 1;
        int n3 = this.tokAt(1);
        switch (n3) {
            case 1073742119: 
            case 1275069441: {
                n = n3;
                n3 = this.tokAt(++n2);
            }
        }
        boolean bl3 = bl2 = n3 == 1086324742;
        if (bl2) {
            n3 = this.tokAt(++n2);
        }
        switch (n3) {
            case 1073742330: {
                this.setObjectProperty();
                return;
            }
            case 0: {
                break;
            }
            default: {
                bS = this.slen == 4 && this.tokAt(2) == 1677721602 ? BondSet.newBS(BSUtil.newBitSet2(0, this.vwr.ms.bondCount), null) : this.atomExpressionAt(n2);
            }
        }
        if (this.chk) {
            return;
        }
        if (bS instanceof BondSet) {
            this.vwr.ms.displayBonds((BondSet)bS, bl);
            return;
        }
        this.vwr.displayAtoms(bS, bl, bl2, n, this.tQuiet);
    }

    private void cmdDots(int n) throws ScriptException {
        RadiusData radiusData;
        if (!this.chk) {
            this.sm.loadShape(n);
        }
        this.setShapeProperty(n, "init", null);
        float f = Float.NaN;
        RadiusData.EnumType enumType = RadiusData.EnumType.ABSOLUTE;
        int n2 = 1;
        block7: while (true) {
            switch (this.getToken((int)n2).tok) {
                case 1073742072: {
                    this.restrictSelected(false, false);
                }
                case 1073742335: {
                    f = 1.0f;
                    enumType = RadiusData.EnumType.FACTOR;
                    break block7;
                }
                case 1073742334: {
                    f = 0.0f;
                    break block7;
                }
                case 1073741976: {
                    this.setShapeProperty(n, "ignore", this.atomExpressionAt(n2 + 1));
                    n2 = this.iToken + 1;
                    continue block7;
                }
                case 2: {
                    int n3 = this.intParameter(n2);
                    if (this.tokAt(n2 + 1) != 1665140738) break block7;
                    ++n2;
                    this.setShapeProperty(n, "atom", n3);
                    this.setShapeProperty(n, "radius", Float.valueOf(this.floatParameter(++n2)));
                    if (this.tokAt(++n2) == 1765808132) {
                        this.setShapeProperty(n, "colorRGB", this.getArgbParam(++n2));
                        ++n2;
                    }
                    if (this.getToken((int)n2).tok != 10) {
                        this.invArg();
                    }
                    this.setShapeProperty(n, "dots", this.st[n2].value);
                    return;
                }
            }
            break;
        }
        RadiusData radiusData2 = radiusData = Float.isNaN(f) ? this.encodeRadiusParameter(n2, false, true) : new RadiusData(null, f, enumType, VDW.AUTO);
        if (radiusData == null) {
            return;
        }
        if (Float.isNaN(radiusData.value)) {
            this.invArg();
        }
        this.setShapeSize(n, radiusData);
    }

    private void cmdEcho(int n) throws ScriptException {
        if (this.chk) {
            return;
        }
        String string = this.optParameterAsString(n);
        boolean bl = true;
        if (this.vwr.ms.getEchoStateActive()) {
            if (string.startsWith("\u0001")) {
                string = string.substring(1);
                bl = false;
            }
            if (string != null) {
                this.setShapeProperty(31, "text", string);
            }
        }
        if (bl && this.vwr.getRefreshing()) {
            this.showString(Txt.formatText(this.vwr, string));
        }
    }

    private void cmdFile() throws ScriptException {
        int n = this.intParameter(this.checkLast(1));
        if (this.chk) {
            return;
        }
        int n2 = this.vwr.ms.getModelNumberIndex(n * 1000000 + 1, false, false);
        int n3 = -1;
        if (n2 >= 0) {
            n3 = this.vwr.ms.getModelNumberIndex((n + 1) * 1000000 + 1, false, false);
            if (n3 < 0) {
                n3 = this.vwr.ms.mc;
            }
            --n3;
        }
        this.vwr.setAnimationOn(false);
        this.vwr.am.setAnimationDirection(1);
        this.vwr.setAnimationRange(n2, n3);
        this.vwr.setCurrentModelIndex(-1);
    }

    private void cmdFixed() throws ScriptException {
        BS bS;
        BS bS2 = bS = this.slen == 1 ? null : this.atomExpressionAt(1);
        if (this.chk) {
            return;
        }
        this.vwr.setMotionFixedAtoms(bS);
    }

    private boolean cmdFor(int n, boolean bl) throws ScriptException {
        ContextToken contextToken = (ContextToken)this.theToken;
        int n2 = this.st[0].intValue;
        SV[] sVArray = contextToken.forVars;
        n2 = this.st[0].intValue;
        int[] nArray = new int[2];
        Object object = null;
        SV sV = null;
        SV sV2 = null;
        int n3 = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        int n4 = 0;
        String string = null;
        if (bl && sVArray != null) {
            n = 1275068417;
            sV2 = sVArray[0];
            sV = sVArray[1];
            object = sVArray[1].value;
            n4 = ++sV.intValue;
            if (sV.tok == 2) {
                bl3 = n4 < 0;
                int n5 = ((int[])object)[0];
                int n6 = ((int[])object)[1];
                boolean bl4 = n5 != n6 && n6 < n5 == bl3 ? true : (bl2 = false);
                if (bl2) {
                    int n7 = n5 + (bl3 ? -1 : 1);
                    ((int[])object)[0] = n7;
                    sV2.intValue = n7;
                }
                n4 = -1;
            } else if (sV.tok == 7) {
                boolean bl5 = bl2 = n4 <= ((Lst)object).size();
                if (bl2) {
                    sV2.setv(SV.selectItemVar(sV));
                }
                n4 = -1;
            } else {
                this.isBondSet = object instanceof BondSet;
                bl2 = (n4 = ((BS)object).nextSetBit(n4)) >= 0;
            }
        } else {
            int n8;
            boolean bl6 = false;
            int n9 = 0;
            block11: for (n8 = 1; n8 < this.slen && n4 < 2; ++n8) {
                n = this.tokAt(n8);
                switch (n) {
                    case 36868: {
                        bl6 = true;
                        continue block11;
                    }
                    case 1073742339: {
                        if (n9 > 0) {
                            --n9;
                            continue block11;
                        }
                        nArray[n4++] = n8;
                        continue block11;
                    }
                    case 0x40000080: 
                    case 1275068417: {
                        string = this.paramAsStr(n8 - 1);
                        n9 -= 2;
                        if (this.tokAt(++n8) == 1073742325 || this.tokAt(n8) == 10) {
                            n3 = 10;
                            object = this.atomExpressionAt(n8);
                            if (this.isBondSet) {
                                object = BondSet.newBS((BS)object, null);
                            }
                            bl2 = ((BS)object).nextSetBit(0) >= 0;
                        } else {
                            Lst<SV> lst = this.parameterExpressionList(-n8, 1, false);
                            if (lst == null || lst.size() < 1) {
                                this.invArg();
                            }
                            SV sV3 = (SV)lst.get(0);
                            n3 = sV3.tok;
                            switch (n3) {
                                case 10: {
                                    object = SV.getBitSet(sV3, false);
                                    bl2 = ((BS)object).nextSetBit(0) >= 0;
                                    break;
                                }
                                case 7: {
                                    Object object2;
                                    Object[] objectArray = sV3.getList();
                                    n4 = objectArray.size();
                                    boolean bl7 = bl2 = n4 > 0;
                                    if (bl2 && n == 0x40000080) {
                                        object2 = new int[]{SV.iValue((T)objectArray.get(0)), SV.iValue((T)objectArray.get(n4 - 1))};
                                        bl3 = object2[1] < object2[0];
                                        object = object2;
                                        n = 1275068417;
                                        n3 = 2;
                                        break;
                                    }
                                    object = objectArray;
                                    break;
                                }
                                case 6: {
                                    Object object2 = sV3.getMap();
                                    int n10 = object2.keySet().size();
                                    boolean bl8 = bl2 = n10 > 0;
                                    if (!bl2) break;
                                    Object[] objectArray = new String[n10];
                                    object2.keySet().toArray(objectArray);
                                    Arrays.sort(objectArray);
                                    object = objectArray;
                                    break;
                                }
                                default: {
                                    this.invArg();
                                }
                            }
                        }
                        n8 = this.iToken;
                        continue block11;
                    }
                    case 1275082245: {
                        n9 += 2;
                    }
                }
            }
            if (!bl) {
                this.pushContext(contextToken, "FOR");
                this.thisContext.forVars = sVArray;
                sVArray = null;
            }
            if (string == null) {
                n4 = bl ? (object == null ? nArray[1] + 1 : 2) : 2;
                if (this.tokAt(n4) == 36868) {
                    ++n4;
                }
                boolean bl9 = bl3 = (string = this.paramAsStr(n4)).equals("--") || string.equals("++");
                if (bl3) {
                    string = this.paramAsStr(++n4);
                }
            }
            if (bl2) {
                if (n == 1275068417) {
                    sV2 = this.getContextVariableAsVariable(string, bl6);
                    if (sV2 == null && !bl6) {
                        sV2 = this.vwr.g.getAndSetNewVariable(string, false);
                    }
                    if (sV2 == null || sV2.myName == null) {
                        if (string.startsWith("_")) {
                            this.invArg();
                        }
                        if (bl6) {
                            sV2 = SV.newI(0);
                            this.contextVariables.put(string.toLowerCase(), sV2);
                        } else {
                            sV2 = this.vwr.g.getAndSetNewVariable(string, true);
                        }
                    }
                    if (n3 == 2) {
                        sV2.tok = 2;
                        sV2.intValue = ((int[])object)[0];
                        sV = SV.newV(2, object);
                        sV.intValue = bl3 ? Integer.MIN_VALUE : 0;
                        n4 = -1;
                    } else {
                        sV = SV.getVariable(object);
                        if (n3 == 10) {
                            n4 = ((BS)object).nextSetBit(0);
                        } else {
                            sV.intValue = 1;
                            sV2.setv(SV.selectItemVar(sV));
                            n4 = -1;
                        }
                    }
                    if (sVArray == null) {
                        sVArray = contextToken.forVars = new SV[2];
                    }
                    sVArray[0] = sV2;
                    sVArray[1] = sV;
                } else {
                    n8 = this.tokAt(n4);
                    if (n8 != 1073742339 && (T.tokAttr(n8, 0x40000000) || (sV = this.getContextVariableAsVariable(string, false)) != null)) {
                        if (!bl3 && this.getToken((int)(++n4)).tok != 268435860) {
                            this.invArg();
                        }
                        if (bl3) {
                            n4 -= 2;
                        }
                        this.setVariable(++n4, this.slen - 1, string, false);
                    }
                    boolean bl10 = bl2 = nArray[0] + 1 == nArray[1] || this.parameterExpressionBoolean(nArray[0] + 1, nArray[1]);
                }
            }
        }
        if (bl2 && n == 1275068417 && n4 >= 0) {
            sV.intValue = n4;
            sV2.tok = 10;
            if (this.isBondSet) {
                sV2.value = new BondSet();
                ((BondSet)sV2.value).set(n4);
            } else {
                sV2.value = BSUtil.newAndSetBit(n4);
            }
        }
        ++n2;
        if (!bl2) {
            contextToken.forVars = this.thisContext.forVars;
            this.popContext(true, false);
        }
        bl = false;
        if (!bl2 && !this.chk) {
            this.pc = Math.abs(n2) - 1;
        }
        return bl;
    }

    private boolean cmdFlow(int n, boolean bl, Lst<T[]> lst) throws ScriptException {
        boolean bl2;
        int n2;
        block35: {
            n2 = this.st[0].intValue;
            boolean bl3 = n2 < 0 && !this.chk;
            bl2 = true;
            int n3 = 0;
            block0 : switch (n) {
                case 102436: 
                case 134320137: {
                    this.cmdFunc();
                    return bl;
                }
                case 364558: {
                    return bl;
                }
                case 102412: {
                    ContextToken contextToken = (ContextToken)this.theToken;
                    this.pushContext(contextToken, "CATCH");
                    if (!bl3 && contextToken.name0 != null) {
                        this.contextVariables.put(contextToken.name0, contextToken.contextVariables.get(contextToken.name0));
                    }
                    bl2 = !bl3;
                    this.st[0].intValue = -Math.abs(n2);
                    break;
                }
                case 102410: 
                case 102411: 
                case 102413: {
                    n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                    switch (bl3 ? 0 : this.cmdFlowSwitch((ContextToken)this.theToken, n)) {
                        case 0: {
                            n3 = -n3;
                            bl2 = false;
                            break;
                        }
                        case -1: {
                            bl2 = false;
                            break;
                        }
                    }
                    this.aatoken[this.pc][0].intValue = Math.abs(n2);
                    this.theToken = this.aatoken[Math.abs(n2)][0];
                    if (this.theToken.tok == 102409) break;
                    this.theToken.intValue = n3;
                    break;
                }
                case 102402: 
                case 134320649: {
                    boolean bl4 = bl2 = !bl3 && this.parameterExpressionBoolean(1, 0);
                    if (this.chk) break;
                    n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                    this.aatoken[Math.abs((int)n2)][0].intValue = n3 = bl3 || bl2 ? -n3 : n3;
                    if (n != 102412) break;
                    this.aatoken[this.pc][0].intValue = -n2;
                    break;
                }
                case 364547: {
                    this.checkLength(1);
                    if (n2 >= 0 || this.chk) break;
                    this.pc = -n2 - 1;
                    break;
                }
                case 364548: {
                    this.checkLength(1);
                    break;
                }
                case 102406: {
                    if (!bl) {
                        this.pushContext((ContextToken)this.theToken, "WHILE");
                    }
                    bl = false;
                    if (this.parameterExpressionBoolean(1, 0) || this.chk) break;
                    this.pc = n2;
                    this.popContext(true, false);
                    break;
                }
                case 102407: {
                    if (!this.chk) {
                        this.breakAt(n2);
                        break;
                    }
                    if (this.slen == 1) break;
                    int n4 = this.intParameter(this.checkLast(1));
                    if (this.chk) break;
                    for (int i = 0; i < n4; ++i) {
                        this.popContext(true, false);
                    }
                    break;
                }
                case 102408: {
                    bl = true;
                    if (!this.chk) {
                        this.pc = n2 - 1;
                    }
                    if (this.slen <= 1) break;
                    this.intParameter(this.checkLast(1));
                    break;
                }
                case 102409: {
                    switch (this.getToken((int)this.checkLast((int)1)).tok) {
                        case 364558: {
                            ScriptFunction scriptFunction = (ScriptFunction)this.getToken((int)1).value;
                            if (this.chk) {
                                return false;
                            }
                            this.runFunctionAndRet(scriptFunction, "try", null, null, true, true, true);
                            return false;
                        }
                        case 102436: 
                        case 134320137: {
                            this.vwr.addFunction((ScriptFunction)this.theToken.value);
                            return bl;
                        }
                        case 102412: {
                            this.popContext(true, false);
                            break block0;
                        }
                        case 102439: {
                            this.addProcess(lst, n2, this.pc);
                            this.popContext(true, false);
                            break block0;
                        }
                        case 102410: {
                            if (n2 > 0 && this.cmdFlowSwitch((ContextToken)this.aatoken[n2][0], 0) == -1) {
                                while (n2 < this.pc && ((n = this.aatoken[n2][0].tok) == 102413 || n == 102411)) {
                                    ++n2;
                                }
                                bl2 = this.pc == n2;
                                break block0;
                            }
                            break block35;
                        }
                        case 134320649: {
                            break block0;
                        }
                        case 102406: 
                        case 134320648: {
                            bl2 = false;
                            bl = true;
                        }
                    }
                }
            }
        }
        if (!bl2 && !this.chk) {
            this.pc = Math.abs(n2) - 1;
        }
        return bl;
    }

    private int cmdFlowSwitch(ContextToken contextToken, int n) throws ScriptException {
        SV sV;
        if (n == 102410) {
            contextToken.addName("_var");
        }
        if ((sV = contextToken.contextVariables.get("_var")) == null) {
            return 1;
        }
        if (n == 0) {
            contextToken.contextVariables.remove("_var");
            return -1;
        }
        if (n == 102413) {
            return -1;
        }
        SV sV2 = this.parameterExpressionToken(1);
        if (n == 102411) {
            boolean bl = SV.areEqual(sV, sV2);
            if (bl) {
                contextToken.contextVariables.remove("_var");
            }
            return bl ? 1 : -1;
        }
        contextToken.contextVariables.put("_var", sV2);
        return 1;
    }

    private void cmdFont(int n, float f) throws ScriptException {
        String string = "SansSerif";
        String string2 = "Plain";
        int n2 = 0;
        float f2 = -1.0f;
        this.iToken = this.slen;
        switch (this.iToken) {
            case 6: {
                f2 = this.floatParameter(5);
                if (f2 >= 5.0f) {
                    f2 = this.vwr.tm.getZoomSetting() / f2 / this.vwr.getScalePixelsPerAngstrom(false);
                }
            }
            case 5: {
                if (this.getToken((int)4).tok != 0x40000000) {
                    this.invArg();
                }
                string2 = this.paramAsStr(4);
            }
            case 4: {
                if (this.getToken((int)3).tok != 0x40000000) {
                    this.invArg();
                }
                string = this.paramAsStr(3);
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                f = this.floatParameter(2);
                n = this.getShapeType(this.getToken((int)1).tok);
                break;
            }
            case 3: {
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                if (n == -1) {
                    n = this.getShapeType(this.getToken((int)1).tok);
                    f = this.floatParameter(2);
                    break;
                }
                if (!(f >= 1.0f)) break;
                n2 = 5;
                f += (float)5;
                break;
            }
            default: {
                if (n == 5) {
                    f = 13.0f;
                    break;
                }
                this.bad();
            }
        }
        if (n == 5) {
            if (f < 0.0f || f >= 1.0f && (f < 6.0f || f > 63.0f)) {
                this.integerOutOfRange(6 - n2, 63 - n2);
                return;
            }
            this.setShapeProperty(5, "setDefaults", this.vwr.slm.noneSelected);
        }
        if (this.chk) {
            return;
        }
        if (Font.getFontStyleID(string) >= 0) {
            string2 = string;
            string = "SansSerif";
        }
        Font font = this.vwr.getFont3D(string, string2, f);
        this.sm.loadShape(n);
        this.setShapeProperty(n, "font", font);
        if (f2 >= 0.0f) {
            this.setShapeProperty(n, "scalereference", Float.valueOf(f2));
        }
    }

    private void cmdFrank(int n) throws ScriptException {
        boolean bl = true;
        if (this.slen > n) {
            switch (this.getToken((int)this.checkLast((int)n)).tok) {
                case 1073742335: {
                    break;
                }
                case 1073742334: {
                    bl = false;
                    break;
                }
                default: {
                    this.error(5);
                }
            }
        }
        this.setBooleanProperty("frank", bl);
    }

    private void cmdFunc() throws ScriptException {
        Lst<SV> lst;
        if (this.chk && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        String string = ((String)this.getToken((int)0).value).toLowerCase();
        if (!this.vwr.isFunction(string)) {
            this.error(10);
        }
        Lst<SV> lst2 = lst = this.slen == 1 || this.slen == 3 && this.tokAt(1) == 0x10000010 && this.tokAt(2) == 0x10000011 ? null : this.parameterExpressionList(1, -1, false);
        if (this.chk) {
            return;
        }
        this.runFunctionAndRet(null, string, lst, null, false, true, true);
    }

    private void cmdGetProperty() throws ScriptException {
        if (this.chk) {
            return;
        }
        String string = "";
        String string2 = this.optParameterAsString(1);
        String string3 = string2;
        if (string3.indexOf(".") >= 0) {
            string3 = string3.substring(0, string3.indexOf("."));
        }
        if (string3.indexOf("[") >= 0) {
            string3 = string3.substring(0, string3.indexOf("["));
        }
        int n = this.vwr.getPropertyNumber(string3);
        Object object = "";
        switch (this.tokAt(2)) {
            default: {
                object = this.optParameterAsString(2);
                break;
            }
            case 10: 
            case 1073742325: {
                object = this.atomExpressionAt(2);
                if (!string2.equalsIgnoreCase("bondInfo")) break;
                switch (this.tokAt(++this.iToken)) {
                    case 10: 
                    case 1073742325: {
                        object = new BS[]{(BS)object, this.atomExpressionAt(this.iToken)};
                    }
                }
            }
        }
        if (string2.length() > 0 && n < 0) {
            string2 = "";
            object = "";
        } else if (n >= 0 && this.slen < 3) {
            object = this.vwr.getDefaultPropertyParam(n);
            if (object.equals("(visible)")) {
                object = this.vwr.ms.getVisibleSet(true);
            }
        } else if (n == this.vwr.getPropertyNumber("fileContents")) {
            String string4 = object.toString();
            for (int i = 3; i < this.slen; ++i) {
                string4 = string4 + this.paramAsStr(i);
            }
            object = string4;
        }
        string = (String)this.vwr.getProperty("readable", string2, object);
        this.showString(string);
    }

    private void cmdGoto(boolean bl) throws ScriptException {
        int n;
        int n2;
        String string = bl ? this.paramAsStr(this.checkLast(1)) : null;
        int n3 = string == null ? this.aatoken.length - 1 : -1;
        String string2 = null;
        block11: for (n2 = n3 + 1; n2 < this.aatoken.length; ++n2) {
            T[] tArray = this.aatoken[n2];
            n = tArray[0].tok;
            switch (n) {
                case 0: 
                case 20485: {
                    string2 = (String)tArray[tArray.length - 1].value;
                    if (n != 0) break;
                    string2 = string2.substring(string2.startsWith("#") ? 1 : 2);
                    break;
                }
                default: {
                    continue block11;
                }
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            n3 = n2;
            break;
        }
        if (n3 < 0) {
            this.invArg();
        }
        if (string == null) {
            n3 = 0;
        }
        n2 = n3 < this.pc ? 1 : -1;
        int n4 = 0;
        block12: for (n = n3; n != this.pc; n += n2) {
            switch (this.aatoken[n][0].tok) {
                case 102406: 
                case 102412: 
                case 102439: 
                case 134320648: 
                case 1275335685: {
                    ++n4;
                    continue block12;
                }
                case 1275334673: {
                    --n4;
                    continue block12;
                }
                case 102409: {
                    switch (this.aatoken[n][1].tok) {
                        case 102406: 
                        case 102412: 
                        case 102439: 
                        case 134320648: {
                            --n4;
                        }
                    }
                }
            }
        }
        if (string == null) {
            n3 = Integer.MAX_VALUE;
            while (n4 > 0) {
                this.popContext(false, false);
                --n4;
            }
        }
        if (n4 != 0) {
            this.invArg();
        }
        if (!this.chk) {
            this.pc = n3 - 1;
        }
    }

    private void cmdHbond() throws ScriptException {
        if (this.slen == 2 && this.getToken((int)1).tok == 4102) {
            if (this.chk) {
                return;
            }
            int n = this.vwr.autoHbond(null, null, false);
            this.report(GT.i(GT._("{0} hydrogen bonds"), Math.abs(n)));
            return;
        }
        if (this.slen == 2 && this.getToken((int)1).tok == 12291) {
            if (this.chk) {
                return;
            }
            this.checkExtension(1613238294);
            return;
        }
        int n = this.getMadParameter();
        if (n == Integer.MAX_VALUE) {
            return;
        }
        this.setShapeProperty(1, "type", 30720);
        this.setShapeSizeBs(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void cmdHelp() throws ScriptException {
        if (this.chk) {
            return;
        }
        String string = this.optParameterAsString(1).toLowerCase();
        int n = 0;
        if (string.startsWith("mouse") && (n = string.indexOf(" ")) >= 0 && n == string.lastIndexOf(" ")) {
            this.showString(this.vwr.getBindingInfo(string.substring(n + 1)));
            return;
        }
        if (T.tokAttr(T.getTokFromName(string), 4096)) {
            string = "?command=" + string;
        }
        this.vwr.getHelp(string);
    }

    private void cmdHistory(int n) throws ScriptException {
        if (this.slen == 1) {
            this.showString(this.vwr.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (n == 2) {
            int n2 = this.intParameter(this.checkLast(2));
            if (n2 < 0) {
                this.invArg();
            }
            if (!this.chk) {
                this.vwr.getSetHistory(n2 == 0 ? 0 : -2 - n2);
            }
            return;
        }
        switch (this.getToken((int)this.checkLast((int)1)).tok) {
            case 1073741882: 
            case 1073742335: {
                if (!this.chk) {
                    this.vwr.getSetHistory(Integer.MIN_VALUE);
                }
                return;
            }
            case 1073742334: {
                if (this.chk) break;
                this.vwr.getSetHistory(0);
                break;
            }
            default: {
                this.errorStr(24, "ON, OFF, CLEAR");
            }
        }
    }

    private void cmdHover() throws ScriptException {
        String string;
        if (this.chk) {
            return;
        }
        String string2 = string = this.slen == 1 ? "on" : this.paramAsStr(1);
        if (string.equalsIgnoreCase("on")) {
            string = "%U";
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.vwr.setHoverLabel(string);
    }

    private void cmdInvertSelected() throws ScriptException {
        P3 p3 = null;
        P4 p4 = null;
        BS bS = null;
        int n = Integer.MIN_VALUE;
        switch (this.tokAt(1)) {
            case 0: {
                if (this.chk) {
                    return;
                }
                bS = this.vwr.bsA();
                p3 = this.vwr.ms.getAtomSetCenter(bS);
                this.vwr.invertAtomCoordPt(p3, bS);
                return;
            }
            case 528443: {
                n = this.atomExpressionAt(2).nextSetBit(0);
                bS = this.atomExpressionAt(this.iToken + 1);
                break;
            }
            case 0x8000010: {
                p3 = this.centerParameter(2, null);
                break;
            }
            case 0x800000F: {
                p4 = this.planeParameter(1);
                break;
            }
            case 134219265: {
                p4 = this.hklParameter(2);
            }
        }
        this.checkLengthErrorPt(this.iToken + 1, 1);
        if (p4 == null && p3 == null && n == Integer.MIN_VALUE) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        if (n == -1) {
            return;
        }
        this.vwr.invertSelected(p3, p4, n, bS);
    }

    private void cmdLabel(int n) throws ScriptException {
        if (this.chk) {
            return;
        }
        this.sm.loadShape(5);
        Object object = null;
        switch (this.getToken((int)n).tok) {
            case 1073742335: {
                object = this.vwr.getStandardLabelFormat(0);
                break;
            }
            case 1073742334: {
                break;
            }
            case 12294: 
            case 1610625028: {
                this.setShapeProperty(5, "display", this.theTok == 1610625028 ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            case 7: {
                object = this.theToken.value;
                break;
            }
            default: {
                object = this.paramAsStr(n);
            }
        }
        this.sm.setLabel(object, this.vwr.bsA());
    }

    public void cmdLoad() throws ScriptException {
        Object object;
        Object object2;
        String string;
        int n;
        boolean bl = !this.chk || this.isCmdLine_C_Option;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = this.vwr.async;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = this.vwr.getBoolean(603979792);
        String string2 = null;
        int n2 = this.tokAt(0) == 0x8001008 ? 0 : 1;
        String string3 = null;
        int n3 = this.vwr.ms.mc - (this.vwr.fm.getFileName().equals("zapped") ? 1 : 0);
        int n4 = this.vwr.ms.ac;
        SB sB = new SB().append("load");
        int n5 = 1;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.isStateScript) {
            hashtable.put("isStateScript", Boolean.TRUE);
            if (this.forceNoAddHydrogens) {
                hashtable.put("doNotAddHydrogens", Boolean.TRUE);
            }
        }
        String string4 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string5 = null;
        SB sB2 = new SB();
        int n6 = 0;
        if (this.slen == 1) {
            n2 = 0;
        } else {
            Object object3;
            string4 = this.paramAsStr(n2);
            if (this.slen == 2 && !this.chk && (string4.endsWith(".spt") || string4.endsWith(".png") || string4.endsWith(".pngj"))) {
                this.cmdScript(0, string4, null);
                return;
            }
            n = this.tokAt(n2);
            switch (n) {
                case 36868: {
                    object3 = this.paramAsStr(++n2);
                    string2 = "@" + (String)object3;
                    Object object4 = this.getVarParameter((String)object3, false);
                    if (!(object4 instanceof Map)) break;
                    this.checkLength(3);
                    this.loadPNGJVar(string2, object4, hashtable);
                    return;
                }
                case 1073742015: 
                case 1073877011: 
                case 1610616855: {
                    String string6 = this.paramAsStr(this.checkLast(2));
                    if (!this.chk) {
                        switch (n) {
                            case 1073877011: {
                                hashtable.put("service", "nbo");
                                hashtable.put("mode", 1);
                                hashtable.put("action", "load");
                                hashtable.put("value", string6);
                                hashtable.put("sync", Boolean.TRUE);
                                this.vwr.sm.processService(hashtable);
                                this.runScript((String)hashtable.get("ret"));
                                break;
                            }
                            case 1610616855: {
                                this.vwr.setHistory(string6);
                                break;
                            }
                            case 1073742015: {
                                this.vwr.setMenu(string6, true);
                            }
                        }
                    }
                    return;
                }
                case 0x8001008: {
                    bl6 = true;
                    sB.append(" /*data*/ data");
                    string = this.stringParameter(++n2).toLowerCase();
                    int n7 = string.indexOf("@");
                    if (n7 >= 0) {
                        string = string.replace('@', '_');
                    }
                    sB.append(" ").append(PT.esc(string));
                    bl2 = string.startsWith("append");
                    bl9 = string.indexOf("orientation") >= 0;
                    object2 = n7 >= 0 ? "" + this.getParameter(string.substring(n7 + 1), 4, true) : this.paramAsStr(++n2);
                    object2 = Viewer.fixInlineString((String)object2, this.vwr.getInlineChar());
                    hashtable.put("fileData", object2);
                    hashtable.put("isData", Boolean.TRUE);
                    sB.appendC('\n').append((String)object2).append(" end ").append(PT.esc(string));
                    if (n7 >= 0) break;
                    n2 += 2;
                    break;
                }
                case 4130: {
                    bl2 = true;
                    bl5 = true;
                    bl10 = false;
                    sB.append(" mutate");
                    string4 = this.optParameterAsString(++n2);
                    n = T.getTokFromName(string4);
                    break;
                }
                case 0x4000000F: {
                    bl2 = true;
                    sB.append(" append");
                    string4 = this.optParameterAsString(++n2);
                    n = T.getTokFromName(string4);
                    break;
                }
                case 1073742077: {
                    bl9 = true;
                    sB.append(" orientation");
                    this.vwr.stm.saveOrientation("preload", null);
                    string4 = this.optParameterAsString(++n2);
                    n = T.getTokFromName(string4);
                    break;
                }
                case 0x40000000: {
                    ++n2;
                    sB.append(" " + string4);
                    int n8 = n6 = n == 0x40000000 && PT.isOneOf(string4.toLowerCase(), ";xyz;vxyz;vibration;temperature;occupancy;partialcharge;") ? T.getTokFromName(string4) : 0;
                    if (n6 == 0) break;
                    hashtable.put("atomDataOnly", Boolean.TRUE);
                    hashtable.put("modelNumber", 1);
                    if (n6 == 4166) {
                        n6 = 1145047055;
                    }
                    stringArray2 = this.vwr.fm.getFileInfo();
                    bl2 = true;
                }
            }
            block14 : switch (n) {
                case 1228935687: {
                    sB.append(" " + string4);
                    if (this.optParameterAsString(++n2).equals("+")) {
                        bl8 = true;
                        ++n2;
                        sB.append(" +");
                    }
                    if (this.tokAt(n2) != 7) break;
                    stringArray = this.stringParameterSet(n2);
                    n2 = this.iToken;
                    if (n2 + 1 != this.slen) {
                        this.invArg();
                    }
                    if (stringArray == null) break;
                    n5 = stringArray.length;
                    break;
                }
                case 1073741983: {
                    bl3 = true;
                    ++n2;
                    sB.append(" " + string4);
                    break;
                }
                case 0x8000408: {
                    bl4 = true;
                    ++n2;
                    break;
                }
                case 1073741849: {
                    bl7 = true;
                    hashtable.put("async", Boolean.TRUE);
                    ++n2;
                    break;
                }
                case 0x2000000E: 
                case 1094717454: {
                    ++n2;
                    sB.append(" " + string4);
                    if (n == 0x2000000E) {
                        hashtable.put("isTrajectory", Boolean.TRUE);
                    }
                    if (this.isPoint3f(n2)) {
                        object3 = this.getPoint3f(n2, false);
                        n2 = this.iToken + 1;
                        hashtable.put("firstLastStep", new int[]{(int)((P3)object3).x, (int)((P3)object3).y, (int)((P3)object3).z});
                        sB.append(" " + Escape.eP((T3)object3));
                        break;
                    }
                    switch (this.tokAt(n2)) {
                        case 10: {
                            BS bS = (BS)this.getToken((int)n2++).value;
                            hashtable.put("bsModels", bS);
                            sB.append(" " + Escape.eBS(bS));
                            break block14;
                        }
                    }
                    hashtable.put("firstLastStep", new int[]{0, -1, 1});
                    break;
                }
                case 0x40000000: {
                    break;
                }
                default: {
                    string4 = "fileset";
                }
            }
            if (string2 == null && stringArray == null && this.getToken((int)n2).tok != 4) {
                this.error(16);
            }
        }
        int n9 = n2;
        int n10 = n2 + 1;
        String string7 = null;
        if (this.tokAt(n10) == 1073741848) {
            n2 = n10 + 1;
            string7 = this.stringParameter(n2);
            if (this.vwr.fm.getPathForAllFiles() != "") {
                string7 = null;
                n9 = n2;
            }
        }
        string = null;
        String string8 = null;
        if (this.slen == n2 + 1) {
            if (string2 == null && (n2 == 0 || stringArray == null && (string2 = this.paramAsStr(n9)).length() == 0)) {
                string2 = this.getFullPathName();
            }
            if (string2 == null && stringArray == null) {
                this.cmdZap(false);
                return;
            }
            if (stringArray == null && !bl3) {
                if (bl4) {
                    string2 = "$" + string2;
                } else {
                    if (string2.indexOf("[]") >= 0) {
                        return;
                    }
                    if (string2.indexOf("[") == 0 && (stringArray = Escape.unescapeStringArray(string2)) != null) {
                        if (n2 == 1) {
                            sB.append(" files");
                        }
                        n5 = stringArray.length;
                    }
                }
            }
            if (stringArray != null) {
                for (int i = 0; i < n5; ++i) {
                    sB.append(" /*file*/").append(PT.esc(stringArray[i]));
                }
            }
        } else if (this.isLoadOption(this.getToken((int)(n2 + 1)).tok)) {
            if (string2 == null && (string2 = this.paramAsStr(n9)).length() == 0 && (string2 = this.getFullPathName()) == null) {
                this.cmdZap(false);
                return;
            }
            if (n9 == n2 || string7 != null) {
                ++n2;
            }
            if (string2.indexOf("[]") >= 0) {
                return;
            }
            n = this.tokAt(n2);
            if (n == 1073742010) {
                object2 = this.stringParameter(++n2);
                hashtable.put("manifest", object2);
                sB2.append(" MANIFEST " + PT.esc((String)object2));
                n = this.tokAt(++n2);
            }
            switch (n) {
                case 2: 
                case 7: 
                case 0x10000040: 
                case 1073742195: {
                    n2 = this.getLoadModelIndex(n2, sB2, hashtable);
                }
            }
            n2 = this.getCmdExt().getLoadSymmetryParams(n2, sB2, hashtable);
            if (this.tokAt(n2) == 0x4000000F) {
                if (this.tokAt(++n2) == 0x8001008) {
                    n2 += 2;
                    string = (String)this.getToken((int)n2++).value;
                    string8 = this.stringParameter(++n2);
                    ++n2;
                } else {
                    string8 = this.stringParameter(n2++);
                    string = this.stringParameter(n2++);
                }
                hashtable.put(string8, string);
            }
            if (this.tokAt(n2) == 0x40000074) {
                string3 = this.stringParameter(++n2);
            }
        } else {
            object2 = new Lst<String>();
            if (n2 == 1) {
                ++n2;
                sB.append(" " + string4);
            }
            string3 = this.getLoadFilesList(n2, sB, sB2, (Map<String, Object>)hashtable, (Lst<String>)object2);
            n5 = ((ArrayList)object2).size();
            stringArray = ((ArrayList)object2).toArray(new String[n5]);
            if (!bl8 && sB.indexOf("/*concat*/") >= 0) {
                bl8 = true;
            }
        }
        if (!bl) {
            return;
        }
        if (stringArray != null) {
            string2 = "fileSet";
        }
        if (string != null) {
            sB2.append(" APPEND data \"" + string8 + "\"\n" + string + (string.endsWith("\n") ? "" : "\n") + "end \"" + string8 + "\"");
        }
        if (string3 == null) {
            string3 = this.vwr.g.defaultLoadFilter;
        }
        if (string3.length() > 0) {
            if (string3.toUpperCase().indexOf("DOCACHE") >= 0 && !this.isStateScript && !bl2) {
                this.vwr.cacheClear();
            }
            hashtable.put("filter", string3);
            if (string3.equalsIgnoreCase("2d")) {
                string3 = "2D-noMin";
            }
            sB2.append(" FILTER " + PT.esc(string3));
        }
        boolean bl11 = false;
        if (stringArray == null) {
            if (bl3) {
                hashtable.put("fileData", string2);
            } else if (string2.startsWith("@") && string2.length() > 1) {
                object = this.getVarParameter(string2.substring(1), false);
                if (object instanceof Map) {
                    this.checkLength(n2 + 1);
                    this.loadPNGJVar(string2, object, hashtable);
                    return;
                }
                bl11 = true;
                object = "" + object;
                sB = new SB().append("{\n    var ").append(string2.substring(1)).append(" = ").append(PT.esc((String)object)).append(";\n    ").appendSB(sB);
                hashtable.put("fileData", object);
            } else if ((this.vwr.testAsync || this.vwr.isJS) && (bl7 || string2.startsWith("?"))) {
                string7 = null;
                string2 = this.loadFileAsync("LOAD" + (bl2 ? "_APPEND_" : "_"), string2, n2, !bl2 && this.pc != this.pcResume);
            }
        }
        object = null;
        if (string7 != null) {
            String[] stringArray3;
            if (string7.equals(".")) {
                string7 = this.vwr.fm.getFilePath(string2, false, true);
            }
            if (string7.length() == 0 || this.vwr.fm.getFilePath(string7, false, false).equalsIgnoreCase(this.vwr.fm.getFilePath(string2, false, false))) {
                this.invArg();
            }
            if ((object = this.vwr.getOutputChannel(string7, stringArray3 = new String[]{string7})) == null) {
                Logger.error("Could not create output stream for " + stringArray3[0]);
            } else {
                hashtable.put("outputChannel", object);
            }
        }
        if (stringArray == null && n6 == 0) {
            sB.append(" ");
            if (bl11 || bl3) {
                sB.append(PT.esc(string2));
            } else if (!bl6) {
                if (string7 != null) {
                    string7 = this.vwr.fm.getFilePath(string7, false, false);
                }
                if (!string2.equals("string") && !string2.equals("string[]")) {
                    sB.append("/*file*/").append(string7 != null ? PT.esc(string7) : "$FILENAME$");
                }
            }
            if (!bl8 && (string2.startsWith("=") || string2.startsWith("*")) && string2.indexOf("/") > 0) {
                String string9;
                bl8 = true;
                int n11 = string2.indexOf("/");
                if (n11 == 1 && this.vwr.ms.getInfo(this.vwr.am.cmi, "isPDB") == Boolean.TRUE) {
                    string9 = (String)this.vwr.ms.getInfo(this.vwr.am.cmi, "modelName");
                    string2 = string2.substring(0, 1) + string9 + string2.substring(1);
                    n11 = string2.indexOf("/");
                } else {
                    string9 = string2.substring(1, n11);
                }
                String string10 = string2.substring(n11 + 1);
                string2 = string2.substring(0, n11);
                n11 = string2.indexOf(".");
                if (n11 >= 0) {
                    string2 = string2.substring(0, n11);
                }
                if (";dssr;rna3d;dom;val;".indexOf(";" + string10 + ";") >= 0) {
                    String[] stringArray4;
                    if (string2.startsWith("=")) {
                        string2 = string2 + ".cif";
                    }
                    if (string10.equals("all")) {
                        String[] stringArray5 = new String[3];
                        stringArray5[0] = string2;
                        stringArray5[1] = "*dom/" + string9;
                        stringArray4 = stringArray5;
                        stringArray5[2] = "*val/" + string9;
                    } else {
                        String[] stringArray6 = new String[2];
                        stringArray6[0] = string2;
                        stringArray4 = stringArray6;
                        stringArray6[1] = "*" + string10 + "/" + string9;
                    }
                    stringArray = stringArray4;
                    string2 = "fileSet";
                    sB = null;
                    bl11 = false;
                    sB2.setLength(0);
                } else {
                    string2 = string2 + "/" + string10;
                }
            }
            if (sB2.length() > 0) {
                sB.append(" /*options*/ ").append(sB2.toString());
            }
            if (bl11) {
                sB.append("\n  }");
            }
            if (sB != null) {
                hashtable.put("loadScript", sB);
            }
        }
        this.setCursorWait(true);
        boolean bl12 = this.vwr.getBoolean(603979934);
        if (bl12) {
            Logger.startTimer("load");
        }
        if (!this.isStateScript && !bl2) {
            this.vwr.setBooleanProperty("legacyJavaFloat", false);
        }
        if (bl5) {
            hashtable.put("isMutate", Boolean.TRUE);
        }
        hashtable.put("eval", this);
        string5 = this.vwr.loadModelFromFile(null, string2, stringArray, null, bl2, hashtable, sB, sB2, n6, bl8);
        if (bl12) {
            this.showString(Logger.getTimerMsg("load", 0));
        }
        if (object != null) {
            this.vwr.fm.setFileInfo(new String[]{string7});
            Logger.info(GT.o(GT._("file {0} created"), string7));
            this.showString(this.vwr.fm.getFilePath(string7, false, false) + " created");
            ((OC)object).closeChannel();
        }
        if (n6 > 0) {
            this.vwr.fm.setFileInfo(stringArray2);
            if (string5 != null && !this.isCmdLine_c_or_C_Option) {
                this.evalError(string5, null);
            }
            return;
        }
        if (string5 != null && !this.isCmdLine_c_or_C_Option) {
            if (string5.indexOf("NOTE: file recognized as a script file: ") == 0) {
                string2 = string5.substring("NOTE: file recognized as a script file: ".length()).trim();
                this.cmdScript(0, string2, null);
                return;
            }
            if (this.vwr.async && string5.startsWith(JC.READER_NOT_FOUND)) {
                throw new ScriptInterruption(this, "async", 1);
            }
            this.evalError(string5, null);
        }
        if (this.debugHigh) {
            this.report("Successfully loaded:" + (stringArray == null ? hashtable.get("fullPathName") : string4));
        }
        this.finalizeLoad(bl2, bl10, bl8, bl9, n5, n4, n3);
    }

    private void loadPNGJVar(String string, Object object, Map<String, Object> map) throws ScriptException {
        T[] tArray = new SV[]{SV.newV(6, object)};
        this.getCmdExt().dispatch(1073741866, false, tArray);
        map.put("imageData", ((SV)tArray[0]).value);
        OC oC = this.vwr.getOutputChannel(null, null);
        map.put("outputChannel", oC);
        this.vwr.createZip("", "BINARY", map);
        String string2 = "cache://VAR_" + string;
        this.vwr.cacheFileByName("cache://VAR_*", false);
        this.vwr.cachePut(string2, oC.toByteArray());
        this.cmdScript(0, string2, null);
    }

    private String getLoadFilesList(int n, SB sB, SB sB2, Map<String, Object> map, Lst<String> lst) throws ScriptException {
        Lst<Object> lst2 = null;
        String string = null;
        P3 p3 = null;
        BS bS = null;
        block7: while (n < this.slen) {
            switch (this.tokAt(n)) {
                case 0x100000A1: {
                    sB.append("/*concat*/ +");
                    ++n;
                    continue block7;
                }
                case 2: 
                case 7: 
                case 0x10000040: 
                case 1073742195: {
                    n = this.getLoadModelIndex(n, sB2, map);
                    continue block7;
                }
                case 0x40000074: {
                    string = this.stringParameter(++n);
                    ++n;
                    continue block7;
                }
                case 1073742329: {
                    map.remove("isTrajectory");
                    if (lst2 == null) {
                        lst2 = new Lst<Object>();
                        p3 = P3.new3(0.0f, -1.0f, 1.0f);
                    }
                    if (this.isPoint3f(++n)) {
                        p3 = this.getPoint3f(n, false);
                        n = this.iToken + 1;
                        break;
                    }
                    if (this.tokAt(n) != 10) break;
                    bS = (BS)this.getToken((int)n).value;
                    p3 = null;
                    n = this.iToken + 1;
                    break;
                }
                case 0x40000000: {
                    this.invArg();
                }
            }
            lst.addLast(this.paramAsStr(n++));
            if (p3 != null) {
                lst2.addLast(new int[]{(int)p3.x, (int)p3.y, (int)p3.z});
                sB.append(" COORD " + Escape.eP(p3));
            } else if (bS != null) {
                lst2.addLast(bS);
                sB.append(" COORD " + Escape.eBS(bS));
            }
            sB.append(" /*file*/$FILENAME" + lst.size() + "$");
        }
        if (lst2 != null) {
            map.put("firstLastSteps", lst2);
        }
        return string;
    }

    private boolean isLoadOption(int n) {
        switch (n) {
            case 2: 
            case 7: 
            case 8: 
            case 0x10000040: 
            case 0x4000000F: 
            case 1073741938: 
            case 1073742010: 
            case 1073742066: 
            case 0x40000100: 
            case 1073742114: 
            case 1073742152: 
            case 1073742163: 
            case 1073742195: 
            case 1073742332: 
            case 1094713350: 
            case 1613369372: {
                return true;
            }
            case 0x40000000: 
            case 0x40000074: {
                return this.tokAt(this.iToken + 2) != 1073742329;
            }
        }
        return false;
    }

    private int getLoadModelIndex(int n, SB sB, Map<String, Object> map) throws ScriptException {
        switch (this.tokAt(n)) {
            case 2: {
                map.remove("firstLastStep");
                map.remove("bsModel");
                map.put("useFileModelNumbers", Boolean.TRUE);
                int n2 = this.intParameter(n);
                sB.append(" ").appendI(n2);
                if (n2 < 0) {
                    map.put("vibrationNumber", -n2);
                    break;
                }
                map.put("modelNumber", n2);
                break;
            }
            case 7: 
            case 0x10000040: 
            case 1073742195: {
                map.remove("firstLastStep");
                float[] fArray = this.floatParameterSet(n, 1, Integer.MAX_VALUE);
                BS bS = new BS();
                int[] nArray = new int[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    int n3 = (int)fArray[i];
                    if (fArray[i] >= 1.0f && fArray[i] == (float)n3) {
                        bS.set(n3 - 1);
                    } else {
                        this.invArg();
                    }
                    nArray[i] = n3;
                }
                sB.append(" " + Escape.eAI(nArray));
                map.put("bsModels", bS);
                map.put("useFileModelNumbers", Boolean.TRUE);
            }
        }
        return this.iToken + 1;
    }

    private void finalizeLoad(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, int n3) throws ScriptException {
        String string;
        String string2;
        Map<String, Object> map;
        Object object;
        Object object2;
        if (bl && (bl2 || n > 1)) {
            this.vwr.setAnimationRange(-1, -1);
            this.vwr.setCurrentModelIndex(n3);
        }
        if (this.scriptLevel == 0 && !bl && (bl3 || n < 2)) {
            this.vwr.showString((String)this.vwr.ms.getInfoM("modelLoadNote"), false);
        }
        if (AU.isAI(object2 = this.vwr.ms.getInfoM("centroidMinMax")) && this.vwr.ms.ac > 0) {
            object = BSUtil.newBitSet2(bl ? n2 : 0, this.vwr.ms.ac);
            this.vwr.ms.setCentroid((BS)object, (int[])object2);
        }
        object = this.vwr.g.defaultLoadScript;
        String string3 = "";
        if (((String)object).length() > 0) {
            string3 = string3 + "\nUsing defaultLoadScript: " + (String)object;
        }
        if ((map = this.vwr.ms.msInfo) != null && this.vwr.allowEmbeddedScripts() && (string2 = (String)map.remove("jmolscript")) != null && string2.length() > 0) {
            string3 = string3 + "\nAdding embedded #jmolscript: " + string2;
            object = (String)object + ";" + string2;
            this.setStringProperty("_loadScript", (String)object);
            object = "allowEmbeddedScripts = false;try{" + (String)object + "} allowEmbeddedScripts = true;";
        } else {
            this.setStringProperty("_loadScript", "");
        }
        this.logLoadInfo(string3);
        String string4 = string = map == null ? null : (String)map.remove("sitescript");
        if (string != null) {
            object = string + ";" + (String)object;
        }
        if (bl4) {
            object = (String)object + ";restore orientation preload";
        }
        if (((String)object).length() > 0 && !this.isCmdLine_c_or_C_Option) {
            this.runScript((String)object);
        }
    }

    private void cmdLog() throws ScriptException {
        if (this.slen == 1) {
            this.bad();
        }
        if (this.chk) {
            return;
        }
        String string = this.parameterExpressionString(1, 0);
        if (this.tokAt(1) == 1073742334) {
            this.setStringProperty("logFile", "");
        } else {
            this.vwr.log(string);
        }
    }

    private void cmdLoop() throws ScriptException {
        if (this.vwr.headless) {
            return;
        }
        if (!this.chk) {
            this.pc = -1;
        }
        this.cmdDelay();
    }

    private void cmdMessage() throws ScriptException {
        String string = this.paramAsStr(this.checkLast(1));
        if (this.chk) {
            return;
        }
        String string2 = Txt.formatText(this.vwr, string);
        if (this.outputBuffer == null) {
            this.vwr.warn(string2);
        }
        if (!string2.startsWith("_")) {
            this.report(string2);
        }
    }

    private void cmdModel(int n) throws ScriptException {
        int n2;
        int n3;
        boolean bl = this.theTok == 4115;
        boolean bl2 = true;
        if (this.slen == 1 && n == 1) {
            int n4;
            int n5 = this.vwr.am.cmi;
            if (!this.chk && n5 >= 0 && (n4 = this.vwr.ms.getJmolDataSourceFrame(n5)) >= 0) {
                this.vwr.setCurrentModelIndex(n4 == n5 ? Integer.MIN_VALUE : n4);
            }
            return;
        }
        switch (this.tokAt(1)) {
            case 2: {
                if (!bl || this.slen != 2) break;
                if (!this.chk) {
                    this.vwr.am.setFrame(this.intParameter(1) - 1);
                }
                return;
            }
            case 10: 
            case 1073742325: {
                int n6 = this.atomExpressionAt(1).nextSetBit(0);
                this.checkLength(this.iToken + 1);
                if (this.chk || n6 < 0) {
                    return;
                }
                BS bS = new BS();
                bS.set(n6);
                this.vwr.setCurrentModelIndex(this.vwr.ms.getModelBS(bS, false).nextSetBit(0));
                return;
            }
            case 0x40000050: {
                this.iToken = 1;
                int n7 = this.tokAt(2) == 2 ? this.intParameter(++this.iToken) : 1;
                this.checkLength(this.iToken + 1);
                if (!this.chk && n7 > 0) {
                    this.vwr.ms.createModels(n7);
                }
                return;
            }
            case 1073741974: {
                this.checkLength(3);
                String string = this.stringParameter(2);
                if (!this.chk) {
                    this.vwr.setCurrentModelID(string);
                }
                return;
            }
            case 528397: {
                long l = 0L;
                this.checkLength(3);
                switch (this.getToken((int)2).tok) {
                    case 2: 
                    case 3: {
                        l = (long)(this.floatParameter(2) * 1000.0f);
                        break;
                    }
                    default: {
                        this.error(20);
                    }
                }
                if (!this.chk) {
                    this.vwr.setFrameDelayMs(l);
                }
                return;
            }
            case 1073742166: {
                if (this.checkLength23() > 0 && !this.chk) {
                    this.vwr.setFrameTitleObj(this.slen == 2 ? "@{_modelName}" : (this.tokAt(2) == 7 ? SV.strListValue(this.st[2]) : this.paramAsStr(2)));
                }
                return;
            }
            case 0x40000008: {
                BS bS;
                boolean bl3 = this.tokAt(2) == 1073742333;
                BS bS2 = bS = this.slen == 2 || bl3 ? null : this.atomExpressionAt(2);
                if (bl3) {
                    this.iToken = 2;
                }
                boolean bl4 = this.tokAt(this.iToken + 1) == 12293;
                this.checkLength(this.iToken + (bl4 ? 2 : 1));
                if (!this.chk) {
                    this.vwr.setFrameOffsets(bS, bl4);
                }
                return;
            }
        }
        if (this.getToken((int)n).tok == 0x100000A0) {
            if (this.getToken((int)this.checkLast((int)(++n))).tok != 2 || this.intParameter(n) != 1) {
                this.invArg();
            }
            if (!this.chk) {
                this.vwr.setAnimation(1073742108);
            }
            return;
        }
        boolean bl5 = false;
        boolean bl6 = false;
        String string = null;
        Object object = null;
        boolean bl7 = false;
        boolean bl8 = false;
        int[] nArray = new int[]{-1, -1};
        int n8 = 0;
        float f = 0.0f;
        P3 p3 = null;
        boolean bl9 = this.vwr.haveFileSet();
        if (this.isArrayParameter(1)) {
            this.setFrameSet(1);
            bl7 = true;
        } else {
            block23: for (n3 = n; n3 < this.slen; ++n3) {
                switch (this.getToken((int)n3).tok) {
                    case 0x40000008: {
                        if (n3 != 2) {
                            this.invArg();
                        }
                        p3 = this.centerParameter(3, null);
                        n3 = this.iToken + 1;
                        this.checkLength(n3);
                        continue block23;
                    }
                    case 0x100000B1: 
                    case 1073742327: {
                        this.checkLength(n + (bl6 ? 2 : 1));
                        bl7 = true;
                        continue block23;
                    }
                    case 0x100000A0: {
                        if (n8 != 1) {
                            this.invArg();
                        }
                        bl8 = true;
                        continue block23;
                    }
                    case 1073742333: {
                        this.checkLength(n + 1);
                        continue block23;
                    }
                    case 3: {
                        float f2;
                        bl2 = false;
                        f = this.floatParameter(n3);
                        if (f2 < 0.0f) {
                            this.checkLength(n3 + 1);
                            if (!this.chk) {
                                this.vwr.am.morph(-f);
                            }
                            return;
                        }
                    }
                    case 2: 
                    case 4: {
                        if (n8 == 2) {
                            this.invArg();
                        }
                        int n9 = n2 = this.theTok == 4 ? ScriptEval.getFloatEncodedInt((String)this.theToken.value) : this.theToken.intValue;
                        if (n2 < 0 && n8 == 1) {
                            bl8 = true;
                            n2 = -n2;
                            if (bl9 && n2 < 1000000) {
                                n2 *= 1000000;
                            }
                        }
                        if (this.theTok == 3 && bl9 && f == (float)((int)f)) {
                            n2 = (int)f * 1000000;
                        }
                        if (n2 == Integer.MAX_VALUE) {
                            bl2 = false;
                            nArray[n8++] = this.chk || n3 != 1 ? 0 : this.vwr.getModelIndexFromId(this.theToken.value.toString());
                            continue block23;
                        }
                        if (n2 == -1) {
                            this.checkLength(n + 1);
                            if (!this.chk) {
                                this.vwr.setAnimation(1073742108);
                            }
                            return;
                        }
                        if (n2 >= 1000 && n2 < 1000000 && bl9) {
                            n2 = n2 / 1000 * 1000000 + n2 % 1000;
                        }
                        if (!bl2 && n2 == 0 && n8 == 0) {
                            bl7 = true;
                        }
                        if (n2 >= 1000000) {
                            bl2 = false;
                        }
                        nArray[n8++] = n2;
                        continue block23;
                    }
                    case 0x40000110: {
                        bl5 = true;
                        continue block23;
                    }
                    case 1073742114: {
                        bl6 = true;
                        continue block23;
                    }
                    case 1715472409: {
                        string = this.stringParameter(3);
                        SV sV = this.setVariable(4, -1, "", false);
                        if (sV != null) {
                            object = SV.oValue(sV);
                        }
                        n3 = this.slen;
                        continue block23;
                    }
                    default: {
                        this.frameControl(n);
                        return;
                    }
                }
            }
        }
        if (this.chk) {
            return;
        }
        if (bl6 && n8 == 0) {
            bl7 = true;
        }
        if (bl7) {
            this.vwr.setAnimationOn(false);
            this.vwr.setAnimationRange(-1, -1);
            if (!bl6) {
                this.vwr.setCurrentModelIndex(-1);
            }
            return;
        }
        if (n8 == 2 && !bl6) {
            bl8 = true;
        }
        if (bl9) {
            bl2 = false;
        } else if (bl2) {
            for (n3 = 0; n3 < n8; ++n3) {
                if (nArray[n3] < 0) continue;
                int n10 = n3;
                nArray[n10] = nArray[n10] % 1000000;
            }
        }
        n3 = this.vwr.ms.getModelNumberIndex(nArray[0], bl2, false);
        if (p3 != null) {
            if (n3 >= 0) {
                this.vwr.ms.translateModel(n3, null);
                this.vwr.ms.translateModel(n3, p3);
            }
            return;
        }
        n2 = -1;
        if (bl9 && n3 < 0 && nArray[0] != 0) {
            if (nArray[0] < 1000000) {
                nArray[0] = nArray[0] * 1000000;
            }
            if (n8 == 2 && nArray[1] < 1000000) {
                nArray[1] = nArray[1] * 1000000;
            }
            if (nArray[0] % 1000000 == 0) {
                nArray[0] = nArray[0] + 1;
                n3 = this.vwr.ms.getModelNumberIndex(nArray[0], false, false);
                if (n3 >= 0) {
                    int n11 = n8 == 1 ? nArray[0] + 1000000 : (nArray[1] == 0 ? -1 : (nArray[1] % 1000000 == 0 ? nArray[1] + 1000001 : nArray[1] + 1));
                    n2 = this.vwr.ms.getModelNumberIndex(n11, false, false);
                    if (n2 < 0) {
                        n2 = this.vwr.ms.mc;
                    }
                    --n2;
                    if (bl6) {
                        n8 = 2;
                    } else if (!bl8 && n2 != n3) {
                        bl8 = true;
                    }
                    bl6 = bl6 || n3 == n2;
                }
            } else {
                return;
            }
        }
        if (string != null) {
            if (n3 >= 0) {
                this.vwr.ms.setInfo(n3, string, object);
            }
            return;
        }
        if (!bl5 && !bl6 || n3 >= 0) {
            this.vwr.setCurrentModelIndexClear(n3, false);
        }
        if (bl5 && n8 == 2 || bl6 || bl8) {
            if (n2 < 0) {
                n2 = this.vwr.ms.getModelNumberIndex(nArray[1], bl2, false);
            }
            this.vwr.setAnimationOn(false);
            this.vwr.am.setAnimationDirection(1);
            this.vwr.setAnimationRange(n3, n2);
            this.vwr.setCurrentModelIndexClear(bl8 && !bl6 ? -1 : (n3 >= 0 ? n3 : 0), false);
        }
        if (bl5) {
            this.vwr.setAnimation(4143);
        }
    }

    private void cmdMove() throws ScriptException {
        int n;
        this.checkLength(-11);
        V3 v3 = V3.new3(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        float f = this.floatParameter(4);
        V3 v32 = V3.new3(this.intParameter(5), this.intParameter(6), this.intParameter(7));
        float f2 = this.floatParameter(8);
        float f3 = this.floatParameter(9);
        int n2 = n = this.slen == 11 ? this.intParameter(10) : 30;
        if (this.chk) {
            return;
        }
        this.refresh(false);
        if (!this.useThreads()) {
            f3 = 0.0f;
        }
        this.vwr.move(this, v3, f, v32, f2, f3, n);
        if (f3 > 0.0f && this.isJS) {
            throw new ScriptInterruption(this, "move", 1);
        }
    }

    private void cmdMoveto() throws ScriptException {
        Object[] objectArray;
        if (this.slen == 2 && this.tokAt(1) == 1073742162) {
            if (!this.chk) {
                this.vwr.tm.stopMotion();
            }
            return;
        }
        if (this.slen == 2 && this.isFloatParameter(1)) {
            float f = this.floatParameter(1);
            if (this.chk) {
                return;
            }
            if (!this.useThreads()) {
                f = 0.0f;
            }
            if (f > 0.0f) {
                this.refresh(false);
            }
            this.vwr.moveTo(this, f, null, JC.axisZ, 0.0f, null, 100.0f, 0.0f, 0.0f, 0.0f, null, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN);
            if (this.isJS && f > 0.0f && this.vwr.g.waitForMoveTo) {
                throw new ScriptInterruption(this, "moveTo", 1);
            }
            return;
        }
        V3 v3 = V3.new3(Float.NaN, 0.0f, 0.0f);
        P3 p3 = null;
        int n = 1;
        float f = this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f;
        float f2 = 90.0f;
        BS bS = null;
        boolean bl = true;
        boolean bl2 = false;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = Float.NaN;
        float f6 = Float.NaN;
        float f7 = this.vwr.tm.getZoomSetting();
        P3 p32 = null;
        float f8 = Float.NaN;
        float f9 = Float.NaN;
        float f10 = Float.NaN;
        float f11 = Float.NaN;
        float f12 = Float.NaN;
        float f13 = Float.NaN;
        float[] fArray = null;
        Quat quat = null;
        block0 : switch (this.getToken((int)n).tok) {
            case 1073742110: {
                fArray = this.floatParameterSet(++n, 18, 21);
                n = this.iToken + 1;
                if (!this.chk || this.checkLength(n) <= 0) break;
                return;
            }
            case 134221842: {
                if (this.tokAt(++n) == 0x400000CC) {
                    bl2 = true;
                    ++n;
                }
                if (this.tokAt(n) == 10 || this.tokAt(n) == 1073742325) {
                    bl2 = true;
                    objectArray = new Object[1];
                    p3 = this.centerParameter(n, objectArray);
                    if (!(objectArray[0] instanceof BS)) {
                        this.invArg();
                    }
                    bS = (BS)objectArray[0];
                    quat = this.chk ? new Quat() : this.vwr.ms.getQuaternion(bS.nextSetBit(0), this.vwr.getQuaternionFrame());
                } else {
                    quat = this.getQuaternionParameter(n);
                }
                n = this.iToken + 1;
                if (quat != null) break;
                this.invArg();
                break;
            }
            case 8: 
            case 9: 
            case 1073742332: {
                if (this.isPoint3f(n)) {
                    v3.setT(this.getPoint3f(n, true));
                    n = this.iToken + 1;
                    f2 = this.floatParameter(n++);
                    break;
                }
                objectArray = this.getPoint4f(n);
                n = this.iToken + 1;
                v3.set(objectArray.x, objectArray.y, objectArray.z);
                f2 = objectArray.x == 0.0f && objectArray.y == 0.0f && objectArray.z == 0.0f ? Float.NaN : objectArray.w;
                break;
            }
            case 1073741954: {
                v3.set(1.0f, 0.0f, 0.0f);
                f2 = 0.0f;
                this.checkLength(++n);
                break;
            }
            case 1073741859: {
                v3.set(0.0f, 1.0f, 0.0f);
                f2 = 180.0f;
                this.checkLength(++n);
                break;
            }
            case 1073741996: {
                v3.set(0.0f, 1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073742126: {
                v3.set(0.0f, -1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073742172: {
                v3.set(1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073741871: {
                v3.set(-1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073741854: {
                objectArray = this.paramAsStr(++n);
                this.checkLength(++n);
                switch ("xyz".indexOf((String)objectArray)) {
                    case 0: {
                        quat = Quat.new4(0.5f, 0.5f, 0.5f, -0.5f);
                        break block0;
                    }
                    case 1: {
                        quat = Quat.new4(0.5f, 0.5f, 0.5f, 0.5f);
                        break block0;
                    }
                    case 2: {
                        quat = Quat.new4(0.0f, 0.0f, 0.0f, 1.0f);
                        break block0;
                    }
                }
                SymmetryInterface symmetryInterface = this.vwr.getCurrentUnitCell();
                if (symmetryInterface == null) {
                    symmetryInterface = this.vwr.ms.getSymTemp(true);
                    symmetryInterface.setUnitCell(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f}, false);
                }
                if ((quat = symmetryInterface.getQuaternionRotation((String)objectArray)) != null) break;
                this.invArg();
                break;
            }
            default: {
                v3 = V3.new3(this.floatParameter(n++), this.floatParameter(n++), this.floatParameter(n++));
                f2 = this.floatParameter(n++);
            }
        }
        if (quat != null) {
            objectArray = quat.toAxisAngle4f();
            v3.set(objectArray.x, objectArray.y, objectArray.z);
            f2 = (float)(bl2 ? -1 : 1) * (float)((double)objectArray.angle * 180.0 / Math.PI);
        }
        if (Float.isNaN(v3.x) || Float.isNaN(v3.y) || Float.isNaN(v3.z)) {
            v3.set(0.0f, 0.0f, 0.0f);
        } else if (v3.length() == 0.0f && f2 == 0.0f) {
            f2 = Float.NaN;
        }
        boolean bl3 = bl = !this.vwr.tm.isInPosition(v3, f2);
        if (this.isFloatParameter(n)) {
            f5 = this.floatParameter(n++);
        }
        if (this.isFloatParameter(n) && !this.isCenterParameter(n)) {
            f3 = this.floatParameter(n++);
            f4 = this.floatParameter(n++);
            if (!bl && Math.abs(f3 - this.vwr.tm.getTranslationXPercent()) >= 1.0f) {
                bl = true;
            }
            if (!bl && Math.abs(f4 - this.vwr.tm.getTranslationYPercent()) >= 1.0f) {
                bl = true;
            }
        }
        if (bS == null && n != this.slen) {
            objectArray = new Object[1];
            p3 = this.centerParameter(n, objectArray);
            if (objectArray[0] instanceof BS) {
                bS = (BS)objectArray[0];
            }
            n = this.iToken + 1;
        }
        if (p3 != null) {
            if (!bl && (double)p3.distance(this.vwr.tm.fixedRotationCenter) >= 0.1) {
                bl = true;
            }
            if (this.isFloatParameter(n)) {
                f6 = this.floatParameter(n++);
            }
            if (!this.isCenterParameter(n)) {
                if ((f6 == 0.0f || Float.isNaN(f6)) && (f5 == 0.0f || Float.isNaN(f5))) {
                    float f14 = Math.abs(this.getZoom(0, n, bS, f5 == 0.0f ? 0.0f : f7));
                    n = this.iToken + 1;
                    f5 = f14;
                } else if (!bl && (double)Math.abs(f6 - this.vwr.getFloat(0x2200002C)) >= 0.1) {
                    bl = true;
                }
            }
            if (f5 == 0.0f || Float.isNaN(f5)) {
                f5 = 100.0f;
            }
            if (Float.isNaN(f6)) {
                f6 = 0.0f;
            }
            if (!bl && Math.abs(f5 - f7) >= 1.0f) {
                bl = true;
            }
            if (n != this.slen) {
                p32 = this.centerParameter(n, null);
                n = this.iToken + 1;
                if (n != this.slen) {
                    f8 = this.floatParameter(n++);
                    f9 = this.floatParameter(n++);
                }
                if (n != this.slen) {
                    f10 = this.floatParameter(n++);
                }
                if (n != this.slen) {
                    f11 = this.floatParameter(n++);
                    if (!bl && Math.abs(f11 - this.vwr.tm.getCameraDepth()) >= 0.01f) {
                        bl = true;
                    }
                }
                if (n + 1 < this.slen) {
                    f12 = this.floatParameter(n++);
                    f13 = this.floatParameter(n++);
                    if (!bl && Math.abs(f12 - this.vwr.tm.camera.x) >= 0.01f) {
                        bl = true;
                    }
                    if (!bl && Math.abs(f13 - this.vwr.tm.camera.y) >= 0.01f) {
                        bl = true;
                    }
                }
            }
        }
        this.checkLength(n);
        if (this.chk) {
            return;
        }
        if (!bl) {
            f = 0.0f;
        }
        if (f > 0.0f) {
            this.refresh(false);
        }
        if (!this.useThreads()) {
            f = 0.0f;
        }
        if (f11 == 0.0f) {
            f13 = Float.NaN;
            f12 = Float.NaN;
            f11 = Float.NaN;
        }
        if (fArray != null) {
            this.vwr.tm.moveToPyMOL(this, f, fArray);
        } else {
            this.vwr.moveTo(this, f, p3, v3, f2, null, f5, f3, f4, f6, p32, f8, f9, f10, f11, f12, f13);
        }
        if (this.isJS && f > 0.0f && this.vwr.g.waitForMoveTo) {
            throw new ScriptInterruption(this, "moveTo", 1);
        }
    }

    private boolean cmdPause() throws ScriptException {
        if (this.chk || this.isJS && !this.allowJSThreads) {
            return false;
        }
        String string = this.optParameterAsString(1);
        if (!this.vwr.getBooleanProperty("_useCommandThread")) {
            // empty if block
        }
        if (this.vwr.autoExit || !this.vwr.haveDisplay && !this.vwr.isWebGL) {
            return false;
        }
        if (this.scriptLevel == 0 && this.pc == this.aatoken.length - 1) {
            this.vwr.scriptStatus("nothing to pause: " + string);
            return false;
        }
        string = string.length() == 0 ? ": RESUME to continue." : ": " + Txt.formatText(this.vwr, string);
        this.pauseExecution(true);
        this.vwr.scriptStatusMsg("script execution paused" + string, "script paused for RESUME");
        return true;
    }

    private void cmdPrint() throws ScriptException {
        if (this.slen == 1) {
            if (!this.chk) {
                this.showStringPrint("\u0000", true);
            }
            return;
        }
        this.showStringPrint(this.parameterExpressionString(1, 0), true);
    }

    private void cmdPrompt() throws ScriptException {
        String string = null;
        if (this.slen == 1) {
            if (!this.chk) {
                string = ScriptEval.getContextTrace(this.vwr, this.getScriptContext("prompt"), null, true).toString();
            }
        } else {
            string = this.parameterExpressionString(1, 0);
        }
        if (!this.chk) {
            this.vwr.prompt(string, "OK", null, true);
        }
    }

    private void cmdReset() throws ScriptException {
        if (this.slen == 3 && this.tokAt(1) == 134320137) {
            if (!this.chk) {
                this.vwr.removeFunction(this.stringParameter(2));
            }
            return;
        }
        this.checkLength(-2);
        if (this.chk) {
            return;
        }
        if (this.slen == 1) {
            this.vwr.reset(false);
            return;
        }
        switch (this.tokAt(1)) {
            case 36865: {
                if (!this.chk && this.outputBuffer != null) {
                    this.outputBuffer.setLength(0);
                }
                return;
            }
            case 134221847: {
                this.vwr.cacheClear();
                return;
            }
            case 1073741935: {
                this.resetError();
                return;
            }
            case 1073741995: {
                this.vwr.stm.resetLighting();
                return;
            }
            case 0x40C0000C: {
                this.vwr.resetShapes(true);
                return;
            }
            case 134320137: {
                this.vwr.clearFunctions();
                return;
            }
            case 1639976963: {
                BS bS = new BS();
                this.runScript(this.vwr.ms.getDefaultStructure(this.vwr.bsA(), bS));
                this.vwr.shm.resetBioshapes(bS);
                return;
            }
            case 1648363544: {
                this.vwr.setData("element_vdw", new Object[]{null, ""}, 0, 0, 0, 0, 0);
                return;
            }
            case 1075838996: {
                this.vwr.ms.resetAromatic();
                return;
            }
            case 1611141175: {
                this.vwr.reset(true);
                return;
            }
        }
        String string = this.paramAsStr(1);
        if (string.charAt(0) == '_') {
            this.invArg();
        }
        this.vwr.unsetProperty(string);
    }

    private void resetError() {
        this.vwr.g.removeParam("_errormessage");
    }

    private void cmdRestrict() throws ScriptException {
        boolean bl = this.tokAt(1) == 1677721602;
        this.cmdSelect(bl ? 2 : 1);
        this.restrictSelected(bl, true);
    }

    private void cmdReturn(SV sV) throws ScriptException {
        if (this.chk) {
            return;
        }
        SV sV2 = this.getContextVariableAsVariable("_retval", false);
        if (sV2 != null) {
            SV sV3;
            SV sV4 = sV3 = sV != null || this.slen == 1 ? null : this.parameterExpressionToken(1);
            if (sV == null) {
                sV = sV3 == null ? SV.newI(0) : sV3;
            }
            sV2.value = sV.value;
            sV2.intValue = sV.intValue;
            sV2.tok = sV.tok;
        }
        this.cmdGoto(false);
    }

    private void cmdRotate(boolean bl, boolean bl2) throws ScriptException {
        boolean bl3;
        float f;
        T3[] t3Array;
        if (this.slen == 2) {
            switch (this.getToken((int)1).tok) {
                case 1073742335: {
                    if (!this.chk) {
                        this.vwr.tm.setSpinOn();
                    }
                    return;
                }
                case 1073742334: {
                    if (!this.chk) {
                        this.vwr.tm.setSpinOff();
                    }
                    return;
                }
            }
        }
        BS bS = null;
        float f2 = Float.MIN_VALUE;
        int n = 0;
        float f3 = Float.MAX_VALUE;
        boolean bl4 = false;
        boolean bl5 = false;
        float[] fArray = null;
        Lst<P3> lst = null;
        P3[] p3Array = new P3[2];
        V3 v3 = V3.new3(0.0f, 1.0f, 0.0f);
        V3 v32 = null;
        M4 m4 = null;
        M3 m3 = null;
        boolean bl6 = false;
        int n2 = 1;
        Quat quat = null;
        boolean bl7 = false;
        Lst<P3> lst2 = null;
        BS bS2 = null;
        P3 p3 = null;
        P4 p4 = null;
        boolean bl8 = this.vwr.getBoolean(603979806);
        block25: for (int i = 1; i < this.slen; ++i) {
            int n3 = this.getToken((int)i).tok;
            switch (n3) {
                case 8: 
                case 10: 
                case 1073742325: 
                case 1073742330: 
                case 1073742332: {
                    Object[] objectArray;
                    if (!(n3 != 10 && n3 != 1073742325 || v32 == null && quat == null && n != 2)) {
                        bS = this.atomExpressionAt(i);
                        lst2 = null;
                        bl2 = true;
                        break;
                    }
                    bl5 = true;
                    if (n == 2) {
                        n = 0;
                    }
                    t3Array = this.centerParameterForModel(i, this.vwr.am.cmi, null);
                    if (!this.chk && n3 == 1073742330 && this.tokAt(i + 2) != 0x10000040) {
                        bl4 = true;
                        v3 = this.getShapePropertyData(22, "getSpinAxis", objectArray = new Object[]{this.objectNameParameter(++i), this.vwr.am.cmi, null}) ? (V3)objectArray[2] : null;
                    }
                    p3Array[n++] = t3Array;
                    break;
                }
                case 1611141175: {
                    bl = true;
                    continue block25;
                }
                case 0x400000A4: 
                case 0x400000CC: {
                    bl4 = true;
                    continue block25;
                }
                case 1113589787: {
                    bl2 = true;
                    break;
                }
                case 0x10000030: {
                    continue block25;
                }
                case 2: 
                case 3: {
                    if (bl) {
                        if (f2 == Float.MIN_VALUE) {
                            f2 = this.floatParameter(i);
                            continue block25;
                        }
                        if (f3 == Float.MAX_VALUE) {
                            f3 = f2;
                            f2 = this.floatParameter(i);
                            continue block25;
                        }
                    } else {
                        if (f3 == Float.MAX_VALUE) {
                            f3 = this.floatParameter(i);
                            continue block25;
                        }
                        if (f2 == Float.MIN_VALUE) {
                            f2 = this.floatParameter(i);
                            bl = true;
                            continue block25;
                        }
                    }
                    this.invArg();
                    break;
                }
                case 0x100000A0: {
                    n2 = -1;
                    continue block25;
                }
                case 1111492629: {
                    bl5 = true;
                    v3.set(n2, 0.0f, 0.0f);
                    continue block25;
                }
                case 1111492630: {
                    bl5 = true;
                    v3.set(0.0f, n2, 0.0f);
                    continue block25;
                }
                case 1111492631: {
                    bl5 = true;
                    v3.set(0.0f, 0.0f, bl8 && !bl4 ? -n2 : n2);
                    continue block25;
                }
                case 9: 
                case 134221842: 
                case 1073741863: {
                    if (n3 == 134221842) {
                        ++i;
                    }
                    bl5 = true;
                    quat = this.getQuaternionParameter(i);
                    if (quat == null) break;
                    if (n3 == 1073741863 && !(bl4 = bl2)) {
                        quat = quat.div(this.vwr.tm.getRotationQ());
                    }
                    v3.setT(quat.getNormal());
                    f3 = quat.getTheta();
                    break;
                }
                case 0x800000F: {
                    int n4;
                    int n5;
                    Serializable serializable;
                    Object[] objectArray;
                    if (this.paramAsStr(i + 1).equalsIgnoreCase("picked")) {
                        ++i;
                        serializable = (Lst)this.vwr.getPOrNull("pickedList");
                        n5 = ((ArrayList)serializable).size();
                        if (n5 < 3) {
                            return;
                        }
                        objectArray = new P3[3];
                        for (n4 = 0; n4 < 3; ++n4) {
                            objectArray[n4] = this.vwr.ms.getAtomSetCenter(SV.getBitSet((SV)((ArrayList)serializable).get(n5 - 3 + n4), false));
                        }
                    } else if (this.isArrayParameter(i + 1)) {
                        objectArray = this.getPointArray(++i, -1, false);
                        i = this.iToken;
                    } else {
                        objectArray = new P3[3];
                        for (int j = 0; j < 3; ++j) {
                            objectArray[j] = this.centerParameter(++i, null);
                            i = this.iToken;
                        }
                    }
                    n5 = objectArray.length;
                    if (n5 < 3) {
                        return;
                    }
                    quat = Quat.getQuaternionFrame(objectArray[n5 - 3], objectArray[n5 - 2], objectArray[n5 - 1]);
                    quat = Quat.new4(1.0f, 0.0f, 0.0f, 0.0f).mulQ(quat.inv().div(this.vwr.tm.getRotationQ()));
                    v3.setT(quat.getNormal());
                    f3 = quat.getTheta();
                    break;
                }
                case 0x8000003: {
                    bl5 = true;
                    if (this.isPoint3f(++i)) {
                        v3.setT(this.centerParameter(i, null));
                        break;
                    }
                    Serializable serializable = this.getPoint4f(i);
                    v3.set(((P4)serializable).x, ((P4)serializable).y, ((P4)serializable).z);
                    f3 = ((P4)serializable).w;
                    quat = Quat.newVA(v3, f3);
                    break;
                }
                case 1073742328: {
                    bl2 = true;
                    bl4 = true;
                    bl5 = true;
                    if (this.isArrayParameter(++i)) {
                        fArray = this.floatParameterSet(i, 6, Integer.MAX_VALUE);
                        i = this.iToken;
                        break;
                    }
                    int n4 = this.atomExpressionAt(i).nextSetBit(0);
                    int n6 = this.atomExpressionAt(++this.iToken).nextSetBit(0);
                    if (n4 < 0 || n6 < 0) {
                        return;
                    }
                    bS = this.vwr.getBranchBitSet(n6, n4, true);
                    p3Array[0] = this.vwr.ms.at[n4];
                    p3Array[1] = this.vwr.ms.at[n6];
                    n = 2;
                    break;
                }
                case 4160: {
                    v32 = V3.newV(this.centerParameter(++i, null));
                    bl2 = true;
                    bl4 = true;
                    break;
                }
                case 136314891: {
                    bl7 = true;
                    continue block25;
                }
                case 1296041474: {
                    Object[] objectArray;
                    int n4 = this.intParameter(++i);
                    if (this.chk) continue block25;
                    Map<String, Object> map = this.vwr.ms.getSymTemp(true).getSpaceGroupInfo(this.vwr.ms, null);
                    Object[] objectArray2 = objectArray = map == null ? null : (Object[])map.get("operations");
                    if (n4 == 0 || objectArray == null || objectArray.length < Math.abs(n4)) {
                        this.invArg();
                    }
                    objectArray = (Object[])objectArray[Math.abs(n4) - 1];
                    v32 = (V3)objectArray[5];
                    p3 = (P3)objectArray[6];
                    p3Array[0] = (P3)objectArray[7];
                    if (objectArray[8] != null) {
                        v3 = (V3)objectArray[8];
                    }
                    f3 = ((Integer)objectArray[9]).intValue();
                    if (n4 < 0) {
                        f3 = -f3;
                        if (v32 != null) {
                            v32.scale(-1.0f);
                        }
                    }
                    if (f3 == 0.0f && p3Array[0] != null) {
                        v3.normalize();
                        p4 = new P4();
                        Measure.getPlaneThroughPoint(p3Array[0], v3, p4);
                    }
                    quat = Quat.newVA(v3, f3);
                    n = p3Array[0] == null ? 0 : 1;
                    bl4 = true;
                    bl5 = true;
                    bl2 = true;
                    continue block25;
                }
                case 134221829: {
                    float f4;
                    bS2 = this.atomExpressionAt(++i);
                    lst = this.vwr.ms.getAtomPointVector(bS2);
                    if (lst == null) {
                        this.iToken = i;
                        this.invArg();
                    }
                    i = this.iToken;
                    if ((lst2 = this.getPointVector(this.getToken(++i), i)) == null || lst.size() != lst2.size()) {
                        this.iToken = i;
                        this.invArg();
                    }
                    m4 = new M4();
                    p3Array[0] = new P3();
                    n = 1;
                    Interface.getInterface("javajs.util.Eigen", this.vwr, "script");
                    float f5 = f4 = this.chk ? 0.0f : Measure.getTransformMatrix4(lst, lst2, m4, p3Array[0]);
                    if ((double)f4 > 0.001) {
                        lst2 = null;
                    }
                }
                case 11: 
                case 12: {
                    bl5 = true;
                    m3 = new M3();
                    if (n3 == 12) {
                        bl6 = true;
                        m4 = (M4)this.theToken.value;
                    }
                    if (m4 != null) {
                        v32 = new V3();
                        m4.getTranslation(v32);
                        m4.getRotationScale(m3);
                    } else {
                        m3 = (M3)this.theToken.value;
                    }
                    quat = this.chk ? new Quat() : Quat.newM(m3);
                    v3.setT(quat.getNormal());
                    f3 = quat.getTheta();
                    bl4 = true;
                    break;
                }
                default: {
                    this.invArg();
                }
            }
            i = this.iToken;
        }
        if (this.chk) {
            return;
        }
        if (fArray != null && f3 != Float.MAX_VALUE) {
            bl = true;
            f2 = f3;
        }
        if (bl2 && bS == null) {
            bS = this.vwr.bsA();
        }
        if (bS2 != null) {
            bl2 = true;
            if (bS == null) {
                bS = bS2;
            }
        }
        float f6 = f2 == Float.MIN_VALUE ? 10.0f : (f3 == Float.MAX_VALUE ? f2 : (f = f2 < 0.0f == f3 > 0.0f ? -f3 / f2 : f2));
        if (fArray != null) {
            if (!bl) {
                this.vwr.setDihedrals(fArray, null, 1.0f);
                return;
            }
            v32 = null;
        }
        if (quat != null) {
            if (n == 0 && v32 != null && !bl6) {
                p3Array[0] = this.vwr.ms.getAtomSetCenter(bS != null ? bS : (bl2 ? this.vwr.bsA() : this.vwr.getAllAtoms()));
            }
            if (bl7 && v32 != null) {
                p3Array[1] = P3.newP(p3Array[0]);
                p3Array[1].add(v32);
                t3Array = Measure.computeHelicalAxis(p3Array[0], p3Array[1], quat);
                p3Array[0] = (P3)t3Array[0];
                float f7 = ((P3)t3Array[3]).x;
                if (f7 != 0.0f) {
                    v32 = (V3)t3Array[1];
                    v3 = V3.newV(v32);
                    if (f7 < 0.0f) {
                        v3.scale(-1.0f);
                    }
                }
                m4 = null;
            }
            if (bl && m4 == null) {
                m4 = ScriptMathProcessor.getMatrix4f(quat.getMatrix(), v32);
            }
            if (p3Array[0] != null) {
                n = 1;
            }
        }
        if (p3 != null) {
            this.vwr.invertAtomCoordPt(p3, bS);
            if (v3 == null) {
                return;
            }
        }
        if (p4 != null) {
            this.vwr.invertAtomCoordPlane(p4, bS);
            if (v3 == null) {
                return;
            }
        }
        boolean bl9 = bl3 = bl && (!this.vwr.headless || f3 == Float.MAX_VALUE);
        if (bl && !bl3) {
            bl = false;
        }
        if (n < 2 && fArray == null) {
            if (!bl4) {
                if (bl3 && bS == null && !this.useThreads()) {
                    bl = false;
                    if (f3 == Float.MAX_VALUE) {
                        return;
                    }
                }
                if (this.vwr.rotateAxisAngleAtCenter(this, p3Array[0], v3, f, f3, bl, bS) && this.isJS && bl && bS == null && this.vwr.g.waitForMoveTo && f3 != Float.MAX_VALUE) {
                    throw new ScriptInterruption(this, "rotate", 1);
                }
                return;
            }
            if (n == 0) {
                p3Array[0] = new P3();
            }
            p3Array[1] = P3.newP(p3Array[0]);
            p3Array[1].add(v3);
            n = 2;
        }
        if (n == 0) {
            p3Array[0] = new P3();
        }
        if (n < 2 || p3Array[0].distance(p3Array[1]) == 0.0f) {
            p3Array[1] = P3.newP(p3Array[0]);
            p3Array[1].y = (float)((double)p3Array[1].y + 1.0);
        }
        if (f3 == Float.MAX_VALUE) {
            f3 = 0.0f;
        }
        if (f3 != 0.0f && v32 != null && !bl5) {
            v32.scale(f3 / v32.length());
        }
        if (bl && v32 != null && (f3 == 0.0f || f2 == 0.0f)) {
            f3 = 0.01f;
            f = f2 == Float.MIN_VALUE ? 0.01f : (f2 < 0.0f ? -f3 / f2 : f2 * 0.01f / v32.length());
            f2 = 0.01f;
        }
        if (bS != null && bl && lst2 == null && m4 != null) {
            lst = this.vwr.ms.getAtomPointVector(bS);
            lst2 = Measure.transformPoints(lst, m4, p3Array[0]);
        }
        if (bS != null && !bl && lst2 != null) {
            this.vwr.setAtomCoords(bS, 1145047050, lst2);
        } else {
            if (bl3 && !this.useThreads()) {
                return;
            }
            if (this.vwr.rotateAboutPointsInternal(this, p3Array[0], p3Array[1], f, f3, bl, bS, v32, lst2, fArray, bl6 ? m4 : null) && this.isJS && bl) {
                throw new ScriptInterruption(this, "rotate", 1);
            }
        }
    }

    private void cmdRestore() throws ScriptException {
        if (this.slen > 1) {
            String string = this.optParameterAsString(2);
            int n = this.tokAt(1);
            switch (n) {
                case 1613369372: {
                    if (!this.chk) {
                        this.setCurrentCagePts(null, null);
                    }
                    return;
                }
                case 1073742077: 
                case 1073742132: 
                case 1073742139: {
                    float f;
                    float f2 = f = this.slen > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.invArg();
                    }
                    if (this.chk) {
                        return;
                    }
                    String string2 = "";
                    switch (n) {
                        case 1073742077: {
                            string2 = "Orientation";
                            this.vwr.stm.restoreOrientation(string, f, true);
                            break;
                        }
                        case 1073742132: {
                            string2 = "Rotation";
                            this.vwr.stm.restoreOrientation(string, f, false);
                            break;
                        }
                        case 1073742139: {
                            string2 = "Scene";
                            this.vwr.stm.restoreScene(string, f);
                        }
                    }
                    if (this.isJS && f > 0.0f && this.vwr.g.waitForMoveTo) {
                        throw new ScriptInterruption(this, "restore" + string2, 1);
                    }
                    return;
                }
            }
            this.checkLength23();
            switch (n) {
                case 1677721602: {
                    if (!this.chk) {
                        this.vwr.stm.restoreBonds(string);
                    }
                    return;
                }
                case 14: {
                    if (this.chk) {
                        return;
                    }
                    ScriptContext scriptContext = (ScriptContext)this.vwr.stm.getContext(string);
                    if (scriptContext != null) {
                        this.restoreScriptContext(scriptContext, true, false, false);
                        if (this.thisContext != null) {
                            this.thisContext.setMustResume();
                            this.mustResumeEval = true;
                            this.tQuiet = true;
                        }
                    }
                    return;
                }
                case 1073742329: {
                    if (this.chk) {
                        return;
                    }
                    String string3 = this.vwr.stm.getSavedCoordinates(string);
                    if (string3 == null) {
                        this.invArg();
                    }
                    this.runScript(string3);
                    this.vwr.checkCoordinatesChanged();
                    return;
                }
                case 1073742140: {
                    if (!this.chk) {
                        this.vwr.stm.restoreSelection(string);
                    }
                    return;
                }
                case 1073742158: {
                    if (this.chk) {
                        return;
                    }
                    String string4 = this.vwr.stm.getSavedState(string);
                    if (string4 == null) {
                        this.invArg();
                    }
                    this.runScript(string4);
                    return;
                }
                case 1639976963: {
                    if (this.chk) {
                        return;
                    }
                    String string5 = this.vwr.stm.getSavedStructure(string);
                    if (string5 == null) {
                        this.invArg();
                    }
                    this.runScript(string5);
                    return;
                }
            }
        }
        this.errorStr2(53, "RESTORE", saveList);
    }

    private void cmdSave() throws ScriptException {
        if (this.slen > 1) {
            String string = this.optParameterAsString(2);
            switch (this.tokAt(1)) {
                case 1677721602: {
                    if (!this.chk) {
                        this.vwr.stm.saveBonds(string);
                    }
                    return;
                }
                case 14: {
                    if (!this.chk) {
                        this.saveContext(string);
                    }
                    return;
                }
                case 1073742329: {
                    if (!this.chk) {
                        this.vwr.stm.saveCoordinates(string, this.vwr.bsA());
                    }
                    return;
                }
                case 1073742077: 
                case 1073742132: {
                    if (!this.chk) {
                        this.vwr.stm.saveOrientation(string, null);
                    }
                    return;
                }
                case 1073742140: {
                    if (!this.chk) {
                        this.vwr.stm.saveSelection(string, this.vwr.bsA());
                        this.vwr.stm.restoreSelection(string);
                    }
                    return;
                }
                case 1073742158: {
                    if (!this.chk) {
                        this.vwr.stm.saveState(string);
                    }
                    return;
                }
                case 1639976963: {
                    if (!this.chk) {
                        this.vwr.stm.saveStructure(string);
                    }
                    return;
                }
            }
        }
        this.errorStr2(53, "SAVE", saveList);
    }

    public void cmdScript(int n, String string, String string2) throws ScriptException {
        if (n == 134238732) {
            this.checkLength(2);
            if (!this.chk) {
                this.vwr.jsEval(this.paramAsStr(1));
            }
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = this.vwr.async;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Lst<SV> lst = null;
        if (n == 4124) {
            n6 = -2;
        }
        if (string == null && string2 == null) {
            n = this.tokAt(n6);
            if (n != 4) {
                this.error(16);
            }
            if ((string = this.paramAsStr(n6)).equalsIgnoreCase("async")) {
                bl4 = true;
                string = this.paramAsStr(++n6);
            }
            if (string.equalsIgnoreCase("applet")) {
                String string6 = this.paramAsStr(++n6);
                string2 = this.parameterExpressionString(++n6, 0);
                this.checkLast(this.iToken);
                if (this.chk) {
                    return;
                }
                if (string6.length() == 0 || string6.equals("all")) {
                    string6 = "*";
                }
                if (!string6.equals(".")) {
                    this.vwr.jsEval(string6 + "\u0001" + string2);
                    if (!string6.equals("*")) {
                        return;
                    }
                }
            } else {
                n = this.tokAt(this.slen - 1);
                boolean bl5 = bl3 = n == 266298;
                if (string.equalsIgnoreCase("inline")) {
                    string2 = this.parameterExpressionString(++n6, bl3 ? this.slen - 1 : 0);
                    n6 = this.iToken;
                }
                while (string.equalsIgnoreCase("localPath") || string.equalsIgnoreCase("remotePath") || string.equalsIgnoreCase("scriptPath")) {
                    if (string.equalsIgnoreCase("localPath")) {
                        string3 = this.paramAsStr(++n6);
                    } else if (string.equalsIgnoreCase("scriptPath")) {
                        string5 = this.paramAsStr(++n6);
                    } else {
                        string4 = this.paramAsStr(++n6);
                    }
                    string = this.paramAsStr(++n6);
                }
                if ((this.vwr.isJS || this.vwr.testAsync) && (bl4 || string.startsWith("?"))) {
                    string = this.loadFileAsync("SCRIPT_", string, n6, true);
                }
                if ((n = this.tokAt(++n6)) == 1073741878) {
                    bl2 = true;
                    n = this.tokAt(++n6);
                }
                if (n == 1073742050) {
                    bl = false;
                    n = this.tokAt(++n6);
                }
                if (n == 1073741998 || n == 0x44000004) {
                    int n7 = ++n6;
                    n4 = n2 = Math.max(this.intParameter(n7), 0);
                    if (this.checkToken(++n6) && (n4 = this.getToken((int)n6).tok == 0x100000A0 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                        this.invArg();
                    }
                } else if (n == 0x40000042 || n == 0x40000044) {
                    int n8 = ++n6;
                    n3 = Math.max(this.intParameter(n8) - 1, 0);
                    n5 = n3 + 1;
                    if (this.checkToken(++n6) && (n5 = this.getToken((int)n6).tok == 0x100000A0 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                        this.invArg();
                    }
                }
                n6 = -n6;
            }
        } else if (string != null && bl4) {
            string = this.loadFileAsync("SCRIPT_", string, n6, true);
        }
        if (n6 < 0) {
            if (this.tokAt(n6 = -n6) == 0x10000010) {
                lst = this.parameterExpressionList(n6, -1, false);
                n6 = this.iToken + 1;
            }
            this.checkLength(bl3 ? n6 + 1 : n6);
        }
        if (this.chk && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        if (this.isCmdLine_c_or_C_Option) {
            bl2 = true;
        }
        boolean bl6 = this.chk;
        boolean bl7 = this.isCmdLine_c_or_C_Option;
        if (bl2) {
            this.isCmdLine_c_or_C_Option = true;
            this.chk = true;
        }
        this.pushContext(null, "SCRIPT");
        this.contextPath = this.contextPath + " >> " + string;
        if (string2 == null ? this.compileScriptFileInternal(string, string3, string4, string5) : this.compileScript(null, string2, false)) {
            boolean bl8;
            this.pcEnd = n5;
            this.lineEnd = n4;
            while (n3 < this.lineNumbers.length && this.lineNumbers[n3] < n2) {
                ++n3;
            }
            this.pc = n3;
            boolean bl9 = this.isCmdLine_C_Option;
            this.isCmdLine_C_Option &= bl;
            this.executionStepping |= bl3;
            if (this.contextVariables == null) {
                this.contextVariables = new Hashtable();
            }
            this.contextVariables.put("_arguments", lst == null ? SV.getVariableAI(new int[0]) : SV.getVariableList(lst));
            this.contextVariables.put("_argcount", SV.newI(lst == null ? 0 : lst.size()));
            if (bl2) {
                this.listCommands = true;
            }
            if (bl8 = this.vwr.getBoolean(603979934)) {
                Logger.startTimer("script");
            }
            this.dispatchCommands(false, false, false);
            if (this.isStateScript) {
                ScriptManager.setStateScriptVersion(this.vwr, null);
            }
            if (bl8) {
                this.showString(Logger.getTimerMsg("script", 0));
            }
            this.isCmdLine_C_Option = bl9;
            this.popContext(false, false);
        } else {
            Logger.error(GT._("script ERROR: ") + this.errorMessage);
            this.popContext(false, false);
            if (bl7) {
                this.setErrorMessage(null);
            } else {
                this.evalError(null, null);
            }
        }
        this.chk = bl6;
        this.isCmdLine_c_or_C_Option = bl7;
    }

    private void cmdSelect(int n) throws ScriptException {
        Object object;
        if (this.slen == 1) {
            this.vwr.select(null, false, 0, !this.doReport());
            return;
        }
        if (this.slen == 2 && this.tokAt(1) == 1073742072) {
            return;
        }
        int n2 = this.tokAt(2);
        this.vwr.slm.noneSelected = this.slen == 4 && n2 == 1073742333;
        Object object2 = null;
        switch (n2) {
            case 10: {
                if (!(this.getToken((int)2).value instanceof BondSet) && (this.tokAt(2) != 1677721602 || this.getToken((int)3).tok != 10)) break;
                if (this.slen != this.iToken + 2) {
                    this.invArg();
                }
                if (!this.chk) {
                    this.vwr.selectBonds((BS)this.theToken.value);
                }
                return;
            }
            case 1677721602: 
            case 1745489933: {
                if (this.slen == 5 && this.tokAt(3) == 10) {
                    object2 = (BS)this.getToken((int)3).value;
                    ++this.iToken;
                } else if (this.isArrayParameter(4)) {
                    object2 = new BS();
                    int[] nArray = this.expandFloatArray(this.floatParameterSet(4, 0, Integer.MAX_VALUE), 0);
                    int n3 = nArray.length;
                    while (--n3 >= 0) {
                        if (nArray[n3] < 0) continue;
                        ((BS)object2).set(nArray[n3]);
                    }
                }
                this.checkLast(this.iToken);
                if (this.chk) {
                    return;
                }
                if (object2 == null) {
                    this.invArg();
                }
                if (n2 == 1745489933) {
                    this.setShapeProperty(6, "select", object2);
                } else {
                    this.vwr.selectBonds((BS)object2);
                }
                return;
            }
        }
        int n4 = 0;
        boolean bl = false;
        if (this.getToken((int)1).intValue == 0 && this.theTok != 1073742334) {
            object = this.parameterExpressionToken((int)0).value;
            if (!(object instanceof BS)) {
                this.invArg();
            }
            this.checkLast(this.iToken);
            object2 = (BS)object;
        } else {
            n2 = this.tokAt(n);
            switch (n2) {
                case 1073742334: 
                case 1073742335: {
                    if (!this.chk) {
                        this.vwr.setSelectionHalosEnabled(n2 == 1073742335);
                    }
                    if ((n2 = this.tokAt(++n)) != 0) break;
                    return;
                }
            }
            switch (n2) {
                case 1073742119: 
                case 1275069441: {
                    n4 = n2;
                    n2 = this.tokAt(++n);
                }
            }
            boolean bl2 = bl = n2 == 1086324742;
            if (bl) {
                n2 = this.tokAt(++n);
            }
            object2 = this.atomExpressionAt(n);
        }
        if (this.chk) {
            return;
        }
        if (this.isBondSet) {
            this.vwr.selectBonds((BS)object2);
        } else {
            if (((BS)object2).length() > this.vwr.ms.ac) {
                object = this.vwr.getAllAtoms();
                ((BS)object).and((BS)object2);
                object2 = object;
            }
            this.vwr.select((BS)object2, bl, n4, !this.doReport());
        }
    }

    private void cmdSelectionHalos(int n) throws ScriptException {
        boolean bl = false;
        switch (n == this.slen ? 1073742335 : this.getToken((int)n).tok) {
            case 1073742335: 
            case 1113589787: {
                bl = true;
            }
            case 1073742056: 
            case 1073742333: 
            case 1073742334: {
                this.setBooleanProperty("selectionHalos", bl);
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    private void cmdSet() throws ScriptException {
        boolean bl;
        String string;
        if (this.slen == 1) {
            this.showString(this.vwr.getAllSettings(null));
            return;
        }
        boolean bl2 = this.paramAsStr(0).equals("set");
        String string2 = this.optParameterAsString(1);
        if (bl2 && this.slen == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.vwr.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        int n = this.getToken((int)1).tok;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        boolean bl3 = !this.chk && this.doReport() && !((String)this.st[0].value).equals("var");
        switch (n) {
            case 553648148: 
            case 603979868: 
            case 603979902: 
            case 603979924: 
            case 603979960: 
            case 603979962: 
            case 603979964: 
            case 603979965: 
            case 603979970: {
                if (!this.isStateScript) break;
                return;
            }
            case 1611272194: {
                this.cmdAxes(2);
                return;
            }
            case 1610616835: {
                this.cmdBackground(2);
                return;
            }
            case 1678381065: {
                this.cmdBoundbox(2);
                return;
            }
            case 1611272202: {
                this.cmdFrank(2);
                return;
            }
            case 1610616855: {
                this.cmdHistory(2);
                return;
            }
            case 1825200140: {
                this.cmdLabel(2);
                return;
            }
            case 1613369372: {
                this.cmdUnitcell(2);
                return;
            }
            case 0x20000008: {
                this.sm.loadShape(8);
                this.setShapeProperty(8, "highlight", this.tokAt(2) == 1073742334 ? null : this.atomExpressionAt(2));
                return;
            }
            case 1610625028: 
            case 1611141171: {
                this.cmdSelectionHalos(2);
                return;
            }
            case 536875070: {
                this.cmdTimeout(2);
                return;
            }
            case 1639976963: {
                float[] fArray;
                STR sTR = STR.getProteinStructureType(this.paramAsStr(2));
                if (sTR == STR.NOT) {
                    this.invArg();
                }
                if ((fArray = this.floatParameterSet(3, 0, Integer.MAX_VALUE)).length % 4 != 0) {
                    this.invArg();
                }
                this.vwr.setStructureList(fArray, sTR);
                this.checkLast(this.iToken);
                return;
            }
            case 545259526: {
                n3 = this.getArgbParam(2);
                if (!this.chk) {
                    this.setObjectArgb("axes", n3);
                }
                return;
            }
            case 0x60000001: {
                boolean bl4 = false;
                switch (this.getToken((int)this.checkLast((int)2)).tok) {
                    case 0x10000060: {
                        break;
                    }
                    case 0x10000050: {
                        bl4 = true;
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                this.setBooleanProperty("bondModeOr", bl4);
                return;
            }
            case 0x20000004: {
                if (this.chk) {
                    return;
                }
                int n4 = this.tokAt(2) == 1073742334 || this.tokAt(2) == 2 && this.intParameter(2) == 0 ? 4 : 5;
                Logger.setLogLevel(n4);
                this.setIntProperty("logLevel", n4);
                if (n4 == 4) {
                    this.vwr.setDebugScript(false);
                    if (bl3) {
                        this.vwr.showParameter("debugScript", true, 80);
                    }
                }
                this.setDebugging();
                if (bl3) {
                    this.vwr.showParameter("logLevel", true, 80);
                }
                return;
            }
            case 537022465: {
                this.cmdSetEcho();
                return;
            }
            case 0x60000002: {
                this.cmdFont(5, this.checkLength23() == 2 ? 0.0f : this.floatParameter(2));
                return;
            }
            case 1613238294: {
                boolean bl5 = false;
                switch (this.tokAt(this.checkLast(2))) {
                    case 1114249217: {
                        bl5 = true;
                    }
                    case 2097178: {
                        this.setBooleanProperty("hbondsBackbone", bl5);
                        break;
                    }
                    case 1073742150: {
                        bl5 = true;
                    }
                    case 0x40000066: {
                        this.setBooleanProperty("hbondsSolid", bl5);
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                return;
            }
            case 0x20021010: 
            case 1745489933: {
                n = this.tokAt(this.checkLast(2));
                switch (n) {
                    case 1073742334: 
                    case 1073742335: {
                        this.setBooleanProperty("measurementlabels", n == 1073742335);
                        return;
                    }
                    case 2: 
                    case 3: 
                    case 0x40000066: {
                        this.vwr.shm.loadShape(6);
                        int n5 = this.getSetAxesTypeMad(2);
                        if (n5 != Integer.MAX_VALUE) {
                            this.setShapeSizeBs(6, n5, null);
                        }
                        return;
                    }
                }
                this.setUnits(this.paramAsStr(2), 545259568);
                return;
            }
            case 1611141176: {
                boolean bl6 = false;
                switch (this.tokAt(this.checkLast(2))) {
                    case 1114249217: {
                        bl6 = true;
                        break;
                    }
                    case 2097178: {
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                this.setBooleanProperty("ssbondsBackbone", bl6);
                return;
            }
            case 0x60000005: {
                this.cmdSetLabel("toggle");
                return;
            }
            case 0x20000012: {
                int n6;
                Lst<Integer> lst = new Lst<Integer>();
                for (n6 = 2; n6 < this.slen; ++n6) {
                    int n7 = this.getArgbParam(n6);
                    lst.addLast(n7);
                    n6 = this.iToken;
                }
                if (this.chk) {
                    return;
                }
                n6 = lst.size();
                int[] nArray = new int[n6];
                int n8 = n6;
                while (--n8 >= 0) {
                    nArray[n8] = (Integer)lst.get(n8);
                }
                this.vwr.cm.ce.setUserScale(nArray);
                return;
            }
            case 553648188: {
                P3 p3;
                if (this.isFloatParameter(2)) {
                    this.checkLength(3);
                    this.setIntProperty("zSlab", (int)this.floatParameter(2));
                    p3 = null;
                } else {
                    if (!this.isCenterParameter(2)) {
                        this.invArg();
                    }
                    p3 = this.centerParameter(2, null);
                    this.checkLength(this.iToken + 1);
                }
                if (!this.chk) {
                    this.vwr.tm.zSlabPoint = p3 == null ? null : P3.newP(p3);
                }
                return;
            }
        }
        boolean bl7 = true;
        switch (n) {
            case 0x20000002: {
                int n9;
                if (this.slen <= 2) break;
                String string3 = this.getSettingStr(2, false);
                boolean bl8 = false;
                if (string3.indexOf(".") < 0) {
                    n9 = PT.parseInt(string3);
                    bl8 = true;
                } else {
                    n9 = ScriptEval.getFloatEncodedInt(string3);
                }
                if (this.chk) {
                    return;
                }
                int n10 = this.vwr.ms.getModelNumberIndex(n9, bl8, true);
                this.vwr.setBackgroundModelIndex(n10);
                return;
            }
            case 1648363544: {
                if (this.chk) {
                    return;
                }
                this.vwr.setAtomProperty(this.vwr.getAllAtoms(), 1648363544, -1, Float.NaN, null, null, null);
                if (this.slen > 2 && "probe".equalsIgnoreCase(this.getSettingStr(2, false))) {
                    this.runScript("#VDW radii for PROBE;{_H}.vdw = 1.0;{_H and connected(_C) and not connected(within(smiles,'[a]'))}.vdw = 1.17;{_C}.vdw = 1.75;{_C and connected(3) and connected(_O)}.vdw = 1.65;{_N}.vdw = 1.55;{_O}.vdw = 1.4;{_P}.vdw = 1.8;{_S}.vdw = 1.8;message VDW radii for H, C, N, O, P, and S set according to Word, et al., J. Mol. Biol. (1999) 285, 1711-1733");
                    return;
                }
                n2 = 545259555;
            }
            case 545259555: {
                if (this.slen <= 2) break;
                string = this.paramAsStr(2);
                if (this.slen == 3 && VDW.getVdwType(string) == null && VDW.getVdwType(string = this.getSettingStr(2, false)) == null) {
                    this.invArg();
                }
                this.setStringProperty(string2, string);
                break;
            }
            case 0x20000006: {
                P3 p3;
                if (this.slen <= 2) break;
                SV sV = this.parameterExpressionToken(2);
                if (sV.tok == 8) {
                    p3 = (P3)sV.value;
                } else {
                    p3 = new P3();
                    int n11 = sV.asInt();
                    if (n11 >= 100) {
                        SimpleUnitCell.ijkToPoint3f(n11, p3, -1);
                    }
                }
                if (this.chk) break;
                this.vwr.setDefaultLattice(p3);
                break;
            }
            case 545259545: 
            case 0x20800020: {
                if (this.slen <= 2) break;
                this.theTok = this.tokAt(2);
                string = this.theTok == 1073741991 || this.theTok == 1073742116 ? this.paramAsStr(this.checkLast(2)) : this.getSettingStr(2, false);
                this.setStringProperty(string2, string);
                break;
            }
            case 1631586315: {
                n3 = this.getSettingInt(2);
                if (n3 == Integer.MIN_VALUE) {
                    this.invArg();
                }
                if (!this.chk) {
                    this.vwr.ms.setFormalCharges(this.vwr.bsA(), n3);
                }
                return;
            }
            case 545259564: {
                if (this.slen <= 2) break;
                this.setStringProperty(string2, this.getSettingStr(2, bl2));
                break;
            }
            case 545259559: 
            case 545259568: {
                if (this.slen <= 2) break;
                this.setUnits(this.getSettingStr(2, bl2), n);
                break;
            }
            case 545259572: {
                if (!this.chk) {
                    this.vwr.setPicked(-1);
                }
                if (this.slen <= 2) break;
                this.cmdSetPicking();
                return;
            }
            case 545259574: {
                if (this.slen <= 2) break;
                this.cmdSetPickingStyle();
                return;
            }
            case 1715472409: {
                break;
            }
            case 0x2000000C: {
                n3 = this.getSettingInt(2);
                if (n3 == Integer.MIN_VALUE || n3 == 0 || n3 == 1) {
                    bl7 = false;
                    break;
                }
                n = 553648174;
                string2 = "specularPercent";
                this.setIntProperty(string2, n3);
                break;
            }
            case 1649022989: {
                n = 553648178;
                string2 = "strandCount";
                this.setIntProperty(string2, this.getSettingInt(2));
                break;
            }
            default: {
                bl7 = false;
            }
        }
        if (bl7 && !bl3) {
            return;
        }
        boolean bl9 = bl = !bl7 && !bl2 && this.getContextVariableAsVariable(string2, false) != null;
        if (!bl7 && !bl) {
            switch (n) {
                case 1677721602: {
                    n2 = 603979928;
                    break;
                }
                case 0x60200006: {
                    n2 = 603979908;
                    break;
                }
                case 1612709900: {
                    n2 = 603979910;
                    break;
                }
                case 0x60000003: {
                    n2 = 603979879;
                    break;
                }
                case 1665140738: {
                    n2 = 0x22000032;
                    this.setFloatProperty("solventProbeRadius", this.getSettingFloat(2));
                    bl7 = true;
                    break;
                }
                case 0x60000004: {
                    n2 = 0x2200002E;
                    break;
                }
                case 1612709912: {
                    n2 = 603979948;
                    break;
                }
                case 1765808132: {
                    n2 = 545259545;
                    break;
                }
                case 1611141175: {
                    string = this.paramAsStr(2).toLowerCase();
                    switch ("x;y;z;fps".indexOf(string + ";")) {
                        case 0: {
                            n2 = 570425398;
                            break;
                        }
                        case 2: {
                            n2 = 570425400;
                            break;
                        }
                        case 4: {
                            n2 = 570425402;
                            break;
                        }
                        case 6: {
                            n2 = 570425396;
                            break;
                        }
                        default: {
                            this.errorStr2(50, "set SPIN ", string);
                        }
                    }
                    if (!this.chk) {
                        this.vwr.setSpin(string, (int)this.floatParameter(this.checkLast(3)));
                    }
                    bl7 = true;
                }
            }
        }
        if (n2 != 0) {
            n = n2;
            string2 = T.nameOf(n);
        } else if (!bl7 && !bl) {
            String string4;
            if (string2.length() == 0 || string2.charAt(0) == '_' && this.tokAt(2) != 0x10000040) {
                this.error(56);
            }
            if ((string4 = string2.toLowerCase()).indexOf("label") == 0 && PT.isOneOf(string4.substring(5), ";front;group;atom;offset;offsetexact;offsetabsolute;pointer;alignment;toggle;scalereference;") && this.cmdSetLabel(string4.substring(5))) {
                return;
            }
            if (bl2 && string4.indexOf("shift_") == 0) {
                float f = this.floatParameter(2);
                this.checkLength(3);
                if (!this.chk) {
                    this.vwr.getNMRCalculation().setChemicalShiftReference(string4.substring(6), f);
                }
                return;
            }
            if (string4.endsWith("callback")) {
                n = 0x20000000;
            }
        }
        if (bl2 && !T.tokAttr(n, 0x20000000)) {
            this.iToken = 1;
            if (!this.isStateScript) {
                this.errorStr2(50, "SET", string2);
            }
            this.warning(51, "SET", string2);
        }
        if (!bl7 && bl2) {
            switch (this.slen) {
                case 2: {
                    this.setBooleanProperty(string2, true);
                    bl7 = true;
                    break;
                }
                case 3: {
                    if (n3 == Integer.MAX_VALUE) break;
                    this.setIntProperty(string2, n3);
                    bl7 = true;
                }
            }
        }
        if (!bl7 && !bl2 && this.tokAt(2) == 1073742333) {
            if (!this.chk) {
                this.vwr.removeUserVariable(string2.toLowerCase());
            }
            bl7 = true;
        }
        if (!bl7) {
            this.setVariable(1, 0, string2, true);
            if (!bl2) {
                return;
            }
        }
        if (bl3) {
            this.vwr.showParameter(string2, true, 80);
        }
    }

    private void cmdSetEcho() throws ScriptException {
        String string = null;
        Object object = null;
        Object object2 = null;
        boolean bl = true;
        int n = 2;
        switch (this.getToken((int)2).tok) {
            case 1073742334: {
                string = "allOff";
                object2 = "allOff";
                this.checkLength(++n);
                break;
            }
            case 1073742333: {
                bl = false;
            }
            case 1073742327: {
                object2 = this.paramAsStr(2);
                this.checkLength(++n);
                break;
            }
            case 4: 
            case 12289: 
            case 0x40000000: 
            case 1073741871: 
            case 1073741974: 
            case 1073741996: 
            case 1073742019: 
            case 1073742126: 
            case 1073742172: {
                if (this.theTok == 1073741974) {
                    // empty if block
                }
                int n2 = ++n;
                ++n;
                object2 = this.paramAsStr(n2);
            }
        }
        if (!this.chk) {
            this.vwr.ms.setEchoStateActive(bl);
            this.sm.loadShape(31);
            if (object2 != null) {
                this.setShapeProperty(31, string == null ? "target" : string, object2);
            }
        }
        if (n < this.slen) {
            block6 : switch (this.getToken((int)n++).tok) {
                case 0x40000008: {
                    string = "align";
                    switch (this.getToken((int)n).tok) {
                        case 12289: 
                        case 1073741996: 
                        case 1073742126: {
                            object = this.paramAsStr(n++);
                            break block6;
                        }
                    }
                    this.invArg();
                    break;
                }
                case 12289: 
                case 1073741996: 
                case 1073742126: {
                    string = "align";
                    object = this.paramAsStr(n - 1);
                    break;
                }
                case 554176526: {
                    string = "%zpos";
                    object = (int)this.floatParameter(n++);
                    break;
                }
                case 0x200028: 
                case 1073742335: 
                case 1610625028: {
                    string = "hidden";
                    object = Boolean.FALSE;
                    break;
                }
                case 12294: 
                case 0x20002A: {
                    string = "hidden";
                    object = Boolean.TRUE;
                    break;
                }
                case 1094717454: {
                    int n3;
                    int n4 = n3 = this.chk ? 0 : this.modelNumberParameter(n++);
                    if (n3 >= this.vwr.ms.mc) {
                        this.invArg();
                    }
                    string = "model";
                    object = n3;
                    break;
                }
                case 0x10000040: 
                case 1073742195: {
                    string = "xypos";
                    object = this.xypParameter(--n);
                    if (object == null) {
                        this.invArg();
                    }
                    n = this.iToken + 1;
                    break;
                }
                case 2: {
                    int n5 = this.intParameter(n - 1);
                    String string2 = "xpos";
                    if (this.tokAt(n) == 268435634) {
                        string2 = "%xpos";
                    }
                    string = "ypos";
                    int n6 = ++n;
                    object = this.intParameter(n6);
                    if (this.tokAt(++n) == 268435634) {
                        string = "%ypos";
                        ++n;
                    }
                    this.checkLength(n);
                    this.setShapeProperty(31, string2, n5);
                    break;
                }
                case 1073742334: {
                    string = "off";
                    break;
                }
                case 1073742138: {
                    string = "scale";
                    object = Float.valueOf(this.floatParameter(n++));
                    break;
                }
                case 134222853: {
                    string = "script";
                    object = this.paramAsStr(n++);
                    break;
                }
                case 4120: {
                    ++n;
                }
                case 4: {
                    boolean bl2 = this.theTok != 4;
                    this.checkLength(n--);
                    if (bl2) {
                        if (object2 == null) {
                            Object[] objectArray = new String[1];
                            this.getShapePropertyData(31, "currentTarget", objectArray);
                            object2 = objectArray[0];
                        }
                        if (!this.chk && this.vwr.ms.getEchoStateActive() && this.vwr.fm.loadImage(this.getToken((int)n).value, (String)object2, !this.useThreads())) {
                            throw new ScriptInterruption(this, "setEchoImage", 1);
                        }
                        return;
                    }
                    this.cmdEcho(n);
                    return;
                }
                case 0x8000010: {
                    string = "point";
                    object = this.isCenterParameter(n) ? this.centerParameter(n, null) : null;
                    n = this.iToken + 1;
                    break;
                }
                default: {
                    if (this.isCenterParameter(n - 1)) {
                        string = "xyz";
                        object = this.centerParameter(n - 1, null);
                        n = this.iToken + 1;
                        break;
                    }
                    this.invArg();
                }
            }
        }
        this.checkLength(n);
        if (!this.chk && string != null) {
            this.setShapeProperty(31, string, object);
        }
    }

    private boolean cmdSetLabel(String string) throws ScriptException {
        this.sm.loadShape(5);
        Object object = null;
        this.setShapeProperty(5, "setDefaults", this.vwr.slm.noneSelected);
        if (string.equals("scalereference")) {
            float f = this.floatParameter(2);
            if (f >= 5.0f) {
                f = this.vwr.tm.getZoomSetting() / f / this.vwr.getScalePixelsPerAngstrom(false);
            }
            object = Float.valueOf(f);
        } else {
            boolean bl = false;
            if (string.equals("offset") || (bl = string.equals("offsetabsolute") || string.equals("offsetexact"))) {
                string = "offset";
                if (this.isPoint3f(2)) {
                    P3 p3 = this.getPoint3f(2, false);
                    object = new float[]{-1.0f, p3.x, p3.y, p3.z, 0.0f, 0.0f, 0.0f};
                } else if (this.isArrayParameter(2)) {
                    object = this.floatParameterSet(2, 7, 7);
                } else {
                    int n = this.intParameterRange(2, -500, 500);
                    int n2 = this.intParameterRange(3, -500, 500);
                    if (n == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE) {
                        return true;
                    }
                    object = JC.getOffset(n, n2, bl);
                }
            } else if (string.equals("alignment")) {
                switch (this.getToken((int)2).tok) {
                    case 12289: 
                    case 1073741996: 
                    case 1073742126: {
                        string = "align";
                        object = this.theToken.value;
                        break;
                    }
                    default: {
                        this.invArg();
                        break;
                    }
                }
            } else if (string.equals("pointer")) {
                int n = 0;
                switch (this.getToken((int)2).tok) {
                    case 1073742333: 
                    case 1073742334: {
                        break;
                    }
                    case 1610616835: {
                        n |= 2;
                    }
                    case 1073742335: {
                        n |= 1;
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                object = n;
            } else {
                boolean bl2;
                if (string.equals("toggle")) {
                    this.iToken = 1;
                    BS bS = this.slen == 2 ? this.vwr.bsA() : this.atomExpressionAt(2);
                    this.checkLast(this.iToken);
                    if (this.chk) {
                        return true;
                    }
                    this.vwr.shm.loadShape(5);
                    this.vwr.shm.setShapePropertyBs(5, "toggleLabel", null, bS);
                    return true;
                }
                this.iToken = 1;
                boolean bl3 = bl2 = this.slen == 2 || this.getToken((int)2).tok == 1073742335;
                if (string.equals("front") || string.equals("group")) {
                    if (!bl2 && this.tokAt(2) != 1073742334) {
                        this.invArg();
                    }
                    if (!bl2) {
                        string = "front";
                    }
                    object = bl2 ? Boolean.TRUE : Boolean.FALSE;
                } else if (string.equals("atom")) {
                    if (!bl2 && this.tokAt(2) != 1073742334) {
                        this.invArg();
                    }
                    string = "front";
                    object = bl2 ? Boolean.FALSE : Boolean.TRUE;
                } else {
                    return false;
                }
            }
        }
        BS bS = this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null;
        this.checkLast(this.iToken);
        if (this.chk) {
            return true;
        }
        if (bS == null) {
            this.setShapeProperty(5, string, object);
        } else {
            this.setShapePropertyBs(5, string, object, bS);
        }
        return true;
    }

    private void cmdSetPicking() throws ScriptException {
        if (this.slen == 2) {
            this.setStringProperty("picking", "identify");
            return;
        }
        if (this.slen > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("picking", this.getSettingStr(2, false));
            return;
        }
        int n = 2;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 1275082245: 
            case 1611141175: 
            case 1745489933: {
                if (this.checkLength34() != 4) break;
                string = this.paramAsStr(2).toUpperCase();
                if (string.equals("SPIN")) {
                    this.setIntProperty("pickingSpinRate", this.intParameter(3));
                    break;
                }
                n = 3;
                break;
            }
            case 12291: {
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.paramAsStr(n);
        switch (this.getToken((int)n).tok) {
            case 1073742056: 
            case 1073742335: {
                string2 = "identify";
                break;
            }
            case 1073742333: 
            case 1073742334: {
                string2 = "off";
                break;
            }
            case 1275082245: {
                string2 = "atom";
                break;
            }
            case 1825200140: {
                string2 = "label";
                break;
            }
            case 1677721602: {
                string2 = "bond";
                break;
            }
            case 12291: {
                this.checkLength(4);
                if (this.tokAt(3) != 1677721602) {
                    this.invArg();
                }
                string2 = "deleteBond";
            }
        }
        int n2 = string2.indexOf("_");
        n2 = n2 >= 0 ? n2 : string2.length();
        n2 = ActionManager.getPickingMode(string2.substring(0, n2));
        if (n2 < 0) {
            this.errorStr2(50, "SET PICKING " + string, string2);
        }
        this.setStringProperty("picking", string2);
    }

    private void cmdSetPickingStyle() throws ScriptException {
        if (this.slen > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("pickingStyle", this.getSettingStr(2, false));
            return;
        }
        int n = 2;
        boolean bl = false;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 1745489933: {
                bl = true;
                string = "MEASURE";
            }
            case 1275082245: {
                if (this.checkLength34() != 4) break;
                n = 3;
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.paramAsStr(n);
        switch (this.getToken((int)n).tok) {
            case 1073742333: 
            case 1073742334: {
                string2 = bl ? "measureoff" : "toggle";
                break;
            }
            case 1073742335: {
                if (!bl) break;
                string2 = "measure";
            }
        }
        if (ActionManager.getPickingStyleIndex(string2) < 0) {
            this.errorStr2(50, "SET PICKINGSTYLE " + string, string2);
        }
        this.setStringProperty("pickingStyle", string2);
    }

    private void cmdSlab(boolean bl) throws ScriptException {
        boolean bl2 = false;
        P4 p4 = null;
        if (this.isCenterParameter(1) || this.tokAt(1) == 9) {
            p4 = this.planeParameter(1);
        } else {
            block0 : switch (this.getToken((int)1).tok) {
                case 2: {
                    int n = this.intParameter(this.checkLast(1));
                    if (!this.chk) {
                        if (bl) {
                            this.vwr.tm.depthToPercent(n);
                        } else {
                            this.vwr.tm.slabToPercent(n);
                        }
                    }
                    return;
                }
                case 1073742335: {
                    this.checkLength(2);
                    bl2 = true;
                }
                case 1073742334: {
                    this.checkLength(2);
                    this.setBooleanProperty("slabEnabled", bl2);
                    return;
                }
                case 4141: {
                    this.checkLength(2);
                    if (this.chk) {
                        return;
                    }
                    this.vwr.tm.slabReset();
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 36867: {
                    this.checkLength(2);
                    if (this.chk) {
                        return;
                    }
                    this.vwr.tm.setSlabDepthInternal(bl);
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 0x100000A0: {
                    String string = this.paramAsStr(2);
                    if (string.equalsIgnoreCase("hkl")) {
                        p4 = this.hklParameter(3);
                    } else if (string.equalsIgnoreCase("plane")) {
                        p4 = this.planeParameter(2);
                    }
                    if (p4 == null) {
                        this.invArg();
                    }
                    p4.scale4(-1.0f);
                    break;
                }
                case 0x800000F: {
                    switch (this.getToken((int)2).tok) {
                        case 1073742333: {
                            break block0;
                        }
                    }
                    p4 = this.planeParameter(1);
                    break;
                }
                case 134219265: {
                    p4 = this.getToken((int)2).tok == 1073742333 ? null : this.hklParameter(2);
                    break;
                }
                case 1073742118: {
                    return;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (!this.chk) {
            this.vwr.tm.slabInternal(p4, bl);
        }
    }

    private void cmdSsbond() throws ScriptException {
        int n = this.getMadParameter();
        if (n == Integer.MAX_VALUE) {
            return;
        }
        this.setShapeProperty(1, "type", 256);
        this.setShapeSizeBs(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void cmdStructure() throws ScriptException {
        STR sTR = STR.getProteinStructureType(this.paramAsStr(1));
        if (sTR == STR.NOT) {
            this.invArg();
        }
        BS bS = null;
        switch (this.tokAt(2)) {
            case 10: 
            case 1073742325: {
                bS = this.atomExpressionAt(2);
                this.checkLast(this.iToken);
                break;
            }
            default: {
                this.checkLength(2);
            }
        }
        if (this.chk) {
            return;
        }
        this.clearDefinedVariableAtomSets();
        this.vwr.setProteinType(sTR, bS);
    }

    private void cmdSubset() throws ScriptException {
        BS bS = null;
        if (!this.chk) {
            this.vwr.slm.setSelectionSubset(null);
        }
        if (!(this.slen == 1 || this.slen == 4 && this.getToken((int)2).value.equals("off"))) {
            bS = this.atomExpressionAt(1);
        }
        if (!this.chk) {
            this.vwr.slm.setSelectionSubset(bS);
        }
    }

    private void cmdSync() throws ScriptException {
        String string = "";
        String string2 = "";
        int n = PT.parseInt(this.optParameterAsString(1));
        if (n == Integer.MIN_VALUE) {
            this.checkLength(-3);
            n = 0;
            switch (this.slen) {
                case 1: {
                    string2 = "*";
                    string = "ON";
                    break;
                }
                case 2: {
                    string2 = this.paramAsStr(1);
                    if (string2.indexOf("jmolApplet") == 0 || PT.isOneOf(string2, ";*;.;^;")) {
                        string = "ON";
                        if (!this.chk) {
                            this.vwr.syncScript(string, string2, 0);
                        }
                        string2 = ".";
                        break;
                    }
                    string = string2;
                    string2 = "*";
                    break;
                }
                case 3: {
                    string2 = this.paramAsStr(1);
                    string = this.tokAt(2) == 528443 ? "GET_GRAPHICS" : this.paramAsStr(2);
                }
            }
        } else {
            SV sV = null;
            if (this.slen > 2 && (sV = this.setVariable(2, -1, "", false)) == null) {
                return;
            }
            string = this.slen == 2 ? null : (sV.tok == 6 ? sV.toJSON() : sV.asString());
            string2 = null;
        }
        if (this.chk) {
            return;
        }
        this.vwr.syncScript(string, string2, n);
    }

    private void cmdThrow() throws ScriptException {
        if (this.chk) {
            return;
        }
        int n = this.tokAt(1) == 14 ? 2 : 1;
        SV sV = n == 1 ? this.setVariable(1, this.slen, "thrown_value", false) : this.vwr.g.setUserVariable("thrown_value", SV.newS(this.optParameterAsString(2)));
        String string = sV.asString();
        if (string.length() == 0 && (string = this.optParameterAsString(1)).length() == 0) {
            string = "context";
        }
        if (n == 2) {
            this.saveContext(string);
            if (this.doReport()) {
                this.report(GT.o(GT._("to resume, enter: &{0}"), string));
            }
            throw new ScriptInterruption(this, string, Integer.MIN_VALUE);
        }
        this.evalError(string, null);
    }

    private ScriptContext saveContext(String string) {
        ScriptContext scriptContext = this.getScriptContext("Context_" + string);
        this.vwr.stm.saveContext(string, scriptContext);
        this.vwr.g.setUserVariable(string, SV.newV(14, scriptContext));
        return scriptContext;
    }

    private void cmdTimeout(int n) throws ScriptException {
        String string = null;
        String string2 = null;
        int n2 = 0;
        if (this.slen == n) {
            this.showString(this.vwr.showTimeout(null));
            return;
        }
        block6: for (int i = n; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 1073741974: {
                    string = this.paramAsStr(++i);
                    if (this.slen != 3) continue block6;
                    if (!this.chk) {
                        this.vwr.triggerTimeout(string);
                    }
                    return;
                }
                case 1073742334: {
                    continue block6;
                }
                case 2: {
                    n2 = this.intParameter(i);
                    continue block6;
                }
                case 3: {
                    n2 = Math.round(this.floatParameter(i) * 1000.0f);
                    continue block6;
                }
                default: {
                    if (string == null) {
                        string = this.paramAsStr(i);
                        continue block6;
                    }
                    if (string2 == null) {
                        string2 = this.paramAsStr(i);
                        continue block6;
                    }
                    this.invArg();
                }
            }
        }
        if (!this.chk) {
            this.vwr.setTimeout(string, n2, string2);
        }
    }

    private void cmdTranslate(boolean bl) throws ScriptException {
        char c;
        BS bS = null;
        int n = 1;
        int n2 = 0;
        if (this.tokAt(1) == 1113589787) {
            bl = true;
            n2 = 1;
            n = 2;
        }
        if (this.isPoint3f(n)) {
            P3 p3 = this.getPoint3f(n, true);
            bS = this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null;
            this.checkLast(this.iToken);
            if (!this.chk) {
                this.vwr.setAtomCoordsRelative(p3, bS);
            }
            return;
        }
        char c2 = (this.paramAsStr(n).toLowerCase() + " ").charAt(0);
        if ("xyz".indexOf(c2) < 0) {
            this.error(0);
        }
        float f = this.floatParameter(++n);
        switch (this.tokAt(++n)) {
            case 0: 
            case 10: 
            case 1073742325: {
                c = '\u0000';
                break;
            }
            default: {
                c = (this.optParameterAsString(n).toLowerCase() + '\u0000').charAt(0);
            }
        }
        if (f == 0.0f && c != '\u0000') {
            return;
        }
        this.iToken = n2 + (c == '\u0000' ? 2 : 3);
        bS = bl ? this.vwr.bsA() : (this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null);
        this.checkLast(this.iToken);
        if (!this.chk) {
            this.vwr.translate(c2, f, c, bS);
        }
    }

    private void cmdUnbind() throws ScriptException {
        if (this.slen != 1) {
            this.checkLength23();
        }
        String string = this.optParameterAsString(1);
        String string2 = this.optParameterAsString(2);
        if (string.length() == 0 || this.tokAt(1) == 1073742327) {
            string = null;
        }
        if (string2.length() == 0 || this.tokAt(2) == 1073742327) {
            string2 = null;
        }
        if (string2 == null && string != null && ActionManager.getActionFromName(string) >= 0) {
            string2 = string;
            string = null;
        }
        if (!this.chk) {
            this.vwr.unBindAction(string, string2);
        }
    }

    private void cmdUndoRedoMove() throws ScriptException {
        int n = 1;
        int n2 = 2;
        switch (this.tokAt(1)) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1073742327: {
                n = 0;
                break;
            }
            case 2: {
                n = this.intParameter(1);
                break;
            }
            default: {
                this.invArg();
            }
        }
        this.checkLength(n2);
        if (!this.chk) {
            this.vwr.undoMoveAction(this.tokAt(0), n);
        }
    }

    public void setCurrentCagePts(T3[] t3Array, String string) {
        SymmetryInterface symmetryInterface = Interface.getSymmetry(this.vwr, "eval");
        if (symmetryInterface == null && this.vwr.async) {
            throw new NullPointerException();
        }
        try {
            this.vwr.ms.setModelCage(this.vwr.am.cmi, t3Array == null ? null : symmetryInterface.getUnitCell(t3Array, false, string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cmdUnitcell(int n) throws ScriptException {
        this.getCmdExt().dispatch(1613369372, n == 2, null);
    }

    private void cmdVector() throws ScriptException {
        RadiusData.EnumType enumType = RadiusData.EnumType.SCREEN;
        float f = 1.0f;
        this.checkLength(-3);
        this.iToken = this.slen;
        block0 : switch (this.iToken) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 1073742335: {
                        break;
                    }
                    case 1073742334: {
                        f = 0.0f;
                        break;
                    }
                    case 2: {
                        int n = this.intParameterRange(1, 0, 19);
                        if (n == Integer.MAX_VALUE) {
                            return;
                        }
                        f = n;
                        break;
                    }
                    case 3: {
                        enumType = RadiusData.EnumType.ABSOLUTE;
                        f = this.floatParameterRange(1, 0.0f, 3.0f);
                        if (!Float.isNaN(f)) break block0;
                        return;
                    }
                    default: {
                        this.error(6);
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (this.tokAt(1)) {
                    case 1073742138: {
                        f = this.floatParameterRange(2, -100.0f, 100.0f);
                        if (!Float.isNaN(f)) {
                            this.setFloatProperty("vectorScale", f);
                        }
                        return;
                    }
                    case 64: {
                        float f2 = this.floatParameter(2);
                        if (!this.chk) {
                            this.vwr.ms.scaleVectorsToMax(f2);
                        }
                        return;
                    }
                }
            }
        }
        this.setShapeSize(18, new RadiusData(null, f, enumType, null));
    }

    private void cmdVibration() throws ScriptException {
        this.checkLength(-3);
        float f = 0.0f;
        switch (this.getToken((int)1).tok) {
            case 1073742335: {
                this.checkLength(2);
                f = this.vwr.getFloat(0x22000044);
                break;
            }
            case 1073742334: {
                this.checkLength(2);
                f = 0.0f;
                break;
            }
            case 2: 
            case 3: {
                this.checkLength(2);
                f = this.floatParameter(1);
                break;
            }
            case 1073742138: {
                f = this.floatParameterRange(2, -100.0f, 100.0f);
                if (!Float.isNaN(f)) {
                    this.setFloatProperty("vibrationScale", f);
                }
                return;
            }
            case 64: {
                float f2 = this.floatParameter(2);
                if (this.chk) break;
                this.vwr.ms.scaleVectorsToMax(f2);
                break;
            }
            case 1073742090: {
                this.setFloatProperty("vibrationPeriod", this.floatParameter(2));
                return;
            }
            case 0x40000000: {
                this.invArg();
                break;
            }
            default: {
                f = -1.0f;
            }
        }
        if (f < 0.0f) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        if (f == 0.0f) {
            this.vwr.tm.setVibrationPeriod(0.0f);
            return;
        }
        this.vwr.setVibrationPeriod(-f);
    }

    private void cmdWireframe() throws ScriptException {
        int n = Integer.MIN_VALUE;
        if (this.tokAt(1) == 4141) {
            this.checkLast(1);
        } else {
            n = this.getMadParameter();
        }
        if (this.chk || n == Integer.MAX_VALUE) {
            return;
        }
        this.setShapeProperty(1, "type", 1023);
        this.setShapeSizeBs(1, n == Integer.MIN_VALUE ? 300 : n, null);
    }

    private void cmdZap(boolean bl) throws ScriptException {
        boolean bl2;
        if (this.slen == 1 || !bl) {
            boolean bl3;
            boolean bl4 = bl3 = bl && !this.isStateScript;
            if (bl3) {
                this.vwr.cacheFileByName(null, false);
            }
            this.vwr.zap(true, bl3, true);
            this.refresh(false);
            return;
        }
        BS bS = this.atomExpressionAt(1);
        if (this.chk) {
            return;
        }
        if (bS.nextSetBit(0) < 0 && this.slen == 4 && this.tokAt(2) == 1073742359) {
            int n = this.vwr.ms.getModelNumberIndex(this.getToken((int)2).intValue, false, true);
            if (n >= 0) {
                this.vwr.deleteModels(n, null);
            }
            return;
        }
        int n = this.vwr.deleteAtoms(bS, true);
        boolean bl5 = bl2 = !this.doReport();
        if (!bl2) {
            this.report(GT.i(GT._("{0} atoms deleted"), n));
        }
        this.vwr.select(null, false, 0, bl2);
    }

    private void cmdZoom(boolean bl) throws ScriptException {
        float f;
        if (!bl) {
            int n = this.slen > 1 ? this.getToken((int)1).tok : 1073742335;
            switch (n) {
                case 0x400000FF: 
                case 1275068417: {
                    break;
                }
                case 1073742334: 
                case 1073742335: {
                    if (this.slen > 2) {
                        this.bad();
                    }
                    if (!this.chk) {
                        this.setBooleanProperty("zoomEnabled", n == 1073742335);
                    }
                    return;
                }
            }
        }
        P3 p3 = null;
        int n = 1;
        float f2 = bl ? (this.isFloatParameter(n) ? this.floatParameter(n++) : 1.0f) : (f = 0.0f);
        if (f < 0.0f) {
            --n;
            f = 0.0f;
        }
        int n2 = 0;
        BS bS = null;
        if (this.isCenterParameter(n)) {
            n2 = n;
            Object[] objectArray = new Object[1];
            p3 = this.centerParameter(n, objectArray);
            if (objectArray[0] instanceof BS) {
                bS = (BS)objectArray[0];
            }
            n = this.iToken + 1;
        } else if (this.tokAt(n) == 2 && this.getToken((int)n).intValue == 0) {
            bS = this.vwr.getAtomBitSet("visible");
            p3 = this.vwr.ms.getAtomSetCenter(bS);
        }
        boolean bl2 = false;
        float f3 = this.vwr.tm.getZoomSetting();
        float f4 = this.getZoom(n2, n, bS, f3);
        n = this.iToken + 1;
        float f5 = Float.NaN;
        float f6 = Float.NaN;
        if (n != this.slen) {
            f5 = this.floatParameter(n++);
            f6 = this.floatParameter(n++);
        }
        if (n != this.slen) {
            this.invArg();
        }
        if (f4 < 0.0f) {
            f4 = -f4;
            if (bl) {
                if (this.slen == 1 || bl2) {
                    f4 *= 2.0f;
                } else if (p3 == null) {
                    f4 /= 2.0f;
                }
            }
        }
        float f7 = 200000.0f;
        if (f4 < 5.0f || f4 > f7) {
            this.numberOutOfRange(5.0f, f7);
        }
        if (!this.vwr.tm.isWindowCentered()) {
            if (p3 != null) {
                BS bS2 = this.atomExpressionAt(n2);
                if (!this.chk) {
                    this.vwr.setCenterBitSet(bS2, false);
                }
            }
            p3 = this.vwr.tm.fixedRotationCenter;
            if (Float.isNaN(f5)) {
                f5 = this.vwr.tm.getTranslationXPercent();
            }
            if (Float.isNaN(f6)) {
                f6 = this.vwr.tm.getTranslationYPercent();
            }
        }
        if (this.chk) {
            return;
        }
        if (Float.isNaN(f5)) {
            f5 = 0.0f;
        }
        if (Float.isNaN(f6)) {
            f6 = 0.0f;
        }
        if (bl2 && Math.abs(f3 - f4) < 1.0f) {
            f = 0.0f;
        }
        this.vwr.moveTo(this, f, p3, JC.center, Float.NaN, null, f4, f5, f6, Float.NaN, null, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        if (this.isJS && f > 0.0f && this.vwr.g.waitForMoveTo) {
            throw new ScriptInterruption(this, "zoomTo", 1);
        }
    }

    private void colorShape(int n, int n2, boolean bl) throws ScriptException {
        int n3;
        String string = null;
        Object object = null;
        Integer n4 = null;
        BS bS = null;
        String string2 = n2 == 2 && this.tokAt(1) == 0x40000024 ? "ball" : "";
        boolean bl2 = false;
        boolean bl3 = n == 24 || n == 25;
        int n5 = 0;
        boolean bl4 = false;
        float f = Float.MAX_VALUE;
        if (n2 < 0) {
            bS = this.atomExpressionAt(-n2);
            n2 = this.iToken + 1;
            if (this.isBondSet) {
                bl4 = true;
                n = 1;
            }
        }
        int n6 = this.getToken((int)n2).tok;
        if (bl) {
            this.getToken(n2);
        } else {
            bl = n6 == 1610616835;
            if (bl) {
                this.getToken(++n2);
            }
        }
        if (bl) {
            string2 = "bg";
        } else if (bl3) {
            switch (this.theTok) {
                case 1073742018: {
                    this.getToken(++n2);
                    string2 = "mesh";
                    break;
                }
                case 1073742094: {
                    n3 = this.getArgbParamOrNone(++n2, false);
                    n4 = n3 == 0 ? null : Integer.valueOf(n3);
                    n2 = this.iToken + 1;
                    this.getToken(n2);
                    break;
                }
                case 10: 
                case 1073742325: {
                    if (this.theToken.value instanceof BondSet) {
                        bS = (BondSet)this.theToken.value;
                        string2 = "vertex";
                    } else {
                        bS = this.atomExpressionAt(n2);
                        string2 = "atom";
                    }
                    n2 = this.iToken + 1;
                    this.getToken(n2);
                }
            }
        }
        if (!(this.chk || n != 27 && n != 28 || this.getIsoExt().dispatch(n, true, this.st) == null)) {
            return;
        }
        int n7 = n3 = this.theTok == 603979967 ? 1 : 0;
        if (n3 != 0 || this.theTok == 1073742074) {
            if (f == Float.MIN_VALUE) {
                this.invArg();
            }
            string = this.paramAsStr(n2++);
            if (n3 != 0 && this.isFloatParameter(n2)) {
                f = this.getTranslucentLevel(n2++);
            }
        }
        n6 = 0;
        if (n2 < this.slen && this.tokAt(n2) != 1073742335 && this.tokAt(n2) != 1073742334) {
            bl2 = true;
            n6 = this.getToken((int)n2).tok;
            if ((!bl3 || this.tokAt(n2 + 1) != 1073742170) && this.isColorParam(n2)) {
                int n8 = this.getArgbParamOrNone(n2, false);
                object = n8 == 0 ? null : Integer.valueOf(n8);
                n2 = this.iToken + 1;
                if (this.tokAt(n2) != 0 && string == null) {
                    this.getToken(n2);
                    int n9 = n3 = this.theTok == 603979967 ? 1 : 0;
                    if (n3 != 0 || this.theTok == 1073742074) {
                        string = this.paramAsStr(n2++);
                        if (n3 != 0 && this.isFloatParameter(n2)) {
                            f = this.getTranslucentLevel(n2++);
                        }
                    }
                }
                if (this.isColorParam(n2)) {
                    n8 = this.getArgbParamOrNone(n2, false);
                    n4 = n8 == 0 ? null : Integer.valueOf(n8);
                    n2 = this.iToken + 1;
                }
                this.checkLength(n2);
            } else if (n == 26) {
                --this.iToken;
            } else {
                BS bS2;
                PAL pAL;
                boolean bl5;
                String string3 = this.paramAsStr(n2).toLowerCase();
                boolean bl6 = string3.indexOf("byelement") == 0;
                boolean bl7 = bl5 = bl6 || string3.indexOf("byresidue") == 0;
                PAL pAL2 = bl5 || bl3 ? PAL.PROPERTY : (pAL = n6 == 1112152075 ? PAL.CPK : PAL.getPalette(string3));
                if (pAL == PAL.UNKNOWN || (pAL == PAL.TYPE || pAL == PAL.ENERGY) && n != 2) {
                    this.invArg();
                }
                float[] fArray = null;
                BS bS3 = bS2 = pAL != PAL.PROPERTY && pAL != PAL.VARIABLE || !this.vwr.g.rangeSelected ? null : this.vwr.bsA();
                if (pAL == PAL.PROPERTY) {
                    if (bl5) {
                        if (!this.chk) {
                            fArray = this.getCmdExt().getBitsetPropertyFloat(bS2, (bl6 ? 1094715402 : 1094713356) | 0x100, null, Float.NaN, Float.NaN);
                        }
                    } else {
                        boolean bl8 = string3.equals("property");
                        if (bl8 && T.tokAttr(n6 = this.getToken((int)(++n2)).tok, 0x40400000) && !T.tokAttr(n6, 0x40C00000)) {
                            if (!this.chk) {
                                fArray = this.getCmdExt().getBitsetPropertyFloat(bS2, this.getToken((int)n2).tok | 0x100, null, Float.NaN, Float.NaN);
                            }
                            ++n2;
                        } else if (!bl8 && !bl3) {
                            ++n2;
                        }
                    }
                } else if (pAL == PAL.VARIABLE) {
                    int n10 = ++n2;
                    ++n2;
                    string3 = this.paramAsStr(n10);
                    fArray = new float[this.vwr.ms.ac];
                    Parser.parseStringInfestedFloatArray("" + this.getParameter(string3, 4, true), null, fArray);
                    pAL = PAL.PROPERTY;
                }
                if (pAL == PAL.PROPERTY) {
                    Object object2;
                    String string4 = null;
                    if (this.tokAt(n2) == 4) {
                        string4 = this.paramAsStr(n2++).toLowerCase();
                        if (this.isArrayParameter(n2)) {
                            string4 = string4 + "=" + SV.sValue(SV.getVariableAS(this.stringParameterSet(n2))).replace('\n', ' ');
                            n2 = this.iToken + 1;
                        }
                    } else if (bl3 && this.isColorParam(n2)) {
                        string4 = this.getColorRange(n2);
                        n2 = this.iToken + 1;
                    }
                    if (string4 != null && !bl3) {
                        this.setStringProperty("propertyColorScheme", (n3 != 0 && f == Float.MAX_VALUE ? "translucent " : "") + string4);
                        bl5 = string4.indexOf("byelement") == 0 || string4.indexOf("byresidue") == 0;
                    }
                    Object object3 = 0.0f;
                    Object object4 = Float.MAX_VALUE;
                    if (!(bl5 || this.tokAt(n2) != 0x40000002 && this.tokAt(n2) != 1073742114)) {
                        object3 = this.floatParameter(n2 + 1);
                        object4 = this.floatParameter(n2 + 2);
                        n2 += 3;
                        if (object3 == object4 && bl3) {
                            object2 = (float[])this.getShapeProperty(n, "dataRange");
                            if (object2 != null) {
                                object3 = object2[0];
                                object4 = object2[1];
                            }
                        } else if (object3 == object4) {
                            object4 = Float.MAX_VALUE;
                        }
                    }
                    if (!bl3) {
                        if (fArray == null) {
                            if (!this.chk) {
                                this.vwr.setCurrentColorRange(string3);
                            }
                        } else if (!this.chk) {
                            this.vwr.cm.setPropertyColorRangeData(fArray, bS2);
                        }
                    }
                    if (bl3) {
                        this.checkLength(n2);
                        if (this.chk) {
                            return;
                        }
                        bl2 = false;
                        object2 = this.vwr.cm.getColorEncoder(string4);
                        if (object2 == null) {
                            return;
                        }
                        ((ColorEncoder)object2).isTranslucent = n3 != 0 && f == Float.MAX_VALUE;
                        ((ColorEncoder)object2).setRange((float)object3, (float)object4, object3 > object4);
                        if (object4 == Float.MAX_VALUE) {
                            ((ColorEncoder)object2).hi = object4;
                        }
                        this.setShapeProperty(n, "remapColor", object2);
                        this.showString(((String)this.getShapeProperty(n, "dataRangeStr")).replace('\n', ' '));
                        if (f == Float.MAX_VALUE) {
                            return;
                        }
                    } else if (object4 != Float.MAX_VALUE) {
                        this.vwr.cm.setPropertyColorRange((float)object3, (float)object4);
                    }
                } else {
                    ++n2;
                }
                this.checkLength(n2);
                object = pAL;
            }
        }
        if (this.chk || n < 0) {
            return;
        }
        switch (n) {
            case 4: {
                n5 = 32768;
                break;
            }
            case 2: {
                n5 = 30720;
                break;
            }
            case 3: {
                n5 = 256;
                break;
            }
            case 1: {
                n5 = 1023;
                break;
            }
            default: {
                n5 = 0;
            }
        }
        if (n5 == 0) {
            this.sm.loadShape(n);
            if (n == 5) {
                this.setShapeProperty(5, "setDefaults", this.vwr.slm.noneSelected);
            }
        } else {
            if (bS != null) {
                this.vwr.selectBonds(bS);
                bS = null;
            }
            n = 1;
            this.setShapeProperty(n, "type", n5);
        }
        if (bl2) {
            switch (n6) {
                case 1111490574: 
                case 1111490575: {
                    this.vwr.autoCalculate(n6);
                    break;
                }
                case 1111492620: {
                    if (!this.vwr.g.rangeSelected) break;
                    this.vwr.ms.clearBfactorRange();
                    break;
                }
                case 1086324742: {
                    this.vwr.ms.calcSelectedGroupsCount();
                    break;
                }
                case 0x41400011: 
                case 1094713362: {
                    this.vwr.ms.calcSelectedMonomersCount();
                    break;
                }
                case 0x41400010: {
                    this.vwr.ms.calcSelectedMoleculesCount();
                }
            }
            if (n4 != null && (bl3 || n == 11 || n == 14 || n == 21)) {
                this.setShapeProperty(n, "colorPhase", new Object[]{n4, object});
            } else if (bS == null) {
                this.setShapeProperty(n, string2 + "color", object);
            } else {
                this.setShapePropertyBs(n, string2 + "color", object, bS);
            }
        }
        if (string != null) {
            this.setShapeTranslucency(n, string2, string, f, bS);
        }
        if (n5 != 0) {
            this.setShapeProperty(1, "type", 1023);
        }
        if (bl4) {
            this.vwr.selectBonds(null);
        }
        if (n == 0) {
            this.vwr.shm.checkInheritedShapes();
        }
    }

    public RadiusData encodeRadiusParameter(int n, boolean bl, boolean bl2) throws ScriptException {
        float f = Float.NaN;
        RadiusData.EnumType enumType = RadiusData.EnumType.ABSOLUTE;
        VDW vDW = null;
        int n2 = n == -1 ? 1648363544 : this.getToken((int)n).tok;
        switch (n2) {
            case 1111490561: 
            case 0x42400002: 
            case 1111492618: 
            case 1111492620: 
            case 1113589786: 
            case 1648363544: {
                f = 1.0f;
                enumType = RadiusData.EnumType.FACTOR;
                vDW = n2 == 1648363544 ? null : VDW.getVdwType2(T.nameOf(n2));
                n2 = this.tokAt(++n);
            }
        }
        switch (n2) {
            case 4141: {
                return this.vwr.rd;
            }
            case 1073741852: 
            case 0x40000020: 
            case 0x40000022: 
            case 1073741991: 
            case 1073742116: {
                f = 1.0f;
                enumType = RadiusData.EnumType.FACTOR;
                this.iToken = n - 1;
                break;
            }
            case 2: 
            case 3: 
            case 0x100000A1: {
                float f2;
                if (n2 == 0x100000A1) {
                    ++n;
                } else {
                    if (this.tokAt(n + 1) == 268435634) {
                        f = Math.round(this.floatParameter(n));
                        this.iToken = ++n;
                        enumType = RadiusData.EnumType.FACTOR;
                        if (f < 0.0f || f > 200.0f) {
                            this.integerOutOfRange(0, 200);
                            return null;
                        }
                        f /= 100.0f;
                        break;
                    }
                    if (n2 == 2) {
                        f = this.intParameter(n);
                        if (f > 749.0f || f < -200.0f) {
                            this.integerOutOfRange(-200, 749);
                            return null;
                        }
                        if (f > 0.0f) {
                            f /= 250.0f;
                            enumType = RadiusData.EnumType.ABSOLUTE;
                            break;
                        }
                        f /= -100.0f;
                        enumType = RadiusData.EnumType.FACTOR;
                        break;
                    }
                }
                if (n2 == 0x100000A1 || !bl2) {
                    enumType = RadiusData.EnumType.OFFSET;
                    f2 = 16.0f;
                } else {
                    enumType = RadiusData.EnumType.ABSOLUTE;
                    vDW = VDW.NADA;
                    f2 = 100.0f;
                }
                f = this.floatParameterRange(n, bl || !bl2 ? -f2 : 0.0f, f2);
                if (Float.isNaN(f)) {
                    return null;
                }
                if (bl) {
                    f = -f;
                }
                if (!(f > 16.0f)) break;
                f = 16.1f;
                break;
            }
            default: {
                if (f != 1.0f) break;
                --n;
            }
        }
        if (vDW == null && (vDW = VDW.getVdwType(this.optParameterAsString(++this.iToken))) == null) {
            this.iToken = n;
            vDW = VDW.AUTO;
        }
        return new RadiusData(null, f, enumType, vDW);
    }

    private int[] expandFloatArray(float[] fArray, int n) throws ScriptException {
        int n2 = fArray.length;
        boolean bl = false;
        try {
            int n3;
            for (int i = 0; i < fArray.length; ++i) {
                if (!(fArray[i] < 0.0f)) continue;
                n2 = (int)((float)n2 + (Math.abs(fArray[i - 1] + fArray[i]) - 1.0f));
                bl = true;
            }
            if (bl) {
                float[] fArray2 = new float[n2];
                n3 = 0;
                for (int i = 0; i < fArray.length; ++i) {
                    n2 = (int)fArray[i];
                    if (n2 >= 0) {
                        if (n2 < n) {
                            this.invArg();
                        }
                        fArray2[n3++] = n2;
                        continue;
                    }
                    int n4 = (int)(fArray[i - 1] + (float)n2);
                    int n5 = n4 < 0 ? 1 : -1;
                    int n6 = (int)fArray[i - 1];
                    while ((float)n6 != -fArray[i]) {
                        fArray2[n3] = fArray2[n3 - 1] + (float)n5;
                        n6 += n5;
                        ++n3;
                    }
                }
                fArray = fArray2;
                n2 = fArray.length;
            }
            int[] nArray = new int[n2];
            n3 = n2;
            while (--n3 >= 0) {
                nArray[n3] = (int)fArray[n3];
            }
            return nArray;
        }
        catch (Exception exception) {
            this.invArg();
            return null;
        }
    }

    private void frameControl(int n) throws ScriptException {
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 4143: 
            case 20487: 
            case 1073741942: 
            case 1073741993: 
            case 1073742037: 
            case 0x40000110: 
            case 1073742098: 
            case 1073742108: 
            case 1073742125: {
                if (!this.chk) {
                    this.vwr.setAnimation(this.theTok);
                }
                return;
            }
        }
        this.invArg();
    }

    public String getColorRange(int n) throws ScriptException {
        int n2 = this.getArgbParam(n);
        if (this.tokAt(++this.iToken) != 1073742170) {
            this.invArg();
        }
        int n3 = this.getArgbParam(++this.iToken);
        int n4 = this.tokAt(this.iToken + 1) == 2 ? this.intParameter(++this.iToken) : 0;
        return ColorEncoder.getColorSchemeList(ColorEncoder.getPaletteAtoB(n2, n3, n4));
    }

    public String getFullPathName() throws ScriptException {
        String string;
        String string2 = string = !this.chk || this.isCmdLine_C_Option ? this.vwr.fm.getFullPathName(true) : "test.xyz";
        if (string == null) {
            this.invArg();
        }
        return string;
    }

    private P3[] getObjectBoundingBox(String string) {
        Object[] objectArray = new Object[]{string, null, null};
        return this.getShapePropertyData(24, "getBoundingBox", objectArray) || this.getShapePropertyData(29, "getBoundingBox", objectArray) || this.getShapePropertyData(25, "getBoundingBox", objectArray) || this.getShapePropertyData(28, "getBoundingBox", objectArray) || this.getShapePropertyData(27, "getBoundingBox", objectArray) ? (P3[])objectArray[2] : null;
    }

    @Override
    protected P3 getObjectCenter(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, n, n2};
        return this.getShapePropertyData(22, "getCenter", objectArray) || this.getShapePropertyData(24, "getCenter", objectArray) || this.getShapePropertyData(29, "getCenter", objectArray) || this.getShapePropertyData(25, "getCenter", objectArray) || this.getShapePropertyData(28, "getCenter", objectArray) || this.getShapePropertyData(27, "getCenter", objectArray) ? (P3)objectArray[2] : null;
    }

    @Override
    protected P4 getPlaneForObject(String string, V3 v3) {
        int n = this.sm.getShapeIdFromObjectName(string);
        switch (n) {
            case 22: {
                this.setShapeProperty(22, "thisID", string);
                P3[] p3Array = (P3[])this.getShapeProperty(22, "vertices");
                if (p3Array == null || p3Array.length < 3 || p3Array[0] == null || p3Array[1] == null || p3Array[2] == null) break;
                return Measure.getPlaneThroughPoints(p3Array[0], p3Array[1], p3Array[2], new V3(), v3, new P4());
            }
            case 24: {
                this.setShapeProperty(24, "thisID", string);
                return (P4)this.getShapeProperty(24, "plane");
            }
        }
        return null;
    }

    public Quat[] getQuaternionArray(Object object, int n) {
        Quat[] quatArray;
        switch (n) {
            case 134221842: {
                quatArray = (Quat[])object;
                break;
            }
            case 9: {
                P4[] p4Array = (P4[])object;
                quatArray = new Quat[p4Array.length];
                for (int i = 0; i < p4Array.length; ++i) {
                    quatArray[i] = Quat.newP4(p4Array[i]);
                }
                break;
            }
            case 1073742001: {
                Lst lst = (Lst)object;
                quatArray = new Quat[lst.size()];
                for (int i = 0; i < lst.size(); ++i) {
                    P4 p4 = SV.pt4Value((SV)lst.get(i));
                    if (p4 == null) {
                        return null;
                    }
                    quatArray[i] = Quat.newP4(p4);
                }
                break;
            }
            default: {
                return null;
            }
        }
        return quatArray;
    }

    public int getSetAxesTypeMad(int n) throws ScriptException {
        if (n == this.slen) {
            return 1;
        }
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 1073742335: {
                return 1;
            }
            case 1073742334: {
                return 0;
            }
            case 0x40000066: {
                return -1;
            }
            case 2: {
                return this.intParameterRange(n, -1, 19);
            }
            case 3: {
                float f = this.floatParameterRange(n, 0.0f, 2.0f);
                return Float.isNaN(f) ? Integer.MAX_VALUE : (int)Math.floor(f * 1000.0f * 2.0f);
            }
        }
        this.errorStr(7, "\"DOTTED\"");
        return 0;
    }

    private float getSettingFloat(int n) throws ScriptException {
        return n >= this.slen ? Float.NaN : SV.fValue(this.parameterExpressionToken(n));
    }

    private int getSettingInt(int n) throws ScriptException {
        return n >= this.slen ? Integer.MIN_VALUE : this.parameterExpressionToken(n).asInt();
    }

    private String getSettingStr(int n, boolean bl) throws ScriptException {
        return bl && this.slen == n + 1 ? this.paramAsStr(n) : this.parameterExpressionToken(n).asString();
    }

    public Object getShapeProperty(int n, String string) {
        return this.sm.getShapePropertyIndex(n, string, Integer.MIN_VALUE);
    }

    public boolean getShapePropertyData(int n, String string, Object[] objectArray) {
        return this.sm.getShapePropertyData(n, string, objectArray);
    }

    private int getShapeType(int n) throws ScriptException {
        int n2 = JC.shapeTokenIndex(n);
        if (n2 < 0) {
            this.error(49);
        }
        return n2;
    }

    public float getTranslucentLevel(int n) throws ScriptException {
        float f = this.floatParameter(n);
        return this.theTok == 2 && f > 0.0f && f < 9.0f ? f + 1.0f : f;
    }

    private float getZoom(int n, int n2, BS bS, float f) throws ScriptException {
        float f2;
        float f3 = f2 = this.isFloatParameter(n2) ? this.floatParameter(n2++) : Float.NaN;
        if (f2 == 0.0f || f == 0.0f) {
            float f4 = Float.NaN;
            if (bS == null) {
                P3[] p3Array;
                if (this.tokAt(n) == 1073742330 && ((p3Array = this.getObjectBoundingBox(this.objectNameParameter(n + 1))) == null || (f4 = p3Array[0].distance(p3Array[1]) / 2.0f) == 0.0f)) {
                    this.invArg();
                }
            } else {
                f4 = this.vwr.ms.calcRotationRadiusBs(bS);
            }
            if (Float.isNaN(f4)) {
                this.invArg();
            }
            f = this.vwr.getFloat(0x2200002C) / f4 * 100.0f;
            f2 = Float.NaN;
        }
        if (f2 < 0.0f) {
            f2 += f;
        } else if (Float.isNaN(f2)) {
            int n3 = this.tokAt(n2);
            switch (n3) {
                case 0x400000FF: 
                case 1275068417: {
                    f2 = f * (n3 == 0x400000FF ? 0.5f : 2.0f);
                    ++n2;
                    break;
                }
                case 0x100000A1: 
                case 0x100000B0: 
                case 0x100000B1: {
                    float f5 = this.floatParameter(++n2);
                    ++n2;
                    switch (n3) {
                        case 0x100000B0: {
                            f2 = f / f5;
                            break;
                        }
                        case 0x100000B1: {
                            f2 = f * f5;
                            break;
                        }
                        case 0x100000A1: {
                            f2 = f + f5;
                        }
                    }
                    break;
                }
                default: {
                    f2 = bS == null ? -f : f;
                }
            }
        }
        this.iToken = n2 - 1;
        return f2;
    }

    private boolean setElementColor(String string, int n) {
        int n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(Elements.elementNameFromNumber(n2))) continue;
            if (!this.chk) {
                this.vwr.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = Elements.altElementMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(Elements.altElementNameFromIndex(n2))) continue;
            if (!this.chk) {
                this.vwr.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        if (string.charAt(0) != '_') {
            return false;
        }
        n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase("_" + Elements.elementSymbolFromNumber(n2))) continue;
            if (!this.chk) {
                this.vwr.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = Elements.altElementMax;
        while (--n2 >= 4) {
            if (string.equalsIgnoreCase("_" + Elements.altElementSymbolFromIndex(n2))) {
                if (!this.chk) {
                    this.vwr.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
                }
                return true;
            }
            if (!string.equalsIgnoreCase("_" + Elements.altIsotopeSymbolFromIndex(n2))) continue;
            if (!this.chk) {
                this.vwr.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        return false;
    }

    public boolean setMeshDisplayProperty(int n, int n2, int n3) throws ScriptException {
        boolean bl;
        String string = null;
        Integer n4 = null;
        boolean bl2 = n == 25;
        boolean bl3 = bl = n2 == 0;
        if (!bl) {
            n3 = this.getToken((int)n2).tok;
        }
        switch (n3) {
            case 1765808132: {
                if (!bl2) break;
                ++this.iToken;
            }
            case 603979967: 
            case 1073742074: {
                if (!bl) {
                    this.colorShape(n, this.iToken, false);
                }
                return true;
            }
            case 0: 
            case 12291: 
            case 12294: 
            case 0x200028: 
            case 0x20002A: 
            case 1073742334: 
            case 1073742335: 
            case 1610625028: {
                if (this.iToken == 1 && n >= 0 && this.tokAt(2) == 0) {
                    this.setShapeProperty(n, "thisID", null);
                }
                if (n3 == 0) {
                    return this.iToken == 1;
                }
                if (bl) {
                    return true;
                }
                switch (n3) {
                    case 12291: {
                        this.setShapeProperty(n, "delete", null);
                        return true;
                    }
                    case 12294: 
                    case 0x20002A: {
                        n3 = 1073742334;
                        break;
                    }
                    case 0x200028: {
                        n3 = 1073742335;
                        break;
                    }
                    case 1610625028: {
                        if (n2 + 1 != this.slen) break;
                        n3 = 1073742335;
                    }
                }
            }
            case 1073741862: 
            case 0x4000004A: 
            case 1073741938: 
            case 1073741958: 
            case 0x40000088: 
            case 1073741964: 
            case 1073742018: 
            case 1073742039: 
            case 1073742042: 
            case 1073742046: 
            case 0x400000E4: 
            case 1073742058: 
            case 1073742060: 
            case 1073742182: 
            case 1112150019: {
                string = "token";
                n4 = n3;
            }
        }
        if (string == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        this.setShapeProperty(n, string, n4);
        if (this.tokAt(this.iToken + 1) != 0 && !this.setMeshDisplayProperty(n, ++this.iToken, 0)) {
            --this.iToken;
        }
        return true;
    }

    private void setObjectArgb(String string, int n) {
        if (this.chk) {
            return;
        }
        this.vwr.setObjectArgb(string, n);
    }

    public void setObjectMad(int n, String string, int n2) {
        if (this.chk) {
            return;
        }
        this.vwr.setObjectMad(n, string, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String setObjectProp(String string, int n, int n2) throws ScriptException {
        Object[] objectArray = new Object[]{string, null};
        String string2 = "";
        boolean bl = PT.isWild(string);
        int n3 = 17;
        block14: while (true) {
            if (this.getShapePropertyData(n3, "checkID", objectArray)) {
                this.setShapeProperty(n3, "thisID", string);
                switch (n) {
                    case 12291: {
                        this.setShapeProperty(n3, "delete", null);
                        break;
                    }
                    case 12294: 
                    case 1610625028: {
                        this.setShapeProperty(n3, "hidden", n == 1610625028 ? Boolean.FALSE : Boolean.TRUE);
                        break;
                    }
                    case 134222350: {
                        string2 = string2 + (String)this.getShapeProperty(n3, "command") + "\n";
                        break;
                    }
                    case 1765808132: {
                        if (n2 < 0) break;
                        this.colorShape(n3, n2 + 1, false);
                    }
                }
                if (!bl) return string2;
            }
            switch (n3) {
                case 17: {
                    n3 = 20;
                    continue block14;
                }
                case 20: {
                    n3 = 32;
                }
            }
            switch (--n3) {
                case 27: {
                    --n3;
                    break;
                }
                case 28: {
                    n3 -= 2;
                }
            }
            if (n3 < 22) return string2;
        }
    }

    public String setObjectProperty() throws ScriptException {
        String string = this.setShapeNameParameter(2);
        return this.chk ? "" : this.setObjectProp(string, this.tokAt(0), this.iToken);
    }

    public String setShapeNameParameter(int n) throws ScriptException {
        String string = this.paramAsStr(n);
        boolean bl = string.equals("*");
        if (string.length() == 0) {
            this.invArg();
        }
        if (bl) {
            switch (this.tokAt(n + 1)) {
                case 0: 
                case 12291: 
                case 0x200028: 
                case 0x20002A: 
                case 1073742334: 
                case 1073742335: 
                case 1765808132: {
                    break;
                }
                default: {
                    if (this.setMeshDisplayProperty(-1, 0, this.tokAt(n + 1))) break;
                    string = string + this.optParameterAsString(++n);
                }
            }
        }
        if (this.tokAt(n + 1) == 0x100000B1) {
            string = string + this.paramAsStr(++n);
        }
        this.iToken = n;
        return string;
    }

    public void setShapeProperty(int n, String string, Object object) {
        if (!this.chk) {
            this.sm.setShapePropertyBs(n, string, object, null);
        }
    }

    public void setShapePropertyBs(int n, String string, Object object, BS bS) {
        if (!this.chk) {
            this.sm.setShapePropertyBs(n, string, object, bS);
        }
    }

    private void setShapeSize(int n, RadiusData radiusData) {
        if (!this.chk) {
            this.sm.setShapeSizeBs(n, 0, radiusData, null);
        }
    }

    public void setShapeSizeBs(int n, int n2, BS bS) {
        if (!this.chk) {
            this.sm.setShapeSizeBs(n, n2, null, bS);
        }
    }

    public void setShapeTranslucency(int n, String string, String string2, float f, BS bS) {
        if (f == Float.MAX_VALUE) {
            f = this.vwr.getFloat(0x2200000A);
        }
        this.setShapeProperty(n, "translucentLevel", Float.valueOf(f));
        if (string == null) {
            return;
        }
        if (bS == null) {
            this.setShapeProperty(n, string + "translucency", string2);
        } else if (!this.chk) {
            this.setShapePropertyBs(n, string + "translucency", string2, bS);
        }
    }

    private void setSize(int n, float f) throws ScriptException {
        RadiusData radiusData = null;
        int n2 = this.tokAt(1);
        boolean bl = false;
        switch (n2) {
            case 1073742072: {
                this.restrictSelected(false, false);
            }
            case 1073742335: {
                break;
            }
            case 1073742334: {
                f = 0.0f;
                break;
            }
            case 3: {
                bl = this.floatParameter(1) < 0.0f;
            }
            default: {
                radiusData = this.encodeRadiusParameter(1, bl, true);
                if (radiusData == null) {
                    return;
                }
                if (!Float.isNaN(radiusData.value)) break;
                this.invArg();
            }
        }
        if (radiusData == null) {
            radiusData = new RadiusData(null, f, RadiusData.EnumType.FACTOR, VDW.AUTO);
        }
        if (bl) {
            this.restrictSelected(false, false);
        }
        this.setShapeSize(n, radiusData);
    }

    private void setSizeBio(int n) throws ScriptException {
        int n2 = 0;
        switch (this.getToken((int)1).tok) {
            case 1073742072: {
                this.restrictSelected(false, false);
            }
            case 1073742335: {
                n2 = -1;
                break;
            }
            case 1073742334: {
                break;
            }
            case 1639976963: {
                n2 = -2;
                break;
            }
            case 1073741922: 
            case 1111492620: {
                n2 = -4;
                break;
            }
            case 2: {
                n2 = this.intParameterRange(1, 0, 1000) * 8;
                if (n2 != Integer.MAX_VALUE) break;
                return;
            }
            case 3: {
                n2 = Math.round(this.floatParameterRange(1, -4.0f, 4.0f) * 2000.0f);
                if (n2 == Integer.MAX_VALUE) {
                    return;
                }
                if (n2 >= 0) break;
                this.restrictSelected(false, false);
                n2 = -n2;
                break;
            }
            case 10: {
                if (!this.chk) {
                    this.sm.loadShape(n);
                }
                this.setShapeProperty(n, "bitset", this.theToken.value);
                return;
            }
            default: {
                this.error(6);
            }
        }
        this.setShapeSizeBs(n, n2, null);
    }

    private boolean setUnits(String string, int n) throws ScriptException {
        if (n == 545259568 && (string.endsWith("hz") || PT.isOneOf(string.toLowerCase(), ";angstroms;au;bohr;nanometers;nm;picometers;pm;vanderwaals;vdw;"))) {
            if (!this.chk) {
                this.vwr.setUnits(string, true);
            }
        } else if (n == 545259559 && PT.isOneOf(string.toLowerCase(), ";kcal;kj;")) {
            if (!this.chk) {
                this.vwr.setUnits(string, false);
            }
        } else {
            this.errorStr2(50, "set " + T.nameOf(n), string);
        }
        return true;
    }

    public String toString() {
        SB sB = new SB();
        sB.append("Eval\n pc:");
        sB.appendI(this.pc);
        sB.append("\n");
        sB.appendI(this.aatoken.length);
        sB.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            sB.append("----\n");
            T[] tArray = this.aatoken[i];
            for (int j = 0; j < tArray.length; ++j) {
                sB.appendO(tArray[j]);
                sB.appendC('\n');
            }
            sB.appendC('\n');
        }
        sB.append("END\n");
        return sB.toString();
    }

    @Override
    protected void setAtomProp(String string, Object object, BS bS) {
        this.setShapePropertyBs(0, string, object, bS);
    }

    static {
        commandHistoryLevelMax = 0;
        contextDepthMax = 100;
        scriptReportingLevel = 0;
    }
}

