/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordContext;
import org.parosproxy.paros.db.TableContext;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableContext
extends ParosAbstractTable
implements TableContext {
    private static final String TABLE_NAME = "CONTEXT_DATA";
    private static final String DATAID = "DATAID";
    private static final String CONTEXTID = "CONTEXTID";
    private static final String TYPE = "TYPE";
    private static final String DATA = "DATA";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psGetAllData = null;
    private PreparedStatement psGetAllDataForContext = null;
    private PreparedStatement psGetAllDataForContextAndType = null;
    private PreparedStatement psDeleteData = null;
    private PreparedStatement psDeleteAllDataForContext = null;
    private PreparedStatement psDeleteAllDataForContextAndType = null;

    @Override
    protected void reconnect(Connection connection) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(connection, TABLE_NAME)) {
                DbUtils.executeAndClose(connection.prepareStatement("CREATE cached TABLE CONTEXT_DATA (dataid bigint generated by default as identity (start with 1), contextId int not null, type int not null, data varchar(8192) default '')"));
            }
            this.psRead = connection.prepareStatement("SELECT * FROM CONTEXT_DATA WHERE DATAID = ?");
            this.psInsert = connection.prepareStatement("INSERT INTO CONTEXT_DATA (CONTEXTID,TYPE,DATA) VALUES (?, ?, ?)");
            this.psGetIdLastInsert = connection.prepareCall("CALL IDENTITY();");
            this.psDeleteData = connection.prepareStatement("DELETE FROM CONTEXT_DATA WHERE CONTEXTID = ? AND TYPE = ? AND DATA = ?");
            this.psDeleteAllDataForContext = connection.prepareStatement("DELETE FROM CONTEXT_DATA WHERE CONTEXTID = ?");
            this.psDeleteAllDataForContextAndType = connection.prepareStatement("DELETE FROM CONTEXT_DATA WHERE CONTEXTID = ? AND TYPE = ?");
            this.psGetAllData = connection.prepareStatement("SELECT * FROM CONTEXT_DATA");
            this.psGetAllDataForContext = connection.prepareStatement("SELECT * FROM CONTEXT_DATA WHERE CONTEXTID = ?");
            this.psGetAllDataForContextAndType = connection.prepareStatement("SELECT * FROM CONTEXT_DATA WHERE CONTEXTID = ? AND TYPE = ?");
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordContext read(long l) throws DatabaseException {
        try {
            this.psRead.setLong(1, l);
            try (ResultSet resultSet = this.psRead.executeQuery();){
                RecordContext recordContext;
                RecordContext recordContext2 = recordContext = this.build(resultSet);
                return recordContext2;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized RecordContext insert(int n, int n2, String string) throws DatabaseException {
        try {
            long l;
            this.psInsert.setInt(1, n);
            this.psInsert.setInt(2, n2);
            this.psInsert.setString(3, string);
            this.psInsert.executeUpdate();
            try (ResultSet resultSet = this.psGetIdLastInsert.executeQuery();){
                resultSet.next();
                l = resultSet.getLong(1);
            }
            return this.read(l);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void delete(int n, int n2, String string) throws DatabaseException {
        try {
            this.psDeleteData.setInt(1, n);
            this.psDeleteData.setInt(2, n2);
            this.psDeleteData.setString(3, string);
            this.psDeleteData.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void deleteAllDataForContextAndType(int n, int n2) throws DatabaseException {
        try {
            this.psDeleteAllDataForContextAndType.setInt(1, n);
            this.psDeleteAllDataForContextAndType.setInt(2, n2);
            this.psDeleteAllDataForContextAndType.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void deleteAllDataForContext(int n) throws DatabaseException {
        try {
            this.psDeleteAllDataForContext.setInt(1, n);
            this.psDeleteAllDataForContext.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public List<RecordContext> getAllData() throws DatabaseException {
        try {
            ArrayList<RecordContext> arrayList = new ArrayList<RecordContext>();
            try (ResultSet resultSet = this.psGetAllData.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(new RecordContext(resultSet.getLong(DATAID), resultSet.getInt(CONTEXTID), resultSet.getInt(TYPE), resultSet.getString(DATA)));
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized List<RecordContext> getDataForContext(int n) throws DatabaseException {
        try {
            ArrayList<RecordContext> arrayList = new ArrayList<RecordContext>();
            this.psGetAllDataForContext.setInt(1, n);
            try (ResultSet resultSet = this.psGetAllDataForContext.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(new RecordContext(resultSet.getLong(DATAID), resultSet.getInt(CONTEXTID), resultSet.getInt(TYPE), resultSet.getString(DATA)));
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized List<RecordContext> getDataForContextAndType(int n, int n2) throws DatabaseException {
        try {
            ArrayList<RecordContext> arrayList = new ArrayList<RecordContext>();
            this.psGetAllDataForContextAndType.setInt(1, n);
            this.psGetAllDataForContextAndType.setInt(2, n2);
            try (ResultSet resultSet = this.psGetAllDataForContextAndType.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(new RecordContext(resultSet.getLong(DATAID), resultSet.getInt(CONTEXTID), resultSet.getInt(TYPE), resultSet.getString(DATA)));
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private RecordContext build(ResultSet resultSet) throws DatabaseException {
        try {
            RecordContext recordContext = null;
            if (resultSet.next()) {
                recordContext = new RecordContext(resultSet.getLong(DATAID), resultSet.getInt(CONTEXTID), resultSet.getInt(TYPE), resultSet.getString(DATA));
            }
            return recordContext;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public void setData(int n, int n2, List<String> list) throws DatabaseException {
        this.deleteAllDataForContextAndType(n, n2);
        for (String string : list) {
            this.insert(n, n2, string);
        }
    }
}

