/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.zaproxy.zap.control.ZapRelease;

@RunWith(value=MockitoJUnitRunner.class)
public class ZapReleaseUnitTest {
    private static final String DEV_BUILD = "Dev Build";

    @Test
    public void testDevBuildLaterThan1_4_1() {
        ZapRelease zapRelease = new ZapRelease();
        zapRelease.setVersion(DEV_BUILD);
        Assert.assertTrue((boolean)zapRelease.isNewerThan("1.4.1"));
    }

    @Test
    public void test1_4_2LaterThan1_4_1() {
        ZapRelease zapRelease = new ZapRelease();
        zapRelease.setVersion("1.4.2");
        Assert.assertTrue((boolean)zapRelease.isNewerThan("1.4.1"));
    }

    @Test
    public void test1_5_1LaterThan1_4_2() {
        ZapRelease zapRelease = new ZapRelease();
        zapRelease.setVersion("1.5.1");
        Assert.assertTrue((boolean)zapRelease.isNewerThan("1.4.2"));
    }

    @Test
    public void test1_5_1LaterThan1_4_2_1() {
        ZapRelease zapRelease = new ZapRelease();
        zapRelease.setVersion("1.5.1");
        Assert.assertTrue((boolean)zapRelease.isNewerThan("1.4.2.1"));
    }

    @Test
    public void testLots() {
        Assert.assertFalse((boolean)new ZapRelease("1.3.4").isNewerThan("1.4"));
        Assert.assertFalse((boolean)new ZapRelease("1.3.4").isNewerThan("1.4"));
        Assert.assertFalse((boolean)new ZapRelease("1.3.4").isNewerThan("2.0"));
        Assert.assertFalse((boolean)new ZapRelease("1.4").isNewerThan("1.4.1"));
        Assert.assertFalse((boolean)new ZapRelease("1.4.1").isNewerThan("1.4.2"));
        Assert.assertFalse((boolean)new ZapRelease("1.4.2").isNewerThan("1.4.11"));
        Assert.assertFalse((boolean)new ZapRelease("1.4.beta.1").isNewerThan("1.5"));
        Assert.assertFalse((boolean)new ZapRelease("D-2012-08-01").isNewerThan("D-2012-08-02"));
        Assert.assertFalse((boolean)new ZapRelease("D-2012-01-01").isNewerThan("D-2013-10-10"));
        Assert.assertFalse((boolean)new ZapRelease("1.4").isNewerThan("1.4"));
        Assert.assertTrue((boolean)new ZapRelease("1.4").isNewerThan("1.3.4"));
        Assert.assertTrue((boolean)new ZapRelease("1.4.2").isNewerThan("1.4.1"));
        Assert.assertTrue((boolean)new ZapRelease("1.4.20").isNewerThan("1.4.11"));
        Assert.assertTrue((boolean)new ZapRelease("1.4.alpha.1").isNewerThan("1.3.4"));
        Assert.assertTrue((boolean)new ZapRelease(DEV_BUILD).isNewerThan("1.5"));
        Assert.assertTrue((boolean)new ZapRelease("D-2012-08-02").isNewerThan("D-2012-08-01"));
        Assert.assertTrue((boolean)new ZapRelease("D-2013-10-10").isNewerThan("D-2012-01-01"));
        Assert.assertTrue((boolean)new ZapRelease("D-2013-01-01").isNewerThan("D-2012-12-31"));
        Assert.assertTrue((boolean)new ZapRelease("D-2013-01-07").isNewerThan("D-2012-12-31"));
    }
}

