/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk.impl.http;

import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.brk.AbstractBreakPointMessage;
import org.zaproxy.zap.extension.httppanel.Message;

public class HttpBreakpointMessage
extends AbstractBreakPointMessage {
    private static final Logger logger = Logger.getLogger(HttpBreakpointMessage.class);
    private static final String TYPE = "HTTP";
    private String string;
    private Pattern pattern;
    private Location location;
    private Match match;
    private boolean inverse;
    private boolean ignoreCase;

    public HttpBreakpointMessage(String string, Location location, Match match, boolean bl, boolean bl2) {
        this.string = string;
        this.location = location;
        this.match = match;
        this.inverse = bl;
        this.ignoreCase = bl2;
        this.compilePattern();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
        this.compilePattern();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Match getMatch() {
        return this.match;
    }

    public void setMatch(Match match) {
        this.match = match;
        this.compilePattern();
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean bl) {
        this.inverse = bl;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
        this.compilePattern();
    }

    @Override
    public boolean match(Message message, boolean bl, boolean bl2) {
        if (message instanceof HttpMessage) {
            HttpMessage httpMessage = (HttpMessage)message;
            try {
                URI uRI = (URI)httpMessage.getRequestHeader().getURI().clone();
                uRI.setQuery(null);
                if (bl2 && !Model.getSingleton().getSession().isInScope(uRI.toString())) {
                    return false;
                }
                String string = null;
                switch (this.location) {
                    case url: {
                        string = uRI.getURI();
                        break;
                    }
                    case request_header: {
                        if (!bl) {
                            return false;
                        }
                        string = httpMessage.getRequestHeader().toString();
                        break;
                    }
                    case request_body: {
                        if (!bl) {
                            return false;
                        }
                        string = httpMessage.getRequestBody().toString();
                        break;
                    }
                    case response_header: {
                        if (bl) {
                            return false;
                        }
                        string = httpMessage.getResponseHeader().toString();
                        break;
                    }
                    case response_body: {
                        if (bl) {
                            return false;
                        }
                        string = httpMessage.getResponseBody().toString();
                    }
                }
                boolean bl3 = Match.contains.equals((Object)this.match) ? (this.ignoreCase ? string.toLowerCase().contains(this.string.toLowerCase()) : string.contains(this.string)) : this.pattern.matcher(string).find();
                if (this.inverse) {
                    return !bl3;
                }
                return bl3;
            }
            catch (CloneNotSupportedException | URIException throwable) {
                logger.error((Object)throwable.getMessage(), throwable);
            }
        }
        return false;
    }

    private void compilePattern() {
        try {
            this.pattern = this.ignoreCase ? Pattern.compile(this.string, 2) : Pattern.compile(this.string);
        }
        catch (Exception exception) {
            logger.debug((Object)"Potentially invalid regex", (Throwable)exception);
        }
    }

    @Override
    public String getDisplayMessage() {
        return Constant.messages.getString("brk.brkpoint.location." + this.location.name()) + ": " + Constant.messages.getString("brk.brkpoint.match." + this.match.name()) + ": " + (this.ignoreCase ? Constant.messages.getString("brk.brkpoint.ignorecase.label") : "") + (this.inverse ? Constant.messages.getString("brk.brkpoint.inverse.label") : "") + this.string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof HttpBreakpointMessage)) {
            return false;
        }
        HttpBreakpointMessage httpBreakpointMessage = (HttpBreakpointMessage)object;
        return this.getString().equals(httpBreakpointMessage.getString()) && this.getLocation().equals((Object)httpBreakpointMessage.getLocation()) && this.getMatch().equals((Object)httpBreakpointMessage.getMatch()) && this.isIgnoreCase() == httpBreakpointMessage.isIgnoreCase() && this.isInverse() == httpBreakpointMessage.isInverse();
    }

    public int hashCode() {
        return new HashCodeBuilder(349, 631).append((Object)this.string).append((Object)this.location).append((Object)this.match).append(this.ignoreCase).append(this.inverse).toHashCode();
    }

    public static enum Match {
        contains,
        regex;

    }

    public static enum Location {
        url,
        request_header,
        request_body,
        response_header,
        response_body;

    }
}

