/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.sessions;

import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.sessions.ExtensionSessionManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.SessionManagementMethodType;
import org.zaproxy.zap.utils.ApiUtils;

public class SessionManagementAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(SessionManagementAPI.class);
    private static final String PREFIX = "sessionManagement";
    private static final String VIEW_GET_SESSION_MANAGEMENT_METHOD = "getSessionManagementMethod";
    private static final String VIEW_GET_METHOD_CONFIG_PARAMETERS = "getSessionManagementMethodConfigParams";
    private static final String VIEW_GET_SUPPORTED_METHODS = "getSupportedSessionManagementMethods";
    private static final String ACTION_SET_METHOD = "setSessionManagementMethod";
    public static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_METHOD_NAME = "methodName";
    private static final String PARAM_METHOD_CONFIG_PARAMS = "methodConfigParams";
    private ExtensionSessionManagement extension;
    private Map<String, ApiDynamicActionImplementor> loadedSessionManagementMethodActions;

    public SessionManagementAPI(ExtensionSessionManagement extensionSessionManagement) {
        this.extension = extensionSessionManagement;
        this.addApiView(new ApiView(VIEW_GET_SUPPORTED_METHODS));
        this.addApiView(new ApiView(VIEW_GET_METHOD_CONFIG_PARAMETERS, new String[]{PARAM_METHOD_NAME}));
        this.addApiView(new ApiView(VIEW_GET_SESSION_MANAGEMENT_METHOD, new String[]{PARAM_CONTEXT_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_METHOD, new String[]{PARAM_CONTEXT_ID, PARAM_METHOD_NAME}, new String[]{PARAM_METHOD_CONFIG_PARAMS}));
        this.loadedSessionManagementMethodActions = new HashMap<String, ApiDynamicActionImplementor>();
        if (extensionSessionManagement != null) {
            for (SessionManagementMethodType sessionManagementMethodType : extensionSessionManagement.getSessionManagementMethodTypes()) {
                ApiDynamicActionImplementor apiDynamicActionImplementor = sessionManagementMethodType.getSetMethodForContextApiAction();
                if (apiDynamicActionImplementor == null) continue;
                this.loadedSessionManagementMethodActions.put(apiDynamicActionImplementor.getName(), apiDynamicActionImplementor);
            }
        }
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiView " + string + " " + jSONObject.toString()));
        switch (string) {
            case "getSessionManagementMethod": {
                return this.getContext(jSONObject).getSessionManagementMethod().getApiResponseRepresentation();
            }
            case "getSupportedSessionManagementMethods": {
                ApiResponseList apiResponseList = new ApiResponseList("supportedMethods");
                for (ApiDynamicActionImplementor apiDynamicActionImplementor : this.loadedSessionManagementMethodActions.values()) {
                    apiResponseList.addItem(new ApiResponseElement(PARAM_METHOD_NAME, apiDynamicActionImplementor.getName()));
                }
                return apiResponseList;
            }
            case "getSessionManagementMethodConfigParams": {
                ApiDynamicActionImplementor apiDynamicActionImplementor = this.getSetMethodActionImplementor(jSONObject);
                return apiDynamicActionImplementor.buildParamsDescription();
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiAction " + string + " " + jSONObject.toString()));
        switch (string) {
            case "setSessionManagementMethod": {
                JSONObject jSONObject2 = jSONObject.has(PARAM_METHOD_CONFIG_PARAMS) ? API.getParams(jSONObject.getString(PARAM_METHOD_CONFIG_PARAMS)) : new JSONObject();
                jSONObject2.put((Object)PARAM_CONTEXT_ID, (Object)this.getContextId(jSONObject));
                this.getSetMethodActionImplementor(jSONObject).handleAction(jSONObject2);
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    private ApiDynamicActionImplementor getSetMethodActionImplementor(JSONObject jSONObject) throws ApiException {
        ApiDynamicActionImplementor apiDynamicActionImplementor = this.loadedSessionManagementMethodActions.get(ApiUtils.getNonEmptyStringParam(jSONObject, PARAM_METHOD_NAME));
        if (apiDynamicActionImplementor == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, "No session management method type matches the provided value.");
        }
        return apiDynamicActionImplementor;
    }

    private Context getContext(JSONObject jSONObject) throws ApiException {
        int n = this.getContextId(jSONObject);
        Context context = Model.getSingleton().getSession().getContext(n);
        if (context == null) {
            throw new ApiException(ApiException.Type.CONTEXT_NOT_FOUND, PARAM_CONTEXT_ID);
        }
        return context;
    }

    private int getContextId(JSONObject jSONObject) throws ApiException {
        try {
            return jSONObject.getInt(PARAM_CONTEXT_ID);
        }
        catch (JSONException jSONException) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_CONTEXT_ID);
        }
    }

    private boolean hasContextId(JSONObject jSONObject) {
        try {
            jSONObject.getInt(PARAM_CONTEXT_ID);
        }
        catch (JSONException jSONException) {
            return false;
        }
        return true;
    }
}

