/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stdmenus;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.stdmenus.PopupUserMenu;
import org.zaproxy.zap.extension.users.ContextUserAuthManager;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuMessageContainer;

public abstract class PopupUserMenuItemHolder
extends ExtensionPopupMenuMessageContainer {
    private static final long serialVersionUID = 4454384312614225721L;
    private String parentName;
    private List<ExtensionPopupMenuItem> subMenuItems = null;
    private boolean visibleItself;
    private ExtensionUserManagement extensionUserAuth;

    public PopupUserMenuItemHolder(String string, String string2) {
        super(string);
        this.parentName = string2;
        this.visibleItself = true;
        this.extensionUserAuth = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
        if (this.extensionUserAuth == null || !this.extensionUserAuth.isEnabled()) {
            Logger.getLogger(PopupUserMenuItemHolder.class).warn((Object)(ExtensionUserManagement.class + " is not enabled but is required for getting info about Users."));
            this.extensionUserAuth = null;
        }
    }

    public PopupUserMenuItemHolder(String string) {
        super("UserMenuItemHolder");
        this.parentName = string;
        this.visibleItself = false;
    }

    @Override
    public String getParentMenuName() {
        return this.parentName;
    }

    @Override
    public int getParentMenuIndex() {
        return 0;
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    private List<ExtensionPopupMenuItem> getSubmenuItems() {
        if (this.subMenuItems == null) {
            this.subMenuItems = new ArrayList<ExtensionPopupMenuItem>();
        }
        return this.subMenuItems;
    }

    @Override
    public boolean isEnableForMessageContainer(MessageContainer<?> messageContainer) {
        this.resetMenu();
        if (this.extensionUserAuth == null) {
            return false;
        }
        if (this.visibleItself) {
            return super.isEnableForMessageContainer(messageContainer);
        }
        return false;
    }

    private void resetMenu() {
        Vector<JMenuItem> vector = View.getSingleton().getPopupList();
        if (this.visibleItself) {
            this.removeAll();
        } else {
            for (ExtensionPopupMenuItem object2 : this.getSubmenuItems()) {
                vector.remove(object2);
            }
            this.subMenuItems.clear();
        }
        Session session = Model.getSingleton().getSession();
        List<Context> list = session.getContexts();
        for (Context context : list) {
            ContextUserAuthManager contextUserAuthManager = this.extensionUserAuth.getContextUserAuthManager(context.getIndex());
            for (User user : contextUserAuthManager.getUsers()) {
                PopupUserMenu popupUserMenu;
                if (this.visibleItself) {
                    popupUserMenu = this.getPopupUserMenu(context, user, this.getText());
                    this.add(popupUserMenu);
                    continue;
                }
                popupUserMenu = this.getPopupUserMenu(context, user, this.parentName);
                popupUserMenu.setMenuIndex(this.getMenuIndex());
                vector.add(popupUserMenu);
                this.subMenuItems.add(popupUserMenu);
            }
        }
    }

    public abstract PopupUserMenu getPopupUserMenu(Context var1, User var2, String var3);
}

