/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.users;

import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpState;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.Role;
import org.zaproxy.zap.utils.Enableable;

public class User
extends Enableable {
    private static final Logger log = Logger.getLogger(User.class);
    private static int ID_SOURCE = 0;
    private static final String FIELD_SEPARATOR = ";";
    private int id;
    private String name;
    private int contextId;
    private List<Role> roles;
    private WebSession authenticatedSession;
    private AuthenticationCredentials authenticationCredentials;
    private static ExtensionAuthentication extensionAuth;
    private long lastSuccessfulAuthTime;
    private Context context;

    public User(int n, String string) {
        this.id = ID_SOURCE++;
        this.contextId = n;
        this.name = string;
    }

    public User(int n, String string, int n2) {
        this.id = n2;
        if (this.id >= ID_SOURCE) {
            ID_SOURCE = this.id + 1;
        }
        this.contextId = n;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getContextId() {
        return this.contextId;
    }

    public String toString() {
        return "User [id=" + this.id + ", name=" + this.name + ", contextId=" + this.contextId + ", enabled=" + this.isEnabled() + "]";
    }

    public Context getContext() {
        if (this.context == null) {
            this.context = Model.getSingleton().getSession().getContext(this.contextId);
        }
        return this.context;
    }

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessageToMatchUser(HttpMessage httpMessage) {
        User user = this;
        synchronized (user) {
            if (this.requiresAuthentication()) {
                this.authenticate();
                if (this.requiresAuthentication()) {
                    log.info((Object)("Authentication failed for user: " + this.name));
                    return;
                }
            }
        }
        this.getContext().getSessionManagementMethod().processMessageToMatchSession(httpMessage, this.authenticatedSession);
    }

    public AuthenticationCredentials getAuthenticationCredentials() {
        return this.authenticationCredentials;
    }

    public void setAuthenticationCredentials(AuthenticationCredentials authenticationCredentials) {
        this.authenticationCredentials = authenticationCredentials;
    }

    public boolean requiresAuthentication() {
        return this.authenticatedSession == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAuthentication(HttpMessage httpMessage) {
        User user = this;
        synchronized (user) {
            if (httpMessage.getTimeSentMillis() >= this.getLastSuccessfulAuthTime()) {
                this.authenticatedSession = null;
            }
        }
    }

    protected long getLastSuccessfulAuthTime() {
        return this.lastSuccessfulAuthTime;
    }

    public boolean isAuthenticated(HttpMessage httpMessage) {
        return this.getContext().getAuthenticationMethod().isAuthenticated(httpMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate() {
        log.info((Object)("Authenticating user: " + this.name));
        WebSession webSession = this.getContext().getAuthenticationMethod().authenticate(this.getContext().getSessionManagementMethod(), this.authenticationCredentials, this);
        User user = this;
        synchronized (user) {
            this.lastSuccessfulAuthTime = System.currentTimeMillis();
            this.authenticatedSession = webSession;
        }
    }

    private static ExtensionAuthentication getAuthenticationExtension() {
        if (extensionAuth == null) {
            extensionAuth = (ExtensionAuthentication)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAuthentication");
        }
        return extensionAuth;
    }

    public static String encode(User user) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(user.id).append(FIELD_SEPARATOR);
        stringBuilder.append(user.isEnabled()).append(FIELD_SEPARATOR);
        stringBuilder.append(Base64.encodeBase64String((byte[])user.name.getBytes())).append(FIELD_SEPARATOR);
        stringBuilder.append(user.getContext().getAuthenticationMethod().getType().getUniqueIdentifier()).append(FIELD_SEPARATOR);
        stringBuilder.append(user.authenticationCredentials.encode(FIELD_SEPARATOR));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Encoded user: " + stringBuilder.toString()));
        }
        return stringBuilder.toString();
    }

    public static User decode(int n, String string) {
        return User.decode(n, string, User.getAuthenticationExtension());
    }

    protected static User decode(int n, String string, ExtensionAuthentication extensionAuthentication) {
        String[] stringArray = string.split(FIELD_SEPARATOR);
        User user = null;
        try {
            int n2 = Integer.parseInt(stringArray[0]);
            if (n2 >= ID_SOURCE) {
                ID_SOURCE = n2 + 1;
            }
            boolean bl = stringArray[1].equals("true");
            String string2 = new String(Base64.decodeBase64((String)stringArray[2]));
            int n3 = Integer.parseInt(stringArray[3]);
            user = new User(n, string2, n2);
            user.setEnabled(bl);
            AuthenticationCredentials authenticationCredentials = extensionAuthentication.getAuthenticationMethodTypeForIdentifier(n3).createAuthenticationCredentials();
            authenticationCredentials.decode(stringArray[4]);
            user.setAuthenticationCredentials(authenticationCredentials);
        }
        catch (Exception exception) {
            log.error((Object)("An error occured while decoding user from: " + string), (Throwable)exception);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Decoded user: " + user));
        }
        return user;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        User user = (User)object;
        return this.id == user.id;
    }

    public void setName(String string) {
        this.name = string;
    }

    public HttpState getCorrespondingHttpState() {
        if (this.authenticatedSession != null) {
            return this.authenticatedSession.getHttpState();
        }
        return null;
    }

    public WebSession getAuthenticatedSession() {
        return this.authenticatedSession;
    }

    public void setAuthenticatedSession(WebSession webSession) {
        this.authenticatedSession = webSession;
    }
}

