/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.SingleColumnTableModel;

public class SessionExcludeFromScanPanel
extends AbstractParamPanel {
    public static final String PANEL_NAME = Constant.messages.getString("session.ascan.exclude.title");
    private static final long serialVersionUID = -8337361808959321380L;
    private JPanel panelSession = null;
    private JTable tableIgnore = null;
    private JScrollPane jScrollPane = null;
    private SingleColumnTableModel model = null;

    public SessionExcludeFromScanPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(PANEL_NAME);
        this.add((Component)this.getPanelSession(), this.getPanelSession().getName());
    }

    private JPanel getPanelSession() {
        if (this.panelSession == null) {
            this.panelSession = new JPanel();
            this.panelSession.setLayout(new GridBagLayout());
            this.panelSession.setName("Ignorescan");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            jLabel.setText(Constant.messages.getString("session.ascan.label.ignore"));
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.insets = new Insets(10, 0, 5, 0);
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 18;
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(Constant.messages.getString("options.globalexcludeurl.seeglobalconfig"));
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.anchor = 15;
            this.panelSession.add((Component)jLabel, gridBagConstraints2);
            this.panelSession.add((Component)this.getJScrollPane(), gridBagConstraints);
            this.panelSession.add((Component)jLabel2, gridBagConstraints3);
        }
        return this.panelSession;
    }

    @Override
    public void initParam(Object object) {
        Session session = (Session)object;
        this.getModel().setLines(session.getExcludeFromScanRegexs());
    }

    @Override
    public void validateParam(Object object) {
        for (String string : this.getModel().getLines()) {
            if (string.trim().length() <= 0) continue;
            Pattern.compile(string.trim(), 2);
        }
    }

    @Override
    public void saveParam(Object object) throws Exception {
        Session session = (Session)object;
        session.setExcludeFromScanRegexs(this.getModel().getLines());
    }

    private JTable getTableIgnore() {
        if (this.tableIgnore == null) {
            this.tableIgnore = new JTable();
            this.tableIgnore.setModel(this.getModel());
            this.tableIgnore.setRowHeight(DisplayUtils.getScaledSize(18));
            this.tableIgnore.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }
        return this.tableIgnore;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTableIgnore());
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    private SingleColumnTableModel getModel() {
        if (this.model == null) {
            this.model = new SingleColumnTableModel(Constant.messages.getString("session.ascan.table.header.ignore"));
        }
        return this.model;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.sessprop";
    }
}

