/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.core.Prototype;
import org.owasp.jbrofuzz.encode.EncoderHashCore;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.util.JBroFuzzFileFilter;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class OpenSession {
    private static final int MAX_CHARS = Short.MAX_VALUE;
    private JBroFuzzWindow mWindow;

    public OpenSession(JBroFuzzWindow mWindow) {
        new OpenSession(mWindow, "");
        this.mWindow = mWindow;
    }

    public OpenSession(JBroFuzzWindow mWindow, String fileName) {
        this.mWindow = mWindow;
        File file = null;
        mWindow.setTabShow(124);
        JBroFuzzFileFilter filter = new JBroFuzzFileFilter();
        String dirString = JBroFuzz.PREFS.get(JBroFuzzPrefs.DIRS[2].getId(), System.getProperty("user.dir"));
        JFileChooser fc = new JFileChooser();
        if (!(fileName.length() != 0 && !fileName.equals("") || JBroFuzzPrefs.DBSETTINGS[11].getId().equals("SQLite") || JBroFuzzPrefs.DBSETTINGS[11].getId().equals("CouchDB"))) {
            try {
                fc = new File(dirString).isDirectory() ? new JFileChooser(dirString) : new JFileChooser();
            }
            catch (SecurityException e1) {
                fc = new JFileChooser();
                Logger.log("A security exception occured, while attempting to point to a directory", 4);
            }
            fc.setFileFilter(filter);
            int returnVal = fc.showOpenDialog(mWindow);
            if (returnVal == 0) {
                file = fc.getSelectedFile();
                this.setUpFromFile(file, fc);
            }
        } else if (fileName.length() > 0 && !fileName.equals("")) {
            file = new File(fileName);
            this.setUpFromFile(file, fc);
        }
    }

    private void setUpFromFile(File file, JFileChooser fc) {
        StringBuffer fileContents;
        block58: {
            String path = file.getAbsolutePath().toLowerCase();
            JBroFuzzFileFilter jbfff = new JBroFuzzFileFilter();
            if (!path.endsWith(".jbrofuzz") || !jbfff.accept(file)) {
                JOptionPane.showMessageDialog(fc, "The file selected is not a valid .jbrofuzz file", " JBroFuzz - Open ", 2);
                return;
            }
            this.mWindow.getPanelFuzzing().clearAllFields();
            fileContents = new StringBuffer();
            BufferedReader in = null;
            int counter = 0;
            try {
                int c;
                in = new BufferedReader(new FileReader(file));
                while ((c = in.read()) > 0 && counter < Short.MAX_VALUE) {
                    if (CharUtils.isAsciiPrintable((char)c) || (char)c == '\n') {
                        fileContents.append((char)c);
                    }
                    ++counter;
                }
                in.close();
            }
            catch (FileNotFoundException e) {
                Logger.log("FileNotFoundException", 3);
                IOUtils.closeQuietly(in);
                break block58;
            }
            catch (IOException e) {
                try {
                    Logger.log("IOException", 3);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly(in);
                break block58;
            }
            IOUtils.closeQuietly(in);
        }
        String[] fileContentsArray = fileContents.toString().split("\n");
        int fileNoOfLines = fileContentsArray.length;
        if (fileNoOfLines < 12) {
            Logger.log("Invalid File: Contains less than 8 lines", 3);
            return;
        }
        if (!fileContentsArray[0].equals("[JBroFuzz]")) {
            Logger.log("Invalid File: Line 1 is not [JBroFuzz]", 3);
            return;
        }
        if (!fileContentsArray[2].equals("[Fuzzing]")) {
            Logger.log("Invalid File: Line 3 is not [Fuzzing]", 3);
            return;
        }
        if (!fileContentsArray[4].equals("[Comment]")) {
            Logger.log("Invalid File: Line 5 is not [Comment]", 3);
            return;
        }
        if (!fileContentsArray[6].equals("[URL]")) {
            Logger.log("Invalid File: Line 7 is not [URL]", 3);
            return;
        }
        if (!fileContentsArray[8].equals("[Request]")) {
            Logger.log("Invalid File: Line 9 is not [Request]", 3);
            return;
        }
        int fuzzersLine = 0;
        int fuzzerLineCounter = fileNoOfLines - 1;
        while (fuzzerLineCounter > 0) {
            if (fileContentsArray[fuzzerLineCounter].equals("[Fuzzers]")) {
                if (fuzzersLine != 0) {
                    Logger.log("Invalid File: Found 2 instances of [Fuzzers]", 3);
                    return;
                }
                fuzzersLine = fuzzerLineCounter;
            }
            --fuzzerLineCounter;
        }
        if (fuzzersLine == 0) {
            Logger.log("Invalid File: Cannot find a [Fuzzers] line", 3);
            return;
        }
        int transformsLine = 0;
        int transformsLineCounter = fileNoOfLines - 1;
        while (transformsLineCounter > 0) {
            if (fileContentsArray[transformsLineCounter].equals("[Transforms]")) {
                if (transformsLine != 0) {
                    Logger.log("Invalid File: Found 2 instances of [Transforms]", 3);
                    return;
                }
                transformsLine = transformsLineCounter;
            }
            --transformsLineCounter;
        }
        if (transformsLine == 0) {
            Logger.log("Invalid File: Cannot find a [Transforms] line", 3);
            return;
        }
        if (!fileContentsArray[fileNoOfLines - 1].equals("[End]")) {
            Logger.log("Invalid File: Last line is not [End]", 3);
            return;
        }
        String targetString = StringUtils.abbreviate(fileContentsArray[7], Short.MAX_VALUE);
        this.mWindow.getPanelFuzzing().setTextURL(targetString);
        StringBuffer requestBuffer = new StringBuffer();
        int reqLineCount = 9;
        while (reqLineCount < fuzzersLine) {
            requestBuffer.append(fileContentsArray[reqLineCount]);
            requestBuffer.append('\n');
            ++reqLineCount;
        }
        this.mWindow.getPanelFuzzing().setTextRequest(requestBuffer.toString());
        if (fileNoOfLines - 1 - fuzzersLine - 1 > 1024) {
            Logger.log("Invalid File: More than 1024 Fuzzers Identified", 3);
            return;
        }
        int i = fuzzersLine + 1;
        while (i < transformsLine) {
            block59: {
                String[] payloadArray = fileContentsArray[i].split(",");
                if (payloadArray.length != 3) {
                    Logger.log("Invalid File: Line " + (i + 1) + " does not contain 3 elements", 2);
                } else {
                    String fuzzerID = payloadArray[0];
                    int start = 0;
                    int end = 0;
                    if (!Prototype.isValidFuzzerID(fuzzerID)) {
                        Logger.log("Fuzzer Line Syntax Error: " + (i + 1) + " Invalid Fuzzer ID Format", 2);
                    } else if (!this.mWindow.getJBroFuzz().getDatabase().containsPrototype(fuzzerID)) {
                        Logger.log("Could not find Fuzzer with ID: " + fuzzerID, 2);
                    } else {
                        try {
                            start = Integer.parseInt(payloadArray[1]);
                            end = Integer.parseInt(payloadArray[2]);
                        }
                        catch (NumberFormatException e) {
                            Logger.log("Fuzzer Line Syntax Error: Number Format Exception", 2);
                            break block59;
                        }
                        if (start < 0 || end < 0) {
                            Logger.log("Fuzzer Line Syntax Error: Negative Value", 2);
                        } else if (start > requestBuffer.length() || end > requestBuffer.length()) {
                            Logger.log("Fuzzer Line Syntax Error: Value Larger than Request", 2);
                        } else {
                            Logger.log("Adding Fuzzer Line: \t" + (i + 1) + "\t" + fileContentsArray[i], 1);
                            this.mWindow.getPanelFuzzing().getFuzzersPanel().addFuzzer(fuzzerID, start, end);
                        }
                    }
                }
            }
            ++i;
        }
        if (fileNoOfLines - 1 - transformsLine - 1 > 1024) {
            Logger.log("Invalid File: More than 1024 Transforms Identified", 3);
            return;
        }
        int j = transformsLine + 1;
        while (j < fileNoOfLines - 1) {
            block60: {
                String[] transformLineArray = fileContentsArray[j].split(",");
                int noOfElements = transformLineArray.length;
                if (noOfElements < 2 || noOfElements > 4) {
                    Logger.log("Invalid File: Line " + (j + 1) + " does not contain 4 elements", 2);
                } else {
                    int fuzzerNumber = 0;
                    try {
                        fuzzerNumber = Integer.parseInt(transformLineArray[0]);
                    }
                    catch (NumberFormatException e) {
                        Logger.log("Transform Line Syntax Error: Number Format Exception", 2);
                        break block60;
                    }
                    if (fuzzerNumber < 1) {
                        Logger.log("Transform Line Syntax Error: Value Less Than One", 2);
                    } else if (fuzzerNumber > transformsLine - fuzzersLine) {
                        Logger.log("Transform Line Syntax Error: Transform Outside Fuzzer Range", 2);
                    } else {
                        String encoder = StringUtils.abbreviate(transformLineArray[1], Short.MAX_VALUE);
                        if (!EncoderHashCore.isValidCode(encoder)) {
                            Logger.log("Transform Line Syntax Error: Invalid Encode/Hash Code", 2);
                        } else {
                            String prefix = "";
                            if (transformLineArray.length >= 3) {
                                try {
                                    prefix = new String(Base64.decodeBase64(transformLineArray[2]), "UTF-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    Logger.log("Transform Line Syntax Error: Cannot Decode Prefix", 2);
                                    break block60;
                                }
                                prefix = StringUtils.abbreviate(prefix, Short.MAX_VALUE);
                            }
                            String suffix = "";
                            if (transformLineArray.length >= 4) {
                                try {
                                    suffix = new String(Base64.decodeBase64(transformLineArray[3]), "UTF-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    Logger.log("Transform Line Syntax Error: Cannot Decode Suffix", 2);
                                    break block60;
                                }
                                suffix = StringUtils.abbreviate(suffix, Short.MAX_VALUE);
                            }
                            Logger.log("Adding Transform Line:\t" + (j + 1) + "\tOn Fuzzer Row:\t" + fuzzerNumber, 1);
                            this.mWindow.getPanelFuzzing().getTransformsPanel().addTransform(fuzzerNumber, encoder, prefix, suffix);
                        }
                    }
                }
            }
            ++j;
        }
        this.mWindow.setOpenFileTo(file);
        String parentDir = file.getParent();
        if (parentDir != null) {
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DIRS[2].getId(), parentDir);
        }
    }

    public JBroFuzzWindow getmWindow() {
        return this.mWindow;
    }
}

