/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.control.Separator;
import javafx.scene.layout.Region;

public class SeparatorSkin
extends SkinBase<Separator, BehaviorBase<Separator>> {
    private static final double DEFAULT_LENGTH = 10.0;
    private final Region line = new Region();

    public SeparatorSkin(Separator separator) {
        super(separator, new BehaviorBase<Separator>(separator));
        this.line.getStyleClass().setAll((String[])new String[]{"line"});
        this.getChildren().add(this.line);
        this.registerChangeListener(separator.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(separator.halignmentProperty(), "HALIGNMENT");
        this.registerChangeListener(separator.valignmentProperty(), "VALIGNMENT");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("ORIENTATION".equals(string) || "HALIGNMENT".equals(string) || "VALIGNMENT".equals(string)) {
            this.requestLayout();
        }
    }

    @Override
    protected void layoutChildren() {
        Separator separator = (Separator)this.getSkinnable();
        Insets insets = this.getInsets();
        double d = this.getWidth() - (insets.getLeft() + insets.getRight());
        double d2 = this.getHeight() - (insets.getTop() + insets.getBottom());
        if (separator.getOrientation() == Orientation.HORIZONTAL) {
            this.line.resize(d, this.line.prefHeight(-1.0));
        } else {
            this.line.resize(this.line.prefWidth(-1.0), d2);
        }
        this.positionInArea(this.line, insets.getLeft(), insets.getTop(), d, d2, 0.0, separator.getHalignment(), separator.getValignment());
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = ((Separator)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.line.prefWidth(-1.0) : 10.0;
        return d2 + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = ((Separator)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? 10.0 : this.line.prefHeight(-1.0);
        return d2 + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    @Override
    protected double computeMaxWidth(double d) {
        return ((Separator)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? ((Separator)this.getSkinnable()).prefWidth(d) : Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((Separator)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? Double.MAX_VALUE : ((Separator)this.getSkinnable()).prefHeight(d);
    }
}

