/* gala.vapi generated by valac 0.30.0, do not modify. */

namespace Gala {
	namespace Granite {
		namespace DateTime {
			[CCode (cheader_filename = "gala.h")]
			public static string get_default_date_format (bool with_weekday = false, bool with_day = true, bool with_year = false);
			[CCode (cheader_filename = "gala.h")]
			public static string get_default_time_format (bool is_12h = false, bool with_second = false);
		}
		namespace Drawing {
			[CCode (cheader_filename = "gala.h")]
			public class BufferSurface : GLib.Object {
				public BufferSurface (int width, int height);
				public Gala.Granite.Drawing.Color average_color ();
				public void clear ();
				public void exponential_blur (int radius);
				public void fast_blur (int radius, int process_count = 1);
				public void gaussian_blur (int radius);
				public Gdk.Pixbuf load_to_pixbuf ();
				public BufferSurface.with_buffer_surface (int width, int height, Gala.Granite.Drawing.BufferSurface model);
				public BufferSurface.with_surface (int width, int height, Cairo.Surface model);
				public Cairo.Context context { get; }
				public int height { get; private set; }
				public Cairo.Surface surface { get; private set; }
				public int width { get; private set; }
			}
			[CCode (cheader_filename = "gala.h")]
			public class Color : GLib.Object, Gala.Granite.Services.SettingsSerializable {
				public double A;
				public double B;
				public double G;
				public double R;
				public Color (double R, double G, double B, double A);
				public Gala.Granite.Drawing.Color add_hue (double val);
				public Gala.Granite.Drawing.Color brighten_val (double amount);
				public Gala.Granite.Drawing.Color darken_by_sat (double amount);
				public Gala.Granite.Drawing.Color darken_val (double amount);
				public Color.from_gdk (Gdk.Color color);
				public double get_hue ();
				public double get_sat ();
				public double get_val ();
				public Gala.Granite.Drawing.Color multiply_sat (double amount);
				public Gala.Granite.Drawing.Color set_alpha (double alpha);
				public Gala.Granite.Drawing.Color set_hue (double hue);
				public Gala.Granite.Drawing.Color set_max_sat (double sat);
				public Gala.Granite.Drawing.Color set_max_val (double val);
				public Gala.Granite.Drawing.Color set_min_sat (double sat);
				public Gala.Granite.Drawing.Color set_min_value (double val);
				public Gala.Granite.Drawing.Color set_sat (double sat);
				public Gala.Granite.Drawing.Color set_val (double val);
			}
			[CCode (cheader_filename = "gala.h")]
			public class Utilities : GLib.Object {
				public Utilities ();
				public static Gala.Granite.Drawing.Color average_color (Gdk.Pixbuf source);
				public static void cairo_rounded_rectangle (Cairo.Context cr, double x, double y, double width, double height, double radius);
			}
		}
		namespace Services {
			[CCode (cheader_filename = "gala.h")]
			public abstract class Settings : GLib.Object {
				public Settings (string schema);
				protected virtual void verify (string key);
				public Settings.with_backend (string schema, GLib.SettingsBackend backend);
				public Settings.with_backend_and_path (string schema, GLib.SettingsBackend backend, string path);
				public Settings.with_path (string schema, string path);
				public GLib.Settings schema { get; construct; }
				[Signal (action = true, detailed = true, no_hooks = true, no_recurse = true, run = "first")]
				public signal void changed ();
			}
			[CCode (cheader_filename = "gala.h")]
			public interface SettingsSerializable : GLib.Object {
				public abstract void settings_deserialize (string s);
				public abstract string settings_serialize ();
			}
		}
		namespace StyleClass {
			[CCode (cheader_filename = "gala.h")]
			public const string BADGE;
			[CCode (cheader_filename = "gala.h")]
			public const string CATEGORY_EXPANDER;
			[CCode (cheader_filename = "gala.h")]
			public const string COMPOSITED;
			[CCode (cheader_filename = "gala.h")]
			public const string CONTENT_VIEW;
			[CCode (cheader_filename = "gala.h")]
			public const string CONTENT_VIEW_WINDOW;
			[CCode (cheader_filename = "gala.h")]
			public const string DECORATED_WINDOW;
			[CCode (cheader_filename = "gala.h")]
			public const string H1_TEXT;
			[CCode (cheader_filename = "gala.h")]
			public const string H2_TEXT;
			[CCode (cheader_filename = "gala.h")]
			public const string H3_TEXT;
			[CCode (cheader_filename = "gala.h")]
			public const string HELP_BUTTON;
			[CCode (cheader_filename = "gala.h")]
			public const string OVERLAY_BAR;
			[CCode (cheader_filename = "gala.h")]
			public const string POPOVER;
			[CCode (cheader_filename = "gala.h")]
			public const string POPOVER_BG;
			[CCode (cheader_filename = "gala.h")]
			public const string SOURCE_LIST;
			[CCode (cheader_filename = "gala.h")]
			public const string THIN_PANE_SEPARATOR;
			[CCode (cheader_filename = "gala.h")]
			public const string TITLE_TEXT;
		}
		namespace Widgets {
			namespace Utils {
				[CCode (cheader_filename = "gala.h")]
				public static void apply_text_style_to_label (Gala.Granite.TextStyle text_style, Gtk.Label label);
				[CCode (cheader_filename = "gala.h")]
				public static string? get_button_layout_schema ();
				[CCode (cheader_filename = "gala.h", cname = "get_close_pixbuf")]
				public static Gdk.Pixbuf get_close_pixbuf ();
				[CCode (cheader_filename = "gala.h")]
				public static Gtk.CssProvider? get_css_provider (string stylesheet);
				[CCode (cheader_filename = "gala.h")]
				public static bool get_default_close_button_position (out Gala.Granite.CloseButtonPosition position);
				[CCode (cheader_filename = "gala.h")]
				public static Gtk.CssProvider? set_theming (Gtk.Widget widget, string stylesheet, string? class_name, int priority);
				[CCode (cheader_filename = "gala.h")]
				public static Gtk.CssProvider? set_theming_for_screen (Gdk.Screen screen, string stylesheet, int priority);
			}
		}
		[CCode (cheader_filename = "gala.h")]
		public enum CloseButtonPosition {
			LEFT,
			RIGHT
		}
		[CCode (cheader_filename = "gala.h")]
		public enum TextStyle {
			TITLE,
			H1,
			H2,
			H3;
			public string get_stylesheet (out string style_class = null);
		}
	}
	namespace Plank {
		namespace Drawing {
			[CCode (cheader_filename = "gala.h")]
			public class DockSurface : GLib.Object {
				public DockSurface (int width, int height);
				public Gala.Plank.Drawing.Color average_color ();
				public void clear ();
				public Gala.Plank.Drawing.DockSurface copy ();
				public Gala.Plank.Drawing.DockSurface create_mask (double threshold, out Gdk.Rectangle extent);
				public void exponential_blur (int radius);
				public void fast_blur (int radius, int process_count = 1);
				public void gaussian_blur (int radius);
				public Gdk.Pixbuf to_pixbuf ();
				public DockSurface.with_dock_surface (int width, int height, Gala.Plank.Drawing.DockSurface model);
				public DockSurface.with_internal (Cairo.ImageSurface image);
				public DockSurface.with_surface (int width, int height, Cairo.Surface model);
				public Cairo.Context Context { get; construct; }
				public int Height { get; construct; }
				public Cairo.Surface Internal { get; construct; }
				public int Width { get; construct; }
			}
			[CCode (cheader_filename = "gala.h")]
			public class DockTheme : Gala.Plank.Drawing.Theme {
				public DockTheme (string name);
				public Gala.Plank.Drawing.DockSurface create_background (int width, int height, Gtk.PositionType position, Gala.Plank.Drawing.DockSurface model);
				public Gala.Plank.Drawing.DockSurface create_indicator (int size, Gala.Plank.Drawing.Color color, Gala.Plank.Drawing.DockSurface model);
				public Gala.Plank.Drawing.DockSurface create_urgent_glow (int size, Gala.Plank.Drawing.Color color, Gala.Plank.Drawing.DockSurface model);
				public void draw_active_glow (Gala.Plank.Drawing.DockSurface surface, Gdk.Rectangle clip_rect, Gdk.Rectangle rect, Gala.Plank.Drawing.Color color, double opacity, Gtk.PositionType pos);
				public void draw_item_count (Gala.Plank.Drawing.DockSurface surface, int icon_size, Gala.Plank.Drawing.Color color, int64 count);
				public void draw_item_progress (Gala.Plank.Drawing.DockSurface surface, int icon_size, Gala.Plank.Drawing.Color color, double progress);
				protected override void reset_properties ();
				protected override void verify (string prop);
				[Description (blurb = "The amount of time (in ms) for active window indicator animations.", nick = "active-time")]
				public int ActiveTime { get; set; }
				[Description (blurb = "The padding on the bottom dock edge, in tenths of a percent of IconSize.", nick = "bottom-padding")]
				public double BottomPadding { get; set; }
				[Description (blurb = "The amount of time (in ms) for click animations.", nick = "click-time")]
				public int ClickTime { get; set; }
				[Description (blurb = "The opacity value (0 to 1) to fade the dock to when hiding it.", nick = "fade-opacity")]
				public double FadeOpacity { get; set; }
				[Description (blurb = "The time (in ms) to fade the dock in/out on a hide (if FadeOpacity is < 1).", nick = "fade-time")]
				public int FadeTime { get; set; }
				[Description (blurb = "The time (in ms) of each pulse of the hidden-dock urgent glow.", nick = "glow-pulse-time")]
				public int GlowPulseTime { get; set; }
				[Description (blurb = "The size of the urgent glow (shown when dock is hidden), in tenths of a percent of IconSize.", nick = "glow-size")]
				public int GlowSize { get; set; }
				[Description (blurb = "The total time (in ms) to show the hidden-dock urgent glow.", nick = "glow-time")]
				public int GlowTime { get; set; }
				[Description (blurb = "The time (in ms) to slide the dock in/out on a hide (if FadeOpacity is 1).", nick = "hide-time")]
				public int HideTime { get; set; }
				[Description (blurb = "The padding on the left/right dock edges, in tenths of a percent of IconSize.", nick = "horizontal-padding")]
				public double HorizPadding { get; set; }
				[Description (blurb = "The size of the icon-shadow behind every item, in tenths of a percent of IconSize.", nick = "icon-shadow-size")]
				public double IconShadowSize { get; set; }
				[Description (blurb = "The size of item indicators, in tenths of a percent of IconSize.", nick = "indicator-size")]
				public double IndicatorSize { get; set; }
				[Description (blurb = "The time (in ms) to move an item to its new position or its addition/removal to/from the dock.", nick = "item-move-time")]
				public int ItemMoveTime { get; set; }
				[Description (blurb = "The padding between items on the dock, in tenths of a percent of IconSize.", nick = "item-padding")]
				public double ItemPadding { get; set; }
				[Description (blurb = "The height (in percent of IconSize) to bounce an icon when launching an application.", nick = "launch-bounce")]
				public double LaunchBounceHeight { get; set; }
				[Description (blurb = "The amount of time (in ms) to bounce an icon when launching an application.", nick = "launch-bounce-time")]
				public int LaunchBounceTime { get; set; }
				[Description (blurb = "The amount of time (in ms) to slide icons into/out of the dock.", nick = "slide-time")]
				public int SlideTime { get; set; }
				[Description (blurb = "The padding on the top dock edge, in tenths of a percent of IconSize.", nick = "top-padding")]
				public double TopPadding { get; set; }
				[Description (blurb = "The height (in percent of IconSize) to bounce an icon when the application sets urgent.", nick = "urgent-bounce")]
				public double UrgentBounceHeight { get; set; }
				[Description (blurb = "The amount of time (in ms) to bounce an urgent icon.", nick = "urgent-bounce-time")]
				public int UrgentBounceTime { get; set; }
				[Description (blurb = "The hue-shift (-180 to 180) of the urgent indicator color.", nick = "urgent-hue-shift")]
				public int UrgentHueShift { get; set; }
			}
			[CCode (cheader_filename = "gala.h")]
			public class DrawingService : GLib.Object {
				public static Gdk.Pixbuf ar_scale (Gdk.Pixbuf source, int width, int height);
				public static Gala.Plank.Drawing.Color average_color (Gdk.Pixbuf source);
				public static string? get_icon_from_file (GLib.File file);
				public static string? get_icon_from_gicon (GLib.Icon? icon);
				public static Gdk.Pixbuf load_icon (string names, int width, int height);
				public static GLib.File? try_get_icon_file (string name);
			}
			[CCode (cheader_filename = "gala.h")]
			public abstract class Theme : Gala.Plank.Services.Preferences {
				public const string DEFAULT_NAME;
				public const string GTK_THEME_NAME;
				public Theme ();
				public void draw_background (Gala.Plank.Drawing.DockSurface surface);
				protected void draw_inner_rect (Cairo.Context cr, int width, int height);
				public static void draw_rounded_line (Cairo.Context cr, double x, double y, double width, double height, bool is_round_left, bool is_round_right, Cairo.Pattern? stroke = null, Cairo.Pattern? fill = null);
				public static void draw_rounded_rect (Cairo.Context cr, double x, double y, double width, double height, double top_radius = 6.0, double bottom_radius = 6.0, double line_width = 1.0);
				public int get_bottom_offset ();
				public static GLib.File? get_theme_folder (string name);
				public static string[] get_theme_list ();
				public int get_top_offset ();
				public void load (string type);
				protected override void reset_properties ();
				protected override void verify (string prop);
				public Theme.with_name (string name);
				[Description (blurb = "The roundness of the bottom corners.", nick = "bottom-roundness")]
				public int BottomRoundness { get; set; }
				[Description (blurb = "The ending color (RGBA) of the fill gradient.", nick = "fill-end-color")]
				public Gala.Plank.Drawing.Color FillEndColor { get; set; }
				[Description (blurb = "The starting color (RGBA) of the fill gradient.", nick = "fill-start-color")]
				public Gala.Plank.Drawing.Color FillStartColor { get; set; }
				[Description (blurb = "The color (RGBA) of the inner stroke.", nick = "inner-stroke-color")]
				public Gala.Plank.Drawing.Color InnerStrokeColor { get; set; }
				[Description (blurb = "The thickness (in pixels) of lines drawn.", nick = "line-width")]
				public int LineWidth { get; set; }
				[Description (blurb = "The color (RGBA) of the outer stroke.", nick = "outer-stroke-color")]
				public Gala.Plank.Drawing.Color OuterStrokeColor { get; set; }
				[Description (blurb = "The roundness of the top corners.", nick = "top-roundness")]
				public int TopRoundness { get; set; }
			}
			[CCode (cheader_filename = "gala.h")]
			public struct Color : Gdk.RGBA {
				public void add_hue (double val);
				public void brighten_val (double amount);
				public void darken_by_sat (double amount);
				public void darken_val (double amount);
				public static Gala.Plank.Drawing.Color from_prefs_string (string s);
				public void get_hsv (out double h, out double s, out double v);
				public double get_hue ();
				public double get_sat ();
				public double get_val ();
				public void multiply_sat (double amount);
				public void set_hsv (double h, double s, double v);
				public void set_hue (double hue);
				public void set_max_sat (double sat);
				public void set_max_val (double val);
				public void set_min_sat (double sat);
				public void set_min_val (double val);
				public void set_sat (double sat);
				public void set_val (double val);
				public string to_prefs_string ();
			}
		}
		namespace Services {
			[CCode (cheader_filename = "gala.h")]
			public class Logger : GLib.Object {
				public static void initialize (string app_name);
				public static void notification (string msg, string icon = "");
				public static void verbose (string msg, ...);
				public static Gala.Plank.Services.LogLevel DisplayLevel { get; set; }
			}
			[CCode (cheader_filename = "gala.h")]
			public class Paths : GLib.Object {
				public static bool ensure_directory_exists (GLib.File dir);
				public static void initialize (string app_name, string data_folder);
				public static GLib.File AppCacheFolder { get; protected set; }
				public static GLib.File AppConfigFolder { get; protected set; }
				public static GLib.File AppDataFolder { get; protected set; }
				public static string AppName { get; protected set; }
				public static GLib.File AppThemeFolder { get; protected set; }
				public static GLib.File CacheHomeFolder { get; protected set; }
				public static GLib.File ConfigHomeFolder { get; protected set; }
				public static Gee.ArrayList<GLib.File> DataDirFolders { get; protected set; }
				public static GLib.File DataFolder { get; protected set; }
				public static GLib.File DataHomeFolder { get; protected set; }
				public static GLib.File HomeFolder { get; protected set; }
				public static GLib.File ThemeFolder { get; protected set; }
			}
			[CCode (cheader_filename = "gala.h")]
			public abstract class Preferences : GLib.Object {
				public Preferences ();
				public void apply ();
				public void delay ();
				public void @delete ();
				public unowned GLib.File? get_backing_file ();
				public string get_filename ();
				protected void init_from_file (GLib.File file);
				protected void init_from_filename (string filename);
				protected abstract void reset_properties ();
				protected virtual void verify (string prop);
				public Preferences.with_file (GLib.File file);
				public Preferences.with_filename (string filename);
				public signal void deleted ();
			}
			[CCode (cheader_filename = "gala.h")]
			public interface PrefsSerializable : GLib.Object {
				public abstract void prefs_deserialize (string s);
				public abstract string prefs_serialize ();
			}
			[CCode (cheader_filename = "gala.h")]
			public enum LogLevel {
				VERBOSE,
				DEBUG,
				INFO,
				NOTIFY,
				WARN,
				ERROR,
				FATAL
			}
		}
		[CCode (cheader_filename = "gala.h")]
		public class DockPreferences : Gala.Plank.Services.Preferences {
			public const int MAX_ICON_SIZE;
			public const int MIN_ICON_SIZE;
			public DockPreferences ();
			public void decrease_icon_size ();
			public void increase_icon_size ();
			public bool is_horizontal_dock ();
			protected override void reset_properties ();
			protected override void verify (string prop);
			public DockPreferences.with_file (GLib.File file);
			public DockPreferences.with_filename (string filename);
			[Description (blurb = "The alignment for the dock on the monitor's edge.  If 0, panel-mode.  If 1, left-aligned.  If 2, right-aligned.  If 3, centered.", nick = "alignment")]
			public Gtk.Align Alignment { get; set; }
			[Description (blurb = "Whether to automatically pin an application if it seems useful to do.", nick = "auto-pinning")]
			public bool AutoPinning { get; set; }
			[Description (blurb = "Whether to show only windows of the current workspace.", nick = "current-workspace-only")]
			public bool CurrentWorkspaceOnly { get; set; }
			[Description (blurb = "List of *.dockitem files on this dock. DO NOT MODIFY", nick = "dock-items")]
			public string DockItems { get; set; }
			[Description (blurb = "Time (in ms) to wait before hiding the dock.", nick = "hide-delay")]
			public uint HideDelay { get; set; }
			[Description (blurb = "If 0, the dock won't hide.  If 1, the dock intelligently hides.  If 2, the dock auto-hides. If 3, the dock dodges active maximized windows. If 4, the dock dodges every window.", nick = "hide-mode")]
			public Gala.Plank.HideType HideMode { get; set; }
			[Description (blurb = "The size of dock icons (in pixels).", nick = "icon-size")]
			public int IconSize { get; set; }
			[Description (blurb = "The alignment of the items in this dock if panel-mode is used.  If 1, left-aligned.  If 2, right-aligned.  If 3, centered.", nick = "items-alignment")]
			public Gtk.Align ItemsAlignment { get; set; }
			[Description (blurb = "Whether to prevent drag'n'drop actions and lock items on the dock.", nick = "lock-items")]
			public bool LockItems { get; set; }
			[Description (blurb = "The plug-name of the monitor for the dock to show on (e.g. DVI-I-1, HDMI1, LVDS1). Leave this empty to keep on the primary monitor.", nick = "monitor")]
			public string Monitor { get; set; }
			[Description (blurb = "The dock's position offset from center (in percent).", nick = "offset")]
			public int Offset { get; set; }
			[Description (blurb = "Whether to show only pinned applications. Useful for running more then one dock.", nick = "pinned-only")]
			public bool PinnedOnly { get; set; }
			[Description (blurb = "The position for the dock on the monitor.  If 0, left.  If 1, right.  If 2, top.  If 3, bottom.", nick = "position")]
			public Gtk.PositionType Position { get; set; }
			[Description (blurb = "Whether to use pressure-based revealing of the dock if the support is available.", nick = "pressure-reveal")]
			public bool PressureReveal { get; set; }
			[Description (blurb = "Whether to show the item for the dock itself.", nick = "show-dock-item")]
			public bool ShowDockItem { get; set; }
			[Description (blurb = "The name of the dock's theme to use.", nick = "theme")]
			public string Theme { get; set; }
			[Description (blurb = "Time (in ms) to wait before unhiding the dock.", nick = "unhide-delay")]
			public uint UnhideDelay { get; set; }
		}
		[CCode (cheader_filename = "gala.h")]
		public enum HideType {
			NONE,
			INTELLIGENT,
			AUTO,
			DODGE_MAXIMIZED,
			WINDOW_DODGE
		}
		[CCode (cheader_filename = "gala.h")]
		public const string G_RESOURCE_PATH;
	}
	[CCode (cheader_filename = "gala.h")]
	public class ModalProxy : GLib.Object {
		public ModalProxy ();
		public void allow_all_keybindings ();
		public Gala.KeybindingFilter? keybinding_filter { get; owned set; }
	}
	[CCode (cheader_filename = "gala.h")]
	public abstract class Plugin : GLib.Object {
		public Plugin ();
		public abstract void destroy ();
		public abstract void initialize (Gala.WindowManager wm);
		public void track_actor (Clutter.Actor actor);
		public void untrack_actor (Clutter.Actor actor);
		public void update_region ();
		protected Meta.Rectangle[]? custom_region { get; protected set; }
		protected bool freeze_track { get; set; }
		public Meta.Rectangle[] region { get; private set; }
		public signal void region_changed ();
	}
	[CCode (cheader_filename = "gala.h")]
	public class Utils {
		public static void bell (Meta.Screen screen);
		public static GtkClutter.Texture create_close_button ();
		public static Gdk.Pixbuf? get_close_button_pixbuf ();
		public static Gdk.Pixbuf get_icon_for_window (Meta.Window window, int size, bool ignore_cache = false);
		public static Gdk.Pixbuf get_icon_for_xid (uint32 xid, int size, bool ignore_cache = false);
		public static uint get_n_windows (Meta.Workspace workspace);
		public static Meta.Window get_next_window (Meta.Workspace workspace, bool backward = false);
		public static Clutter.Actor? get_window_actor_snapshot (Meta.WindowActor actor, Meta.Rectangle inner_rect, Meta.Rectangle outer_rect);
		public static void request_clean_icon_cache (uint32[] xids);
	}
	[CCode (cheader_filename = "gala.h")]
	public class WindowIcon : GtkClutter.Texture {
		public const int SHADOW_DISTANCE;
		public const uint8 SHADOW_OPACITY;
		public const int SHADOW_SIZE;
		public WindowIcon (Meta.Window window, int icon_size, bool destroy_on_unmanaged = false);
		public bool destroy_on_unmanaged { get; set construct; }
		public int icon_size { get; construct; }
		public Meta.Window window { get; construct; }
	}
	[CCode (cheader_filename = "gala.h")]
	public interface ActivatableComponent : GLib.Object {
		public abstract void close ();
		public abstract bool is_opened ();
		public abstract void open (GLib.HashTable<string,GLib.Variant>? hints = null);
	}
	[CCode (cheader_filename = "gala.h")]
	public interface WindowManager : Meta.Plugin {
		public abstract bool is_modal ();
		public abstract bool modal_proxy_valid (Gala.ModalProxy proxy);
		public abstract void move_window (Meta.Window? window, Meta.MotionDirection direction);
		public abstract void perform_action (Gala.ActionType type);
		public abstract void pop_modal (Gala.ModalProxy proxy);
		public abstract Gala.ModalProxy push_modal ();
		public abstract void switch_to_next_workspace (Meta.MotionDirection direction);
		public abstract Meta.BackgroundGroup background_group { get; protected set; }
		public abstract Clutter.Stage stage { get; protected set; }
		public abstract Clutter.Actor top_window_group { get; protected set; }
		public abstract Clutter.Actor ui_group { get; protected set; }
		public abstract Clutter.Actor window_group { get; protected set; }
	}
	[CCode (cheader_filename = "gala.h")]
	public struct PluginInfo {
		public string name;
		public string author;
		public GLib.Type plugin_type;
		public Gala.PluginFunction provides;
		public Gala.LoadPriority load_priority;
		public string module_name;
	}
	[CCode (cheader_filename = "gala.h")]
	public enum ActionType {
		NONE,
		SHOW_WORKSPACE_VIEW,
		MAXIMIZE_CURRENT,
		MINIMIZE_CURRENT,
		OPEN_LAUNCHER,
		CUSTOM_COMMAND,
		WINDOW_OVERVIEW,
		WINDOW_OVERVIEW_ALL
	}
	[CCode (cheader_filename = "gala.h")]
	public enum LoadPriority {
		IMMEDIATE,
		DEFERRED
	}
	[CCode (cheader_filename = "gala.h")]
	public enum PluginFunction {
		ADDITION,
		WINDOW_SWITCHER,
		DESKTOP,
		WORKSPACE_VIEW,
		WINDOW_OVERVIEW
	}
	[CCode (cheader_filename = "gala.h")]
	public delegate bool KeybindingFilter (Meta.KeyBinding binding);
}
