/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro.version3;

import dguitar.codecs.guitarPro.GPBeat;
import dguitar.codecs.guitarPro.GPBend;
import dguitar.codecs.guitarPro.GPBendPoint;
import dguitar.codecs.guitarPro.GPBendType;
import dguitar.codecs.guitarPro.GPChordDiagram;
import dguitar.codecs.guitarPro.GPChordNote;
import dguitar.codecs.guitarPro.GPChordType;
import dguitar.codecs.guitarPro.GPColor;
import dguitar.codecs.guitarPro.GPDuration;
import dguitar.codecs.guitarPro.GPDynamic;
import dguitar.codecs.guitarPro.GPEffectsOnBeat;
import dguitar.codecs.guitarPro.GPEffectsOnNote;
import dguitar.codecs.guitarPro.GPFingering;
import dguitar.codecs.guitarPro.GPGraceNote;
import dguitar.codecs.guitarPro.GPGraceNoteTransition;
import dguitar.codecs.guitarPro.GPHarmonic;
import dguitar.codecs.guitarPro.GPInputStream;
import dguitar.codecs.guitarPro.GPKey;
import dguitar.codecs.guitarPro.GPMIDIChannel;
import dguitar.codecs.guitarPro.GPMarker;
import dguitar.codecs.guitarPro.GPMeasure;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import dguitar.codecs.guitarPro.GPMixTableChange;
import dguitar.codecs.guitarPro.GPMixTableElement;
import dguitar.codecs.guitarPro.GPNote;
import dguitar.codecs.guitarPro.GPSlide;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.guitarPro.GPTonalityType;
import dguitar.codecs.guitarPro.GPTrack;
import dguitar.codecs.guitarPro.GPTrackLyrics;
import dguitar.codecs.guitarPro.GPVibrato;
import dguitar.codecs.guitarPro.version3.GP3EffectsOnBeat;
import dguitar.codecs.guitarPro.version3.GP3Piece;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class GP3InputStream
extends GPInputStream {
    private static final String[] supportedVersions = new String[]{"FICHIER GUITAR PRO v3.00"};

    public GP3InputStream(InputStream in) {
        super(in);
    }

    public GP3InputStream(GPInputStream gpIn) {
        super(gpIn);
    }

    public static boolean supportedVersion(String version) {
        boolean correct = false;
        int i = 0;
        while (i < supportedVersions.length && !correct) {
            correct = version.equals(supportedVersions[i]);
            ++i;
        }
        return correct;
    }

    public static String supportedVersions() {
        String s = "";
        int i = 0;
        while (i < supportedVersions.length) {
            s = String.valueOf(s) + supportedVersions[i];
            if (i + 1 < supportedVersions.length) {
                s = String.valueOf(s) + "\n";
            }
            ++i;
        }
        return s;
    }

    public GPSong readPiece() throws IOException {
        GP3Piece piece = new GP3Piece();
        if (this.__version.equals("")) {
            this.__version = this.readStringByte(30);
        }
        piece.setVersion(this.__version);
        String s = this.readStringIntegerPlusOne();
        piece.setTitle(s);
        s = this.readStringIntegerPlusOne();
        piece.setSubtitle(s);
        s = this.readStringIntegerPlusOne();
        piece.setInterpret(s);
        s = this.readStringIntegerPlusOne();
        piece.setAlbum(s);
        s = this.readStringIntegerPlusOne();
        piece.setAuthorSong(s);
        s = this.readStringIntegerPlusOne();
        piece.setCopyright(s);
        s = this.readStringIntegerPlusOne();
        piece.setAuthorPiece(s);
        s = this.readStringIntegerPlusOne();
        piece.setInstruction(s);
        int nbNotes = this.readInt();
        String note = "";
        int i = 0;
        while (i < nbNotes) {
            note = String.valueOf(note) + this.readStringIntegerPlusOne();
            note = String.valueOf(note) + "\n";
            ++i;
        }
        piece.setNote(note);
        piece.tripletFeel = this.readBoolean();
        GPTrackLyrics lyrics = new GPTrackLyrics();
        piece.setLyrics(lyrics);
        int tempo = this.readInt();
        piece.setTempo(tempo);
        GPKey k = GPKey.valueOf(this.readInt());
        piece.setKey(k);
        piece.setOctave(0);
        int i2 = 0;
        while (i2 < 64) {
            GPMIDIChannel channel = this.readMIDIChannel();
            piece.setChannels(i2, channel);
            ++i2;
        }
        int numberOfMeasures = this.readInt();
        int numberOfTracks = this.readInt();
        List measures = piece.getMeasures();
        if (numberOfMeasures > 0) {
            GPMeasure measure = this.readMeasure(null);
            measure.setNumber(1);
            measures.add(measure);
            int i3 = 1;
            while (i3 < numberOfMeasures) {
                GPMeasure previous = (GPMeasure)measures.get(i3 - 1);
                measure = this.readMeasure(previous);
                measure.setNumber(i3 + 1);
                measures.add(measure);
                ++i3;
            }
        }
        List tracks = piece.getTracks();
        int i4 = 0;
        while (i4 < numberOfTracks) {
            tracks.add(this.readTrack());
            ++i4;
        }
        List measuresTracksPairs = piece.getMeasuresTracksPairs();
        int i5 = 0;
        while (i5 < numberOfMeasures) {
            int j = 0;
            while (j < numberOfTracks) {
                GPMeasureTrackPair mtp = this.readMeasureTrackPair();
                measuresTracksPairs.add(mtp);
                ++j;
            }
            ++i5;
        }
        i5 = 0;
        boolean different = false;
        int b = this.read();
        while (b != -1) {
            if (!different && ++i5 > 4) {
                different = true;
            }
            b = this.read();
        }
        if (different) {
            System.err.println("GP3InputStream: This GP3 file has something special...");
        }
        return piece;
    }

    private GPBeat readBeat() throws IOException {
        GPBeat beat = new GPBeat();
        GP3EffectsOnBeat gp3effects = new GP3EffectsOnBeat();
        int header = this.readUnsignedByte();
        if ((header & 0x80) != 0) {
            System.err.println("Oops, header & 0x80 !");
            header &= 0x3F;
        }
        if ((header & 0x40) != 0) {
            int beatStatus = this.readUnsignedByte();
            beat.setEmptyBeat(beatStatus == 0);
            beat.setRestBeat(beatStatus == 2);
        }
        beat.dottedNotes = (header & 1) != 0;
        GPDuration duration = GPDuration.valueOf(this.readByte());
        beat.setDuration(duration);
        if ((header & 0x20) != 0) {
            int n = this.readInt();
            beat.setNTuplet(n);
        }
        if ((header & 2) != 0) {
            beat.chordDiagram = this.readChordDiagram();
        }
        if ((header & 4) != 0) {
            beat.text = this.readStringIntegerPlusOne();
        }
        if ((header & 8) != 0) {
            beat.effects = this.readEffectsOnBeat(gp3effects);
        }
        if ((header & 0x10) != 0) {
            beat.mixTableChange = this.readMixTableChange();
        }
        int stringsPlayed = this.readUnsignedByte();
        int numberOfStrings = 0;
        int i = 0;
        while (i < 7) {
            if ((stringsPlayed & 1 << i) != 0) {
                ++numberOfStrings;
                beat.setString(i, true);
            }
            ++i;
        }
        List notes = beat.getNotes();
        int i2 = 0;
        while (i2 < numberOfStrings) {
            GPNote note = this.readNote();
            if (gp3effects.hasEffects()) {
                if (note.effects == null) {
                    note.effects = new GPEffectsOnNote();
                }
                note.effects.harmonic = gp3effects.harmonic;
                note.effects.leftHandVibrato = gp3effects.vibrato;
                note.effects.wideVibrato = gp3effects.wideVibrato;
            }
            notes.add(note);
            ++i2;
        }
        return beat;
    }

    private GPBend readBend() throws IOException {
        GPBend bend = new GPBend();
        GPBendType type = GPBendType.valueOf(this.readByte());
        bend.setType(type);
        bend.setValue(this.readInt());
        int numPoints = this.readInt();
        List points = bend.getPoints();
        int i = 0;
        while (i < numPoints) {
            points.add(this.readBendPoint());
            ++i;
        }
        return bend;
    }

    private GPBendPoint readBendPoint() throws IOException {
        GPBendPoint bendPoint = new GPBendPoint();
        bendPoint.setPosition(this.readInt());
        bendPoint.setValue(this.readInt());
        GPVibrato vibrato = GPVibrato.valueOf(this.readByte());
        bendPoint.setVibrato(vibrato);
        return bendPoint;
    }

    private GPChordDiagram readChordDiagram() throws IOException {
        boolean debug = false;
        GPChordDiagram cd = new GPChordDiagram();
        int header = this.readUnsignedByte();
        if ((header & 1) == 0) {
            cd.setName(this.readStringIntegerPlusOne());
            int base = this.readInt();
            cd.setBaseFret(base);
            if (base != 0) {
                int i = 0;
                while (i < 6) {
                    cd.setFret(i + 1, this.readInt());
                    ++i;
                }
            }
        } else {
            cd.setSharp(this.readBoolean());
            this.skip(3L);
            cd.setRoot(GPChordNote.valueOf(this.readInt()));
            cd.setChordType(GPChordType.valueOf(this.readInt()));
            cd.setNineElevenThirteen(this.readInt());
            cd.setBass(GPChordNote.valueOf(this.readInt()));
            cd.setTonalityType(GPTonalityType.valueOf(this.readUnsignedByte()));
            this.skip(3L);
            cd.setAddedNote(this.readUnsignedByte());
            cd.setName(this.readStringByte(34));
            cd.setBaseFret(this.readInt());
            int i = 0;
            while (i < 6) {
                cd.setFret(i + 1, this.readInt());
                ++i;
            }
            i = 0;
            while (i < 28) {
                int n = this.readUnsignedByte();
                if (debug) {
                    System.out.print(String.valueOf(n) + " ");
                }
                ++i;
            }
            if (debug) {
                System.out.println();
            }
            i = 0;
            while (i < 7) {
                this.readUnsignedByte();
                ++i;
            }
            int n = this.readUnsignedByte();
            if (debug) {
                System.out.println(n);
            }
        }
        return cd;
    }

    private GPColor readColor() throws IOException {
        GPColor color = new GPColor();
        color.red = this.readUnsignedByte();
        color.green = this.readUnsignedByte();
        color.blue = this.readUnsignedByte();
        this.read();
        return color;
    }

    private GPEffectsOnBeat readEffectsOnBeat(GP3EffectsOnBeat gp3effects) throws IOException {
        GPEffectsOnBeat eob = new GPEffectsOnBeat();
        int header = this.readUnsignedByte();
        if ((header & 0x20) != 0) {
            int effect = this.readUnsignedByte();
            if (effect == 0) {
                int value = this.readInt();
                GPBend tremoloBar = new GPBend();
                tremoloBar.setType(GPBendType.DIP);
                tremoloBar.setValue(value);
                List points = tremoloBar.getPoints();
                GPBendPoint bendPoint = new GPBendPoint();
                bendPoint.setPosition(0);
                bendPoint.setValue(0);
                bendPoint.setVibrato(GPVibrato.NONE);
                points.add(bendPoint);
                bendPoint = new GPBendPoint();
                bendPoint.setPosition(30);
                bendPoint.setValue(-value);
                bendPoint.setVibrato(GPVibrato.NONE);
                points.add(bendPoint);
                bendPoint = new GPBendPoint();
                bendPoint.setPosition(60);
                bendPoint.setValue(0);
                bendPoint.setVibrato(GPVibrato.NONE);
                points.add(bendPoint);
                eob.tremoloBar = tremoloBar;
            } else {
                switch (effect) {
                    case 1: {
                        eob.tapping = true;
                        break;
                    }
                    case 2: {
                        eob.slapping = true;
                        break;
                    }
                    case 3: {
                        eob.popping = true;
                        break;
                    }
                    default: {
                        throw new IOException("Unexpected value in effect: " + effect);
                    }
                }
                int dummy = this.readInt();
                if (dummy != 0) {
                    System.err.println("dummy = " + dummy);
                }
            }
        }
        if ((header & 0x40) != 0) {
            byte durationValue = this.readByte();
            if (durationValue != 0) {
                eob.upStroke = GPDuration.valueOf(6 - durationValue);
            }
            if ((durationValue = this.readByte()) != 0) {
                eob.downStroke = GPDuration.valueOf(6 - durationValue);
            }
        }
        boolean bl = gp3effects.vibrato = (header & 1) != 0;
        if ((header & 2) != 0) {
            gp3effects.wideVibrato = true;
        }
        if ((header & 4) != 0) {
            gp3effects.harmonic = GPHarmonic.NATURAL;
        }
        if ((header & 8) != 0) {
            gp3effects.harmonic = GPHarmonic.ARTIFICIAL_12;
        }
        eob.fadeIn = (header & 0x10) != 0;
        return eob;
    }

    private GPEffectsOnNote readEffectsOnNote() throws IOException {
        GPEffectsOnNote eon = new GPEffectsOnNote();
        int header = this.readUnsignedByte();
        if ((header & 1) != 0) {
            eon.bend = this.readBend();
        }
        if ((header & 0x10) != 0) {
            eon.graceNote = this.readGraceNote();
        }
        if ((header & 4) != 0) {
            eon.slide = GPSlide.SHIFT_SLIDE;
        }
        eon.letRing = (header & 8) != 0;
        eon.hammerOnPullOff = (header & 2) != 0;
        return eon;
    }

    private GPGraceNote readGraceNote() throws IOException {
        GPGraceNote gn = new GPGraceNote();
        byte[] b = new byte[4];
        this.read(b);
        gn.setFret(b[0]);
        gn.setDynamic(GPDynamic.valueOf(b[1]));
        gn.setTransition(GPGraceNoteTransition.valueOf(b[2]));
        gn.setDuration(GPDuration.valueOf(5 - b[3]));
        return gn;
    }

    private GPMarker readMarker() throws IOException {
        GPMarker marker = new GPMarker();
        marker.setName(this.readStringIntegerPlusOne());
        marker.setColor(this.readColor());
        return marker;
    }

    private GPMeasure readMeasure(GPMeasure previous) throws IOException {
        GPMeasure measure = new GPMeasure(previous);
        int header = this.readUnsignedByte();
        if ((header & 1) != 0) {
            measure.setNumerator(this.readByte());
        }
        if ((header & 2) != 0) {
            measure.setDenominator(this.readByte());
        }
        boolean bl = measure.repeatStart = (header & 4) != 0;
        if ((header & 8) != 0) {
            measure.setNumberOfRepetitions(this.readByte());
        }
        if ((header & 0x10) != 0) {
            measure.setNumberOfAlternateEnding(this.readByte());
        }
        if ((header & 0x20) != 0) {
            measure.marker = this.readMarker();
        }
        if ((header & 0x40) != 0) {
            byte type = this.readByte();
            GPKey key = GPKey.valueOf(this.readByte(), type);
            measure.setTonality(key);
        }
        if ((header & 0x80) != 0) {
            System.err.println("prout");
        }
        measure.hasDoubleBar = (header & 0x80) != 0;
        return measure;
    }

    private GPMeasureTrackPair readMeasureTrackPair() throws IOException {
        GPMeasureTrackPair mtp = new GPMeasureTrackPair();
        List beats = mtp.getBeats();
        int numberOfBeats = this.readInt();
        int i = 0;
        while (i < numberOfBeats) {
            GPBeat beat = this.readBeat();
            beats.add(beat);
            ++i;
        }
        return mtp;
    }

    private GPMIDIChannel readMIDIChannel() throws IOException {
        GPMIDIChannel channel = new GPMIDIChannel();
        channel.setInstrument(this.readInt());
        channel.setVolume(this.readByte());
        channel.setBalance(this.readByte());
        channel.setChorus(this.readByte());
        channel.setReverb(this.readByte());
        channel.setPhaser(this.readByte());
        channel.setTremolo(this.readByte());
        this.skip(2L);
        return channel;
    }

    private GPMixTableChange readMixTableChange() throws IOException {
        int aux;
        int[] pos = new int[8];
        GPMixTableChange mtc = new GPMixTableChange();
        GPMixTableElement[] elements = new GPMixTableElement[8];
        int i = 0;
        while (i < 8) {
            elements[i] = new GPMixTableElement();
            ++i;
        }
        mtc.instrument = elements[0];
        mtc.volume = elements[1];
        mtc.balance = elements[2];
        mtc.chorus = elements[3];
        mtc.reverb = elements[4];
        mtc.phaser = elements[5];
        mtc.tremolo = elements[6];
        mtc.tempo = elements[7];
        int n = 0;
        i = 0;
        while (i < 7) {
            aux = this.readByte();
            if (i != 0 && aux != -1) {
                pos[n] = i;
                ++n;
            }
            elements[i].setNewValue(aux);
            ++i;
        }
        aux = this.readInt();
        if (aux != -1) {
            pos[n] = i;
            ++n;
        }
        elements[7].setNewValue(aux);
        i = 0;
        while (i < n) {
            aux = this.readByte();
            if (elements[pos[i]].getNewValue() != -1) {
                elements[pos[i]].setChangeDuration(aux);
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            elements[i].applyToAllTracks = false;
            ++i;
        }
        return mtc;
    }

    private GPNote readNote() throws IOException {
        GPNote note = new GPNote();
        int header = this.readUnsignedByte();
        note.isAccentuated = (header & 0x40) != 0;
        note.isDotted = (header & 2) != 0;
        note.setGhostNote((header & 4) != 0);
        if ((header & 0x20) != 0) {
            int noteType = this.readUnsignedByte();
            note.setTieNote(noteType == 2);
            note.setDeadNote(noteType == 3);
        }
        if ((header & 1) != 0) {
            note.duration = GPDuration.valueOf(this.readByte());
            note.setNTuplet(this.readByte());
        }
        if ((header & 0x10) != 0) {
            note.setDynamic(GPDynamic.valueOf(this.readByte()));
        }
        if ((header & 0x20) != 0) {
            note.setFretNumber(this.readByte());
        }
        if ((header & 0x80) != 0) {
            note.fingeringLeftHand = GPFingering.valueOf(this.readByte());
            note.fingeringRightHand = GPFingering.valueOf(this.readByte());
        }
        if ((header & 8) != 0) {
            note.effects = this.readEffectsOnNote();
        }
        return note;
    }

    private GPTrack readTrack() throws IOException {
        GPTrack track = new GPTrack();
        int header = this.readUnsignedByte();
        track.isDrumsTrack = (header & 1) != 0;
        track.is12StringedGuitarTrack = (header & 2) != 0;
        track.isBanjoTrack = (header & 4) != 0;
        track.setName(this.readStringByte(40));
        track.setNumberOfStrings(this.readInt());
        int i = 0;
        while (i < 7) {
            track.setStringsTuning(i, this.readInt());
            ++i;
        }
        track.setPort(this.readInt());
        track.setChannel(this.readInt());
        track.setChannelEffects(this.readInt());
        track.setNumberOfFrets(this.readInt());
        track.setCapo(this.readInt());
        track.setColor(this.readColor());
        return track;
    }
}

