/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Locale;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.settings.Validator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class ClusterRebalanceAllocationDecider
extends AllocationDecider {
    public static final String NAME = "cluster_rebalance";
    public static final String CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE = "cluster.routing.allocation.allow_rebalance";
    public static final Validator ALLOCATION_ALLOW_REBALANCE_VALIDATOR = new Validator(){

        @Override
        public String validate(String setting, String value, ClusterState clusterState) {
            try {
                ClusterRebalanceType.parseString(value);
                return null;
            }
            catch (IllegalArgumentException e) {
                return "the value of " + setting + " must be one of: [always, indices_primaries_active, indices_all_active]";
            }
        }
    };
    private ClusterRebalanceType type;

    @Inject
    public ClusterRebalanceAllocationDecider(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        String allowRebalance = settings.get(CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE, "indices_all_active");
        try {
            this.type = ClusterRebalanceType.parseString(allowRebalance);
        }
        catch (IllegalStateException e) {
            this.logger.warn("[{}] has a wrong value {}, defaulting to 'indices_all_active'", CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE, allowRebalance);
            this.type = ClusterRebalanceType.INDICES_ALL_ACTIVE;
        }
        this.logger.debug("using [{}] with [{}]", CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE, this.type.toString().toLowerCase(Locale.ROOT));
        nodeSettingsService.addListener(new ApplySettings());
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return this.canRebalance(allocation);
    }

    @Override
    public Decision canRebalance(RoutingAllocation allocation) {
        if (this.type == ClusterRebalanceType.INDICES_PRIMARIES_ACTIVE) {
            if (allocation.routingNodes().hasUnassignedPrimaries()) {
                return allocation.decision(Decision.NO, NAME, "cluster has unassigned primary shards", new Object[0]);
            }
            if (allocation.routingNodes().hasInactivePrimaries()) {
                return allocation.decision(Decision.NO, NAME, "cluster has inactive primary shards", new Object[0]);
            }
            return allocation.decision(Decision.YES, NAME, "all primary shards are active", new Object[0]);
        }
        if (this.type == ClusterRebalanceType.INDICES_ALL_ACTIVE) {
            if (allocation.routingNodes().hasUnassignedShards()) {
                return allocation.decision(Decision.NO, NAME, "cluster has unassigned shards", new Object[0]);
            }
            if (allocation.routingNodes().hasInactiveShards()) {
                return allocation.decision(Decision.NO, NAME, "cluster has inactive shards", new Object[0]);
            }
        }
        return allocation.decision(Decision.YES, NAME, "all shards are active", new Object[0]);
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            String newAllowRebalance = settings.get(ClusterRebalanceAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE, null);
            if (newAllowRebalance != null) {
                ClusterRebalanceType newType = null;
                try {
                    newType = ClusterRebalanceType.parseString(newAllowRebalance);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (newType != null && newType != ClusterRebalanceAllocationDecider.this.type) {
                    ClusterRebalanceAllocationDecider.this.logger.info("updating [{}] from [{}] to [{}]", ClusterRebalanceAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE, ClusterRebalanceAllocationDecider.this.type.toString().toLowerCase(Locale.ROOT), newType.toString().toLowerCase(Locale.ROOT));
                    ClusterRebalanceAllocationDecider.this.type = newType;
                }
            }
        }
    }

    public static enum ClusterRebalanceType {
        ALWAYS,
        INDICES_PRIMARIES_ACTIVE,
        INDICES_ALL_ACTIVE;


        public static ClusterRebalanceType parseString(String typeString) {
            if ("always".equalsIgnoreCase(typeString)) {
                return ALWAYS;
            }
            if ("indices_primaries_active".equalsIgnoreCase(typeString) || "indicesPrimariesActive".equalsIgnoreCase(typeString)) {
                return INDICES_PRIMARIES_ACTIVE;
            }
            if ("indices_all_active".equalsIgnoreCase(typeString) || "indicesAllActive".equalsIgnoreCase(typeString)) {
                return INDICES_ALL_ACTIVE;
            }
            throw new IllegalArgumentException("Illegal value for cluster.routing.allocation.allow_rebalance: " + typeString);
        }
    }
}

