/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

public enum MapperUtils {


    private static MergeResult newStrictMergeResult() {
        return new MergeResult(false, false){

            @Override
            public void addFieldMappers(Collection<FieldMapper> fieldMappers) {
            }

            @Override
            public void addObjectMappers(Collection<ObjectMapper> objectMappers) {
            }

            @Override
            public Collection<FieldMapper> getNewFieldMappers() {
                throw new UnsupportedOperationException("Strict merge result does not support new field mappers");
            }

            @Override
            public Collection<ObjectMapper> getNewObjectMappers() {
                throw new UnsupportedOperationException("Strict merge result does not support new object mappers");
            }

            @Override
            public void addConflict(String mergeFailure) {
                throw new MapperParsingException("Merging dynamic updates triggered a conflict: " + mergeFailure);
            }
        };
    }

    public static void merge(Mapper mergeInto, Mapper mergeWith) {
        mergeInto.merge(mergeWith, MapperUtils.newStrictMergeResult());
    }

    public static void merge(Mapping mergeInto, Mapping mergeWith) {
        mergeInto.merge(mergeWith, MapperUtils.newStrictMergeResult());
    }

    public static void collect(Mapper mapper, Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers) {
        if (!(mapper instanceof RootObjectMapper)) {
            if (mapper instanceof ObjectMapper) {
                objectMappers.add((ObjectMapper)mapper);
            } else if (mapper instanceof FieldMapper) {
                fieldMappers.add((FieldMapper)mapper);
            }
        }
        for (Mapper child : mapper) {
            MapperUtils.collect(child, objectMappers, fieldMappers);
        }
    }
}

