/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridParams;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoHashGrid;

public class GeoHashGridBuilder
extends AggregationBuilder<GeoHashGridBuilder> {
    private String field;
    private int precision = 5;
    private int requiredSize = 10000;
    private int shardSize = 0;

    public GeoHashGridBuilder(String name) {
        super(name, InternalGeoHashGrid.TYPE.name());
    }

    public GeoHashGridBuilder field(String field) {
        this.field = field;
        return this;
    }

    public GeoHashGridBuilder precision(int precision) {
        this.precision = GeoHashGridParams.checkPrecision(precision);
        return this;
    }

    public GeoHashGridBuilder size(int requiredSize) {
        this.requiredSize = requiredSize;
        return this;
    }

    public GeoHashGridBuilder shardSize(int shardSize) {
        this.shardSize = shardSize;
        return this;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.precision != 5) {
            builder.field(GeoHashGridParams.FIELD_PRECISION.getPreferredName(), this.precision);
        }
        if (this.requiredSize != 10000) {
            builder.field(GeoHashGridParams.FIELD_SIZE.getPreferredName(), this.requiredSize);
        }
        if (this.shardSize != 0) {
            builder.field(GeoHashGridParams.FIELD_SHARD_SIZE.getPreferredName(), this.shardSize);
        }
        return builder.endObject();
    }
}

