/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.ipv4;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.ipv4.IPv4RangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.ipv4.InternalIPv4Range;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceParser;
import org.elasticsearch.search.internal.SearchContext;

public class IpRangeParser
implements Aggregator.Parser {
    @Override
    public String type() {
        return InternalIPv4Range.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        ValuesSourceParser<ValuesSource.Numeric> vsParser = ValuesSourceParser.numeric(aggregationName, InternalIPv4Range.TYPE, context).targetValueType(ValueType.IP).formattable(false).build();
        ArrayList<RangeAggregator.Range> ranges = null;
        boolean keyed = false;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (vsParser.token(currentFieldName, token, parser)) continue;
            if (token == XContentParser.Token.START_ARRAY) {
                if ("ranges".equals(currentFieldName)) {
                    ranges = new ArrayList<RangeAggregator.Range>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        double from = Double.NEGATIVE_INFINITY;
                        String fromAsStr = null;
                        double to = Double.POSITIVE_INFINITY;
                        String toAsStr = null;
                        String key = null;
                        String mask = null;
                        String toOrFromOrMaskOrKey = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                toOrFromOrMaskOrKey = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                if ("from".equals(toOrFromOrMaskOrKey)) {
                                    from = parser.doubleValue();
                                    continue;
                                }
                                if (!"to".equals(toOrFromOrMaskOrKey)) continue;
                                to = parser.doubleValue();
                                continue;
                            }
                            if (token != XContentParser.Token.VALUE_STRING) continue;
                            if ("from".equals(toOrFromOrMaskOrKey)) {
                                fromAsStr = parser.text();
                                continue;
                            }
                            if ("to".equals(toOrFromOrMaskOrKey)) {
                                toAsStr = parser.text();
                                continue;
                            }
                            if ("key".equals(toOrFromOrMaskOrKey)) {
                                key = parser.text();
                                continue;
                            }
                            if (!"mask".equals(toOrFromOrMaskOrKey)) continue;
                            mask = parser.text();
                        }
                        RangeAggregator.Range range = new RangeAggregator.Range(key, from, fromAsStr, to, toAsStr);
                        if (mask != null) {
                            IpRangeParser.parseMaskRange(mask, range, aggregationName, context);
                        }
                        ranges.add(range);
                    }
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if ("keyed".equals(currentFieldName)) {
                    keyed = parser.booleanValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].", parser.getTokenLocation());
        }
        if (ranges == null) {
            throw new SearchParseException(context, "Missing [ranges] in ranges aggregator [" + aggregationName + "]", parser.getTokenLocation());
        }
        return new RangeAggregator.Factory(aggregationName, vsParser.config(), InternalIPv4Range.FACTORY, ranges, keyed);
    }

    private static void parseMaskRange(String cidr, RangeAggregator.Range range, String aggregationName, SearchContext ctx) {
        long[] fromTo = IPv4RangeBuilder.cidrMaskToMinMax(cidr);
        if (fromTo == null) {
            throw new SearchParseException(ctx, "invalid CIDR mask [" + cidr + "] in aggregation [" + aggregationName + "]", null);
        }
        range.from = fromTo[0] < 0L ? Double.NEGATIVE_INFINITY : (double)fromTo[0];
        double d = range.to = fromTo[1] < 0L ? Double.POSITIVE_INFINITY : (double)fromTo[1];
        if (range.key == null) {
            range.key = cidr;
        }
    }
}

