/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.InternalSampler;
import org.elasticsearch.search.aggregations.bucket.sampler.SamplerParser;

public class SamplerAggregationBuilder
extends ValuesSourceAggregationBuilder<SamplerAggregationBuilder> {
    private int shardSize = 100;
    int maxDocsPerValue = 1;
    String executionHint = null;

    public SamplerAggregationBuilder(String name) {
        super(name, InternalSampler.TYPE.name());
    }

    public SamplerAggregationBuilder shardSize(int shardSize) {
        this.shardSize = shardSize;
        return this;
    }

    public SamplerAggregationBuilder maxDocsPerValue(int maxDocsPerValue) {
        this.maxDocsPerValue = maxDocsPerValue;
        return this;
    }

    public SamplerAggregationBuilder executionHint(String executionHint) {
        this.executionHint = executionHint;
        return this;
    }

    @Override
    protected XContentBuilder doInternalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.shardSize != 100) {
            builder.field(SamplerParser.SHARD_SIZE_FIELD.getPreferredName(), this.shardSize);
        }
        if (this.maxDocsPerValue != 1) {
            builder.field(SamplerParser.MAX_DOCS_PER_VALUE_FIELD.getPreferredName(), this.maxDocsPerValue);
        }
        if (this.executionHint != null) {
            builder.field(SamplerParser.EXECUTION_HINT_FIELD.getPreferredName(), this.executionHint);
        }
        return builder;
    }
}

