/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.format;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.internal.SearchContext;
import org.joda.time.DateTimeZone;

public interface ValueParser {
    public static final ValueParser IPv4 = new IPv4();
    public static final ValueParser RAW = new Raw();
    public static final ValueParser BOOLEAN = new Boolean();

    public long parseLong(String var1, SearchContext var2);

    public double parseDouble(String var1, SearchContext var2);

    public static class Boolean
    implements ValueParser {
        private Boolean() {
        }

        @Override
        public long parseLong(String value, SearchContext searchContext) {
            return java.lang.Boolean.parseBoolean(value) ? 1L : 0L;
        }

        @Override
        public double parseDouble(String value, SearchContext searchContext) {
            return this.parseLong(value, searchContext);
        }
    }

    public static abstract class Number
    implements ValueParser {
        NumberFormat format;

        Number(NumberFormat format) {
            this.format = format;
        }

        public static class Pattern
        extends Number {
            private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.ROOT);

            public Pattern(String pattern) {
                super(new DecimalFormat(pattern, SYMBOLS));
            }

            @Override
            public long parseLong(String value, SearchContext searchContext) {
                try {
                    return this.format.parse(value).longValue();
                }
                catch (ParseException nfe) {
                    throw new AggregationExecutionException("Invalid number format [" + ((DecimalFormat)this.format).toPattern() + "]");
                }
            }

            @Override
            public double parseDouble(String value, SearchContext searchContext) {
                try {
                    return this.format.parse(value).doubleValue();
                }
                catch (ParseException nfe) {
                    throw new AggregationExecutionException("Invalid number format [" + ((DecimalFormat)this.format).toPattern() + "]");
                }
            }
        }
    }

    public static class Raw
    implements ValueParser {
        private Raw() {
        }

        @Override
        public long parseLong(String value, SearchContext searchContext) {
            return Long.parseLong(value);
        }

        @Override
        public double parseDouble(String value, SearchContext searchContext) {
            return Double.parseDouble(value);
        }
    }

    public static class IPv4
    implements ValueParser {
        private IPv4() {
        }

        @Override
        public long parseLong(String value, SearchContext searchContext) {
            return IpFieldMapper.ipToLong(value);
        }

        @Override
        public double parseDouble(String value, SearchContext searchContext) {
            return this.parseLong(value, searchContext);
        }
    }

    public static class DateMath
    implements ValueParser {
        public static final DateMath DEFAULT = new DateMath(new DateMathParser(DateFieldMapper.Defaults.DATE_TIME_FORMATTER), DateTimeZone.UTC);
        private DateMathParser parser;
        private DateTimeZone timezone = DateTimeZone.UTC;

        public DateMath(String format, DateTimeZone timezone) {
            this(new DateMathParser(Joda.forPattern(format)), timezone);
        }

        public DateMath(DateMathParser parser, @Nullable DateTimeZone timeZone) {
            this.parser = parser;
            if (timeZone != null) {
                this.timezone = timeZone;
            }
        }

        @Override
        public long parseLong(String value, final SearchContext searchContext) {
            Callable<Long> now = new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return searchContext.nowInMillis();
                }
            };
            return this.parser.parse(value, now, false, this.timezone);
        }

        @Override
        public double parseDouble(String value, SearchContext searchContext) {
            return this.parseLong(value, searchContext);
        }

        public static DateMath mapper(DateFieldMapper.DateFieldType fieldType, @Nullable DateTimeZone timezone) {
            return new DateMath(new DateMathParser(fieldType.dateTimeFormatter()), timezone);
        }
    }

    public static class DateTime
    implements ValueParser {
        public static final DateTime DEFAULT = new DateTime(DateFieldMapper.Defaults.DATE_TIME_FORMATTER);
        private FormatDateTimeFormatter formatter;

        public DateTime(String format) {
            this(Joda.forPattern(format));
        }

        public DateTime(FormatDateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public long parseLong(String value, SearchContext searchContext) {
            return this.formatter.parser().parseMillis(value);
        }

        @Override
        public double parseDouble(String value, SearchContext searchContext) {
            return this.parseLong(value, searchContext);
        }
    }
}

