/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhaseContext;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public interface FetchSubPhase {
    public Map<String, ? extends SearchParseElement> parseElements();

    public boolean hitExecutionNeeded(SearchContext var1);

    public void hitExecute(SearchContext var1, HitContext var2);

    public boolean hitsExecutionNeeded(SearchContext var1);

    public void hitsExecute(SearchContext var1, InternalSearchHit[] var2);

    public static interface ContextFactory<SubPhaseContext extends FetchSubPhaseContext> {
        public String getName();

        public SubPhaseContext newContextInstance();
    }

    public static class HitContext {
        private InternalSearchHit hit;
        private IndexSearcher searcher;
        private LeafReaderContext readerContext;
        private int docId;
        private Map<String, Object> cache;

        public void reset(InternalSearchHit hit, LeafReaderContext context, int docId, IndexSearcher searcher) {
            this.hit = hit;
            this.readerContext = context;
            this.docId = docId;
            this.searcher = searcher;
        }

        public InternalSearchHit hit() {
            return this.hit;
        }

        public LeafReader reader() {
            return this.readerContext.reader();
        }

        public LeafReaderContext readerContext() {
            return this.readerContext;
        }

        public int docId() {
            return this.docId;
        }

        public IndexReader topLevelReader() {
            return this.searcher.getIndexReader();
        }

        public IndexSearcher topLevelSearcher() {
            return this.searcher;
        }

        public Map<String, Object> cache() {
            if (this.cache == null) {
                this.cache = Maps.newHashMap();
            }
            return this.cache;
        }

        public String getSourcePath(String sourcePath) {
            SearchHit.NestedIdentity nested = this.hit().getNestedIdentity();
            if (nested != null) {
                StringBuilder nestedPath = new StringBuilder();
                while (nested != null) {
                    nestedPath.append(nested.getField());
                    nested = nested.getChild();
                }
                assert (sourcePath.startsWith(nestedPath.toString()));
                int startIndex = nestedPath.length() + 1;
                return sourcePath.substring(startIndex);
            }
            return sourcePath;
        }
    }
}

