/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.suggest.context.CategoryContextMapping;
import org.elasticsearch.search.suggest.context.ContextMapping;
import org.elasticsearch.search.suggest.context.GeolocationContextMapping;

public class SuggestBuilder
extends ToXContentToBytes {
    private final String name;
    private String globalText;
    private final List<SuggestionBuilder<?>> suggestions = new ArrayList();

    public SuggestBuilder() {
        this.name = null;
    }

    public SuggestBuilder(String name) {
        this.name = name;
    }

    public SuggestBuilder setText(String globalText) {
        this.globalText = globalText;
        return this;
    }

    public SuggestBuilder addSuggestion(SuggestionBuilder<?> suggestion) {
        this.suggestions.add(suggestion);
        return this;
    }

    public List<SuggestionBuilder<?>> getSuggestion() {
        return this.suggestions;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.name == null) {
            builder.startObject();
        } else {
            builder.startObject(this.name);
        }
        if (this.globalText != null) {
            builder.field("text", this.globalText);
        }
        for (SuggestionBuilder<?> suggestion : this.suggestions) {
            builder = suggestion.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static abstract class SuggestionBuilder<T>
    extends ToXContentToBytes {
        private String name;
        private String suggester;
        private String text;
        private String field;
        private String analyzer;
        private Integer size;
        private Integer shardSize;
        private List<ContextMapping.ContextQuery> contextQueries = new ArrayList<ContextMapping.ContextQuery>();

        public SuggestionBuilder(String name, String suggester) {
            this.name = name;
            this.suggester = suggester;
        }

        private T addContextQuery(ContextMapping.ContextQuery ctx) {
            this.contextQueries.add(ctx);
            return (T)this;
        }

        public T addGeoLocation(String name, double lat, double lon, int ... precisions) {
            return this.addContextQuery(GeolocationContextMapping.query(name, lat, lon, precisions));
        }

        public T addGeoLocationWithPrecision(String name, double lat, double lon, String ... precisions) {
            return this.addContextQuery(GeolocationContextMapping.query(name, lat, lon, precisions));
        }

        public T addGeoLocation(String name, String geohash) {
            return this.addContextQuery(GeolocationContextMapping.query(name, geohash, new int[0]));
        }

        public T addCategory(String name, CharSequence ... categories) {
            return this.addContextQuery(CategoryContextMapping.query(name, categories));
        }

        public T addCategory(String name, Iterable<? extends CharSequence> categories) {
            return this.addContextQuery(CategoryContextMapping.query(name, categories));
        }

        public T addContextField(String name, CharSequence ... fieldvalues) {
            return this.addContextQuery(CategoryContextMapping.query(name, fieldvalues));
        }

        public T addContextField(String name, Iterable<? extends CharSequence> fieldvalues) {
            return this.addContextQuery(CategoryContextMapping.query(name, fieldvalues));
        }

        public T text(String text) {
            this.text = text;
            return (T)this;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.name);
            if (this.text != null) {
                builder.field("text", this.text);
            }
            builder.startObject(this.suggester);
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.field != null) {
                builder.field("field", this.field);
            }
            if (this.size != null) {
                builder.field("size", this.size);
            }
            if (this.shardSize != null) {
                builder.field("shard_size", this.shardSize);
            }
            if (!this.contextQueries.isEmpty()) {
                builder.startObject("context");
                for (ContextMapping.ContextQuery query : this.contextQueries) {
                    query.toXContent(builder, params);
                }
                builder.endObject();
            }
            builder = this.innerToXContent(builder, params);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        protected abstract XContentBuilder innerToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

        public T field(String field) {
            this.field = field;
            return (T)this;
        }

        public T analyzer(String analyzer) {
            this.analyzer = analyzer;
            return (T)this;
        }

        public T size(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Size must be positive");
            }
            this.size = size;
            return (T)this;
        }

        public T shardSize(Integer shardSize) {
            this.shardSize = shardSize;
            return (T)this;
        }
    }
}

