/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.DistanceStyle;
import org.apache.lucene.geo3d.GeoBaseShape;
import org.apache.lucene.geo3d.GeoMembershipShape;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.Vector;

public abstract class GeoBaseMembershipShape
extends GeoBaseShape
implements GeoMembershipShape {
    public GeoBaseMembershipShape(PlanetModel planetModel) {
        super(planetModel);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.isWithin(point.x, point.y, point.z);
    }

    @Override
    public double computeOutsideDistance(DistanceStyle distanceStyle, GeoPoint point) {
        return this.computeOutsideDistance(distanceStyle, point.x, point.y, point.z);
    }

    @Override
    public double computeOutsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (this.isWithin(x, y, z)) {
            return 0.0;
        }
        return this.outsideDistance(distanceStyle, x, y, z);
    }

    protected abstract double outsideDistance(DistanceStyle var1, double var2, double var4, double var6);
}

