/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.BigOperatorAtom;
import org.scilab.forge.jlatexmath.BreakMarkAtom;
import org.scilab.forge.jlatexmath.CharAtom;
import org.scilab.forge.jlatexmath.ColorAtom;
import org.scilab.forge.jlatexmath.CumulativeScriptsAtom;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.EmptyAtom;
import org.scilab.forge.jlatexmath.FormulaNotFoundException;
import org.scilab.forge.jlatexmath.HlineAtom;
import org.scilab.forge.jlatexmath.JavaFontRenderingAtom;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.MathAtom;
import org.scilab.forge.jlatexmath.NewCommandMacro;
import org.scilab.forge.jlatexmath.OverUnderDelimiter;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.PhantomAtom;
import org.scilab.forge.jlatexmath.RomanAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.ScriptsAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.SymbolNotFoundException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.UnderscoreAtom;

public class TeXParser {
    TeXFormula formula;
    private StringBuffer parseString;
    private int pos;
    private int spos;
    private int line;
    private int col;
    private int len;
    private int group;
    private boolean insertion;
    private int atIsLetter;
    private boolean arrayMode;
    private boolean ignoreWhiteSpace = true;
    private boolean isPartial;
    private boolean autoNumberBreaking;
    private static final char ESCAPE = '\\';
    private static final char L_GROUP = '{';
    private static final char R_GROUP = '}';
    private static final char L_BRACK = '[';
    private static final char R_BRACK = ']';
    private static final char DOLLAR = '$';
    private static final char DQUOTE = '\"';
    private static final char PERCENT = '%';
    private static final int OVER_DEL = 0;
    private static final int UNDER_DEL = 1;
    private static final char SUB_SCRIPT = '_';
    private static final char SUPER_SCRIPT = '^';
    private static final char PRIME = '\'';
    private static final char BACKPRIME = '\u2035';
    private static final char DEGRE = '\u00b0';
    private static final char SUPZERO = '\u2070';
    private static final char SUPONE = '\u00b9';
    private static final char SUPTWO = '\u00b2';
    private static final char SUPTHREE = '\u00b3';
    private static final char SUPFOUR = '\u2074';
    private static final char SUPFIVE = '\u2075';
    private static final char SUPSIX = '\u2076';
    private static final char SUPSEVEN = '\u2077';
    private static final char SUPEIGHT = '\u2078';
    private static final char SUPNINE = '\u2079';
    private static final char SUPPLUS = '\u207a';
    private static final char SUPMINUS = '\u207b';
    private static final char SUPEQUAL = '\u207c';
    private static final char SUPLPAR = '\u207d';
    private static final char SUPRPAR = '\u207e';
    private static final char SUPN = '\u207f';
    private static final char SUBZERO = '\u2080';
    private static final char SUBONE = '\u2081';
    private static final char SUBTWO = '\u2082';
    private static final char SUBTHREE = '\u2083';
    private static final char SUBFOUR = '\u2084';
    private static final char SUBFIVE = '\u2085';
    private static final char SUBSIX = '\u2086';
    private static final char SUBSEVEN = '\u2087';
    private static final char SUBEIGHT = '\u2088';
    private static final char SUBNINE = '\u2089';
    private static final char SUBPLUS = '\u208a';
    private static final char SUBMINUS = '\u208b';
    private static final char SUBEQUAL = '\u208c';
    private static final char SUBLPAR = '\u208d';
    private static final char SUBRPAR = '\u208e';
    protected static boolean isLoading = false;
    private static final Set<String> unparsedContents = new HashSet<String>(6);

    public TeXParser(String string, TeXFormula teXFormula) {
        this(string, teXFormula, true);
    }

    public TeXParser(boolean bl, String string, TeXFormula teXFormula) {
        this(string, teXFormula, false);
        this.isPartial = bl;
        this.firstpass();
    }

    public TeXParser(boolean bl, String string, TeXFormula teXFormula, boolean bl2) {
        this.formula = teXFormula;
        this.isPartial = bl;
        if (string != null) {
            this.parseString = new StringBuffer(string);
            this.len = string.length();
            this.pos = 0;
            if (bl2) {
                this.firstpass();
            }
        } else {
            this.parseString = null;
            this.pos = 0;
            this.len = 0;
        }
    }

    public TeXParser(String string, TeXFormula teXFormula, boolean bl) {
        this(false, string, teXFormula, bl);
    }

    public TeXParser(boolean bl, String string, ArrayOfAtoms arrayOfAtoms, boolean bl2) {
        this(bl, string, (TeXFormula)arrayOfAtoms, bl2);
        this.arrayMode = true;
    }

    public TeXParser(boolean bl, String string, ArrayOfAtoms arrayOfAtoms, boolean bl2, boolean bl3) {
        this(bl, string, (TeXFormula)arrayOfAtoms, bl2, bl3);
        this.arrayMode = true;
    }

    public TeXParser(String string, ArrayOfAtoms arrayOfAtoms, boolean bl) {
        this(false, string, (TeXFormula)arrayOfAtoms, bl);
    }

    public TeXParser(boolean bl, String string, TeXFormula teXFormula, boolean bl2, boolean bl3) {
        this(bl, string, teXFormula, bl2);
        this.ignoreWhiteSpace = bl3;
    }

    public TeXParser(String string, TeXFormula teXFormula, boolean bl, boolean bl2) {
        this(false, string, teXFormula, bl);
        this.ignoreWhiteSpace = bl2;
    }

    public void reset(String string) {
        this.parseString = new StringBuffer(string);
        this.len = this.parseString.length();
        this.formula.root = null;
        this.pos = 0;
        this.spos = 0;
        this.line = 0;
        this.col = 0;
        this.group = 0;
        this.insertion = false;
        this.atIsLetter = 0;
        this.arrayMode = false;
        this.ignoreWhiteSpace = true;
        this.firstpass();
    }

    public boolean getIsPartial() {
        return this.isPartial;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.pos - this.col - 1;
    }

    public Atom getLastAtom() {
        Atom atom = this.formula.root;
        if (atom instanceof RowAtom) {
            return ((RowAtom)atom).getLastAtom();
        }
        this.formula.root = null;
        return atom;
    }

    public Atom getFormulaAtom() {
        Atom atom = this.formula.root;
        this.formula.root = null;
        return atom;
    }

    public void addAtom(Atom atom) {
        this.formula.add(atom);
    }

    public void makeAtLetter() {
        ++this.atIsLetter;
    }

    public void makeAtOther() {
        --this.atIsLetter;
    }

    public boolean isAtLetter() {
        return this.atIsLetter != 0;
    }

    public boolean isArrayMode() {
        return this.arrayMode;
    }

    public void setArrayMode(boolean bl) {
        this.arrayMode = bl;
    }

    public boolean isIgnoreWhiteSpace() {
        return this.ignoreWhiteSpace;
    }

    public boolean isMathMode() {
        return this.ignoreWhiteSpace;
    }

    public int getPos() {
        return this.pos;
    }

    public int rewind(int n) {
        this.pos -= n;
        return this.pos;
    }

    public String getStringFromCurrentPos() {
        return this.parseString.substring(this.pos);
    }

    public void finish() {
        this.pos = this.parseString.length();
    }

    public void addRow() throws ParseException {
        if (!this.arrayMode) {
            throw new ParseException("You can add a row only in array mode !");
        }
        ((ArrayOfAtoms)this.formula).addRow();
    }

    /*
     * Unable to fully structure code
     */
    private void firstpass() throws ParseException {
        block52: {
            if (this.len == 0) break block52;
            block42: while (this.pos < this.len) {
                var1_1 = this.parseString.charAt(this.pos);
                switch (var1_1) {
                    case '\\': {
                        var3_3 = this.pos;
                        var2_2 = this.getCommand();
                        if (!"newcommand".equals(var2_2) && !"renewcommand".equals(var2_2)) ** GOTO lbl23
                        var4_4 = this.getOptsArgs(2, 2);
                        var5_5 = MacroInfo.Commands.get(var2_2);
                        try {
                            var5_5.invoke(this, var4_4);
                        }
                        catch (ParseException var6_6) {
                            if (this.isPartial) ** GOTO lbl18
                            throw var6_6;
                        }
lbl18:
                        // 2 sources

                        this.parseString.delete(var3_3, this.pos);
                        this.len = this.parseString.length();
                        this.pos = var3_3;
                        continue block42;
lbl23:
                        // 1 sources

                        if (NewCommandMacro.isMacro(var2_2)) {
                            var5_5 = MacroInfo.Commands.get(var2_2);
                            var4_4 = this.getOptsArgs(var5_5.nbArgs, var5_5.hasOptions != false ? 1 : 0);
                            var4_4[0] = var2_2;
                            try {
                                this.parseString.replace(var3_3, this.pos, (String)var5_5.invoke(this, var4_4));
                            }
                            catch (ParseException var6_7) {
                                if (!this.isPartial) {
                                    throw var6_7;
                                }
                                var3_3 += var2_2.length() + 1;
                            }
                            this.len = this.parseString.length();
                            this.pos = var3_3;
                            continue block42;
                        }
                        if ("begin".equals(var2_2)) {
                            var4_4 = this.getOptsArgs(1, 0);
                            var5_5 = MacroInfo.Commands.get(var4_4[1] + "@env");
                            if (var5_5 == null) {
                                if (this.isPartial) continue block42;
                                throw new ParseException("Unknown environment: " + var4_4[1] + " at position " + this.getLine() + ":" + this.getCol());
                            }
                            try {
                                var6_8 = this.getOptsArgs(var5_5.nbArgs - 1, 0);
                                var7_11 = this.getGroup("\\begin{" + var4_4[1] + "}", "\\end{" + var4_4[1] + "}");
                                var8_12 = "{\\makeatletter \\" + var4_4[1] + "@env";
                                for (var9_13 = 1; var9_13 <= var5_5.nbArgs - 1; ++var9_13) {
                                    var8_12 = var8_12 + "{" + var6_8[var9_13] + "}";
                                }
                                var8_12 = var8_12 + "{" + var7_11 + "}\\makeatother}";
                                this.parseString.replace(var3_3, this.pos, var8_12);
                                this.len = this.parseString.length();
                                this.pos = var3_3;
                                continue block42;
                            }
                            catch (ParseException var6_9) {
                                if (this.isPartial) continue block42;
                                throw var6_9;
                            }
                        }
                        if ("makeatletter".equals(var2_2)) {
                            ++this.atIsLetter;
                            continue block42;
                        }
                        if ("makeatother".equals(var2_2)) {
                            --this.atIsLetter;
                            continue block42;
                        }
                        if (!TeXParser.unparsedContents.contains(var2_2)) continue block42;
                        this.getOptsArgs(1, 0);
                        continue block42;
                    }
                    case '%': {
                        ++this.pos;
                        while (this.pos < this.len && (var6_10 = this.parseString.charAt(this.pos++)) != '\r' && var6_10 != '\n') {
                        }
                        if (this.pos < this.len) {
                            --this.pos;
                        }
                        this.parseString.replace(var3_3, this.pos, "");
                        this.len = this.parseString.length();
                        this.pos = var3_3;
                        continue block42;
                    }
                    case '\u00b0': {
                        this.parseString.replace(this.pos, this.pos + 1, "^\\circ");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u00b2': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{2}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u00b3': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{3}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u00b9': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{1}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2070': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{0}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2074': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{4}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2075': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{5}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2076': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{6}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2077': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{7}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2078': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{8}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2079': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{9}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207a': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{+}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207b': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{-}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207c': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{=}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207d': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{(}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207e': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{)}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207f': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{n}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2082': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{2}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2083': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{3}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2081': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{1}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2080': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{0}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2084': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{4}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2085': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{5}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2086': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{6}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2087': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{7}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2088': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{8}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2089': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{9}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u208a': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{+}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u208b': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{-}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u208c': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{=}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u208d': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{(}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u208e': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{)}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                }
                ++this.pos;
            }
            this.pos = 0;
            this.len = this.parseString.length();
        }
    }

    public void parse() throws ParseException {
        if (this.len != 0) {
            block15: while (this.pos < this.len) {
                char c = this.parseString.charAt(this.pos);
                block0 : switch (c) {
                    case '\n': {
                        ++this.line;
                        this.col = this.pos;
                    }
                    case '\t': 
                    case '\r': {
                        ++this.pos;
                        break;
                    }
                    case ' ': {
                        ++this.pos;
                        if (this.ignoreWhiteSpace) continue block15;
                        this.formula.add(new SpaceAtom());
                        this.formula.add(new BreakMarkAtom());
                        while (this.pos < this.len && (c = this.parseString.charAt(this.pos)) == ' ' && c == '\t') {
                            if (c != '\r') break block0;
                            ++this.pos;
                        }
                        continue block15;
                    }
                    case '$': {
                        ++this.pos;
                        if (this.ignoreWhiteSpace) continue block15;
                        int n = 2;
                        boolean bl = false;
                        if (this.parseString.charAt(this.pos) == '$') {
                            n = 0;
                            bl = true;
                            ++this.pos;
                        }
                        this.formula.add(new MathAtom(new TeXFormula((TeXParser)this, (String)this.getDollarGroup((char)'$'), (boolean)false).root, n));
                        if (!bl || this.parseString.charAt(this.pos) != '$') continue block15;
                        ++this.pos;
                        break;
                    }
                    case '\\': {
                        Atom atom = this.processEscape();
                        this.formula.add(atom);
                        if (this.arrayMode && atom instanceof HlineAtom) {
                            ((ArrayOfAtoms)this.formula).addRow();
                        }
                        if (!this.insertion) continue block15;
                        this.insertion = false;
                        break;
                    }
                    case '{': {
                        Atom atom = this.getArgument();
                        if (atom != null) {
                            atom.type = 0;
                        }
                        this.formula.add(atom);
                        break;
                    }
                    case '}': {
                        --this.group;
                        ++this.pos;
                        if (this.group == -1) {
                            throw new ParseException("Found a closing '}' without an opening '{'!");
                        }
                        return;
                    }
                    case '^': {
                        this.formula.add(this.getScripts(c));
                        break;
                    }
                    case '_': {
                        if (this.ignoreWhiteSpace) {
                            this.formula.add(this.getScripts(c));
                            break;
                        }
                        this.formula.add(new UnderscoreAtom());
                        ++this.pos;
                        break;
                    }
                    case '&': {
                        if (!this.arrayMode) {
                            throw new ParseException("Character '&' is only available in array mode !");
                        }
                        ((ArrayOfAtoms)this.formula).addCol();
                        ++this.pos;
                        break;
                    }
                    case '\'': {
                        if (this.ignoreWhiteSpace) {
                            this.formula.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("prime")));
                        } else {
                            this.formula.add(this.convertCharacter('\'', true));
                        }
                        ++this.pos;
                        break;
                    }
                    case '\u2035': {
                        if (this.ignoreWhiteSpace) {
                            this.formula.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("backprime")));
                        } else {
                            this.formula.add(this.convertCharacter('\u2035', true));
                        }
                        ++this.pos;
                        break;
                    }
                    case '\"': {
                        if (this.ignoreWhiteSpace) {
                            this.formula.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("prime")));
                            this.formula.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("prime")));
                        } else {
                            this.formula.add(this.convertCharacter('\'', true));
                            this.formula.add(this.convertCharacter('\'', true));
                        }
                        ++this.pos;
                        break;
                    }
                    default: {
                        this.formula.add(this.convertCharacter(c, false));
                        ++this.pos;
                    }
                }
            }
        }
        if (this.formula.root == null && !this.arrayMode) {
            this.formula.add(new EmptyAtom());
        }
    }

    private Atom getScripts(char c) throws ParseException {
        Atom atom;
        ++this.pos;
        Atom atom2 = this.getArgument();
        Atom atom3 = null;
        char c2 = '\u0000';
        if (this.pos < this.len) {
            c2 = this.parseString.charAt(this.pos);
        }
        if (c == '^' && c2 == '^') {
            atom3 = atom2;
            atom2 = null;
        } else if (c == '_' && c2 == '^') {
            ++this.pos;
            atom3 = this.getArgument();
        } else if (c == '^' && c2 == '_') {
            ++this.pos;
            atom3 = atom2;
            atom2 = this.getArgument();
        } else if (c == '^' && c2 != '_') {
            atom3 = atom2;
            atom2 = null;
        }
        if (this.formula.root instanceof RowAtom) {
            atom = ((RowAtom)this.formula.root).getLastAtom();
        } else if (this.formula.root == null) {
            atom = new PhantomAtom(new CharAtom('M', "mathnormal"), false, true, true);
        } else {
            atom = this.formula.root;
            this.formula.root = null;
        }
        if (atom.getRightType() == 1) {
            return new BigOperatorAtom(atom, atom2, atom3);
        }
        if (atom instanceof OverUnderDelimiter) {
            if (((OverUnderDelimiter)atom).isOver()) {
                if (atom3 != null) {
                    ((OverUnderDelimiter)atom).addScript(atom3);
                    return new ScriptsAtom(atom, atom2, null);
                }
            } else if (atom2 != null) {
                ((OverUnderDelimiter)atom).addScript(atom2);
                return new ScriptsAtom(atom, null, atom3);
            }
        }
        return new ScriptsAtom(atom, atom2, atom3);
    }

    public String getDollarGroup(char c) throws ParseException {
        char c2;
        int n = this.pos;
        do {
            if ((c2 = this.parseString.charAt(this.pos++)) != '\\') continue;
            ++this.pos;
        } while (this.pos < this.len && c2 != c);
        if (c2 == c) {
            return this.parseString.substring(n, this.pos - 1);
        }
        return this.parseString.substring(n, this.pos);
    }

    public String getGroup(char c, char c2) throws ParseException {
        if (this.pos == this.len) {
            return null;
        }
        char c3 = this.parseString.charAt(this.pos);
        if (this.pos < this.len && c3 == c) {
            int n = 1;
            int n2 = this.pos;
            while (this.pos < this.len - 1 && n != 0) {
                ++this.pos;
                c3 = this.parseString.charAt(this.pos);
                if (c3 == c) {
                    ++n;
                    continue;
                }
                if (c3 == c2) {
                    --n;
                    continue;
                }
                if (c3 != '\\' || this.pos == this.len - 1) continue;
                ++this.pos;
            }
            ++this.pos;
            if (n != 0) {
                return this.parseString.substring(n2 + 1, this.pos);
            }
            return this.parseString.substring(n2 + 1, this.pos - 1);
        }
        throw new ParseException("missing '" + c + "'!");
    }

    public String getGroup(String string, String string2) throws ParseException {
        int n = 1;
        int n2 = string.length();
        int n3 = string2.length();
        boolean bl = this.isValidCharacterInCommand(string.charAt(n2 - 1));
        boolean bl2 = this.isValidCharacterInCommand(string2.charAt(n3 - 1));
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        while (this.pos < this.len && n != 0) {
            char c2 = this.parseString.charAt(this.pos);
            if (c != '\\' && c2 == ' ') {
                while (this.pos < this.len && this.parseString.charAt(this.pos++) == ' ') {
                    stringBuffer.append(' ');
                }
                c2 = this.parseString.charAt(--this.pos);
                if (this.isValidCharacterInCommand(c) && this.isValidCharacterInCommand(c2)) {
                    n5 = 0;
                    n4 = 0;
                }
            }
            n4 = c2 == string.charAt(n4) ? ++n4 : 0;
            if (c2 == string2.charAt(n5)) {
                if (n5 == 0) {
                    n6 = this.pos;
                }
                ++n5;
            } else {
                n5 = 0;
            }
            if (this.pos + 1 < this.len) {
                char c3 = this.parseString.charAt(this.pos + 1);
                if (n4 == n2) {
                    if (!bl || !this.isValidCharacterInCommand(c3)) {
                        ++n;
                    }
                    n4 = 0;
                }
                if (n5 == n3) {
                    if (!bl2 || !this.isValidCharacterInCommand(c3)) {
                        --n;
                    }
                    n5 = 0;
                }
            } else {
                if (n4 == n2) {
                    ++n;
                    n4 = 0;
                }
                if (n5 == n3) {
                    --n;
                    n5 = 0;
                }
            }
            c = c2;
            stringBuffer.append(c2);
            ++this.pos;
        }
        if (n != 0) {
            if (this.isPartial) {
                return stringBuffer.toString();
            }
            throw new ParseException("The token " + string + " must be closed by " + string2);
        }
        return stringBuffer.substring(0, stringBuffer.length() - this.pos + n6);
    }

    public Atom getArgument() throws ParseException {
        this.skipWhiteSpace();
        if (this.pos >= this.len) {
            return new EmptyAtom();
        }
        char c = this.parseString.charAt(this.pos);
        if (c == '{') {
            TeXFormula teXFormula = new TeXFormula();
            TeXFormula teXFormula2 = this.formula;
            this.formula = teXFormula;
            ++this.pos;
            ++this.group;
            this.parse();
            this.formula = teXFormula2;
            if (this.formula.root == null) {
                RowAtom rowAtom = new RowAtom();
                rowAtom.add(teXFormula.root);
                return rowAtom;
            }
            return teXFormula.root;
        }
        if (c == '\\') {
            Atom atom = this.processEscape();
            if (this.insertion) {
                this.insertion = false;
                return this.getArgument();
            }
            return atom;
        }
        Atom atom = this.convertCharacter(c, true);
        ++this.pos;
        return atom;
    }

    public String getOverArgument() throws ParseException {
        String string;
        if (this.pos == this.len) {
            return null;
        }
        int n = 1;
        char c = '\u0000';
        int n2 = this.pos;
        while (this.pos < this.len && n != 0) {
            c = this.parseString.charAt(this.pos);
            switch (c) {
                case '{': {
                    ++n;
                    break;
                }
                case '&': {
                    if (n != 1) break;
                    --n;
                    break;
                }
                case '}': {
                    --n;
                    break;
                }
                case '\\': {
                    ++this.pos;
                    if (this.pos < this.len && this.parseString.charAt(this.pos) == '\\' && n == 1) {
                        --n;
                        --this.pos;
                        break;
                    }
                    if (this.pos >= this.len - 1 || this.parseString.charAt(this.pos) != 'c' || this.parseString.charAt(this.pos + 1) != 'r' || n != 1) break;
                    --n;
                    --this.pos;
                }
            }
            ++this.pos;
        }
        if (n >= 2) {
            throw new ParseException("Illegal end,  missing '}' !");
        }
        if (n == 0) {
            string = this.parseString.substring(n2, this.pos - 1);
        } else {
            string = this.parseString.substring(n2, this.pos);
            c = '\u0000';
        }
        if (c == '&' || c == '\\' || c == '}') {
            --this.pos;
        }
        return string;
    }

    public float[] getLength() throws ParseException {
        if (this.pos == this.len) {
            return null;
        }
        boolean bl = true;
        int n = 0;
        this.skipWhiteSpace();
        int n2 = this.pos;
        while (this.pos < this.len && n != 32) {
            n = this.parseString.charAt(this.pos++);
        }
        this.skipWhiteSpace();
        return SpaceAtom.getLength(this.parseString.substring(n2, this.pos - 1));
    }

    public Atom convertCharacter(char c, boolean bl) throws ParseException {
        if (this.ignoreWhiteSpace) {
            if (c >= '\u03b1' && c <= '\u03c9') {
                return SymbolAtom.get(TeXFormula.symbolMappings[c]);
            }
            if (c >= '\u0391' && c <= '\u03a9') {
                return new TeXFormula((String)TeXFormula.symbolFormulaMappings[c]).root;
            }
        }
        if (!((c = TeXParser.convertToRomanNumber(c)) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            String string;
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
            if (!isLoading && !DefaultTeXFont.loadedAlphabets.contains(unicodeBlock)) {
                DefaultTeXFont.addAlphabet(DefaultTeXFont.registeredAlphabets.get(unicodeBlock));
            }
            if ((string = TeXFormula.symbolMappings[c]) == null && (TeXFormula.symbolFormulaMappings == null || TeXFormula.symbolFormulaMappings[c] == null)) {
                TeXFormula.FontInfos fontInfos = null;
                boolean bl2 = Character.UnicodeBlock.BASIC_LATIN.equals(unicodeBlock);
                if (bl2 && TeXFormula.isRegisteredBlock(Character.UnicodeBlock.BASIC_LATIN) || !bl2) {
                    fontInfos = TeXFormula.getExternalFont(unicodeBlock);
                }
                if (fontInfos != null) {
                    if (bl) {
                        return new JavaFontRenderingAtom(Character.toString(c), fontInfos);
                    }
                    int n = this.pos++;
                    int n2 = this.len - 1;
                    while (this.pos < this.len) {
                        c = this.parseString.charAt(this.pos);
                        if (!Character.UnicodeBlock.of(c).equals(unicodeBlock)) {
                            n2 = --this.pos;
                            break;
                        }
                        ++this.pos;
                    }
                    return new JavaFontRenderingAtom(this.parseString.substring(n, n2 + 1), fontInfos);
                }
                if (!this.isPartial) {
                    throw new ParseException("Unknown character : '" + Character.toString(c) + "' (or " + c + ")");
                }
                return new ColorAtom(new RomanAtom(new TeXFormula((String)new StringBuilder().append((String)"\\text{(Unknown char ").append((int)c).append((String)")}").toString()).root), null, Color.RED);
            }
            if (!this.ignoreWhiteSpace && TeXFormula.symbolTextMappings[c] != null) {
                return SymbolAtom.get(TeXFormula.symbolTextMappings[c]).setUnicode(c);
            }
            if (TeXFormula.symbolFormulaMappings != null && TeXFormula.symbolFormulaMappings[c] != null) {
                return new TeXFormula((String)TeXFormula.symbolFormulaMappings[c]).root;
            }
            try {
                return SymbolAtom.get(string);
            }
            catch (SymbolNotFoundException symbolNotFoundException) {
                throw new ParseException("The character '" + Character.toString(c) + "' was mapped to an unknown symbol with the name '" + string + "'!", symbolNotFoundException);
            }
        }
        TeXFormula.FontInfos fontInfos = TeXFormula.externalFontMap.get(Character.UnicodeBlock.BASIC_LATIN);
        if (fontInfos != null) {
            if (bl) {
                return new JavaFontRenderingAtom(Character.toString(c), fontInfos);
            }
            int n = this.pos++;
            int n3 = this.len - 1;
            while (this.pos < this.len) {
                c = this.parseString.charAt(this.pos);
                if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    n3 = --this.pos;
                    break;
                }
                ++this.pos;
            }
            return new JavaFontRenderingAtom(this.parseString.substring(n, n3 + 1), fontInfos);
        }
        return new CharAtom(c, this.formula.textStyle);
    }

    private String getCommand() {
        String string;
        int n = ++this.pos;
        char c = '\u0000';
        while (this.pos < this.len && ((c = this.parseString.charAt(this.pos)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || this.atIsLetter != 0 && c == '@')) {
            ++this.pos;
        }
        if (c == '\u0000') {
            return "";
        }
        if (this.pos == n) {
            ++this.pos;
        }
        if ("cr".equals(string = this.parseString.substring(n, this.pos)) && this.pos < this.len && this.parseString.charAt(this.pos) == ' ') {
            ++this.pos;
        }
        return string;
    }

    private Atom processEscape() throws ParseException {
        this.spos = this.pos;
        String string = this.getCommand();
        if (string.length() == 0) {
            return new EmptyAtom();
        }
        if (MacroInfo.Commands.get(string) != null) {
            return this.processCommands(string);
        }
        try {
            return TeXFormula.get((String)string).root;
        }
        catch (FormulaNotFoundException formulaNotFoundException) {
            try {
                return SymbolAtom.get(string);
            }
            catch (SymbolNotFoundException symbolNotFoundException) {
                if (!this.isPartial) {
                    throw new ParseException("Unknown symbol or command or predefined TeXFormula: '" + string + "'");
                }
                return new ColorAtom(new RomanAtom(new TeXFormula((String)new StringBuilder().append((String)"\\backslash ").append((String)string).toString()).root), null, Color.RED);
            }
        }
    }

    private void insert(int n, int n2, String string) {
        this.parseString.replace(n, n2, string);
        this.len = this.parseString.length();
        this.pos = n;
        this.insertion = true;
    }

    public String[] getOptsArgs(int n, int n2) {
        String[] stringArray = new String[n + 10 + 1];
        if (n != 0) {
            if (n2 == 1) {
                try {
                    for (int i = n + 1; i < n + 11; ++i) {
                        this.skipWhiteSpace();
                        stringArray[i] = this.getGroup('[', ']');
                    }
                }
                catch (ParseException parseException) {
                    stringArray[i] = null;
                }
            }
            this.skipWhiteSpace();
            try {
                stringArray[1] = this.getGroup('{', '}');
            }
            catch (ParseException parseException) {
                if (this.parseString.charAt(this.pos) != '\\') {
                    stringArray[1] = "" + this.parseString.charAt(this.pos);
                    ++this.pos;
                }
                stringArray[1] = this.getCommandWithArgs(this.getCommand());
            }
            if (n2 == 2) {
                try {
                    for (int i = n + 1; i < n + 11; ++i) {
                        this.skipWhiteSpace();
                        stringArray[i] = this.getGroup('[', ']');
                    }
                }
                catch (ParseException parseException) {
                    stringArray[i] = null;
                }
            }
            for (int i = 2; i <= n; ++i) {
                this.skipWhiteSpace();
                try {
                    stringArray[i] = this.getGroup('{', '}');
                    continue;
                }
                catch (ParseException parseException) {
                    if (this.parseString.charAt(this.pos) != '\\') {
                        stringArray[i] = "" + this.parseString.charAt(this.pos);
                        ++this.pos;
                        continue;
                    }
                    stringArray[i] = this.getCommandWithArgs(this.getCommand());
                }
            }
            if (this.ignoreWhiteSpace) {
                this.skipWhiteSpace();
            }
        }
        return stringArray;
    }

    private String getCommandWithArgs(String string) {
        if (string.equals("left")) {
            return this.getGroup("\\left", "\\right");
        }
        MacroInfo macroInfo = MacroInfo.Commands.get(string);
        if (macroInfo != null) {
            String string2;
            int n;
            int n2 = 0;
            if (macroInfo.hasOptions) {
                n2 = macroInfo.posOpts;
            }
            String[] stringArray = this.getOptsArgs(macroInfo.nbArgs, n2);
            StringBuffer stringBuffer = new StringBuffer("\\");
            stringBuffer.append(string);
            for (n = 0; n < macroInfo.posOpts; ++n) {
                string2 = stringArray[macroInfo.nbArgs + n + 1];
                if (string2 == null) continue;
                stringBuffer.append("[").append(string2).append("]");
            }
            for (n = 0; n < macroInfo.nbArgs; ++n) {
                string2 = stringArray[n + 1];
                if (string2 == null) continue;
                stringBuffer.append("{").append(string2).append("}");
            }
            return stringBuffer.toString();
        }
        return "\\" + string;
    }

    private Atom processCommands(String string) throws ParseException {
        MacroInfo macroInfo = MacroInfo.Commands.get(string);
        int n = 0;
        if (macroInfo.hasOptions) {
            n = macroInfo.posOpts;
        }
        String[] stringArray = this.getOptsArgs(macroInfo.nbArgs, n);
        stringArray[0] = string;
        if (NewCommandMacro.isMacro(string)) {
            String string2 = (String)macroInfo.invoke(this, stringArray);
            this.insert(this.spos, this.pos, string2);
            return null;
        }
        return (Atom)macroInfo.invoke(this, stringArray);
    }

    public final boolean isValidName(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        char c = '\u0000';
        if (string.charAt(0) == '\\') {
            int n = string.length();
            for (int i = 1; i < n && (Character.isLetter(c = string.charAt(i)) || this.atIsLetter != 0 && c == '@'); ++i) {
            }
        } else {
            return false;
        }
        return Character.isLetter(c);
    }

    public final boolean isValidCharacterInCommand(char c) {
        return Character.isLetter(c) || this.atIsLetter != 0 && c == '@';
    }

    private final void skipWhiteSpace() {
        char c;
        while (this.pos < this.len && ((c = this.parseString.charAt(this.pos)) == ' ' || c == '\t' || c == '\n' || c == '\r')) {
            if (c == '\n') {
                ++this.line;
                this.col = this.pos;
            }
            ++this.pos;
        }
    }

    private static char convertToRomanNumber(char c) {
        if (c == '\u066b') {
            return '.';
        }
        if ('\u0660' <= c && c <= '\u0669') {
            return (char)(c - 1584);
        }
        if ('\u06f0' <= c && c <= '\u06f9') {
            return (char)(c - 1728);
        }
        if ('\u0966' <= c && c <= '\u096f') {
            return (char)(c - 2358);
        }
        if ('\u09e6' <= c && c <= '\u09ef') {
            return (char)(c - 2486);
        }
        if ('\u0a66' <= c && c <= '\u0a6f') {
            return (char)(c - 2614);
        }
        if ('\u0ae6' <= c && c <= '\u0aef') {
            return (char)(c - 2742);
        }
        if ('\u0b66' <= c && c <= '\u0b6f') {
            return (char)(c - 2870);
        }
        if ('\u0c66' <= c && c <= '\u0c6f') {
            return (char)(c - 3126);
        }
        if ('\u0d66' <= c && c <= '\u0d6f') {
            return (char)(c - 3382);
        }
        if ('\u0e50' <= c && c <= '\u0e59') {
            return (char)(c - 3616);
        }
        if ('\u0ed0' <= c && c <= '\u0ed9') {
            return (char)(c - 3744);
        }
        if ('\u0f20' <= c && c <= '\u0f29') {
            return (char)(c - 3728);
        }
        if ('\u1040' <= c && c <= '\u1049') {
            return (char)(c - 4112);
        }
        if ('\u17e0' <= c && c <= '\u17e9') {
            return (char)(c - 6064);
        }
        if ('\u1810' <= c && c <= '\u1819') {
            return (char)(c - 6112);
        }
        if ('\u1b50' <= c && c <= '\u1b59') {
            return (char)(c - 6944);
        }
        if ('\u1bb0' <= c && c <= '\u1bb9') {
            return (char)(c - 7040);
        }
        if ('\u1c40' <= c && c <= '\u1c49') {
            return (char)(c - 7184);
        }
        if ('\u1c50' <= c && c <= '\u1c59') {
            return (char)(c - 7200);
        }
        if ('\ua8d0' <= c && c <= '\ua8d9') {
            return (char)(c - 43168);
        }
        return c;
    }

    static {
        unparsedContents.add("jlmDynamic");
        unparsedContents.add("jlmText");
        unparsedContents.add("jlmTextit");
        unparsedContents.add("jlmTextbf");
        unparsedContents.add("jlmTextitbf");
        unparsedContents.add("jlmExternalFont");
    }
}

