/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.BrowserCommandsMenu;
import org.gjt.sp.jedit.browser.BrowserListener;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.DeleteBrowserTask;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.MkDirBrowserTask;
import org.gjt.sp.jedit.browser.RenameBrowserTask;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTable;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.datatransfer.ListVFSFileTransferable;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindow;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.FilePropertiesDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.io.CopyFileWorker;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.GlobVFSFileFilter;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSFileFilter;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskAdapter;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class VFSBrowser
extends JPanel
implements DefaultFocusComponent,
DockableWindow {
    public static final String NAME = "vfs.browser";
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int BROWSER_DIALOG = 4;
    public static final int CHOOSE_DIRECTORY_DIALOG = 3;
    public static final int BROWSER = 2;
    public static final int M_OPEN = 0;
    public static final int M_OPEN_NEW_VIEW = 1;
    public static final int M_OPEN_NEW_PLAIN_VIEW = 2;
    public static final int M_OPEN_NEW_SPLIT = 3;
    public static final int M_INSERT = 4;
    String currentEncoding;
    boolean autoDetectEncoding;
    private static final ActionContext actionContext = new BrowserActionContext();
    private EventListenerList listenerList;
    private View view;
    private boolean horizontalLayout;
    private String path;
    private JPanel pathAndFilterPanel;
    private HistoryTextField pathField;
    private JComponent defaultFocusComponent;
    private JCheckBox filterCheckbox;
    private HistoryComboBoxEditor filterEditor;
    private JComboBox filterField;
    private Box toolbarBox;
    private Box topBox;
    private FavoritesMenuButton favorites;
    private PluginsMenuButton plugins;
    private BrowserView browserView;
    private int mode;
    private boolean multipleSelection;
    private boolean showHiddenFiles;
    private boolean sortMixFilesAndDirs;
    private boolean sortIgnoreCase;
    private boolean doubleClickClose;
    private boolean requestRunning;
    private boolean maybeReloadRequestRunning;
    private final Stack<String> historyStack = new Stack();
    private final Stack<String> nextDirectoryStack = new Stack();

    public static void browseDirectoryInNewWindow(View view, String string) {
        DockableWindowManager dockableWindowManager = view.getDockableWindowManager();
        if (string != null) {
            jEdit.setTemporaryProperty("vfs.browser.path.tmp", string);
        }
        dockableWindowManager.floatDockableWindow(NAME);
        jEdit.unsetProperty("vfs.browser.path.tmp");
    }

    public static void browseDirectory(View view, String string) {
        DockableWindowManager dockableWindowManager = view.getDockableWindowManager();
        VFSBrowser vFSBrowser = (VFSBrowser)dockableWindowManager.getDockable(NAME);
        if (vFSBrowser != null) {
            dockableWindowManager.showDockableWindow(NAME);
            vFSBrowser.setDirectory(string);
        } else {
            if (string != null) {
                jEdit.setTemporaryProperty("vfs.browser.path.tmp", string);
            }
            dockableWindowManager.addDockableWindow(NAME);
            jEdit.unsetProperty("vfs.browser.path.tmp");
        }
    }

    public static ActionContext getActionContext() {
        return actionContext;
    }

    public VFSBrowser(View view, String string) {
        this(view, null, 2, true, string);
    }

    public VFSBrowser(View view, String string, int n, boolean bl, String string2) {
        super(new BorderLayout());
        Object object;
        Object object2;
        Object object3;
        this.listenerList = new EventListenerList();
        this.mode = n;
        this.multipleSelection = bl;
        this.view = view;
        this.currentEncoding = null;
        this.autoDetectEncoding = jEdit.getBooleanProperty("buffer.encodingAutodetect");
        ActionHandler actionHandler = new ActionHandler();
        this.topBox = new Box(1);
        this.horizontalLayout = n != 2 || "top".equals(string2) || "bottom".equals(string2);
        this.toolbarBox = new Box(this.horizontalLayout ? 0 : 1);
        this.topBox.add(this.toolbarBox);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.pathAndFilterPanel = new JPanel(gridBagLayout);
        if (this.isHorizontalLayout()) {
            this.pathAndFilterPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        JLabel jLabel = new JLabel(jEdit.getProperty("vfs.browser.path"), 4);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.pathAndFilterPanel.add(jLabel);
        this.pathField = new HistoryTextField("vfs.browser.path");
        this.pathField.setName("path");
        this.pathField.setInstantPopups(true);
        this.pathField.setEnterAddsToHistory(false);
        this.pathField.setSelectAllOnFocus(true);
        Dimension dimension = this.pathField.getPreferredSize();
        dimension.width = 0;
        this.pathField.setPreferredSize(dimension);
        this.pathField.addActionListener(actionHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.pathField, gridBagConstraints);
        this.pathAndFilterPanel.add(this.pathField);
        this.filterCheckbox = new JCheckBox(jEdit.getProperty("vfs.browser.filter"));
        this.filterCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.filterCheckbox.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.filterCheckbox.setSelected(jEdit.getBooleanProperty("vfs.browser.filter-enabled"));
        this.filterCheckbox.addActionListener(actionHandler);
        this.filterCheckbox.setName("filter-checkbox");
        if (n != 3) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.filterCheckbox, gridBagConstraints);
            this.pathAndFilterPanel.add(this.filterCheckbox);
        }
        this.filterField = new JComboBox();
        this.filterEditor = new HistoryComboBoxEditor("vfs.browser.filter");
        this.filterEditor.setToolTipText(jEdit.getProperty("glob.tooltip"));
        this.filterEditor.setInstantPopups(true);
        this.filterEditor.setSelectAllOnFocus(true);
        this.filterEditor.addActionListener(actionHandler);
        this.filterField.setName("filter-field");
        if (n == 2) {
            object3 = view.getDockableWindowManager();
            object2 = ((DockableWindowManager)object3).closeListener(NAME);
            this.filterCheckbox.addKeyListener((KeyListener)object2);
            this.addKeyListener((KeyListener)object2);
            this.filterEditor.addKeyListener((KeyListener)object2);
            this.pathField.addKeyListener((KeyListener)object2);
            this.pathField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        VFSBrowser.this.pathField.setText(VFSBrowser.this.path);
                    }
                }
            });
        }
        if (n == 2 || !jEdit.getBooleanProperty("vfs.browser.currentBufferFilter")) {
            object3 = jEdit.getProperty("vfs.browser.last-filter");
            if (object3 == null) {
                object3 = jEdit.getProperty("vfs.browser.default-filter");
            }
        } else {
            object2 = MiscUtilities.getFileExtension(view.getBuffer().getName());
            object3 = object2.length() == 0 ? jEdit.getProperty("vfs.browser.default-filter") : '*' + (String)object2;
        }
        this.filterEditor.setItem(new GlobVFSFileFilter((String)object3));
        this.filterField.addItem(this.filterEditor.getItem());
        this.filterField.addItemListener(actionHandler);
        this.filterField.setRenderer(new VFSFileFilterRenderer());
        object2 = ServiceManager.getServiceNames(VFSFileFilter.SERVICE_NAME);
        for (int i = 0; i < ((String[])object2).length; ++i) {
            object = (VFSFileFilter)ServiceManager.getService(VFSFileFilter.SERVICE_NAME, object2[i]);
            this.filterField.addItem(object);
        }
        if (n != 3) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            if (this.filterField.getItemCount() > 1) {
                this.filterField.setEditor(this.filterEditor);
                this.filterField.setEditable(true);
                gridBagLayout.setConstraints(this.filterField, gridBagConstraints);
                this.pathAndFilterPanel.add(this.filterField);
            } else {
                gridBagLayout.setConstraints(this.filterEditor, gridBagConstraints);
                this.pathAndFilterPanel.add(this.filterEditor);
            }
        }
        this.topBox.add(this.pathAndFilterPanel);
        this.add("North", this.topBox);
        this.browserView = new BrowserView(this);
        this.add("Center", this.browserView);
        if (this.isHorizontalLayout()) {
            this.browserView.setBorder(new EmptyBorder(0, 12, 0, 12));
        }
        this.defaultFocusComponent = this.browserView.getTable();
        this.propertiesChanged();
        this.updateFilterEnabled();
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        if (string == null) {
            string = jEdit.getProperty("vfs.browser.path.tmp");
        }
        if (string == null || string.isEmpty()) {
            String string3 = System.getProperty("user.home");
            object = jEdit.getProperty("vfs.browser.defaultPath");
            if ("home".equals(object)) {
                string = string3;
            } else if ("working".equals(object)) {
                string = System.getProperty("user.dir");
            } else if ("buffer".equals(object)) {
                boolean bl2;
                Buffer buffer = view.getBuffer();
                boolean bl3 = bl2 = (buffer.getVFS().getCapabilities() & 4) != 0;
                if (bl2) {
                    string = buffer.getDirectory();
                }
            } else if ("last".equals(object)) {
                string = VFSBrowser.getLastVisitedPath();
                if (string == null) {
                    string = "~";
                }
            } else if ("favorites".equals(object)) {
                string = "favorites:";
            }
            if (string == null || string.isEmpty()) {
                string = string3;
            }
        }
        final String string4 = string;
        ThreadUtilities.runInDispatchThread(new Runnable(){

            @Override
            public void run() {
                VFSBrowser.this.setDirectory(string4);
            }
        });
    }

    @Override
    public void focusOnDefaultComponent() {
        this.defaultFocusComponent.requestFocus();
    }

    void setDefaultFocusComponent(JComponent jComponent) {
        this.defaultFocusComponent = jComponent;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
    }

    @Override
    public void removeNotify() {
        VFSFileFilter vFSFileFilter;
        super.removeNotify();
        jEdit.setBooleanProperty("vfs.browser.filter-enabled", this.filterCheckbox.isSelected());
        if ((this.mode == 2 || !jEdit.getBooleanProperty("vfs.browser.currentBufferFilter")) && (vFSFileFilter = (VFSFileFilter)this.filterField.getSelectedItem()) instanceof GlobVFSFileFilter) {
            jEdit.setProperty("vfs.browser.last-filter", ((GlobVFSFileFilter)vFSFileFilter).getGlob());
        }
        EditBus.removeFromBus(this);
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        this.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bufferUpdate) {
        if (bufferUpdate.getWhat() == BufferUpdate.CREATED || bufferUpdate.getWhat() == BufferUpdate.CLOSED) {
            this.browserView.updateFileView();
        }
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate pluginUpdate) {
        if ((pluginUpdate.getWhat() == PluginUpdate.LOADED || pluginUpdate.getWhat() == PluginUpdate.UNLOADED) && this.plugins != null) {
            this.plugins.updatePopupMenu();
        }
    }

    @EditBus.EBHandler
    public void handleVFSUpdate(VFSUpdate vFSUpdate) {
        this.maybeReloadDirectory(vFSUpdate.getPath());
    }

    public View getView() {
        return this.view;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isMultipleSelectionEnabled() {
        return this.multipleSelection;
    }

    public boolean isHorizontalLayout() {
        return this.horizontalLayout;
    }

    public boolean getShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean bl) {
        this.showHiddenFiles = bl;
    }

    public VFSFileFilter getVFSFileFilter() {
        if (this.mode == 3) {
            return new DirectoriesOnlyFilter();
        }
        return (VFSFileFilter)this.filterField.getSelectedItem();
    }

    public void addVFSFileFilter(VFSFileFilter vFSFileFilter) {
        this.filterField.addItem(vFSFileFilter);
        if (this.filterField.getItemCount() == 2) {
            this.filterField.setEditor(this.filterEditor);
            this.filterField.setEditable(true);
            GridBagLayout gridBagLayout = (GridBagLayout)this.pathAndFilterPanel.getLayout();
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.filterEditor);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.pathAndFilterPanel.remove(this.filterEditor);
            gridBagLayout.setConstraints(this.filterField, gridBagConstraints);
            this.pathAndFilterPanel.add(this.filterField);
            this.pathAndFilterPanel.validate();
            this.pathAndFilterPanel.repaint();
        }
    }

    public void setFilenameFilter(String string) {
        if (string == null || string.length() == 0 || "*".equals(string)) {
            this.filterCheckbox.setSelected(false);
        } else {
            this.filterCheckbox.setSelected(true);
            this.filterEditor.setItem(new GlobVFSFileFilter(string));
        }
    }

    public HistoryTextField getDirectoryField() {
        return this.pathField;
    }

    public String getDirectory() {
        return this.path;
    }

    public void previousDirectory() {
        if (this.historyStack.size() > 1) {
            this.historyStack.pop();
            this.nextDirectoryStack.push(this.path);
            this.setDirectory(this.historyStack.peek());
            this.historyStack.pop();
        }
    }

    public void nextDirectory() {
        if (!this.nextDirectoryStack.isEmpty()) {
            this.setDirectory(this.nextDirectoryStack.pop());
        }
    }

    public static String getLastVisitedPath() {
        HistoryModel historyModel = HistoryModel.getModel("vfs.browser.path");
        if (historyModel.getSize() == 0) {
            return null;
        }
        return historyModel.getItem(0);
    }

    public void setDirectory(String string) {
        if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        string = MiscUtilities.expandVariables(string);
        this.pathField.setText(string);
        if (!this.startRequest()) {
            return;
        }
        this.historyStack.push(string);
        this.browserView.saveExpansionState();
        DelayedEndRequest delayedEndRequest = new DelayedEndRequest();
        this.browserView.loadDirectory(null, string, true, delayedEndRequest);
        this.path = string;
    }

    public static String getRootDirectory() {
        if (OperatingSystem.isMacOS() || OperatingSystem.isWindows()) {
            return "roots:";
        }
        return "/";
    }

    public void rootDirectory() {
        this.setDirectory(VFSBrowser.getRootDirectory());
    }

    public void reloadDirectory() {
        VFSManager.getVFSForPath(this.path).reloadDirectory(this.path);
        this.browserView.saveExpansionState();
        this.browserView.loadDirectory(null, this.path, false);
    }

    public void delete(VFSFile[] vFSFileArray) {
        String string = MiscUtilities.isURL(vFSFileArray[0].getDeletePath()) && "favorites".equals(MiscUtilities.getProtocolOfURL(vFSFileArray[0].getDeletePath())) ? "vfs.browser.delete-favorites" : "vfs.browser.delete-confirm";
        String string2 = "files";
        for (VFSFile vFSFile : vFSFileArray) {
            if (vFSFile.getType() != 1) continue;
            string2 = "directories and their contents";
            break;
        }
        Object[] objectArray = new Object[]{"", string2};
        JList<VFSFile> jList = new JList<VFSFile>(vFSFileArray);
        jList.setVisibleRowCount(10);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(new JScrollPane(jList));
        jPanel.add((Component)new JLabel(jEdit.getProperty(string + ".message", objectArray)), "First");
        int n = JOptionPane.showConfirmDialog(this, jPanel, jEdit.getProperty(string + ".title"), 2, 3);
        if (n != 0) {
            return;
        }
        VFS vFS = VFSManager.getVFSForPath(vFSFileArray[0].getDeletePath());
        if (!this.startRequest()) {
            return;
        }
        final CountDownLatch countDownLatch = new CountDownLatch(vFSFileArray.length);
        for (int i = 0; i < vFSFileArray.length; ++i) {
            Object object = vFS.createVFSSession(vFSFileArray[i].getDeletePath(), this);
            if (object == null) {
                countDownLatch.countDown();
                continue;
            }
            final DeleteBrowserTask deleteBrowserTask = new DeleteBrowserTask(this, object, vFS, vFSFileArray[i].getDeletePath());
            TaskManager.instance.addTaskListener(new TaskAdapter(){

                @Override
                public void done(Task task) {
                    if (deleteBrowserTask == task) {
                        countDownLatch.countDown();
                        TaskManager.instance.removeTaskListener(this);
                    }
                }
            });
            ThreadUtilities.runInBackground(deleteBrowserTask);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Log.log(9, this, interruptedException, interruptedException);
        }
        DelayedEndRequest delayedEndRequest = new DelayedEndRequest();
        EventQueue.invokeLater(delayedEndRequest);
    }

    public void rename(VFSFile vFSFile) {
        String string;
        Object[] objectArray;
        if (vFSFile instanceof FavoritesVFS.Favorite) {
            objectArray = (Object[])vFSFile;
            string = objectArray.getLabel();
        } else {
            string = vFSFile.getName();
        }
        objectArray = new String[]{string};
        String string2 = GUIUtilities.input(this, "vfs.browser.rename", objectArray, string);
        if (string2 == null) {
            return;
        }
        this.rename(vFSFile.getVFS(), vFSFile.getPath(), string2);
    }

    public void rename(VFSFile vFSFile, String string) {
        this.rename(vFSFile.getVFS(), vFSFile.getPath(), string);
    }

    public void rename(String string) {
        VFS vFS = VFSManager.getVFSForPath(string);
        String string2 = vFS.getFileName(string);
        Object[] objectArray = new String[]{string2};
        String string3 = GUIUtilities.input(this, "vfs.browser.rename", objectArray, string2);
        if (string3 == null) {
            return;
        }
        this.rename(string, string3);
    }

    private void rename(VFS vFS, String string, String string2) {
        Object object;
        String string3 = vFS.getFileName(string);
        String string4 = string2;
        if (string4 == null) {
            return;
        }
        if (!(vFS instanceof FavoritesVFS)) {
            if (string3.equals(string2)) {
                return;
            }
            string4 = MiscUtilities.constructPath(vFS.getParentOfPath(string), string4);
        }
        if ((object = vFS.createVFSSession(string, this)) == null) {
            return;
        }
        if (!this.startRequest()) {
            return;
        }
        DelayedEndRequest delayedEndRequest = new DelayedEndRequest();
        RenameBrowserTask renameBrowserTask = new RenameBrowserTask(this, object, vFS, string, string4, delayedEndRequest);
        ThreadUtilities.runInBackground(renameBrowserTask);
    }

    public void rename(String string, String string2) {
        VFS vFS = VFSManager.getVFSForPath(string);
        this.rename(vFS, string, string2);
    }

    public void mkdir() {
        String string;
        String string2 = GUIUtilities.input(this, "vfs.browser.mkdir", null);
        if (string2 == null) {
            return;
        }
        final VFSFile[] vFSFileArray = this.getSelectedFiles();
        if (vFSFileArray.length == 0) {
            string = this.path;
        } else if (vFSFileArray[0].getType() == 0) {
            string = vFSFileArray[0].getPath();
            string = VFSManager.getVFSForPath(string).getParentOfPath(string);
        } else {
            string = vFSFileArray[0].getPath();
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        string2 = MiscUtilities.constructPath(string, string2);
        Object object = vFS.createVFSSession(string2, this);
        if (object == null) {
            return;
        }
        if (!this.startRequest()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                VFSBrowser.this.endRequest();
                if (vFSFileArray.length != 0 && vFSFileArray[0].getType() != 0) {
                    VFSDirectoryEntryTable vFSDirectoryEntryTable = VFSBrowser.this.browserView.getTable();
                    int n = vFSDirectoryEntryTable.getSelectedRow();
                    VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)vFSDirectoryEntryTable.getModel();
                    VFSDirectoryEntryTableModel.Entry entry = vFSDirectoryEntryTableModel.files[n];
                    if (!entry.expanded) {
                        VFSBrowser.this.browserView.clearExpansionState();
                        VFSBrowser.this.browserView.loadDirectory(entry, entry.dirEntry.getPath(), false);
                    }
                }
            }
        };
        MkDirBrowserTask mkDirBrowserTask = new MkDirBrowserTask(this, object, vFS, string2, runnable);
        ThreadUtilities.runInBackground(mkDirBrowserTask);
    }

    public void newFile() {
        VFSFile[] vFSFileArray = this.getSelectedFiles();
        if (vFSFileArray.length >= 1) {
            VFSFile vFSFile = vFSFileArray[0];
            if (vFSFile.getType() == 1) {
                jEdit.newFile(this.view, vFSFile.getPath());
            } else {
                VFS vFS = VFSManager.getVFSForPath(vFSFile.getPath());
                jEdit.newFile(this.view, vFS.getParentOfPath(vFSFile.getPath()));
            }
        } else {
            jEdit.newFile(this.view, this.path);
        }
    }

    public void fileProperties(VFSFile[] vFSFileArray) {
        new FilePropertiesDialog(this.view, this, vFSFileArray);
    }

    public void searchInDirectory() {
        VFSFile[] vFSFileArray = this.getSelectedFiles();
        if (vFSFileArray.length >= 1) {
            VFSFile vFSFile = vFSFileArray[0];
            this.searchInDirectory(vFSFile.getPath(), vFSFile.getType() != 0);
        } else {
            this.searchInDirectory(this.path, true);
        }
    }

    public void searchInDirectory(String string, boolean bl) {
        VFSFileFilter vFSFileFilter = this.getVFSFileFilter();
        String string2 = vFSFileFilter instanceof GlobVFSFileFilter ? ((GlobVFSFileFilter)vFSFileFilter).getGlob() : "*";
        if (!bl) {
            String string3 = MiscUtilities.getFileName(string);
            String string4 = MiscUtilities.getFileExtension(string3);
            string2 = string4 == null || string4.length() == 0 ? string2 : '*' + string4;
            string = MiscUtilities.getParentOfPath(string);
        }
        SearchAndReplace.setSearchFileSet(new DirectoryListSet(string, string2, true));
        SearchDialog.showSearchDialog(this.view, null, 2);
    }

    BrowserView getBrowserView() {
        return this.browserView;
    }

    public VFSFile[] getSelectedFiles() {
        return this.browserView.getSelectedFiles();
    }

    public VFSFile[] getSelectedFiles(Component component) {
        if (GUIUtilities.getComponentParent(component, BrowserView.ParentDirectoryList.class) != null) {
            Object[] objectArray = this.getBrowserView().getParentDirectoryList().getSelectedValues();
            VFSFile[] vFSFileArray = new VFSFile[objectArray.length];
            System.arraycopy(objectArray, 0, vFSFileArray, 0, objectArray.length);
            return vFSFileArray;
        }
        return this.getSelectedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paste(VFSFile vFSFile) throws IOException, UnsupportedFlavorException {
        if (vFSFile == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        String string = null;
        switch (vFSFile.getType()) {
            case 2: {
                return;
            }
            case 0: {
                string = MiscUtilities.getParentOfPath(vFSFile.getPath());
                break;
            }
            case 1: {
                string = vFSFile.getPath();
                break;
            }
            default: {
                Log.log(9, this, "Unknown file type " + vFSFile.getType());
                return;
            }
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        Object object = null;
        try {
            Object object2;
            object = vFS.createVFSSession(string, this);
            if (object == null) {
                Log.log(9, this, "Unable to create session for " + string);
                return;
            }
            Transferable transferable = Registers.getRegister('$').getTransferable();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (transferable.isDataFlavorSupported(ListVFSFileTransferable.jEditFileList)) {
                object2 = (Iterable)transferable.getTransferData(ListVFSFileTransferable.jEditFileList);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    VFSFile vFSFile2 = (VFSFile)iterator.next();
                    arrayList.add(vFSFile2.getPath());
                }
            } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                object2 = (Iterable)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    arrayList.add(file.getAbsolutePath());
                }
            }
            object2 = new CopyFileWorker((Component)this, arrayList, string, CopyFileWorker.Behavior.RENAME);
            ThreadUtilities.runInBackground((Task)object2);
        }
        finally {
            if (object != null) {
                vFS._endVFSSession(object, this);
            }
        }
    }

    public void locateFile(final String string) {
        VFSFileFilter vFSFileFilter = this.getVFSFileFilter();
        if (!vFSFileFilter.accept(MiscUtilities.getFileName(string))) {
            this.setFilenameFilter(null);
        }
        this.setDirectory(MiscUtilities.getParentOfPath(string));
        AwtRunnableQueue.INSTANCE.runAfterIoTasks(new Runnable(){

            @Override
            public void run() {
                VFSBrowser.this.browserView.getTable().selectFile(string);
            }
        });
    }

    public JComponent createPluginsMenu(JComponent jComponent, boolean bl) {
        if (bl && this.getMode() == 2) {
            jComponent.add(GUIUtilities.loadMenuItem("plugin-manager", false));
            jComponent.add(GUIUtilities.loadMenuItem("plugin-options", false));
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).addSeparator();
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).addSeparator();
            }
        }
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        EditPlugin[] editPluginArray = jEdit.getPlugins();
        for (EditPlugin editPlugin : editPluginArray) {
            JMenuItem jMenuItem = editPlugin.createBrowserMenuItems();
            if (jMenuItem == null) continue;
            arrayList.add(jMenuItem);
        }
        if (!arrayList.isEmpty()) {
            Collections.sort(arrayList, new MenuItemTextComparator());
            for (JMenuItem jMenuItem : arrayList) {
                jComponent.add(jMenuItem);
            }
        } else {
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.plugins.no-plugins.label"));
            jMenuItem.setEnabled(false);
            jComponent.add(jMenuItem);
        }
        return jComponent;
    }

    public void addBrowserListener(BrowserListener browserListener) {
        this.listenerList.add(BrowserListener.class, browserListener);
    }

    public void removeBrowserListener(BrowserListener browserListener) {
        this.listenerList.remove(BrowserListener.class, browserListener);
    }

    public void filesActivated(int n, boolean bl) {
        VFSFile[] vFSFileArray = this.browserView.getSelectedFiles();
        Buffer buffer = null;
        for (VFSFile vFSFile : vFSFileArray) {
            EditPane[] editPaneArray;
            if (vFSFile.getType() == 1 || vFSFile.getType() == 2) {
                if (n == 1 && this.mode == 2) {
                    VFSBrowser.browseDirectoryInNewWindow(this.view, vFSFile.getPath());
                    continue;
                }
                if (vFSFileArray.length != 1) continue;
                this.setDirectory(vFSFile.getPath());
                continue;
            }
            if (this.mode != 2 && this.mode != 4) continue;
            if (n == 4) {
                this.view.getBuffer().insertFile(this.view, vFSFile.getPath());
                continue;
            }
            Buffer buffer2 = jEdit.getBuffer(vFSFile.getPath());
            if (buffer2 == null) {
                editPaneArray = new Hashtable();
                if (this.currentEncoding != null) {
                    editPaneArray.put("encoding", this.currentEncoding);
                }
                editPaneArray.put("encodingAutodetect", this.autoDetectEncoding);
                buffer2 = jEdit.openFile(this.view, null, vFSFile.getPath(), false, (Hashtable<String, Object>)editPaneArray);
            } else if (this.doubleClickClose && bl && this.mode != 4 && vFSFileArray.length == 1) {
                for (EditPane editPane : editPaneArray = this.view.getEditPanes()) {
                    if (editPane.getBuffer() != buffer2) continue;
                    jEdit.closeBuffer(this.view, buffer2);
                    return;
                }
            }
            if (buffer2 == null) continue;
            buffer = buffer2;
        }
        if (buffer != null) {
            switch (n) {
                case 0: {
                    this.view.setBuffer(buffer);
                    break;
                }
                case 1: {
                    jEdit.newView(this.view, buffer, false);
                    break;
                }
                case 2: {
                    jEdit.newView(this.view, buffer, true);
                    break;
                }
                case 3: {
                    this.view.splitHorizontally().setBuffer(buffer);
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != BrowserListener.class) continue;
            BrowserListener browserListener = (BrowserListener)objectArray[i + 1];
            browserListener.filesActivated(this, vFSFileArray);
        }
    }

    public void dispose() {
        if (this.mode == 2) {
            this.view.getDockableWindowManager().hideDockableWindow(NAME);
        } else {
            GUIUtilities.getParentDialog(this).dispose();
        }
    }

    @Override
    public void move(String string) {
        boolean bl;
        boolean bl2 = bl = this.mode != 2 || "top".equals(string) || "bottom".equals(string);
        if (bl == this.horizontalLayout) {
            return;
        }
        this.horizontalLayout = bl;
        this.topBox.remove(this.toolbarBox);
        this.toolbarBox = new Box(this.horizontalLayout ? 0 : 1);
        this.topBox.add((Component)this.toolbarBox, 0);
        this.propertiesChanged();
    }

    void directoryLoaded(Object object, Object[] objectArray, boolean bl) {
        String string = (String)objectArray[0];
        if (string == null) {
            return;
        }
        VFSFile[] vFSFileArray = (VFSFile[])objectArray[1];
        if (object == null) {
            this.path = string;
            if (!this.pathField.getText().equals(string)) {
                this.pathField.setText(string);
            }
            if (string.endsWith("/") || string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
            if (bl) {
                HistoryModel.getModel("vfs.browser.path").addItem(string);
            }
        }
        boolean bl2 = this.filterCheckbox.isSelected();
        ArrayList<VFSFile> arrayList = new ArrayList<VFSFile>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (vFSFileArray != null) {
            VFSFileFilter vFSFileFilter = this.getVFSFileFilter();
            for (VFSFile vFSFile : vFSFileArray) {
                if (vFSFile.isHidden() && !this.showHiddenFiles) {
                    ++n3;
                    continue;
                }
                if (vFSFileFilter != null && (bl2 || vFSFileFilter instanceof DirectoriesOnlyFilter) && !vFSFileFilter.accept(vFSFile)) {
                    ++n3;
                    continue;
                }
                if (vFSFile.getType() == 0) {
                    ++n2;
                } else {
                    ++n;
                }
                arrayList.add(vFSFile);
            }
            Collections.sort(arrayList, new VFS.DirectoryEntryCompare(this.sortMixFilesAndDirs, this.sortIgnoreCase));
        }
        this.browserView.directoryLoaded(object, string, arrayList);
        if (this.mode == 3) {
            this.filesSelected();
        }
    }

    void filesSelected() {
        VFSFile[] vFSFileArray = this.browserView.getSelectedFiles();
        if (this.mode == 2) {
            for (VFSFile vFSFile : vFSFileArray) {
                Buffer buffer = jEdit.getBuffer(vFSFile.getPath());
                if (buffer == null || this.view == null) continue;
                this.view.setBuffer(buffer);
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != BrowserListener.class) continue;
            BrowserListener browserListener = (BrowserListener)objectArray[i + 1];
            browserListener.filesSelected(this, vFSFileArray);
        }
    }

    void endRequest() {
        this.requestRunning = false;
    }

    private Container createMenuBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new CommandsMenuButton());
        jToolBar.add(Box.createHorizontalStrut(3));
        this.plugins = new PluginsMenuButton();
        jToolBar.add(this.plugins);
        jToolBar.add(Box.createHorizontalStrut(3));
        this.favorites = new FavoritesMenuButton();
        jToolBar.add(this.favorites);
        return jToolBar;
    }

    private Container createToolBar() {
        if (this.mode == 2) {
            return GUIUtilities.loadToolBar(actionContext, "vfs.browser.toolbar-browser");
        }
        return GUIUtilities.loadToolBar(actionContext, "vfs.browser.toolbar-dialog");
    }

    private void propertiesChanged() {
        Container container;
        this.showHiddenFiles = jEdit.getBooleanProperty("vfs.browser.showHiddenFiles");
        this.sortMixFilesAndDirs = jEdit.getBooleanProperty("vfs.browser.sortMixFilesAndDirs");
        this.sortIgnoreCase = jEdit.getBooleanProperty("vfs.browser.sortIgnoreCase");
        this.doubleClickClose = jEdit.getBooleanProperty("vfs.browser.doubleClickClose");
        this.browserView.propertiesChanged();
        this.toolbarBox.removeAll();
        if (jEdit.getBooleanProperty("vfs.browser.showToolbar")) {
            container = this.createToolBar();
            this.toolbarBox.add(container);
        }
        if (jEdit.getBooleanProperty("vfs.browser.showMenubar")) {
            container = this.createMenuBar();
            if (this.horizontalLayout) {
                this.toolbarBox.add((Component)container, 0);
            } else {
                container.add(Box.createGlue());
                this.toolbarBox.add(container);
            }
        } else {
            this.plugins = null;
            this.favorites = null;
        }
        this.revalidate();
        if (this.path != null) {
            this.reloadDirectory();
        }
    }

    private boolean startRequest() {
        if (this.requestRunning) {
            Log.log(1, this, new Throwable("For debugging purposes"));
            GUIUtilities.error(this, "browser-multiple-io", null);
            return false;
        }
        this.requestRunning = true;
        return true;
    }

    private void updateFilterEnabled() {
        this.filterField.setEnabled(this.filterCheckbox.isSelected());
        this.filterEditor.setEnabled(this.filterCheckbox.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReloadDirectory(String string) {
        if (MiscUtilities.isURL(string) && MiscUtilities.getProtocolOfURL(string).equals("favorites") && this.favorites != null) {
            this.favorites.popup = null;
        }
        if (this.maybeReloadRequestRunning) {
            return;
        }
        if (this.path != null) {
            try {
                this.maybeReloadRequestRunning = true;
                this.browserView.maybeReloadDirectory(string);
                AwtRunnableQueue.INSTANCE.runAfterIoTasks(new Runnable(){

                    @Override
                    public void run() {
                        VFSBrowser.this.maybeReloadRequestRunning = false;
                    }
                });
            }
            catch (Throwable throwable) {
                AwtRunnableQueue.INSTANCE.runAfterIoTasks(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }

    static {
        ActionSet actionSet = new ActionSet(null, null, null, jEdit.class.getResource("browser.actions.xml"));
        actionSet.setLabel(jEdit.getProperty("action-set.browser"));
        actionSet.load();
        actionContext.addActionSet(actionSet);
    }

    private class DelayedEndRequest
    implements Runnable {
        private DelayedEndRequest() {
        }

        @Override
        public void run() {
            VFSBrowser.this.endRequest();
        }
    }

    public static class DirectoriesOnlyFilter
    implements VFSFileFilter {
        @Override
        public boolean accept(VFSFile vFSFile) {
            return vFSFile.getType() == 1 || vFSFile.getType() == 2;
        }

        @Override
        public boolean accept(String string) {
            return false;
        }

        @Override
        public String getDescription() {
            return jEdit.getProperty("vfs.browser.file_filter.dir_only");
        }
    }

    private static class VFSFileFilterRenderer
    extends DefaultListCellRenderer {
        private VFSFileFilterRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof VFSFileFilter) : "Filter is not a VFSFileFilter";
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setText(((VFSFileFilter)object).getDescription());
            return this;
        }
    }

    private static class HistoryComboBoxEditor
    extends HistoryTextField
    implements ComboBoxEditor {
        private GlobVFSFileFilter current;

        HistoryComboBoxEditor(String string) {
            super(string);
        }

        @Override
        public Object getItem() {
            if (this.current == null) {
                this.current = new GlobVFSFileFilter(this.getText());
            }
            if (!this.current.getGlob().equals(this.getText())) {
                this.current.setGlob(this.getText());
            }
            return this.current;
        }

        @Override
        public void setItem(Object object) {
            if (object == this.current) {
                if (object != null) {
                    GlobVFSFileFilter globVFSFileFilter = (GlobVFSFileFilter)object;
                    this.current = new GlobVFSFileFilter(globVFSFileFilter.getGlob());
                    this.setText(this.current.getGlob());
                }
                return;
            }
            if (object != null) {
                if (!(object instanceof GlobVFSFileFilter)) {
                    return;
                }
                GlobVFSFileFilter globVFSFileFilter = (GlobVFSFileFilter)object;
                globVFSFileFilter = new GlobVFSFileFilter(globVFSFileFilter.getGlob());
                this.setText(globVFSFileFilter.getGlob());
                this.addCurrentToHistory();
                this.current = globVFSFileFilter;
            } else {
                this.setText("*");
                this.current = new GlobVFSFileFilter("*");
            }
        }

        @Override
        protected void processFocusEvent(FocusEvent focusEvent) {
            if (focusEvent.getID() != 1005) {
                super.processFocusEvent(focusEvent);
            } else {
                this.setCaretPosition(0);
                this.getCaret().setVisible(false);
            }
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }
    }

    static class BrowserActionContext
    extends ActionContext {
        BrowserActionContext() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invokeAction(EventObject eventObject, EditAction editAction) {
            Component component = (Component)eventObject.getSource();
            VFSBrowser vFSBrowser = (VFSBrowser)GUIUtilities.getComponentParent(component, VFSBrowser.class);
            VFSFile[] vFSFileArray = vFSBrowser.getSelectedFiles(component);
            NameSpace nameSpace = BeanShell.getNameSpace();
            try {
                nameSpace.setVariable("browser", vFSBrowser);
                nameSpace.setVariable("files", vFSFileArray);
                View view = vFSBrowser.getView();
                if (view == null) {
                    view = jEdit.getActiveView();
                }
                editAction.invoke(view);
            }
            catch (UtilEvalError utilEvalError) {
                Log.log(9, this, utilEvalError);
            }
            finally {
                try {
                    nameSpace.setVariable("browser", null);
                    nameSpace.setVariable("files", null);
                }
                catch (UtilEvalError utilEvalError) {
                    Log.log(9, this, utilEvalError);
                }
            }
        }
    }

    class FavoritesMenuButton
    extends MenuButton {
        FavoritesMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.favorites.label"));
            GUIUtilities.setAutoMnemonic(this);
            this.setName("favorites");
            this.createPopupMenu();
        }

        @Override
        void doPopup() {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            GUIUtilities.showPopupMenu(this.popup, this, 0, this.getHeight(), false);
        }

        void createPopupMenu() {
            this.popup = new JPopupMenu();
            ActionHandler actionHandler = new ActionHandler();
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.add-to-favorites.label"));
            jMenuItem.setActionCommand("add-to-favorites");
            jMenuItem.addActionListener(actionHandler);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.edit-favorites.label"));
            jMenuItem.setActionCommand("dir@favorites:");
            jMenuItem.addActionListener(actionHandler);
            this.popup.add(jMenuItem);
            this.popup.addSeparator();
            VFSFile[] vFSFileArray = FavoritesVFS.getFavorites();
            if (vFSFileArray.length == 0) {
                jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.no-favorites.label"));
                jMenuItem.setEnabled(false);
                this.popup.add(jMenuItem);
            } else {
                Arrays.sort(vFSFileArray, new VFS.DirectoryEntryCompare(VFSBrowser.this.sortMixFilesAndDirs, VFSBrowser.this.sortIgnoreCase));
                for (int i = 0; i < vFSFileArray.length; ++i) {
                    FavoritesVFS.Favorite favorite = (FavoritesVFS.Favorite)vFSFileArray[i];
                    jMenuItem = new JMenuItem(favorite.getLabel());
                    jMenuItem.setIcon(FileCellRenderer.getIconForFile(favorite, false));
                    String string = (favorite.getType() == 0 ? "file@" : "dir@") + favorite.getPath();
                    jMenuItem.setActionCommand(string);
                    jMenuItem.addActionListener(actionHandler);
                    this.popup.add(jMenuItem);
                }
            }
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("add-to-favorites".equals(string)) {
                    VFSFile[] vFSFileArray = VFSBrowser.this.getSelectedFiles();
                    if (vFSFileArray == null || vFSFileArray.length == 0) {
                        if (VFSBrowser.this.path.equals("favorites:")) {
                            GUIUtilities.error(VFSBrowser.this, "vfs.browser.recurse-favorites", null);
                        } else {
                            FavoritesVFS.addToFavorites(VFSBrowser.this.path, 1);
                        }
                    } else {
                        for (VFSFile vFSFile : vFSFileArray) {
                            FavoritesVFS.addToFavorites(vFSFile.getPath(), vFSFile.getType());
                        }
                    }
                } else if (string.startsWith("dir@")) {
                    VFSBrowser.this.setDirectory(string.substring(4));
                } else if (string.startsWith("file@")) {
                    switch (VFSBrowser.this.getMode()) {
                        case 2: {
                            jEdit.openFile(VFSBrowser.this.view, string.substring(5));
                            break;
                        }
                        default: {
                            VFSBrowser.this.locateFile(string.substring(5));
                        }
                    }
                }
            }
        }
    }

    class PluginsMenuButton
    extends MenuButton {
        PluginsMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.plugins.label"));
            GUIUtilities.setAutoMnemonic(this);
            this.setName("plugins");
            this.setMargin(new Insets(1, 1, 1, 1));
            this.popup = null;
            this.createPopupMenu();
        }

        void updatePopupMenu() {
            this.popup = null;
        }

        @Override
        void doPopup() {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            GUIUtilities.showPopupMenu(this.popup, this, 0, this.getHeight(), false);
        }

        private void createPopupMenu() {
            if (this.popup != null) {
                return;
            }
            this.popup = (JPopupMenu)VFSBrowser.this.createPluginsMenu(new JPopupMenu(), true);
        }
    }

    class CommandsMenuButton
    extends MenuButton {
        CommandsMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.commands.label"));
            GUIUtilities.setAutoMnemonic(this);
            this.setName("commands");
            this.popup = new BrowserCommandsMenu(VFSBrowser.this, null);
        }

        @Override
        void doPopup() {
            ((BrowserCommandsMenu)this.popup).update();
            GUIUtilities.showPopupMenu(this.popup, this, 0, this.getHeight(), false);
        }
    }

    static abstract class MenuButton
    extends RolloverButton
    implements KeyListener {
        JPopupMenu popup;

        MenuButton() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("dropdown-arrow.icon")));
            this.setHorizontalTextPosition(10);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addMouseListener(new MouseHandler());
            this.addKeyListener(this);
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
            this.setAction(new Action());
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 10) {
                this.doPopup();
                keyEvent.consume();
                return;
            }
        }

        abstract void doPopup();

        class Action
        extends AbstractAction {
            Action() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuButton.this.doPopup();
            }
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (MenuButton.this.popup == null || !MenuButton.this.popup.isVisible()) {
                    MenuButton.this.doPopup();
                } else {
                    MenuButton.this.popup.setVisible(false);
                }
            }
        }
    }

    class ActionHandler
    implements ActionListener,
    ItemListener {
        private boolean isProcessingEvent;

        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isProcessingEvent) {
                return;
            }
            Object object = actionEvent.getSource();
            if (object == VFSBrowser.this.pathField || object == VFSBrowser.this.filterCheckbox) {
                this.isProcessingEvent = true;
                this.resetLater();
                VFSBrowser.this.updateFilterEnabled();
                String string = VFSBrowser.this.pathField.getText();
                if (string != null) {
                    VFSBrowser.this.setDirectory(string);
                }
                VFSBrowser.this.browserView.focusOnFileView();
            } else if (object == VFSBrowser.this.filterField.getEditor()) {
                VFSBrowser.this.filterField.getEditor().setItem(VFSBrowser.this.filterField.getEditor().getItem());
            } else if (object == VFSBrowser.this.filterEditor) {
                VFSBrowser.this.filterEditor.setItem(VFSBrowser.this.filterEditor.getItem());
                VFSBrowser.this.filterField.setSelectedItem(VFSBrowser.this.filterEditor.getItem());
                this.itemStateChanged(new ItemEvent(VFSBrowser.this.filterField, 701, VFSBrowser.this.filterEditor.getItem(), 1));
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.isProcessingEvent) {
                return;
            }
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            this.isProcessingEvent = true;
            this.resetLater();
            VFSBrowser.this.filterField.setEditable(itemEvent.getItem() instanceof GlobVFSFileFilter);
            VFSBrowser.this.updateFilterEnabled();
            String string = VFSBrowser.this.pathField.getText();
            if (string != null) {
                VFSBrowser.this.setDirectory(string);
            }
            VFSBrowser.this.browserView.focusOnFileView();
        }

        private void resetLater() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionHandler.this.isProcessingEvent = false;
                }
            });
        }
    }
}

