/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class MapMode
extends JosmAction
implements MouseListener,
MouseMotionListener {
    protected final Cursor cursor;
    protected boolean ctrl;
    protected boolean alt;
    protected boolean shift;

    public MapMode(String string, String string2, String string3, Shortcut shortcut, MapFrame mapFrame, Cursor cursor) {
        super(string, "mapmode/" + string2, string3, shortcut, false);
        this.cursor = cursor;
        this.putValue("active", Boolean.FALSE);
    }

    public MapMode(String string, String string2, String string3, MapFrame mapFrame, Cursor cursor) {
        this.putValue("Name", string);
        this.putValue("SmallIcon", ImageProvider.get("mapmode", string2));
        this.putValue("ShortDescription", string3);
        this.cursor = cursor;
    }

    public void enterMode() {
        this.putValue("active", Boolean.TRUE);
        Main.map.mapView.setNewCursor(this.cursor, (Object)this);
        this.updateStatusLine();
    }

    public void exitMode() {
        this.putValue("active", Boolean.FALSE);
        Main.map.mapView.resetCursor(this);
    }

    protected void updateStatusLine() {
        Main.map.statusLine.setHelpText(this.getModeHelpText());
        Main.map.statusLine.repaint();
    }

    public String getModeHelpText() {
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (Main.isDisplayingMapView()) {
            Main.map.selectMapMode(this);
        }
    }

    public boolean layerIsSupported(Layer layer) {
        return layer != null;
    }

    protected void updateKeyModifiers(InputEvent inputEvent) {
        this.updateKeyModifiers(inputEvent.getModifiers());
    }

    protected void updateKeyModifiers(MouseEvent mouseEvent) {
        this.updateKeyModifiers(mouseEvent.getModifiers());
    }

    protected void updateKeyModifiers(int n) {
        this.ctrl = (n & 2) != 0;
        this.alt = (n & 0x28) != 0;
        this.shift = (n & 1) != 0;
    }

    protected void requestFocusInMapView() {
        if (this.isEnabled()) {
            Main.map.mapView.requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.requestFocusInMapView();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInMapView();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

