/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.Key;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class RelationChecker
extends Test {
    protected static final int ROLE_UNKNOWN = 1701;
    protected static final int ROLE_EMPTY = 1702;
    protected static final int WRONG_TYPE = 1703;
    protected static final int HIGH_COUNT = 1704;
    protected static final int LOW_COUNT = 1705;
    protected static final int ROLE_MISSING = 1706;
    protected static final int RELATION_UNKNOWN = 1707;
    protected static final int RELATION_EMPTY = 1708;
    public static final String ROLE_VERIF_PROBLEM_MSG = I18n.tr("Role verification problem", new Object[0]);
    private static Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr("Relation checker", new Object[0]), I18n.tr("Checks for errors in relations.", new Object[0]));
    }

    @Override
    public void initialize() {
        RelationChecker.initializePresets();
    }

    public static synchronized void initializePresets() {
        if (!relationpresets.isEmpty()) {
            return;
        }
        block0: for (TaggingPreset taggingPreset : TaggingPresets.getTaggingPresets()) {
            for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                if (!(taggingPresetItem instanceof Roles)) continue;
                relationpresets.add(taggingPreset);
                continue block0;
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        Map<String, RolePreset> map = this.buildAllRoles(relation);
        if (map.isEmpty() && relation.hasTag("type", "route") && relation.hasTag("route", "train", "subway", "monorail", "tram", "bus", "trolleybus", "aerialway", "ferry")) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Route scheme is unspecified. Add {0} ({1}=public_transport; {2}=legacy)", "public_transport:version", "2", "1"), 1707, relation));
        } else if (map.isEmpty()) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Relation type is unknown", new Object[0]), 1707, relation));
        }
        Map<String, RoleInfo> map2 = this.buildRoleInfoMap(relation);
        if (map2.isEmpty()) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Relation is empty", new Object[0]), 1708, relation));
        } else if (!map.isEmpty()) {
            this.checkRoles(relation, map, map2);
        }
    }

    private Map<String, RoleInfo> buildRoleInfoMap(Relation relation) {
        HashMap<String, RoleInfo> hashMap = new HashMap<String, RoleInfo>();
        for (RelationMember relationMember : relation.getMembers()) {
            String string = relationMember.getRole();
            RoleInfo roleInfo = (RoleInfo)hashMap.get(string);
            if (roleInfo == null) {
                roleInfo = new RoleInfo();
                hashMap.put(string, roleInfo);
            }
            roleInfo.total++;
        }
        return hashMap;
    }

    private Map<String, RolePreset> buildAllRoles(Relation relation) {
        HashMap<String, RolePreset> hashMap = new HashMap<String, RolePreset>();
        for (TaggingPreset taggingPreset : relationpresets) {
            Object object;
            boolean bl = true;
            Roles roles = null;
            for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                if (taggingPresetItem instanceof Key) {
                    object = (Key)taggingPresetItem;
                    if (((Key)object).value.equals(relation.get(((Key)object).key))) continue;
                    bl = false;
                    break;
                }
                if (!(taggingPresetItem instanceof Roles)) continue;
                roles = (Roles)taggingPresetItem;
            }
            if (!bl || roles == null) continue;
            for (Roles.Role role : roles.roles) {
                object = role.key;
                List<Roles.Role> list = null;
                if (hashMap.containsKey(object)) {
                    list = ((RolePreset)hashMap.get(object)).roles;
                } else {
                    list = new LinkedList();
                    hashMap.put((String)object, new RolePreset(list, taggingPreset.name));
                }
                list.add(role);
            }
        }
        return hashMap;
    }

    private boolean checkMemberType(Roles.Role role, RelationMember relationMember) {
        if (role.types != null) {
            switch (relationMember.getDisplayType()) {
                case NODE: {
                    return role.types.contains((Object)TaggingPresetType.NODE);
                }
                case CLOSEDWAY: {
                    return role.types.contains((Object)TaggingPresetType.CLOSEDWAY);
                }
                case WAY: {
                    return role.types.contains((Object)TaggingPresetType.WAY);
                }
                case MULTIPOLYGON: 
                case RELATION: {
                    return role.types.contains((Object)TaggingPresetType.RELATION);
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkMemberExpressionAndType(RolePreset rolePreset, RelationMember relationMember, Relation relation) {
        Object object;
        TestError testError = null;
        if (rolePreset == null || rolePreset.roles == null) {
            return true;
        }
        for (Object object2 : rolePreset.roles) {
            if (!this.checkMemberType((Roles.Role)object2, relationMember)) continue;
            if (((Roles.Role)object2).memberExpression == null) {
                return true;
            }
            object = relationMember.getMember();
            if (!((AbstractPrimitive)object).isUsable()) {
                return true;
            }
            if (((Roles.Role)object2).memberExpression.match((OsmPrimitive)object)) {
                return true;
            }
            Object object3 = I18n.marktr("Role member does not match expression {0} in template {1}");
            testError = new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr((String)object3, ((Roles.Role)object2).memberExpression, rolePreset.name), (String)object3, 1703, relationMember.getMember().isUsable() ? relationMember.getMember() : relation);
        }
        if (testError != null) {
            this.errors.add(testError);
        } else {
            Object object2;
            String string = I18n.marktr("Role member type {0} does not match accepted list of {1} in template {2}");
            object2 = EnumSet.noneOf(TaggingPresetType.class);
            for (Object object3 : rolePreset.roles) {
                object2.addAll(((Roles.Role)object3).types);
            }
            object = Utils.join("/", Utils.transform(object2, new Utils.Function<TaggingPresetType, Object>(){

                @Override
                public Object apply(TaggingPresetType taggingPresetType) {
                    return I18n.tr(taggingPresetType.getName(), new Object[0]);
                }
            }));
            this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(string, new Object[]{relationMember.getType(), object, rolePreset.name}), string, 1703, relationMember.getMember().isUsable() ? relationMember.getMember() : relation));
        }
        return false;
    }

    private void checkRoles(Relation relation, Map<String, RolePreset> map, Map<String, RoleInfo> map2) {
        Object object;
        for (RelationMember object2 : relation.getMembers()) {
            object = object2.getRole();
            this.checkMemberExpressionAndType(map.get(object), object2, relation);
        }
        for (RolePreset rolePreset : map.values()) {
            for (Object object2 : rolePreset.roles) {
                String string = ((Roles.Role)object2).key;
                if (string.isEmpty()) {
                    string = I18n.tr("<empty>", new Object[0]);
                }
                this.checkRoleCounts(relation, (Roles.Role)object2, string, map2.get(((Roles.Role)object2).key));
            }
        }
        for (String string : map2.keySet()) {
            Object object2;
            if (map.containsKey(string)) continue;
            object = Utils.join("/", Utils.transform(map.keySet(), new Utils.Function<String, Object>(){

                @Override
                public Object apply(String string) {
                    return I18n.tr(string, new Object[0]);
                }
            }));
            if (!string.isEmpty()) {
                object2 = I18n.marktr("Role {0} unknown in templates {1}");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr((String)object2, string, object), MessageFormat.format((String)object2, string), 1701, relation));
                continue;
            }
            object2 = I18n.marktr("Empty role type found when expecting one of {0}");
            this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr((String)object2, object), (String)object2, 1702, relation));
        }
    }

    private void checkRoleCounts(Relation relation, Roles.Role role, String string, RoleInfo roleInfo) {
        long l;
        long l2 = roleInfo == null ? 0L : (long)roleInfo.total;
        if (l2 != (l = role.getValidCount(l2))) {
            if (l2 == 0L) {
                String string2 = I18n.marktr("Role {0} missing");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(string2, string), MessageFormat.format(string2, string), 1706, relation));
            } else if (l > l2) {
                String string3 = I18n.marktr("Number of {0} roles too low ({1})");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(string3, string, l2), MessageFormat.format(string3, string, l2), 1705, relation));
            } else {
                String string4 = I18n.marktr("Number of {0} roles too high ({1})");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(string4, string, l2), MessageFormat.format(string4, string, l2), 1704, relation));
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        if (this.isFixable(testError)) {
            return new DeleteCommand(testError.getPrimitives());
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        return testError.getCode() == 1708 && !collection.isEmpty() && collection.iterator().next().isNew();
    }

    private static class RoleInfo {
        private int total;

        private RoleInfo() {
        }
    }

    private static class RolePreset {
        private final List<Roles.Role> roles;
        private final String name;

        RolePreset(List<Roles.Role> list, String string) {
            this.roles = list;
            this.name = string;
        }
    }
}

