/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.TemplatedWMSTileSource;
import org.openstreetmap.josm.data.imagery.WMSCachedTileLoader;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

public class WMSLayer
extends AbstractCachedTileSourceLayer {
    private static final String PREFERENCE_PREFIX = "imagery.wms.";
    public static final IntegerProperty PROP_IMAGE_SIZE = new IntegerProperty("imagery.wms.imageSize", 512);
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.wms.default_autozoom", true);
    public static final IntegerProperty THREAD_LIMIT = new IntegerProperty("imagery.wms.simultaneousConnections", 3);
    private static final String CACHE_REGION_NAME = "WMS";
    private Set<String> supportedProjections;

    public WMSLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        this.supportedProjections = new TreeSet<String>(imageryInfo.getServerProjections());
        this.autoZoom = PROP_DEFAULT_AUTOZOOM.get();
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(super.getMenuEntries()));
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new Layer.LayerSaveAction(this));
        arrayList.add(new Layer.LayerSaveAsAction(this));
        arrayList.add(new BookmarkWmsAction());
        return arrayList.toArray(new Action[0]);
    }

    @Override
    protected AbstractTMSTileSource getTileSource(ImageryInfo imageryInfo) {
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.WMS && imageryInfo.getUrl() != null) {
            TemplatedWMSTileSource.checkUrl(imageryInfo.getUrl());
            TemplatedWMSTileSource templatedWMSTileSource = new TemplatedWMSTileSource(imageryInfo);
            imageryInfo.setAttribution(templatedWMSTileSource);
            return templatedWMSTileSource;
        }
        return null;
    }

    @Override
    protected Map<String, String> getHeaders(TileSource tileSource) {
        if (tileSource instanceof TemplatedWMSTileSource) {
            return ((TemplatedWMSTileSource)tileSource).getHeaders();
        }
        return null;
    }

    @Override
    public boolean isProjectionSupported(Projection projection) {
        return this.supportedProjections == null || this.supportedProjections.isEmpty() || this.supportedProjections.contains(projection.toCode());
    }

    @Override
    public String nameSupportedProjections() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.supportedProjections) {
            stringBuilder.append(string).append(", ");
        }
        Object object = "";
        if (this.supportedProjections.contains("EPSG:4326") && "EPSG:3857".equals(Main.getProjection().toCode())) {
            object = ". " + I18n.tr("JOSM will use EPSG:4326 to query the server, but results may vary depending on the WMS server", new Object[0]);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2) + (String)object;
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        super.projectionChanged(projection, projection2);
        if (!projection2.equals(projection) && this.tileSource instanceof TemplatedWMSTileSource) {
            ((TemplatedWMSTileSource)this.tileSource).initProjection(projection2);
        }
    }

    @Override
    protected Class<? extends TileLoader> getTileLoaderClass() {
        return WMSCachedTileLoader.class;
    }

    @Override
    protected String getCacheName() {
        return CACHE_REGION_NAME;
    }

    public static CacheAccess<String, BufferedImageCacheEntry> getCache() {
        return AbstractCachedTileSourceLayer.getCache(CACHE_REGION_NAME);
    }

    public class BookmarkWmsAction
    extends AbstractAction {
        public BookmarkWmsAction() {
            super(I18n.tr("Set WMS Bookmark", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImageryLayerInfo.addLayer(new ImageryInfo(WMSLayer.this.info));
        }
    }
}

