/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.Collections;
import javax.swing.JLabel;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;

public class TaggingPresetLabel
extends JLabel {
    protected final TaggingPreset t;

    public TaggingPresetLabel(TaggingPreset taggingPreset) {
        super(taggingPreset.getName() + " \u2026");
        this.setIcon(taggingPreset.getIcon());
        this.addMouseListener(new PresetLabelMouseListener(this));
        this.t = taggingPreset;
    }

    public static class PresetLabelMouseListener
    implements MouseListener {
        protected final JLabel label;
        protected final Font hover;
        protected final Font normal;

        public PresetLabelMouseListener(JLabel jLabel) {
            this.label = jLabel;
            jLabel.setCursor(new Cursor(12));
            this.normal = this.label.getFont();
            this.hover = this.normal.deriveFont(Collections.singletonMap(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED));
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.label.setFont(this.hover);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.label.setFont(this.normal);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

