/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.net.Authenticator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.JosmPreferencesCredentialAgent;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class MessageNotifier {
    public static final BooleanProperty PROP_NOTIFIER_ENABLED = new BooleanProperty("message.notifier.enabled", true);
    public static final IntegerProperty PROP_INTERVAL = new IntegerProperty("message.notifier.interval", 5);
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor(Utils.newThreadFactory("message-notifier-%d", 5));
    private static final Runnable WORKER = new Worker();
    private static volatile ScheduledFuture<?> task;

    private MessageNotifier() {
    }

    public static void start() {
        int n = PROP_INTERVAL.get();
        if (Main.isOffline(OnlineResource.OSM_API)) {
            Main.info(I18n.tr("{0} not available (offline mode)", I18n.tr("Message notifier", new Object[0])));
        } else if (!MessageNotifier.isRunning() && n > 0 && MessageNotifier.isUserEnoughIdentified()) {
            task = EXECUTOR.scheduleAtFixedRate(WORKER, 0L, n * 60, TimeUnit.SECONDS);
            Main.info("Message notifier active (checks every " + n + " minute" + (n > 1 ? "s" : "") + ')');
        }
    }

    public static void stop() {
        if (MessageNotifier.isRunning()) {
            task.cancel(false);
            Main.info("Message notifier inactive");
            task = null;
        }
    }

    public static boolean isRunning() {
        return task != null;
    }

    public static boolean isUserEnoughIdentified() {
        JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
        if (josmUserIdentityManager.isFullyIdentified()) {
            return true;
        }
        CredentialsManager credentialsManager = CredentialsManager.getInstance();
        try {
            if (JosmPreferencesCredentialAgent.class.equals(credentialsManager.getCredentialsAgentClass())) {
                if (OsmApi.isUsingOAuth()) {
                    return credentialsManager.lookupOAuthAccessToken() != null;
                }
                String string = Main.pref.get("osm-server.username", null);
                String string2 = Main.pref.get("osm-server.password", null);
                return string != null && !string.isEmpty() && string2 != null && !string2.isEmpty();
            }
            CredentialsAgentResponse credentialsAgentResponse = credentialsManager.getCredentials(Authenticator.RequestorType.SERVER, OsmApi.getOsmApi().getHost(), false);
            if (credentialsAgentResponse != null) {
                String string = credentialsAgentResponse.getUsername();
                char[] cArray = credentialsAgentResponse.getPassword();
                return string != null && !string.isEmpty() && cArray != null && cArray.length > 0;
            }
        }
        catch (CredentialsAgentException credentialsAgentException) {
            Main.warn("Unable to get credentials: " + credentialsAgentException.getMessage());
        }
        return false;
    }

    private static class Worker
    implements Runnable {
        private int lastUnreadCount;

        private Worker() {
        }

        @Override
        public void run() {
            try {
                final UserInfo userInfo = new OsmServerUserInfoReader().fetchUserInfo(NullProgressMonitor.INSTANCE, I18n.tr("get number of unread messages", new Object[0]));
                final int n = userInfo.getUnreadMessages();
                if (n > 0 && n != this.lastUnreadCount) {
                    GuiHelper.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            JPanel jPanel = new JPanel(new GridBagLayout());
                            jPanel.add((Component)new JLabel(I18n.trn("You have {0} unread message.", "You have {0} unread messages.", n, n)), GBC.eol());
                            jPanel.add((Component)new UrlLabel(Main.getBaseUserUrl() + '/' + userInfo.getDisplayName() + "/inbox", I18n.tr("Click here to see your inbox.", new Object[0])), GBC.eol());
                            jPanel.setOpaque(false);
                            new Notification().setContent(jPanel).setIcon(1).setDuration(Notification.TIME_LONG).show();
                        }
                    });
                    this.lastUnreadCount = n;
                }
            }
            catch (OsmTransferException osmTransferException) {
                Main.warn(osmTransferException);
            }
        }
    }
}

