/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

public class EncodingUtil {
    public static URI encodeURL(String url) throws MalformedURLException, URISyntaxException {
        URL urlObject = new URL(url);
        URI uriEncoded = new URI(urlObject.getProtocol(), urlObject.getAuthority(), urlObject.getPath(), urlObject.getQuery(), urlObject.getRef());
        return uriEncoded;
    }

    public static String encodeURLToString(String url) {
        try {
            return EncodingUtil.encodeURL(url).toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Error parsing url: %s", url), e);
        }
    }

    public static String encodeURLToString(String baseUrl, String ... paths) {
        String[] parts;
        StringBuilder url = new StringBuilder(baseUrl);
        for (String part : parts = paths == null ? new String[]{} : (paths.length == 1 ? StringUtils.split((String)paths[0], (String)"/") : paths)) {
            if (!url.toString().endsWith("/")) {
                url.append('/');
            }
            url.append(part);
        }
        return EncodingUtil.encodeURLToString(url.toString());
    }
}

