/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubnetUtils {
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String SLASH_FORMAT = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})";
    private static final Pattern addressPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final Pattern cidrPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})");
    private static final int NBITS = 32;
    private int netmask = 0;
    private int address = 0;
    private int network = 0;
    private int broadcast = 0;
    private boolean inclusiveHostCount = false;

    public SubnetUtils(String cidrNotation) {
        this.calculate(cidrNotation);
    }

    public SubnetUtils(String address2, String mask) {
        this.calculate(this.toCidrNotation(address2, mask));
    }

    public boolean isInclusiveHostCount() {
        return this.inclusiveHostCount;
    }

    public void setInclusiveHostCount(boolean inclusiveHostCount) {
        this.inclusiveHostCount = inclusiveHostCount;
    }

    public final SubnetInfo getInfo() {
        return new SubnetInfo();
    }

    private void calculate(String mask) {
        Matcher matcher = cidrPattern.matcher(mask);
        if (matcher.matches()) {
            this.address = this.matchAddress(matcher);
            int cidrPart = this.rangeCheck(Integer.parseInt(matcher.group(5)), 0, 32);
            for (int j = 0; j < cidrPart; ++j) {
                this.netmask |= 1 << 31 - j;
            }
        } else {
            throw new IllegalArgumentException("Could not parse [" + mask + "]");
        }
        this.network = this.address & this.netmask;
        this.broadcast = this.network | ~this.netmask;
    }

    private int toInteger(String address2) {
        Matcher matcher = addressPattern.matcher(address2);
        if (matcher.matches()) {
            return this.matchAddress(matcher);
        }
        throw new IllegalArgumentException("Could not parse [" + address2 + "]");
    }

    private int matchAddress(Matcher matcher) {
        int addr2 = 0;
        for (int i2 = 1; i2 <= 4; ++i2) {
            int n = this.rangeCheck(Integer.parseInt(matcher.group(i2)), -1, 255);
            addr2 |= (n & 0xFF) << 8 * (4 - i2);
        }
        return addr2;
    }

    private int[] toArray(int val) {
        int[] ret = new int[4];
        for (int j = 3; j >= 0; --j) {
            int n = j;
            ret[n] = ret[n] | val >>> 8 * (3 - j) & 0xFF;
        }
        return ret;
    }

    private String format(int[] octets) {
        StringBuilder str = new StringBuilder();
        for (int i2 = 0; i2 < octets.length; ++i2) {
            str.append(octets[i2]);
            if (i2 == octets.length - 1) continue;
            str.append(".");
        }
        return str.toString();
    }

    private int rangeCheck(int value2, int begin2, int end2) {
        if (value2 > begin2 && value2 <= end2) {
            return value2;
        }
        throw new IllegalArgumentException("Value [" + value2 + "] not in range (" + begin2 + "," + end2 + "]");
    }

    int pop(int x) {
        x -= x >>> 1 & 0x55555555;
        x = (x & 0x33333333) + (x >>> 2 & 0x33333333);
        x = x + (x >>> 4) & 0xF0F0F0F;
        x += x >>> 8;
        x += x >>> 16;
        return x & 0x3F;
    }

    private String toCidrNotation(String addr2, String mask) {
        return addr2 + "/" + this.pop(this.toInteger(mask));
    }

    public final class SubnetInfo {
        private SubnetInfo() {
        }

        private int netmask() {
            return SubnetUtils.this.netmask;
        }

        private int network() {
            return SubnetUtils.this.network;
        }

        private int address() {
            return SubnetUtils.this.address;
        }

        private int broadcast() {
            return SubnetUtils.this.broadcast;
        }

        private int low() {
            return SubnetUtils.this.isInclusiveHostCount() ? this.network() : (this.broadcast() - this.network() > 1 ? this.network() + 1 : 0);
        }

        private int high() {
            return SubnetUtils.this.isInclusiveHostCount() ? this.broadcast() : (this.broadcast() - this.network() > 1 ? this.broadcast() - 1 : 0);
        }

        public boolean isInRange(String address2) {
            return this.isInRange(SubnetUtils.this.toInteger(address2));
        }

        private boolean isInRange(int address2) {
            int diff = address2 - this.low();
            return diff >= 0 && diff <= this.high() - this.low();
        }

        public String getBroadcastAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.broadcast()));
        }

        public String getNetworkAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.network()));
        }

        public String getNetmask() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.netmask()));
        }

        public String getAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.address()));
        }

        public String getLowAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.low()));
        }

        public String getHighAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.high()));
        }

        public int getAddressCount() {
            int count2 = this.broadcast() - this.network() + (SubnetUtils.this.isInclusiveHostCount() ? 1 : -1);
            return count2 < 0 ? 0 : count2;
        }

        public int asInteger(String address2) {
            return SubnetUtils.this.toInteger(address2);
        }

        public String getCidrSignature() {
            return SubnetUtils.this.toCidrNotation(SubnetUtils.this.format(SubnetUtils.this.toArray(this.address())), SubnetUtils.this.format(SubnetUtils.this.toArray(this.netmask())));
        }

        public String[] getAllAddresses() {
            int ct = this.getAddressCount();
            String[] addresses = new String[ct];
            if (ct == 0) {
                return addresses;
            }
            int add2 = this.low();
            int j = 0;
            while (add2 <= this.high()) {
                addresses[j] = SubnetUtils.this.format(SubnetUtils.this.toArray(add2));
                ++add2;
                ++j;
            }
            return addresses;
        }

        public String toString() {
            return "CIDR Signature:\t[" + this.getCidrSignature() + "] Netmask: [" + this.getNetmask() + "]\n" + "Network:\t[" + this.getNetworkAddress() + "]\n" + "Broadcast:\t[" + this.getBroadcastAddress() + "]\n" + "First Address:\t[" + this.getLowAddress() + "]\n" + "Last Address:\t[" + this.getHighAddress() + "]\n" + "# Addresses:\t[" + this.getAddressCount() + "]\n";
        }
    }
}

