/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.weakref;

import java.lang.ref.WeakReference;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"WeakRef"}, parent="Delegator")
public class WeakRef
extends RubyObject {
    private WeakReference<IRubyObject> ref;
    public static final ObjectAllocator WEAKREF_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
            return new WeakRef(runtime, klazz);
        }
    };

    public WeakRef(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz);
    }

    @JRubyMethod(name={"__getobj__"})
    public IRubyObject getobj() {
        IRubyObject obj = (IRubyObject)this.ref.get();
        if (obj == null) {
            throw this.newRefError("Illegal Reference - probably recycled");
        }
        return obj;
    }

    @JRubyMethod(name={"__setobj__"})
    public IRubyObject setobj(IRubyObject obj) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"new"}, required=1, meta=true)
    public static IRubyObject newInstance(IRubyObject clazz, IRubyObject arg2) {
        WeakRef weakRef = (WeakRef)((RubyClass)clazz).allocate();
        weakRef.callInit(new IRubyObject[]{arg2}, Block.NULL_BLOCK);
        return weakRef;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject obj) {
        this.ref = new WeakReference<IRubyObject>(obj);
        return context.nil;
    }

    @JRubyMethod(name={"weakref_alive?"})
    public IRubyObject weakref_alive_p() {
        return this.ref.get() != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    private RaiseException newRefError(String message2) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        RubyException exception2 = (RubyException)runtime.getClass("WeakRef").getClass("RefError").newInstance(context, new IRubyObject[]{runtime.newString(message2)}, Block.NULL_BLOCK);
        RaiseException re = new RaiseException(exception2);
        return re;
    }

    @JRubyClass(name={"WeakRef::RefError"}, parent="StandardError")
    public static class RefError {
    }
}

