/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.debug.JSONShapeVisitor;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;

class Debug {
    private static Collection<ShapeImpl> allShapes;

    static {
        if (ObjectStorageOptions.DumpShapes) {
            allShapes = new ConcurrentLinkedQueue<ShapeImpl>();
        }
        if (ObjectStorageOptions.DumpShapes) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (PrintWriter out = new PrintWriter("shapes.json", "UTF-8");){
                            out.println("{\"shapes\": [");
                            boolean first = true;
                            for (ShapeImpl shape : allShapes) {
                                if (!first) {
                                    out.println(",");
                                }
                                first = false;
                                out.print(shape.accept(new JSONShapeVisitor()));
                            }
                            if (!first) {
                                out.println();
                            }
                            out.println("]}");
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (FileNotFoundException | UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }));
        }
    }

    Debug() {
    }

    static void registerShape(ShapeImpl newShape) {
        allShapes.add(newShape);
    }
}

