/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccessFactory;
import com.oracle.truffle.api.interop.InteropPredicate;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.exception.UnsupportedMessageException;
import com.oracle.truffle.api.interop.messages.Message;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.interop.messages.Argument;
import com.oracle.truffle.interop.messages.Execute;
import com.oracle.truffle.interop.messages.HasSize;
import com.oracle.truffle.interop.messages.IsBoxed;
import com.oracle.truffle.interop.messages.IsExecutable;
import com.oracle.truffle.interop.messages.IsNull;
import com.oracle.truffle.interop.messages.Read;
import com.oracle.truffle.interop.messages.Receiver;
import com.oracle.truffle.interop.messages.Write;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.interop.InteropNode;
import org.jruby.truffle.runtime.RubyContext;

public class BasicForeignAccessFactory
implements ForeignAccessFactory {
    private final RubyContext context;

    public BasicForeignAccessFactory(RubyContext context) {
        this.context = context;
    }

    @Override
    public InteropPredicate getLanguageCheck() {
        return new InteropPredicate(){

            @Override
            public boolean test(TruffleObject o) {
                return RubyGuards.isRubyBasicObject(o);
            }
        };
    }

    @Override
    public CallTarget getAccess(Message tree) {
        if (Read.create(Receiver.create(), Argument.create()).matchStructure(tree)) {
            return Truffle.getRuntime().createCallTarget(new RubyInteropRootNode(InteropNode.createRead(this.context, new NullSourceSection("", ""), (Read)tree)));
        }
        if (Execute.create(Read.create(Receiver.create(), Argument.create()), 0).matchStructure(tree)) {
            return Truffle.getRuntime().createCallTarget(new RubyInteropRootNode(InteropNode.createExecuteAfterRead(this.context, new NullSourceSection("", ""), (Execute)tree)));
        }
        if (Write.create(Receiver.create(), Argument.create(), Argument.create()).matchStructure(tree)) {
            return Truffle.getRuntime().createCallTarget(new RubyInteropRootNode(InteropNode.createWrite(this.context, new NullSourceSection("", ""), (Write)tree)));
        }
        if (IsExecutable.create(Receiver.create()).matchStructure(tree)) {
            return Truffle.getRuntime().createCallTarget(new RubyInteropRootNode(InteropNode.createIsExecutable(this.context, new NullSourceSection("", ""))));
        }
        if (IsBoxed.create(Receiver.create()).matchStructure(tree)) {
            return Truffle.getRuntime().createCallTarget(new RubyInteropRootNode(InteropNode.createIsBoxedPrimitive(this.context, new NullSourceSection("", ""))));
        }
        if (IsNull.create(Receiver.create()).matchStructure(tree)) {
            return Truffle.getRuntime().createCallTarget(new RubyInteropRootNode(InteropNode.createIsNull(this.context, new NullSourceSection("", ""))));
        }
        if (HasSize.create(Receiver.create()).matchStructure(tree)) {
            return Truffle.getRuntime().createCallTarget(new RubyInteropRootNode(InteropNode.createHasSizePropertyFalse(this.context, new NullSourceSection("", ""))));
        }
        throw new UnsupportedMessageException("Message not supported: " + tree.toString());
    }

    protected static final class RubyInteropRootNode
    extends RootNode {
        @Node.Child
        private RubyNode node;

        public RubyInteropRootNode(RubyNode node) {
            this.node = node;
        }

        @Override
        public Object execute(VirtualFrame virtualFrame) {
            return this.node.execute(virtualFrame);
        }

        @Override
        public String toString() {
            return "Root of: " + this.node.toString();
        }
    }
}

