/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;

public class SignatureOutputStream
extends OutputStream {
    private final Signature signature;

    public SignatureOutputStream(Signature signature) {
        this.signature = signature;
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        try {
            this.signature.update(bytes, off, len);
        }
        catch (SignatureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        try {
            this.signature.update(bytes);
        }
        catch (SignatureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.signature.update((byte)b);
        }
        catch (SignatureException e) {
            throw new IOException(e);
        }
    }
}

