// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var Base, BufferInStream, Command, E, TrackSubSubCommand, User, add_option_dict, gpg, iced, keypull, log, make_esc, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Base = require('./base').Base;

  log = require('../log');

  add_option_dict = require('./argparse').add_option_dict;

  E = require('../err').E;

  TrackSubSubCommand = require('../tracksubsub').TrackSubSubCommand;

  BufferInStream = require('iced-spawn').BufferInStream;

  gpg = require('../gpg').gpg;

  make_esc = require('iced-error').make_esc;

  User = require('../user').User;

  keypull = require('../keypull').keypull;

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = {
      m: {
        alias: "message",
        help: "provide the message on the command line"
      },
      b: {
        alias: 'binary',
        action: "storeTrue",
        help: "output in binary (rather than ASCII/armored)"
      },
      'clearsign': {
        action: 'storeTrue',
        help: "make a clear signature"
      },
      'detach-sign': {
        action: 'storeTrue',
        help: "make a detached signature"
      },
      o: {
        alias: 'output',
        help: 'specify an output file'
      }
    };

    Command.prototype.is_batch = function() {
      return !(this.argv.message != null) && !(this.argv.file != null);
    };

    Command.prototype.set_argv = function(a) {
      if (a.clearsign && a.detach_sign) {
        return new E.ArgsError("Can only handle one of --clearsign and --detach-sign");
      } else {
        return Command.__super__.set_argv.call(this, a);
      }
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        aliases: ["sig"],
        help: "sign a message"
      };
      name = "sign";
      sub = scp.addParser(name, opts);
      add_option_dict(sub, this.OPTS);
      sub.addArgument(["file"], {
        nargs: '?'
      });
      return opts.aliases.concat([name]);
    };

    Command.prototype.do_sign = function(cb) {
      var args, err, gargs, o, out, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = ["--sign", "-u", this.me.fingerprint(true)];
      gargs = {
        args: args
      };
      if (!this.argv.binary) {
        args.push("-a");
      }
      if (this.argv.clearsign) {
        args.push("--clearsign");
      }
      if (this.argv.detach_sign) {
        args.push("--detach-sign");
      }
      if ((o = this.argv.output) != null) {
        args.push("--output", o);
      }
      if (this.argv.message) {
        gargs.stdin = new BufferInStream(this.argv.message);
      } else if (this.argv.file != null) {
        args.push(this.argv.file);
      } else {
        gargs.stdin = process.stdin;
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/sign.iced",
            funcname: "Command.do_sign"
          });
          gpg(gargs, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 74
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (!_this.argv.output) {
            log.console.log(out.toString(_this.argv.binary ? 'utf8' : 'binary'));
          }
          return cb(err);
        };
      })(this));
    };

    Command.prototype.load_me = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/sign.iced",
            funcname: "Command.load_me"
          });
          User.load_me({
            secret: true
          }, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1.me = arguments[1];
              };
            })(_this),
            lineno: 82
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Command.prototype.run = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      log.debug("+ Command::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/sign.iced",
            funcname: "Command.run"
          });
          keypull({
            stdin_blocked: _this.is_batch(),
            need_secret: true
          }, esc(__iced_deferrals.defer({
            lineno: 90
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/command/sign.iced",
              funcname: "Command.run"
            });
            _this.load_me(esc(__iced_deferrals.defer({
              lineno: 91
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/command/sign.iced",
                funcname: "Command.run"
              });
              _this.do_sign(esc(__iced_deferrals.defer({
                lineno: 92
              })));
              __iced_deferrals._fulfill();
            })(function() {
              log.debug("- Command::run");
              return cb(null);
            });
          });
        };
      })(this));
    };

    return Command;

  })(Base);

}).call(this);
