// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var C, File, Tmp, base58, constants, crypto, fs, iced, log, mkdir_p, open, path, strip_extension, tmp_filename, __iced_k, __iced_k_noop;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  fs = require('fs');

  log = require('./log');

  C = require('constants');

  base58 = require('./basex').base58;

  crypto = require('crypto');

  path = require('path');

  mkdir_p = require('iced-utils').fs.mkdir_p;

  constants = require('./constants').constants;

  exports.File = File = (function() {
    function File(_arg) {
      this.stream = _arg.stream, this.stat = _arg.stat, this.realpath = _arg.realpath, this.filename = _arg.filename, this.fd = _arg.fd;
    }

    File.prototype.close = function() {
      var _ref;
      return (_ref = this.stream) != null ? _ref.close() : void 0;
    };

    return File;

  })();

  exports.open = open = function(_arg, cb) {
    var bufferSize, err, f, fd, file, filename, flags, mode, opts, realpath, ret, stat, stream, write, ___iced_passed_deferral, __iced_deferrals, __iced_k;
    __iced_k = __iced_k_noop;
    ___iced_passed_deferral = iced.findDeferral(arguments);
    filename = _arg.filename, write = _arg.write, mode = _arg.mode, bufferSize = _arg.bufferSize;
    mode || (mode = 0x1a0);
    bufferSize || (bufferSize = 1024 * 1024);
    stat = null;
    err = null;
    flags = write ? C.O_WRONLY | C.O_TRUNC | C.O_EXCL | C.O_CREAT : C.O_RDONLY;
    (function(_this) {
      return (function(__iced_k) {
        if (!write) {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/fs.iced"
            });
            fs.stat(filename, __iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return stat = arguments[1];
                };
              })(),
              lineno: 30
            }));
            __iced_deferrals._fulfill();
          })(function() {
            return __iced_k(err != null ? log.warn("Failed to access file " + filename + ": " + err) : void 0);
          });
        } else {
          return __iced_k();
        }
      });
    })(this)((function(_this) {
      return function() {
        (function(__iced_k) {
          if (err == null) {
            ret = null;
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/fs.iced"
              });
              fs.open(filename, flags, mode, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return fd = arguments[1];
                  };
                })(),
                lineno: 35
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        })(function() {
          (function(__iced_k) {
            if (err == null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/fs.iced"
                });
                fs.realpath(filename, __iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      err = arguments[0];
                      return realpath = arguments[1];
                    };
                  })(),
                  lineno: 37
                }));
                __iced_deferrals._fulfill();
              })(function() {
                return __iced_k(err != null ? log.warn("Realpath failed on file " + filename + ": " + err) : void 0);
              });
            } else {
              return __iced_k();
            }
          })(function() {
            if (err == null) {
              opts = {
                fd: fd,
                bufferSize: bufferSize
              };
              f = write ? fs.createWriteStream : fs.createReadStream;
              stream = f(filename, opts);
            }
            file = err != null ? null : new File({
              stream: stream,
              stat: stat,
              realpath: realpath,
              filename: filename,
              fd: fd
            });
            return cb(err, file);
          });
        });
      };
    })(this));
  };

  exports.tmp_filename = tmp_filename = function(stem) {
    var ext;
    ext = base58.encode(crypto.rng(8));
    return [stem, ext].join('.');
  };

  exports.strip_extension = strip_extension = function(fn, ext) {
    var l, v;
    v = fn.split(".");
    l = v.length;
    if (v[l - 1] === ext) {
      return v.slice(0, l - 1).join('.');
    } else {
      return null;
    }
  };

  exports.stdout = function() {
    return new File({
      stream: process.stdout,
      filename: "<stdout>",
      realpath: "<stdout>",
      fd: -1
    });
  };

  exports.Tmp = Tmp = (function() {
    function Tmp(_arg) {
      this.target = _arg.target, this.mode = _arg.mode, this.bufferSize = _arg.bufferSize;
      this.tmpname = tmp_filename(this.target);
      this.renamed = false;
    }

    Tmp.prototype.open = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/fs.iced",
            funcname: "Tmp.open"
          });
          open({
            filename: _this.tmpname,
            write: true,
            mode: _this.mode,
            bufferSize: _this.bufferSize
          }, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1.tmp = arguments[1];
              };
            })(_this),
            lineno: 82
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            log.error("Error opening file: " + err);
          }
          return cb(typeof err === "undefined" || err === null);
        };
      })(this));
    };

    Tmp.prototype.close = function() {
      var _ref;
      return (_ref = this.tmp) != null ? _ref.close() : void 0;
    };

    Tmp.prototype.rename = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/fs.iced",
            funcname: "Tmp.rename"
          });
          fs.rename(_this.tmpname, _this.target, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 90
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            log.error("Failed to rename temporary file: " + err);
          } else {
            _this.renamed = true;
          }
          return cb(typeof err === "undefined" || err === null);
        };
      })(this));
    };

    Tmp.prototype.finish = function(cb) {
      var ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/fs.iced",
            funcname: "Tmp.finish"
          });
          _this.rename(__iced_deferrals.defer({
            lineno: 98
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/fs.iced",
              funcname: "Tmp.finish"
            });
            _this.cleanup(__iced_deferrals.defer({
              lineno: 99
            }));
            __iced_deferrals._fulfill();
          })(function() {
            return cb();
          });
        };
      })(this));
    };

    Tmp.prototype.cleanup = function(cb) {
      var err, ok, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      ok = false;
      (function(_this) {
        return (function(__iced_k) {
          if (!_this.renamed) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/fs.iced",
                funcname: "Tmp.cleanup"
              });
              fs.unlink(_this.tmpname, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 105
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(typeof err !== "undefined" && err !== null ? (log.error("failed to remove temporary file: " + err), ok = false) : void 0);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(ok);
        };
      })(this));
    };

    Tmp.prototype.stream = function() {
      var _ref;
      return (_ref = this.tmp) != null ? _ref.stream : void 0;
    };

    return Tmp;

  })();

  exports.mkdirp = function(fn, cb) {
    var d, err, found, n, ___iced_passed_deferral, __iced_deferrals, __iced_k;
    __iced_k = __iced_k_noop;
    ___iced_passed_deferral = iced.findDeferral(arguments);
    d = path.dirname(fn);
    n = 0;
    err = null;
    (function(_this) {
      return (function(__iced_k) {
        __iced_deferrals = new iced.Deferrals(__iced_k, {
          parent: ___iced_passed_deferral,
          filename: "/Users/max/src/keybase/node-client/src/fs.iced",
          funcname: "mkdirp"
        });
        fs.exists(d, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return found = arguments[0];
            };
          })(),
          lineno: 119
        }));
        __iced_deferrals._fulfill();
      });
    })(this)((function(_this) {
      return function() {
        (function(__iced_k) {
          if (!found) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/fs.iced",
                funcname: "mkdirp"
              });
              mkdir_p(d, constants.permissions.dir, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return n = arguments[1];
                  };
                })(),
                lineno: 121
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k((err == null) && n > 0 ? log.info("Made directory '" + d + "'") : void 0);
            });
          } else {
            return __iced_k();
          }
        })(function() {
          return cb(err, d, n);
        });
      };
    })(this));
  };

}).call(this);
