/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.launcher;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;
import org.jivesoftware.openfire.launcher.BrowserLauncher;
import org.jivesoftware.openfire.launcher.DroppableFrame;
import org.jivesoftware.openfire.launcher.DroppableTextPane;
import org.jivesoftware.openfire.launcher.GraphicUtils;
import org.jivesoftware.openfire.launcher.SwingWorker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Launcher {
    private String appName;
    private File binDir;
    private Process openfired;
    private File configFile;
    private JPanel toolbar = new JPanel();
    private ImageIcon offIcon;
    private ImageIcon onIcon;
    private TrayIcon trayIcon;
    private JFrame frame;
    private JPanel cardPanel = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    private JTextPane pane;
    private boolean freshStart = true;

    public Launcher() {
        SystemTray tray = null;
        try {
            tray = SystemTray.getDefaultSystemTray();
        }
        catch (Throwable e) {
            System.err.println("Error loading system tray library, system tray support disabled.");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.appName = System.getProperty("app.name") != null ? System.getProperty("app.name") : "Openfire";
        this.binDir = new File("").getAbsoluteFile();
        if (System.getProperty("appdir") != null) {
            this.binDir = new File(System.getProperty("appdir"));
        }
        this.configFile = new File(new File(this.binDir.getParent(), "conf"), "openfire.xml");
        this.frame = new DroppableFrame(){

            @Override
            public void fileDropped(File file) {
                String fileName = file.getName();
                if (fileName.endsWith(".jar") || fileName.endsWith(".war")) {
                    Launcher.this.installPlugin(file);
                }
            }
        };
        this.frame.setTitle(this.appName);
        JPanel mainPanel = new JPanel();
        JLabel splashLabel = null;
        this.cardPanel.setLayout(this.cardLayout);
        try {
            ImageIcon splash = new ImageIcon(this.getClass().getClassLoader().getResource("splash.gif"));
            splashLabel = new JLabel("", splash, 0);
            this.onIcon = new ImageIcon(this.getClass().getClassLoader().getResource("openfire_on-16x16.gif"));
            this.offIcon = new ImageIcon(this.getClass().getClassLoader().getResource("openfire_off-16x16.gif"));
            this.frame.setIconImage(this.offIcon.getImage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mainPanel.setLayout(new BorderLayout());
        this.cardPanel.setBackground(Color.white);
        final JButton startButton = new JButton("Start");
        startButton.setActionCommand("Start");
        final JButton stopButton = new JButton("Stop");
        stopButton.setActionCommand("Stop");
        final JButton browserButton = new JButton("Launch Admin");
        browserButton.setActionCommand("Launch Admin");
        JButton quitButton = new JButton("Quit");
        quitButton.setActionCommand("Quit");
        this.toolbar.setLayout(new GridBagLayout());
        this.toolbar.add((Component)startButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.toolbar.add((Component)stopButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.toolbar.add((Component)browserButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.toolbar.add((Component)quitButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.cardPanel, "Center");
        mainPanel.add((Component)this.toolbar, "South");
        JPopupMenu menu = new JPopupMenu(this.appName + " Menu");
        final JMenuItem showMenuItem = new JMenuItem("Hide");
        showMenuItem.setActionCommand("Hide/Show");
        menu.add(showMenuItem);
        final JMenuItem startMenuItem = new JMenuItem("Start");
        startMenuItem.setActionCommand("Start");
        menu.add(startMenuItem);
        final JMenuItem stopMenuItem = new JMenuItem("Stop");
        stopMenuItem.setActionCommand("Stop");
        menu.add(stopMenuItem);
        final JMenuItem browserMenuItem = new JMenuItem("Launch Admin");
        browserMenuItem.setActionCommand("Launch Admin");
        menu.add(browserMenuItem);
        menu.addSeparator();
        JMenuItem quitMenuItem = new JMenuItem("Quit");
        quitMenuItem.setActionCommand("Quit");
        menu.add(quitMenuItem);
        browserButton.setEnabled(false);
        stopButton.setEnabled(false);
        browserMenuItem.setEnabled(false);
        stopMenuItem.setEnabled(false);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("Start".equals(e.getActionCommand())) {
                    Launcher.this.frame.setCursor(Cursor.getPredefinedCursor(3));
                    startButton.setEnabled(false);
                    stopButton.setEnabled(true);
                    startMenuItem.setEnabled(false);
                    stopMenuItem.setEnabled(true);
                    Launcher.this.startApplication();
                    Launcher.this.frame.setIconImage(Launcher.this.onIcon.getImage());
                    Launcher.this.trayIcon.setIcon((Icon)Launcher.this.onIcon);
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                1.sleep(8000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (stopButton.isEnabled()) {
                                browserButton.setEnabled(true);
                                browserMenuItem.setEnabled(true);
                                Launcher.this.frame.setCursor(Cursor.getDefaultCursor());
                            }
                        }
                    };
                    thread.start();
                } else if ("Stop".equals(e.getActionCommand())) {
                    Launcher.this.stopApplication();
                    Launcher.this.frame.setIconImage(Launcher.this.offIcon.getImage());
                    Launcher.this.trayIcon.setIcon((Icon)Launcher.this.offIcon);
                    Launcher.this.frame.setCursor(Cursor.getDefaultCursor());
                    browserButton.setEnabled(false);
                    startButton.setEnabled(true);
                    stopButton.setEnabled(false);
                    browserMenuItem.setEnabled(false);
                    startMenuItem.setEnabled(true);
                    stopMenuItem.setEnabled(false);
                } else if ("Launch Admin".equals(e.getActionCommand())) {
                    Launcher.this.launchBrowser();
                } else if ("Quit".equals(e.getActionCommand())) {
                    Launcher.this.stopApplication();
                    System.exit(0);
                } else if ("Hide/Show".equals(e.getActionCommand()) || "PressAction".equals(e.getActionCommand())) {
                    if (Launcher.this.frame.isVisible()) {
                        Launcher.this.frame.setVisible(false);
                        Launcher.this.frame.setState(1);
                        showMenuItem.setText("Show");
                    } else {
                        Launcher.this.frame.setVisible(true);
                        Launcher.this.frame.setState(0);
                        showMenuItem.setText("Hide");
                    }
                }
            }
        };
        startButton.addActionListener(actionListener);
        stopButton.addActionListener(actionListener);
        browserButton.addActionListener(actionListener);
        quitButton.addActionListener(actionListener);
        quitMenuItem.addActionListener(actionListener);
        browserMenuItem.addActionListener(actionListener);
        stopMenuItem.addActionListener(actionListener);
        startMenuItem.addActionListener(actionListener);
        showMenuItem.addActionListener(actionListener);
        this.trayIcon = new TrayIcon((Icon)this.offIcon, this.appName, menu);
        this.trayIcon.setIconAutoSize(true);
        this.trayIcon.addActionListener(actionListener);
        if (tray != null) {
            tray.addTrayIcon(this.trayIcon);
        }
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Launcher.this.stopApplication();
                System.exit(0);
            }

            @Override
            public void windowIconified(WindowEvent e) {
                Launcher.this.frame.setVisible(false);
                showMenuItem.setText("Show");
            }
        });
        this.cardPanel.add("main", splashLabel);
        this.frame.getContentPane().add((Component)mainPanel, "Center");
        this.frame.pack();
        this.frame.setSize(400, 300);
        this.frame.setResizable(true);
        GraphicUtils.centerWindowOnScreen(this.frame);
        this.frame.setVisible(true);
        final ImageIcon icon = new ImageIcon(this.getClass().getClassLoader().getResource("splash2.gif"));
        this.pane = new DroppableTextPane(){

            @Override
            public void paintComponent(Graphics g) {
                Dimension size = Launcher.this.pane.getSize();
                int x = (size.width - icon.getIconWidth()) / 2;
                int y = (size.height - icon.getIconHeight()) / 2;
                g.setColor(Color.white);
                g.fillRect(0, 0, size.width, size.height);
                g.drawImage(icon.getImage(), x, y, null);
                this.setOpaque(false);
                super.paintComponent(g);
            }

            @Override
            public void fileDropped(File file) {
                String fileName = file.getName();
                if (fileName.endsWith(".jar") || fileName.endsWith(".war")) {
                    Launcher.this.installPlugin(file);
                }
            }
        };
        this.pane.setEditable(false);
        JPanel bevelPanel = new JPanel();
        bevelPanel.setBackground(Color.white);
        bevelPanel.setLayout(new BorderLayout());
        bevelPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        bevelPanel.add((Component)new JScrollPane(this.pane), "Center");
        this.cardPanel.add("running", bevelPanel);
        startButton.doClick();
    }

    public static void main(String[] args) {
        new Launcher();
    }

    private synchronized void startApplication() {
        if (this.openfired == null) {
            block11: {
                try {
                    File windowsExe = new File(this.binDir, "openfired.exe");
                    File unixExe = new File(this.binDir, "openfired");
                    if (windowsExe.exists()) {
                        this.openfired = Runtime.getRuntime().exec(new String[]{windowsExe.toString()});
                        break block11;
                    }
                    if (unixExe.exists()) {
                        this.openfired = Runtime.getRuntime().exec(new String[]{unixExe.toString()});
                        break block11;
                    }
                    throw new FileNotFoundException();
                }
                catch (Exception e) {
                    try {
                        File libDir = new File(this.binDir.getParentFile(), "lib").getAbsoluteFile();
                        this.openfired = Runtime.getRuntime().exec(new String[]{"java", "-jar", new File(libDir, "startup.jar").toString()});
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Launcher could not start,\n" + this.appName, "File not found", 0);
                    }
                }
            }
            final SimpleAttributeSet styles = new SimpleAttributeSet();
            SwingWorker inputWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    if (Launcher.this.openfired != null) {
                        try {
                            int c;
                            InputStream in = Launcher.this.openfired.getInputStream();
                            while ((c = in.read()) != -1) {
                                try {
                                    StyleConstants.setFontFamily(styles, "courier new");
                                    Launcher.this.pane.getDocument().insertString(Launcher.this.pane.getDocument().getLength(), "" + (char)c, styles);
                                }
                                catch (BadLocationException badLocationException) {}
                            }
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return "ok";
                }
            };
            inputWorker.start();
            SwingWorker errorWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    if (Launcher.this.openfired != null) {
                        try {
                            int c;
                            InputStream in = Launcher.this.openfired.getErrorStream();
                            while ((c = in.read()) != -1) {
                                try {
                                    StyleConstants.setForeground(styles, Color.red);
                                    Launcher.this.pane.getDocument().insertString(Launcher.this.pane.getDocument().getLength(), "" + (char)c, styles);
                                }
                                catch (BadLocationException badLocationException) {}
                            }
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return "ok";
                }
            };
            errorWorker.start();
            if (this.freshStart) {
                try {
                    Thread.sleep(1000L);
                    this.cardLayout.show(this.cardPanel, "running");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.freshStart = false;
            } else {
                this.pane.setText("");
                this.cardLayout.show(this.cardPanel, "running");
            }
        }
    }

    private synchronized void stopApplication() {
        if (this.openfired != null) {
            try {
                OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(this.openfired.getOutputStream()));
                out.write("exit\n");
                ((Writer)out).close();
                final Thread waiting = Thread.currentThread();
                Thread waiter = new Thread(){

                    @Override
                    public void run() {
                        try {
                            Launcher.this.openfired.waitFor();
                            waiting.interrupt();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                waiter.start();
                try {
                    Thread.sleep(10000L);
                    waiter.interrupt();
                    this.openfired.destroy();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.cardLayout.show(this.cardPanel, "main");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.openfired = null;
    }

    private synchronized void launchBrowser() {
        try {
            Element securePortElement;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document document = factory.newDocumentBuilder().parse(this.configFile);
            Element rootElement = document.getDocumentElement();
            Element adminElement = (Element)rootElement.getElementsByTagName("adminConsole").item(0);
            String port = "-1";
            String securePort = "-1";
            Element portElement = (Element)adminElement.getElementsByTagName("port").item(0);
            if (portElement != null) {
                port = portElement.getTextContent();
            }
            if ((securePortElement = (Element)adminElement.getElementsByTagName("securePort").item(0)) != null) {
                securePort = securePortElement.getTextContent();
            }
            if ("-1".equals(port)) {
                BrowserLauncher.openURL("https://127.0.0.1:" + securePort + "/index.html");
            } else {
                BrowserLauncher.openURL("http://127.0.0.1:" + port + "/index.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            JOptionPane.showMessageDialog(new JFrame(), this.configFile + " " + e.getMessage());
        }
    }

    private void installPlugin(final File plugin) {
        final JDialog dialog = new JDialog(this.frame, "Installing Plugin", true);
        dialog.getContentPane().setLayout(new BorderLayout());
        JProgressBar bar = new JProgressBar();
        bar.setIndeterminate(true);
        bar.setString("Installing Plugin.  Please wait...");
        bar.setStringPainted(true);
        dialog.getContentPane().add((Component)bar, "Center");
        dialog.pack();
        dialog.setSize(225, 55);
        SwingWorker installerThread = new SwingWorker(){

            @Override
            public Object construct() {
                File pluginsDir = new File(Launcher.this.binDir.getParentFile(), "plugins");
                String tempName = plugin.getName() + ".part";
                File tempPluginsFile = new File(pluginsDir, tempName);
                File realPluginsFile = new File(pluginsDir, plugin.getName());
                try {
                    Thread.sleep(2000L);
                    Launcher.copy(plugin.toURI().toURL(), tempPluginsFile);
                    tempPluginsFile.renameTo(realPluginsFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return realPluginsFile;
            }

            @Override
            public void finished() {
                dialog.setVisible(false);
            }
        };
        installerThread.start();
        dialog.setLocationRelativeTo(this.frame);
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(URL src, File dst) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = src.openStream();
            out = new FileOutputStream(dst);
            dst.mkdirs();
            Launcher.copy(in, out);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
    }
}

